/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.biomoby.shared.LSIDAccessible;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.extended.ServiceInstanceParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyService
implements Comparable<MobyService>,
LSIDAccessible {
    public static final String DUMMY_NAME = "_dummy_";
    public static final String BIOMOBY_SERVICE_URI = "http://biomoby.org/";
    protected String name;
    protected String category = "moby";
    protected String authority = "";
    protected String emailContact = "";
    protected String type = "";
    protected String description = "";
    protected String url = "";
    protected String signatureURL = "";
    protected String rdf = "";
    protected String pathToRDF = "";
    protected boolean authoritativeService = true;
    protected String id = null;
    protected String lsid = null;
    protected MobyServiceType serviceType;
    public static final int UNCHECKED = 0;
    public static final int DEAD = 1;
    public static final int ALIVE = 2;
    public static final int PINGED = 4;
    public static final int TESTED = 8;
    protected int serviceStatus = 0;
    protected int statusChecks = 0;
    public static final String CATEGORY_MOBY = "moby";
    public static final String CATEGORY_MOBY_ASYNC = "moby-async";
    public static final String SUBMIT_ACTION_SUFFIX = "_submit";
    protected static MobyService[] uninitializedServices = new MobyService[0];
    protected static MobyService[] services = uninitializedServices;
    protected static Map<String, MobyService> serviceMap = new HashMap<String, MobyService>();
    protected Vector<MobyData> primaryInputs = new Vector();
    protected Vector<MobyData> secondaryInputs = new Vector();
    protected Vector<MobyData> primaryOutputs = new Vector();

    @Override
    public int compareTo(MobyService obj) {
        return this.getUniqueName().compareToIgnoreCase(obj.getUniqueName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getUniqueName().equals(((MobyService)obj).getUniqueName());
    }

    public MobyService() {
        this(DUMMY_NAME);
    }

    public MobyService(String name) {
        this.setName(name);
    }

    public MobyService(String name, String authority) {
        this.setName(name);
        this.setAuthority(authority);
    }

    public String getUniqueName() {
        return this.name + "/" + this.authority;
    }

    public void setStatus(int statusCode, boolean mode) {
        if (mode) {
            this.serviceStatus |= statusCode;
        }
        this.statusChecks |= statusCode;
    }

    public int getStatus() {
        if ((this.statusChecks & this.serviceStatus) != 0) {
            return this.serviceStatus;
        }
        if (this.statusChecks == 0) {
            return 0;
        }
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String getLSID() {
        return this.lsid;
    }

    public void setLSID(String value) {
        this.lsid = value;
    }

    public boolean isAuthoritative() {
        return this.authoritativeService;
    }

    public void setAuthoritative(boolean value) {
        this.authoritativeService = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value == null ? "" : value;
    }

    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String value) {
        this.emailContact = value == null ? "" : value;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String value) {
        this.category = value == null ? CATEGORY_MOBY : value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value == null ? "" : value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.serviceType = value == null ? new MobyServiceType() : new MobyServiceType(value);
        this.type = value == null ? "" : value;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String value) {
        this.url = value == null ? "" : value;
    }

    public String getSignatureURL() {
        return this.signatureURL;
    }

    public void setSignatureURL(String value) {
        this.signatureURL = value == null ? "" : value;
    }

    public String getPathToRDF() {
        return this.pathToRDF;
    }

    public void setPathToRDF(String value) {
        this.pathToRDF = value == null ? "" : value;
    }

    public String getRDF() {
        return this.rdf;
    }

    public void setRDF(String value) {
        this.rdf = value == null ? "" : value;
    }

    public void setInputs(MobyData[] value) {
        if (value == null) {
            this.primaryInputs.clear();
            this.secondaryInputs.clear();
        } else {
            for (int i = 0; i < value.length; ++i) {
                if (value[i].isPrimary()) {
                    this.addOrReplaceData(this.primaryInputs, value[i]);
                    continue;
                }
                this.addOrReplaceData(this.secondaryInputs, value[i]);
            }
        }
    }

    public void addInput(MobyData value) {
        if (value != null) {
            if (value.isPrimary()) {
                this.addOrReplaceData(this.primaryInputs, value);
            } else {
                this.addOrReplaceData(this.secondaryInputs, value);
            }
        }
    }

    public void removeInput(MobyData value) {
        if (value != null) {
            if (value.isPrimary()) {
                this.removeData(this.primaryInputs, value);
            } else {
                this.removeData(this.secondaryInputs, value);
            }
        }
    }

    private void addOrReplaceData(Vector<MobyData> vector, MobyData value) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).getName().equals(value.getName())) continue;
            vector.removeElementAt(i);
            vector.insertElementAt(value, i);
            return;
        }
        vector.addElement(value);
    }

    private void removeData(Vector<MobyData> vector, MobyData value) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).getName().equals(value.getName())) continue;
            vector.removeElementAt(i--);
        }
    }

    public void setOutputs(MobyData[] value) {
        if (value == null) {
            this.primaryOutputs.clear();
        } else {
            for (int i = 0; i < value.length; ++i) {
                if (!value[i].isPrimary()) continue;
                this.addOrReplaceData(this.primaryOutputs, value[i]);
            }
        }
    }

    public void addOutput(MobyData value) {
        if (value != null && value.isPrimary()) {
            this.addOrReplaceData(this.primaryOutputs, value);
        }
    }

    public void removeOutput(MobyData value) {
        if (value != null && value.isPrimary()) {
            this.removeData(this.primaryOutputs, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobyPrimaryData[] getPrimaryInputs() {
        Vector<MobyData> vector = this.primaryInputs;
        synchronized (vector) {
            Object[] results = new MobyPrimaryData[this.primaryInputs.size()];
            this.primaryInputs.copyInto(results);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobySecondaryData[] getSecondaryInputs() {
        Vector<MobyData> vector = this.secondaryInputs;
        synchronized (vector) {
            Object[] results = new MobySecondaryData[this.secondaryInputs.size()];
            this.secondaryInputs.copyInto(results);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobyPrimaryData[] getPrimaryOutputs() {
        Vector<MobyData> vector = this.primaryOutputs;
        synchronized (vector) {
            Object[] results = new MobyPrimaryData[this.primaryOutputs.size()];
            this.primaryOutputs.copyInto(results);
            return results;
        }
    }

    public boolean equals(MobyService anotherOne) {
        if (anotherOne == null) {
            return false;
        }
        return this.equals((Object)anotherOne);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name:          " + this.name + "\n");
        buf.append("Type:          " + this.type + "\n");
        buf.append("Category:      " + this.category + "\n");
        buf.append("Auth:          " + this.authority + "\n");
        buf.append("Desc:          " + this.description + "\n");
        buf.append("URL:           " + this.url + "\n");
        buf.append("Contact:       " + this.emailContact + "\n");
        buf.append("LSID:          " + this.lsid + "\n");
        buf.append("Signature URL: " + this.signatureURL + "\n");
        buf.append("Path to RDF:   " + this.pathToRDF + "\n");
        if (this.id != null) {
            buf.append("ID:            " + this.id + "\n");
        }
        buf.append("Primary inputs:\n");
        Enumeration<MobyData> en = this.primaryInputs.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement().format(1));
        }
        if (this.secondaryInputs.size() > 0) {
            buf.append("Secondary inputs:\n");
            en = this.secondaryInputs.elements();
            while (en.hasMoreElements()) {
                buf.append(en.nextElement().format(1));
            }
        }
        buf.append("Outputs:\n");
        en = this.primaryOutputs.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement().format(1));
        }
        return new String(buf);
    }

    public String toShortString() {
        return this.name + " (" + this.authority + ")";
    }

    public static Comparator getAuthorityComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public MobyServiceType getServiceType() {
        return this.serviceType != null ? this.serviceType : new MobyServiceType();
    }

    public void setServiceType(MobyServiceType serviceType) {
        this.type = serviceType == null ? "" : serviceType.getName();
        this.serviceType = serviceType == null ? new MobyServiceType() : serviceType;
    }

    public static MobyService getService(String lsid) {
        String[] lsidParts = lsid.split(":");
        String[] sNameParts = lsidParts[4].split(",");
        return MobyService.getService(sNameParts[1], sNameParts[0]);
    }

    public static MobyService getService(String name, String authority) {
        if (name == null || authority == null) {
            return null;
        }
        String lsid = "urn:lsid:biomoby.org:serviceinstance:" + authority + "," + name;
        if (!serviceMap.containsKey(lsid)) {
            try {
                ServiceInstanceParser p;
                URL lsidResolver = new URL("http://moby.ucalgary.ca/authority/metadata/?lsid=" + lsid);
                String o = MobyService.getContent(lsidResolver);
                if (!(o instanceof String)) {
                    System.err.println("Response for " + lsid + " was not a String, but a " + o.getClass());
                }
                String metadata = o;
                String redirectPattern = "latest>";
                int redirectStringIndex = metadata.indexOf(redirectPattern + lsid);
                String lsidFull = null;
                if (redirectStringIndex != -1) {
                    int lsidFullIndex = redirectStringIndex + redirectPattern.length();
                    lsidFull = metadata.substring(lsidFullIndex, lsidFullIndex + lsid.length() + 21);
                    lsidResolver = new URL("http://moby.ucalgary.ca/authority/metadata/?lsid=" + lsidFull);
                    metadata = MobyService.getContent(lsidResolver);
                }
                if ((services = (p = new ServiceInstanceParser()).getMobyServicesFromRDF(metadata)).length > 0) {
                    serviceMap.put(lsid, services[0]);
                    if (lsidFull != null) {
                        serviceMap.put(lsidFull, services[0]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return serviceMap.get(lsid);
    }

    private static String getContent(URL u) throws Exception {
        StringBuffer contents = new StringBuffer();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(u.openStream()));
        String line = reader.readLine();
        while (line != null) {
            contents.append(line + "\n");
            line = reader.readLine();
        }
        return contents.toString();
    }

    public boolean isAsynchronous() {
        return this.category.equals(CATEGORY_MOBY_ASYNC);
    }
}

