/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.LSIDAccessible;
import org.biomoby.shared.Utils;
import org.biomoby.shared.extended.ServiceTypeParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyServiceType
implements Comparable<MobyServiceType>,
LSIDAccessible {
    protected String name;
    protected String description = "";
    protected String emailContact = "";
    protected String authority = "";
    protected String[] parentNames = new String[0];
    protected String id = null;
    protected String lsid = null;
    protected Registry registry;
    private static Map<String, MobyServiceType[]> servicetypesMapBySynonym = new HashMap<String, MobyServiceType[]>();
    private static Map<URL, MobyServiceType[]> servicetypesMapByURL = new HashMap<URL, MobyServiceType[]>();
    public static final String UNCATEGORIZED_LABEL = "Service";

    @Override
    public int compareTo(MobyServiceType obj) {
        return this.name.compareToIgnoreCase(obj.getName());
    }

    public boolean equals(Object obj) {
        return this.name.equals(((MobyServiceType)obj).getName());
    }

    public MobyServiceType() {
        this(UNCATEGORIZED_LABEL);
    }

    public MobyServiceType(String typeName) {
        this(typeName, null);
    }

    public MobyServiceType(String typeName, Registry reg) {
        this.setName(typeName);
        this.setRegistry(reg);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadServiceTypes(URL serviceDefURL, Registry reg) throws Exception {
        Map<String, MobyServiceType[]> map = servicetypesMapBySynonym;
        synchronized (map) {
            MobyServiceType[] servicetypes;
            if (reg == null) {
                reg = RegistryCache.getDefaultRegistry();
            }
            ServiceTypeParser p = new ServiceTypeParser(serviceDefURL);
            for (MobyServiceType servicetype : servicetypes = p.getMobyServiceTypesFromRDF()) {
                servicetype.setRegistry(reg);
            }
            servicetypesMapBySynonym.put(reg.getSynonym(), servicetypes);
            servicetypesMapByURL.put(serviceDefURL, servicetypes);
        }
    }

    public static MobyServiceType getServiceType(String className) {
        return MobyServiceType.getServiceType(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobyServiceType getServiceType(String className, Registry reg) {
        if (className == null || className.length() == 0 || className.equals(UNCATEGORIZED_LABEL)) {
            return new MobyServiceType(UNCATEGORIZED_LABEL, reg);
        }
        if (reg == null) {
            reg = RegistryCache.getDefaultRegistry();
        }
        if (reg == null) {
            return null;
        }
        MobyServiceType[] servicetypes = null;
        Map<Object, MobyServiceType[]> map = servicetypesMapBySynonym;
        synchronized (map) {
            servicetypes = servicetypesMapBySynonym.get(reg.getSynonym());
        }
        map = servicetypesMapByURL;
        synchronized (map) {
            if (servicetypes == null) {
                try {
                    URL serviceDefURL = Registry.findResourceURL(reg, UNCATEGORIZED_LABEL);
                    servicetypes = servicetypesMapByURL.get(serviceDefURL);
                    if (servicetypes == null) {
                        System.err.println("Fetching service type ontology from " + serviceDefURL);
                        MobyServiceType.loadServiceTypes(serviceDefURL, reg);
                        servicetypes = servicetypesMapByURL.get(serviceDefURL);
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot parse MOBY Service Type Ontology: " + e);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        for (int i = 0; i < servicetypes.length; ++i) {
            String st_name = servicetypes[i].getName();
            String st_lsid = servicetypes[i].getLSID();
            if ((st_name == null || !st_name.equals(className)) && (st_lsid == null || !st_lsid.equals(className))) continue;
            return servicetypes[i];
        }
        System.err.println("Couldn't find service type " + className);
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String getLSID() {
        return this.lsid;
    }

    public void setLSID(String value) {
        this.lsid = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value == null ? "" : value;
    }

    public String getParentName() {
        String[] names = this.getParentNames();
        return names.length == 0 ? "" : names[0];
    }

    public MobyServiceType getParent() {
        String parentName = this.getParentName();
        if (parentName.length() == 0) {
            return null;
        }
        return MobyServiceType.getServiceType(parentName, this.getRegistry());
    }

    public MobyServiceType[] getLineage() {
        Vector<MobyServiceType> lineage = new Vector<MobyServiceType>();
        for (MobyServiceType parent = this; parent != null; parent = parent.getParent()) {
            lineage.insertElementAt(parent, 0);
        }
        return lineage.toArray(new MobyServiceType[lineage.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParentNames() {
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            String[] names = new String[this.parentNames.length];
            System.arraycopy(this.parentNames, 0, names, 0, this.parentNames.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentNames(String[] value) {
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            if (value == null) {
                this.parentNames = new String[0];
            } else {
                this.parentNames = new String[value.length];
                System.arraycopy(value, 0, this.parentNames, 0, value.length);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addParentName(String value) {
        if (value == null) return;
        String[] stringArray = this.parentNames;
        synchronized (this.parentNames) {
            int len = this.parentNames.length + 1;
            String[] newNames = new String[len];
            System.arraycopy(this.parentNames, 0, newNames, 0, len - 1);
            newNames[len - 1] = value;
            this.setParentNames(newNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String value) {
        this.emailContact = value == null ? "" : value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value == null ? "" : value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append(", Auth: " + this.authority);
        buf.append(", Contact: " + this.emailContact);
        if (this.lsid != null) {
            buf.append(", " + this.lsid);
        }
        buf.append("\n\t" + this.description);
        if (this.parentNames.length > 0) {
            buf.append("\n\tParents: ");
            for (int i = 0; i < this.parentNames.length; ++i) {
                buf.append(this.parentNames[i] + " ");
            }
        }
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    public static Comparator getAuthorityComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

