/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.axis.encoding.Base64;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataString;
import org.w3c.dom.Element;

public class MobyDataBytes
extends MobyDataComposite {
    public static final String BASE64_DATATYPE = "text-base64";
    public static final String ENCODED_MEMBER_NAME = "content";
    public static final int BYTE_READ_SIZE = 4096;

    public MobyDataBytes(Element element) throws MobyException {
        this(element, null);
    }

    public MobyDataBytes(Element element, Registry registry) throws MobyException {
        super(MobyDataType.getDataType(BASE64_DATATYPE, registry), MobyDataBytes.getName(element));
        this.setId(MobyDataBytes.getId(element));
        this.addNamespace(MobyDataBytes.getNamespace(element, registry));
        MobyDataType inputDataType = MobyDataType.getDataType(element.getLocalName(), registry);
        if (!inputDataType.inheritsFrom(MobyDataType.getDataType(BASE64_DATATYPE, registry))) {
            throw new MobyException("The given tag (" + element.getLocalName() + ") does not inherit from " + BASE64_DATATYPE + " in the MOBY Object Class Ontology, cannot " + "consider its contents as binary data");
        }
        this.setDataType(inputDataType);
        this.populateMembersFromDOM(element, registry);
        MobyDataObject contents = this.get(ENCODED_MEMBER_NAME);
        if (contents == null) {
            throw new MobyException("The encoded binary member (content) of the given element (" + element.getLocalName() + ") was missing, but must exist to be a proper " + BASE64_DATATYPE + " object");
        }
        if (!(contents instanceof MobyDataString)) {
            throw new MobyException("The encoded binary member (content) of the given element (" + element.getLocalName() + ") was not a String primitive as expected");
        }
    }

    public MobyDataBytes(String name, byte[] data) throws MobyException {
        this(name, data, (Registry)null);
    }

    public MobyDataBytes(String name, byte[] data, Registry registry) throws MobyException {
        super(MobyDataType.getDataType(BASE64_DATATYPE, registry), name);
        this.storeBytes(data);
    }

    public MobyDataBytes(String name, byte[] data, MobyDataType inputDataType) throws MobyException {
        this(name, data);
        if (!inputDataType.inheritsFrom(MobyDataType.getDataType(BASE64_DATATYPE, inputDataType.getRegistry()))) {
            throw new MobyException("The given data type (" + inputDataType.getName() + ") does not inherit from " + BASE64_DATATYPE + " in the MOBY Object Class Ontology, cannot " + "consider the data given as binary data");
        }
        this.setDataType(inputDataType);
    }

    public MobyDataBytes(String name, CharSequence data) {
        this(name, data, (Registry)null);
    }

    public MobyDataBytes(String name, CharSequence data, Registry registry) {
        super(MobyDataType.getDataType(BASE64_DATATYPE, registry), name);
        this.setDataType(MobyDataType.getDataType(BASE64_DATATYPE, registry));
        this.put(ENCODED_MEMBER_NAME, new MobyDataString(ENCODED_MEMBER_NAME, data, registry));
    }

    public MobyDataBytes(String name, CharSequence data, MobyDataType inputDataType) throws MobyException {
        this(name, data);
        if (!inputDataType.inheritsFrom(MobyDataType.getDataType(BASE64_DATATYPE, inputDataType.getRegistry()))) {
            throw new MobyException("The given data type (" + inputDataType.getName() + ") does not inherit from " + BASE64_DATATYPE + " in the MOBY Object Class Ontology, cannot " + "consider the data given as binary data");
        }
        this.setDataType(inputDataType);
    }

    public MobyDataBytes(String name, URL resourceURL) throws MobyException, IOException {
        this(name, resourceURL, (Registry)null);
    }

    public MobyDataBytes(String name, URL resourceURL, Registry registry) throws MobyException, IOException {
        super(MobyDataType.getDataType(BASE64_DATATYPE, registry), name);
        if (resourceURL == null) {
            return;
        }
        InputStream inputStream = resourceURL.openStream();
        this.storeBytes(this.readStream(inputStream));
    }

    protected void storeBytes(byte[] bytes) throws MobyException {
        if (bytes == null) {
            throw new MobyException("The given byte data to Base64 encode was null");
        }
        String contents = Base64.encode(bytes);
        if (contents == null) {
            throw new MobyException("The byte contents could not be encoded in Base64 format");
        }
        this.put(ENCODED_MEMBER_NAME, new MobyDataString(ENCODED_MEMBER_NAME, (CharSequence)contents));
    }

    public MobyDataBytes(String name, URL resourceURL, MobyDataType inputDataType) throws IOException, MobyException {
        this(name, resourceURL);
        if (!inputDataType.inheritsFrom(MobyDataType.getDataType(BASE64_DATATYPE, inputDataType.getRegistry()))) {
            throw new MobyException("The given data type (" + inputDataType.getName() + ") does not inherit from " + BASE64_DATATYPE + " in the MOBY Object Class Ontology, cannot " + "consider the data at the given URL as binary data");
        }
        this.setDataType(inputDataType);
    }

    protected byte[] readStream(InputStream in) throws IOException {
        int r;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(buffer.length);
        while ((r = in.read(buffer)) > 0) {
            byteStream.write(buffer, 0, r);
        }
        return byteStream.toByteArray();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public Object getObject() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        return Base64.decode(((MobyDataString)this.get(ENCODED_MEMBER_NAME)).getValue());
    }
}

