/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;

public class MobyDataDateTime
extends MobyDataObject {
    private GregorianCalendar value;

    public MobyDataDateTime(Element element) throws IllegalArgumentException {
        this(element, null);
    }

    public MobyDataDateTime(Element element, Registry registry) throws IllegalArgumentException {
        this(MobyDataDateTime.getName(element), MobyDataDateTime.getTextContents(element), registry);
        this.setId(MobyDataDateTime.getId(element));
        this.addNamespace(MobyDataDateTime.getNamespace(element, registry));
    }

    public MobyDataDateTime(String articleName, String stringISO8601) throws IllegalArgumentException {
        this(articleName, stringISO8601, null);
    }

    public MobyDataDateTime(String articleName, String stringISO8601, Registry registry) throws IllegalArgumentException {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("DateTime", registry));
        this.value = MobyDataDateTime.parseISO8601(stringISO8601.trim());
    }

    public MobyDataDateTime(String stringISO8601) {
        this("", stringISO8601);
    }

    public MobyDataDateTime(String articleName, GregorianCalendar cal) {
        this(articleName, cal, (Registry)null);
    }

    public MobyDataDateTime(String articleName, GregorianCalendar cal, Registry registry) {
        super(articleName, "", registry);
        this.setDataType(MobyDataType.getDataType("DateTime", registry));
        this.value = cal;
    }

    public MobyDataDateTime(GregorianCalendar cal) {
        this("", cal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GregorianCalendar parseISO8601(String dateTime) throws IllegalArgumentException {
        if (dateTime == null) {
            return new GregorianCalendar();
        }
        StringTokenizer st = new StringTokenizer(dateTime, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!MobyDataDateTime.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!MobyDataDateTime.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!MobyDataDateTime.check(st, "T") || !st.hasMoreTokens()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!MobyDataDateTime.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new IllegalArgumentException("No seconds specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("Z")) return calendar;
            if (!tok.equals("+") && !tok.equals("-")) {
                throw new IllegalArgumentException("only Z, + or - allowed");
            }
            boolean plus = tok.equals("+");
            if (!st.hasMoreTokens()) {
                throw new IllegalArgumentException("Missing hour field in timezone offset");
            }
            String tzhour = st.nextToken();
            String tzmin = "00";
            if (!MobyDataDateTime.check(st, ":") || !st.hasMoreTokens()) {
                throw new IllegalArgumentException("Missing minute field in timezone offset");
            }
            tzmin = st.nextToken();
            if (plus) {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT+" + tzhour + ":" + tzmin));
                calendar.add(10, Integer.parseInt(tzhour));
                calendar.add(12, Integer.parseInt(tzmin));
                calendar.set(16, 0);
                return calendar;
            } else {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT-" + tzhour + ":" + tzmin));
                calendar.add(10, Integer.parseInt("-" + tzhour));
                calendar.add(12, Integer.parseInt("-" + tzmin));
                calendar.set(16, 0);
            }
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    private static boolean check(StringTokenizer st, String token) throws IllegalArgumentException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new IllegalArgumentException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public Object getObject() {
        return this.value;
    }

    public String toString() {
        return MobyDataDateTime.getString(this.value);
    }

    public static String getString(GregorianCalendar cvalue) {
        String timef = "'T'HH:mm:ss";
        String datef = "yyyy-MM-dd";
        String bothf = "yyyy-MM-dd'T'HH:mm:ss";
        boolean doTimeZone = true;
        String format = bothf;
        if (!(cvalue.isSet(5) && cvalue.get(5) != 1 || cvalue.isSet(2) && cvalue.get(2) != 0 || cvalue.isSet(1) && cvalue.get(1) != 1970)) {
            format = timef;
        } else if (!(cvalue.isSet(10) && cvalue.get(10) != 0 || cvalue.isSet(12) && cvalue.get(12) != 0 || cvalue.isSet(13) && cvalue.get(13) != 0)) {
            format = datef;
            doTimeZone = false;
        }
        StringBuffer result = new StringBuffer(new SimpleDateFormat(format).format(cvalue.getTime()));
        if (doTimeZone) {
            int offsetTotalMillis = cvalue.getTimeZone().getOffset(cvalue.getTime().getTime());
            if (offsetTotalMillis == 0) {
                result.append("Z");
            } else {
                DecimalFormat decf = new DecimalFormat("00");
                int offsetTotalMinutes = offsetTotalMillis / 60000;
                int offsetMinutes = offsetTotalMinutes % 60;
                int offsetHours = offsetTotalMinutes / 60;
                String offsetString = offsetTotalMinutes < 0 ? "-" : "+";
                cvalue.add(12, -offsetMinutes);
                cvalue.add(11, -offsetHours);
                result = new StringBuffer(MobyDataDateTime.formatDateTime(cvalue));
                cvalue.add(12, offsetMinutes);
                cvalue.add(11, offsetHours);
                result.append(offsetString).append(decf.format(Math.abs(offsetHours)));
                result.append(":" + decf.format(Math.abs(offsetMinutes)));
            }
        }
        return result.toString();
    }

    protected static String formatDateTime(Calendar ctime) {
        DecimalFormat decf = new DecimalFormat("00");
        return ctime.get(1) + "-" + decf.format(ctime.get(2) + 1) + "-" + decf.format(ctime.get(5)) + "T" + decf.format(ctime.get(11)) + ":" + decf.format(ctime.get(12)) + ":" + decf.format(ctime.get(13));
    }

    public Object clone() {
        MobyDataDateTime copy = new MobyDataDateTime(this.getName(), this.getValue(), this.getDataType().getRegistry());
        copy.setDataType(this.getDataType());
        copy.setId(this.getId());
        copy.setNamespaces(this.getNamespaces());
        return copy;
    }

    public String getValue() {
        return this.toString();
    }

    public String toXML() {
        if (this.xmlMode == 891) {
            return "<DateTime " + this.getAttrXML() + ">" + this.toString() + "</DateTime>";
        }
        return super.toXML();
    }
}

