/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;

public class MobyDataInt
extends MobyDataObject {
    private BigInteger value;

    public MobyDataInt(Element element) throws IllegalArgumentException {
        this(element, null);
    }

    public MobyDataInt(Element element, Registry registry) throws IllegalArgumentException {
        this(MobyDataInt.getName(element), MobyDataInt.getTextContents(element), registry);
        this.setId(MobyDataInt.getId(element));
        this.addNamespace(MobyDataInt.getNamespace(element, registry));
    }

    public MobyDataInt(String articleName, Number n) {
        this(articleName, n, null);
    }

    public MobyDataInt(String articleName, Number n, Registry registry) {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("Integer", registry));
        this.value = n instanceof BigInteger ? (BigInteger)n : (n instanceof BigDecimal ? ((BigDecimal)n).toBigInteger() : new BigInteger("" + n.intValue()));
    }

    public MobyDataInt(Number n) {
        this("", n, null);
    }

    public MobyDataInt(Number n, Registry r) {
        this("", n, r);
    }

    public MobyDataInt(String articleName, int i) {
        this(articleName, i, (Registry)null);
    }

    public MobyDataInt(String articleName, int i, Registry registry) {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("Integer", registry));
        this.value = new BigInteger("" + i);
    }

    public MobyDataInt(int i) {
        this("", i);
    }

    public MobyDataInt(String articleName, String stringNumber) throws NumberFormatException {
        this(articleName, stringNumber, null);
    }

    public MobyDataInt(String articleName, String stringNumber, Registry registry) throws NumberFormatException {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("Integer", registry));
        this.value = new BigInteger(stringNumber.trim());
    }

    public void add(Number n) {
        this.value = n instanceof BigInteger ? this.value.add((BigInteger)n) : (n instanceof BigDecimal ? this.value.add(((BigDecimal)n).toBigInteger()) : this.value.add(new BigDecimal(n.doubleValue()).toBigInteger()));
    }

    public void subtract(Number n) {
        this.value = n instanceof BigInteger ? this.value.subtract((BigInteger)n) : (n instanceof BigDecimal ? this.value.subtract(((BigDecimal)n).toBigInteger()) : this.value.subtract(new BigDecimal(n.doubleValue()).toBigInteger()));
    }

    public void multiply(Number n) {
        this.value = n instanceof BigInteger ? this.value.multiply((BigInteger)n) : (n instanceof BigDecimal ? this.value.multiply(((BigDecimal)n).toBigInteger()) : this.value.multiply(new BigDecimal(n.doubleValue()).toBigInteger()));
    }

    public void divide(Number n) {
        this.value = n instanceof BigInteger ? this.value.divide((BigInteger)n) : (n instanceof BigDecimal ? this.value.divide(((BigDecimal)n).toBigInteger()) : this.value.divide(new BigDecimal(n.doubleValue()).toBigInteger()));
    }

    public void mod(Number n) {
        this.value = n instanceof BigInteger ? this.value.mod((BigInteger)n) : (n instanceof BigDecimal ? this.value.mod(((BigDecimal)n).toBigInteger()) : this.value.mod(new BigDecimal(n.doubleValue()).toBigInteger()));
    }

    public void pow(Number n) {
        long power = n.longValue();
        if (power == 0L) {
            this.value = BigInteger.ONE;
            return;
        }
        if (power < 0L) {
            for (long i = 1L; i >= power; --i) {
                this.divide(this.value);
            }
        } else {
            for (long i = 1L; i <= power; ++i) {
                this.multiply(this.value);
            }
        }
    }

    public Object clone() {
        MobyDataInt copy = new MobyDataInt(this.getName(), this.value, this.getDataType().getRegistry());
        copy.setDataType(this.getDataType());
        copy.setId(this.getId());
        copy.setNamespaces(this.getNamespaces());
        return copy;
    }

    public int compareTo(Object object) {
        if (object instanceof BigInteger) {
            return this.value.compareTo((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return this.value.compareTo(((BigDecimal)object).toBigInteger());
        }
        if (object instanceof MobyDataObject) {
            return this.compareTo(((MobyDataObject)object).getObject());
        }
        if (object instanceof Number) {
            if (this.value.compareTo(new BigInteger("9223372036854775807")) > 0) {
                return 1;
            }
            if (this.value.compareTo(new BigInteger("-9223372036854775808")) < 0) {
                return -1;
            }
            long diff = this.value.longValue() - ((Number)object).longValue();
            if (diff == 0L) {
                return 0;
            }
            if (diff < 0L) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Object getObject() {
        return this.value;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public String getValue() {
        return "" + this.value;
    }

    public String toXML() {
        if (this.xmlMode == 891) {
            return "<Integer " + this.getAttrXML() + ">" + this.value.toString() + "</" + "Integer" + ">";
        }
        return super.toXML();
    }
}

