/*
 * Decompiled with CFR 0.152.
 */
package org.omg.lsae.notifications;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biomoby.shared.MobyException;
import org.omg.lsae.sax.EventParser;
import org.w3c.dom.Document;

public abstract class AnalysisEvent {
    private String message = "";
    private String timestamp = "";
    private String queryId = "";
    protected final String XSLT = "<!DOCTYPE stylesheet [\r\n  <!ENTITY cr \"<xsl:text>\r\n</xsl:text>\">\r\n]>\r\n \r\n<xsl:stylesheet\r\n    xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" \r\n    xmlns:xalan=\"http://xml.apache.org/xslt\" \r\n    version=\"1.0\">\r\n    \r\n    <xsl:output method=\"xml\" indent=\"yes\" xalan:indent-amount=\"4\"/> \r\n      \r\n    <!-- copy out the xml -->\r\n    <xsl:template match=\"* | @*\">\r\n        <xsl:copy><xsl:copy-of select=\"@*\"/><xsl:apply-templates/></xsl:copy>\r\n    </xsl:template>\r\n \r\n</xsl:stylesheet>";

    public void setMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public void setQueryId(String id) {
        if (id == null) {
            id = "";
        }
        this.queryId = id;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setTimestamp(String time) {
        if (time == null) {
            time = "";
        }
        this.timestamp = time;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    protected Document createDomDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public abstract boolean isCompleted();

    public abstract String toString();

    public abstract String toXMLString();

    public static AnalysisEvent[] createFromXML(Object xmlData) throws MobyException {
        EventParser parser = new EventParser();
        if (xmlData instanceof byte[]) {
            return parser.parse(new ByteArrayInputStream((byte[])xmlData));
        }
        if (xmlData instanceof File) {
            try {
                return parser.parse(new FileInputStream((File)xmlData));
            }
            catch (IOException e) {
                throw new MobyException(e.toString());
            }
        }
        if (xmlData instanceof String) {
            return parser.parse(new StringReader((String)xmlData));
        }
        throw new MobyException("The Analyisis event  data should be sent/received either as type String or base64/byte[]. But they are of type '" + xmlData.getClass().getName() + "'.");
    }
}

