/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import MAANOVA.MyMatlab;
import java.util.Arrays;

public class DataObject {
    private int narrays;
    private int ngenes;
    private int nspots;
    private int nreps;
    private Matrix data;
    private Matrix adj_data;
    private double[] colmeans;
    private double[] offset;

    public int getNarrays() {
        return this.narrays;
    }

    public int getNgenes() {
        return this.ngenes;
    }

    public int getNspots() {
        return this.nspots;
    }

    public int getNreps() {
        return this.nreps;
    }

    public Matrix getData() {
        return this.data;
    }

    public Matrix getAdjData() {
        return this.adj_data;
    }

    public double[] getColMeans() {
        return this.colmeans;
    }

    public double[] getOffset() {
        return this.offset;
    }

    public void setAdjData(Matrix A) {
        this.adj_data = A;
    }

    public void setColmeans(double[] T) {
        this.colmeans = T;
    }

    public DataObject(Matrix datain, int rep, int avgreps) {
        int j;
        int i;
        double buf = 0.0;
        double buf3 = 0.0;
        MyMatlab MatLab = new MyMatlab();
        int nrows = datain.getRowDimension();
        int ncols = datain.getColumnDimension();
        if (nrows % rep != 0) {
            throw new IllegalArgumentException("Number of rows in data file doesnot match the number of replicates!");
        }
        this.ngenes = nrows / rep;
        if (ncols % 2 != 0) {
            throw new IllegalArgumentException("Data does not have an even number of columns!");
        }
        this.narrays = ncols / 2;
        if (avgreps == 0) {
            this.data = datain;
            this.nreps = rep;
        } else {
            double t3;
            double[] t2;
            Matrix t1;
            this.nreps = 1;
            this.data = new Matrix(this.ngenes, ncols, 0.0);
            int[] col = new int[1];
            if (avgreps == 1) {
                i = 0;
                while (i < this.ngenes - rep) {
                    j = 0;
                    while (j < ncols) {
                        col[0] = j;
                        t1 = datain.getMatrix(i, i + rep - 1, col);
                        t2 = t1.getColumnPackedCopy();
                        t3 = MatLab.Mean(t2);
                        this.data.set(i, j, t3);
                        ++j;
                    }
                    i += rep;
                }
            } else if (avgreps == 2) {
                i = 0;
                while (i < this.ngenes - rep) {
                    j = 0;
                    while (j < ncols) {
                        col[0] = j;
                        t1 = datain.getMatrix(i, i + rep - 1, col);
                        t2 = t1.getColumnPackedCopy();
                        Arrays.sort(t2);
                        t3 = t2[t2.length / 2 + 1];
                        j = 0;
                        while (j < ncols) {
                            this.data.set(i, j, t3);
                            ++j;
                        }
                        ++j;
                    }
                    i += rep;
                }
            }
        }
        this.nspots = this.nreps * this.narrays;
        this.adj_data = new Matrix(this.data.getRowDimension(), this.data.getColumnDimension(), 0.0);
        i = 0;
        while (i < nrows) {
            j = 0;
            while (j < ncols) {
                this.adj_data.set(i, j, Math.log(this.data.get(i, j) + 1.0));
                ++j;
            }
            ++i;
        }
        this.colmeans = new double[this.narrays * 2];
        i = 0;
        while (i < ncols) {
            Matrix matbuf = this.adj_data.getMatrix(0, nrows - 1, i, i);
            double[] arrbuf = matbuf.getColumnPackedCopy();
            this.colmeans[i] = MatLab.Mean(arrbuf);
            ++i;
        }
        this.offset = new double[this.narrays * 2];
        boolean A = false;
    }

    public DataObject(Matrix datain, int rep) {
        this.nreps = rep;
        boolean bl = false;
    }

    public DataObject(Matrix datain) {
        this.nreps = 1;
        boolean bl = false;
    }
}

