/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import MAANOVA.DefaultGraph2DModel;
import MAANOVA.JScatterGraph;
import java.awt.Graphics;
import javax.swing.JPanel;

class DrawPanel
extends JPanel {
    private Matrix x;
    private int narrays;

    public DrawPanel(Matrix M, int NA, int[] h) {
        this.x = M;
        this.narrays = NA;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        DefaultGraph2DModel gm = new DefaultGraph2DModel();
        int[] indexR = new int[this.x.getColumnDimension() / 2];
        int[] indexI = new int[this.x.getColumnDimension() / 2];
        int j = 0;
        int i = 0;
        while (i < this.x.getColumnDimension()) {
            indexR[j] = i;
            indexI[j] = i + 1;
            ++j;
            i += 2;
        }
        Matrix x1 = this.x.getMatrix(0, this.x.getRowDimension() - 1, indexR);
        Matrix x2 = this.x.getMatrix(0, this.x.getRowDimension() - 1, indexI);
        Matrix R = x1.minus(x2);
        Matrix I = x1.plus(x2);
        gm.setXAxis(I.getColumnPackedCopy());
        int i2 = 0;
        while (i2 < this.narrays) {
            gm.addSeries(R.getMatrix(0, R.getRowDimension() - 1, i2, i2).getColumnPackedCopy());
            ++i2;
        }
        JScatterGraph SG = new JScatterGraph(gm);
        SG.setNumbering(true);
        SG.setXIncrement(0.0f);
        SG.setYIncrement(0.0f);
        SG.setYExtrema(0.0f, 0.0f);
        SG.setBounds(0, 0, 600, 600);
        SG.offscreenPaint(g);
        SG.rescale();
    }
}

