/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ImageButton
extends JButton {
    private final int PRESSED = 0;
    private final int RELEASED = 1;
    private final int OVER = 2;
    private final int LEFT = 3;
    private ImageButtonListener l = new ImageButtonListener();

    public ImageButton(Image img) {
        super(new ImageIcon(img));
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.addMouseListener(this.l);
    }

    private void changeImage(int type) {
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                break;
            }
            case 2: {
                if (!this.isEnabled()) break;
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                break;
            }
            case 3: {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
        }
    }

    protected void setEnabled() {
        this.setEnabled(true);
        this.addMouseListener(this.l);
    }

    protected void setDisabled() {
        this.setEnabled(false);
        this.setBorder(null);
    }

    private class ImageButtonListener
    extends MouseAdapter {
        private ImageButtonListener() {
        }

        public void mousePressed(MouseEvent me) {
            ImageButton.this.changeImage(0);
        }

        public void mouseReleased(MouseEvent me) {
            ImageButton.this.changeImage(1);
        }

        public void mouseEntered(MouseEvent me) {
            ImageButton.this.changeImage(2);
        }

        public void mouseExited(MouseEvent me) {
            ImageButton.this.changeImage(3);
        }

        public void mouseClicked(MouseEvent me) {
            ImageButton.this.changeImage(3);
        }
    }
}

