/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.tigr.midas.Constant;
import org.tigr.midas.util.GBA;

public class MessagePane
extends JPanel {
    private JTextPane logTextPane;
    private JLabel logLabel;
    private JScrollPane logScrollPane;
    private Dimension dm = new Dimension(400, 100);

    public MessagePane() {
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        this.setLayout(new BorderLayout());
        this.logTextPane = new JTextPane();
        this.logTextPane.setEditable(false);
        this.logScrollPane = new JScrollPane(this.logTextPane);
        this.logScrollPane.setBackground(Color.white);
        this.logScrollPane.setForeground(Color.white);
        this.logScrollPane.setVerticalScrollBarPolicy(22);
        this.add(this.logScrollPane);
        this.setPreferredSize(this.dm);
    }

    public MessagePane(String s, Color color) {
        this.setLayout(new BorderLayout());
        this.logTextPane = new JTextPane();
        this.logTextPane.setEditable(false);
        this.logTextPane.setText(s);
        this.logTextPane.setForeground(color);
        this.logScrollPane = new JScrollPane(this.logTextPane);
        this.add(this.logScrollPane);
        this.setPreferredSize(this.dm);
    }

    public void appendMessage(String s, Color color) {
        try {
            StyleContext.NamedStyle style = new StyleContext.NamedStyle(new StyleContext());
            StyleConstants.setForeground(style, color);
            DefaultStyledDocument doc = (DefaultStyledDocument)this.logTextPane.getStyledDocument();
            doc.insertString(doc.getLength(), "\n" + s, style);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendMessageInLine(String s, Color color) {
        try {
            StyleContext.NamedStyle style = new StyleContext.NamedStyle(new StyleContext());
            StyleConstants.setForeground(style, color);
            DefaultStyledDocument doc = (DefaultStyledDocument)this.logTextPane.getStyledDocument();
            doc.insertString(doc.getLength(), s, style);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void appendMessage(String s) {
        this.appendMessage(s, Constant.green_1);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        GBA gba = new GBA();
        Container container = frame.getContentPane();
        container.setLayout(new GridBagLayout());
        MessagePane messagePane = new MessagePane("Welcome to use TIGR MIDAS Version X.0.", Color.blue);
        messagePane.appendMessage("Now adding new messages...", Color.green);
        messagePane.appendMessageInLine("Done!", Color.green);
        gba.add(container, messagePane, 0, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
        frame.pack();
        frame.show();
    }
}

