/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.Midas;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.swing.DecimalNumberField;
import org.tigr.midas.util.swing.FileChooserEditor;
import org.tigr.midas.util.swing.JTableX;
import org.tigr.midas.util.swing.MaanovaCellEditor;
import org.tigr.midas.util.swing.NumberCellEditor;
import org.tigr.midas.util.swing.RowEditorModel;
import org.tigr.midas.util.swing.SAMImputationEngineEditor;
import org.tigr.midas.util.swing.SAMPermutationsNumberEditor;
import org.tigr.midas.util.swing.WholeNumberField;

public class ParameterPane
extends JPanel {
    private final String READ_FILE_FILENAME = "Data File Name";
    private final String ONE_BAD_CHANNEL_POLICY = "One Bad Channel Tolerance Policy";
    private final String USE_CH1_FLAG = "Use ChannelA Flag";
    private final String USE_CH2_FLAG = "Use ChannelB Flag";
    private final String CH1_BACKGROUND_CHECK = "ChannelA Background Checking";
    private final String CH2_BACKGROUND_CHECK = "ChannelB Background Checking";
    private final String SN_RATIO_CUTOFF = "Signal/Noise Threshold";
    private final String READ_FILE_PAIRS = "Data File Pair";
    private final String READ_FOLDER_NAME = "Multiple Data Files Names";
    private final String USE_CROSS_FILE_TRIM_FLAG = "Apply Cross File Cutoff";
    private final String CROSS_FILE_PCT = "Cross File Cutoff Pct ( \u2264 1.0 )";
    private final String TOTINT_CY3_CUTOFF = "Cy3 Intensity Threshold";
    private final String TOTINT_CY5_CUTOFF = "Cy5 Intensity Threshold";
    private final String LOCFIT_MODE = "Mode";
    private final String LOCFIT_SMOOTH_PARAM = "Smoothing Parameter";
    private final String ITER_LIN_REG_MODE = "Mode";
    private final String ITER_LIN_REG_SD_FOLD = "Outlier Range";
    private final String ITER_LOG_MEAN_SD_FOLD = "Data Range For Mean Centering";
    private final String BLOCK_SD_REG_OPTION = "Block SD Regularization";
    private final String SLIDE_SD_REG_OPTION = "Slide SD Regularization";
    private final String RATIO_STATS_CI_CHK_FLAG = "Confidence Interval Checking";
    private final String REFERENCE = "Reference";
    private final String SLICE_DATA_POP = "Slice Data Population";
    private final String SLICE_DATA_KEEP_LT = "Data Keep Range <";
    private final String SLICE_DATA_KEEP_GT = "Data Keep Range >";
    private final String REPLICATES_IDENTIFIER_COL = "Identifier Column";
    private final String TTEST_GRP_ASSIGNMENT = "Group Assignment";
    private final String TTEST_HYPO_MEAN = "Hypothetical Non-significant Log Ratio";
    private final String TTEST_PVAL_BASE = "Compute p-values Based On";
    private final String TTEST_ALPHA = "\u03b1 (critical p-value)";
    private final String TTEST_SIGNIFICANT_METHOD = "Significant Method";
    private final String SAM_HYPO_MEAN = "Hypothetical Non-significant Log Ratio";
    private final String SAM_PERMUTATIONS_NUMBER = "Number of Permutations";
    private final String SAM_S0_METHOD = "S0 Calculation Method";
    private final String SAM_IMPUTATION_ENGINE = "Missing Data Imputation Method";
    private final String SAM_FDR_THRESHOLD = "FDR Threshold";
    private final String FLIP_DYE_TRIM_OPTION = "Data Trim Option";
    private final String FLIP_DYE_DATA_KEEP_RANGE = "Cross Log Ratio Data Keep Range";
    private final String MA_ANOVA = "MAANOVA";
    private final String OUT_FILENAME = "Output File Name";
    private final String VIRTUAL_TRIM_OPTION = "Virtual Trim";
    private final String RENUMBER_OPTION = "Re-number";
    private final String OUTPUT_TRIMMED_OPTION = "Output Trimmed Data";
    private final String[] ONE_BAD_CHANNEL_POLICY_VALUES = new String[]{"Stringent", "Generous"};
    private final String[] FLIPDYE_CUT_OPTION_VALUES = new String[]{"SD cut", "threshold cut"};
    private final String[] DATA_KEEP_OPTION_VALUES = new String[]{"beyond", "within"};
    private final String[] SD_VALUES = new String[]{"+/-0.50 \u03c3", "+/-1.00 \u03c3", "+/-1.50 \u03c3", "+/-1.96 \u03c3", "+/-2.00 \u03c3", "+/-2.50 \u03c3", "+/-3.00 \u03c3"};
    private final String[] SA_SD_VALUES = new String[]{"----------", "+/-0.00 \u03c3", "+/-0.50 \u03c3", "+/-1.00 \u03c3", "+/-1.50 \u03c3", "+/-1.96 \u03c3", "+/-2.00 \u03c3", "+/-2.50 \u03c3", "+/-3.00 \u03c3"};
    private final String[] COLUMN_NAMES = new String[]{"Parameter", "Value"};
    private final String[] CY_REF_VALUES = new String[]{"cy3", "cy5"};
    private final String[] LOCFIT_MODE_VALUES = new String[]{"block", "global"};
    private final String[] ITER_LIN_REG_MODE_VALUES = new String[]{"block", "global"};
    private final String[] IDENTIFIER_COL_VALUES = new String[]{"MEV format, specify the identifier column name", "TAV format, specify the identifier column number"};
    private final String[] TTEST_P_BASE_VALUES = new String[]{"T-Distribution", "All possible unique permutations", "Specify permutations number"};
    private final String[] TTEST_SIG_METHODS_VALUES = new String[]{"Just \u03b1", "Standard Bonferroni", "Adjusted Bonferroni"};
    private final String[] SAM_S0_METHODS_VALUES = new String[]{"Tusher's methods", "5th percentile", "50th percentile", "90th percentile", "Use minimum S value"};
    private final String[] SAM_IMPUTATION_ENGINE_VALUES = new String[]{"K-nearest neighbors", "Row average"};
    private boolean DEBUG = false;
    private GBA gba = new GBA();
    private int src;
    private Object[][] data = new Object[0][];
    private Font theFont;
    private RowEditorModel rm;
    public static int fpd;

    public ParameterPane() {
        this(999);
    }

    public ParameterPane(int source) {
        String s2;
        String s1;
        DefaultCellEditor ed;
        JComboBox<String> cb1;
        DefaultCellEditor ed1;
        JComboBox<String> cb12;
        JComponent cb;
        DefaultCellEditor ed12;
        JComboBox<String> cb13;
        JButton b;
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(200, 165));
        this.theFont = this.getFont();
        this.src = source;
        this.rm = new RowEditorModel();
        if (source == 0) {
            fpd = 0;
            this.data = new Object[][]{{"Data File Name", Parameter.pSingleFileStr}, {"One Bad Channel Tolerance Policy", Parameter.pOneBadChannelPolicyStr}, {"Use ChannelA Flag", new Boolean(Parameter.pUseCh1FlagOpt)}, {"Use ChannelB Flag", new Boolean(Parameter.pUseCh2FlagOpt)}, {"ChannelA Background Checking", new Boolean(Parameter.pCh1BkgdOpt)}, {"ChannelB Background Checking", new Boolean(Parameter.pCh2BkgdOpt)}, {"Signal/Noise Threshold", new Float(Parameter.pBkgdSNRatioVal)}};
            b = new JButton(Parameter.pSingleFileStr);
            b.setToolTipText(Parameter.pSingleFileStr);
            b.setFont(this.theFont);
            cb13 = new JComboBox<String>(this.ONE_BAD_CHANNEL_POLICY_VALUES);
            cb13.setBackground(Color.white);
            cb13.setFont(this.theFont);
            ed12 = new DefaultCellEditor(cb13);
            JCheckBox cb2 = new JCheckBox();
            cb2.setForeground(Color.white);
            cb2.setBackground(Color.white);
            cb2.setHorizontalAlignment(0);
            FileChooserEditor fced = new FileChooserEditor(b);
            DefaultCellEditor ed2 = new DefaultCellEditor(cb2);
            DecimalNumberField snRatioField = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed22 = new NumberCellEditor(snRatioField);
            this.rm.addEditorForRow(0, fced);
            this.rm.addEditorForRow(1, ed12);
            this.rm.addEditorForRow(2, ed2);
            this.rm.addEditorForRow(3, ed2);
            this.rm.addEditorForRow(4, ed2);
            this.rm.addEditorForRow(5, ed2);
            this.rm.addEditorForRow(6, ed22);
        } else if (source == 1) {
            fpd = 1;
            this.data = new Object[][]{{"Data File Pair", Parameter.pFilePairVec}, {"One Bad Channel Tolerance Policy", Parameter.pOneBadChannelPolicyStr}, {"Use ChannelA Flag", new Boolean(Parameter.pUseCh1FlagOpt)}, {"Use ChannelB Flag", new Boolean(Parameter.pUseCh2FlagOpt)}, {"ChannelA Background Checking", new Boolean(Parameter.pCh1BkgdOpt)}, {"ChannelB Background Checking", new Boolean(Parameter.pCh2BkgdOpt)}, {"Signal/Noise Threshold", new Float(Parameter.pBkgdSNRatioVal)}};
            b = new JButton(Parameter.pFilePairVec.toString());
            b.setFont(this.getFont());
            cb13 = new JComboBox<String>(this.ONE_BAD_CHANNEL_POLICY_VALUES);
            cb13.setBackground(Color.white);
            cb13.setFont(this.theFont);
            ed12 = new DefaultCellEditor(cb13);
            JCheckBox cb3 = new JCheckBox();
            cb3.setForeground(Color.white);
            cb3.setBackground(Color.white);
            cb3.setHorizontalAlignment(0);
            FileChooserEditor fced = new FileChooserEditor(b);
            DefaultCellEditor ed3 = new DefaultCellEditor(cb3);
            DecimalNumberField snRatioField = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed2 = new NumberCellEditor(snRatioField);
            this.rm.addEditorForRow(0, fced);
            this.rm.addEditorForRow(1, ed12);
            this.rm.addEditorForRow(2, ed3);
            this.rm.addEditorForRow(3, ed3);
            this.rm.addEditorForRow(4, ed3);
            this.rm.addEditorForRow(5, ed3);
            this.rm.addEditorForRow(6, ed2);
        } else if (source == 2) {
            fpd = 2;
            this.data = new Object[][]{{"Multiple Data Files Names", Parameter.pFolderStr}, {"One Bad Channel Tolerance Policy", new String(Parameter.pOneBadChannelPolicyStr)}, {"Use ChannelA Flag", new Boolean(Parameter.pUseCh1FlagOpt)}, {"Use ChannelB Flag", new Boolean(Parameter.pUseCh2FlagOpt)}, {"ChannelA Background Checking", new Boolean(Parameter.pCh1BkgdOpt)}, {"ChannelB Background Checking", new Boolean(Parameter.pCh2BkgdOpt)}, {"Signal/Noise Threshold", new Float(Parameter.pBkgdSNRatioVal)}};
            b = new JButton(Parameter.pFolderStr);
            b.setFont(this.getFont());
            cb13 = new JComboBox<String>(this.ONE_BAD_CHANNEL_POLICY_VALUES);
            cb13.setBackground(Color.white);
            cb13.setFont(this.theFont);
            ed12 = new DefaultCellEditor(cb13);
            JCheckBox cb4 = new JCheckBox();
            cb4.setForeground(Color.white);
            cb4.setBackground(Color.white);
            cb4.setHorizontalAlignment(0);
            DefaultCellEditor ed4 = new DefaultCellEditor(cb4);
            FileChooserEditor fced = new FileChooserEditor(b);
            DecimalNumberField snRatioField = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed2 = new NumberCellEditor(snRatioField);
            this.rm.addEditorForRow(0, fced);
            this.rm.addEditorForRow(1, ed12);
            this.rm.addEditorForRow(2, ed4);
            this.rm.addEditorForRow(3, ed4);
            this.rm.addEditorForRow(4, ed4);
            this.rm.addEditorForRow(5, ed4);
            this.rm.addEditorForRow(6, ed2);
        } else if (source == 12) {
            this.data = new Object[][]{{"Reference", new String(Parameter.pRefStr)}};
            cb = new JComboBox<String>(this.CY_REF_VALUES);
            DefaultCellEditor ed3 = new DefaultCellEditor((JComboBox<?>)cb);
            cb.setBackground(Color.white);
            cb.setFont(this.theFont);
            this.rm.addEditorForRow(0, ed3);
        } else if (source == 11) {
            this.data = new Object[][]{{"Mode", Parameter.pLocfitModeStr}, {"Smoothing Parameter", new Float(Parameter.pSmoothParaVal)}, {"Reference", new String(Parameter.pRefStr)}};
            cb12 = new JComboBox<String>(this.LOCFIT_MODE_VALUES);
            ed1 = new DefaultCellEditor(cb12);
            cb12.setBackground(Color.white);
            cb12.setFont(this.theFont);
            DecimalNumberField smoothParamField = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed2 = new NumberCellEditor(smoothParamField);
            JComboBox<String> cb2 = new JComboBox<String>(this.CY_REF_VALUES);
            DefaultCellEditor ed3 = new DefaultCellEditor(cb2);
            cb2.setBackground(Color.white);
            cb2.setFont(this.theFont);
            this.rm.addEditorForRow(0, ed1);
            this.rm.addEditorForRow(1, ed2);
            this.rm.addEditorForRow(2, ed3);
        } else if (source == 15) {
            this.data = new Object[][]{{"Mode", Parameter.pIterLinRegModeStr}, {"Outlier Range", "+/-" + Parameter.pIterLinRegSDRangeVal + " \u03c3"}, {"Reference", new String(Parameter.pRefStr)}};
            JComboBox<String> cb0 = new JComboBox<String>(this.ITER_LIN_REG_MODE_VALUES);
            DefaultCellEditor ed0 = new DefaultCellEditor(cb0);
            cb0.setBackground(Color.white);
            cb0.setFont(this.theFont);
            cb1 = new JComboBox<String>(this.SD_VALUES);
            cb1.setBackground(Color.white);
            cb1.setFont(this.theFont);
            DefaultCellEditor ed13 = new DefaultCellEditor(cb1);
            JComboBox<String> cb2 = new JComboBox<String>(this.CY_REF_VALUES);
            DefaultCellEditor ed2 = new DefaultCellEditor(cb2);
            cb2.setBackground(Color.white);
            cb2.setFont(this.theFont);
            this.rm.addEditorForRow(0, ed0);
            this.rm.addEditorForRow(1, ed13);
            this.rm.addEditorForRow(2, ed2);
        } else if (source == 14) {
            this.data = new Object[][]{{"Data Range For Mean Centering", "+/-" + Parameter.pIterLogMeanSDRangeVal + " \u03c3"}, {"Reference", new String(Parameter.pRefStr)}};
            cb12 = new JComboBox<String>(this.SD_VALUES);
            cb12.setBackground(Color.white);
            cb12.setFont(this.theFont);
            ed1 = new DefaultCellEditor(cb12);
            JComboBox<String> cb2 = new JComboBox<String>(this.CY_REF_VALUES);
            DefaultCellEditor ed2 = new DefaultCellEditor(cb2);
            cb2.setBackground(Color.white);
            cb2.setFont(this.theFont);
            this.rm.addEditorForRow(0, ed1);
            this.rm.addEditorForRow(1, ed2);
        } else if (source == 13) {
            if (fpd == 0 || fpd == 1) {
                this.data = new Object[][]{{"Reference", new String(Parameter.pRefStr)}};
                cb12 = new JComboBox<String>(this.CY_REF_VALUES);
                ed1 = new DefaultCellEditor(cb12);
                cb12.setBackground(Color.white);
                cb12.setFont(this.theFont);
                this.rm.addEditorForRow(0, ed1);
            } else if (fpd == 2) {
                this.data = new Object[][]{{"Block SD Regularization", new Boolean(Parameter.pBlockSDRegOpt)}, {"Slide SD Regularization", new Boolean(Parameter.pSlideSDRegOpt)}, {"Reference", new String(Parameter.pRefStr)}};
                cb = new JCheckBox();
                cb.setForeground(Color.white);
                cb.setBackground(Color.white);
                ((AbstractButton)cb).setHorizontalAlignment(0);
                ed = new DefaultCellEditor((JCheckBox)cb);
                cb1 = new JComboBox<String>(this.CY_REF_VALUES);
                DefaultCellEditor ed14 = new DefaultCellEditor(cb1);
                cb1.setBackground(Color.white);
                cb1.setFont(this.theFont);
                this.rm.addEditorForRow(0, ed);
                this.rm.addEditorForRow(1, ed);
                this.rm.addEditorForRow(2, ed14);
            }
        } else if (source == 16) {
            this.data = new Object[][]{{"Confidence Interval Checking", new Boolean(Parameter.pRatioStatsCIChkOpt)}, {"Reference", new String(Parameter.pRefStr)}};
            cb = new JCheckBox();
            cb.setForeground(Color.white);
            cb.setBackground(Color.white);
            ((AbstractButton)cb).setHorizontalAlignment(0);
            ed = new DefaultCellEditor((JCheckBox)cb);
            cb1 = new JComboBox<String>(this.CY_REF_VALUES);
            DefaultCellEditor ed15 = new DefaultCellEditor(cb1);
            cb1.setBackground(Color.white);
            cb1.setFont(this.theFont);
            this.rm.addEditorForRow(0, ed);
            this.rm.addEditorForRow(1, ed15);
        } else if (source == 10) {
            this.data = new Object[][]{{"Cy3 Intensity Threshold", new Long(Parameter.pCy3CutoffVal)}, {"Cy5 Intensity Threshold", new Long(Parameter.pCy5CutoffVal)}};
            WholeNumberField cy3Field = new WholeNumberField(0, 8);
            ed1 = new NumberCellEditor(cy3Field);
            WholeNumberField cy5Field = new WholeNumberField(0, 8);
            NumberCellEditor ed2 = new NumberCellEditor(cy5Field);
            this.rm.addEditorForRow(0, ed1);
            this.rm.addEditorForRow(1, ed2);
        } else if (source == 20) {
            String gtStr;
            String ltStr;
            if (Parameter.pSliceDataRangeLtVal == Float.POSITIVE_INFINITY || (double)Parameter.pSliceDataRangeLtVal == -1.0) {
                Parameter.pSliceDataRangeLtVal = Float.POSITIVE_INFINITY;
                ltStr = "----------";
            } else {
                ltStr = "+/-" + new Float(Parameter.pSliceDataRangeLtVal).toString() + " \u03c3";
            }
            if (Parameter.pSliceDataRangeGtVal == Float.NEGATIVE_INFINITY || (double)Parameter.pSliceDataRangeGtVal == -1.0) {
                Parameter.pSliceDataRangeGtVal = Float.NEGATIVE_INFINITY;
                gtStr = "----------";
            } else {
                gtStr = "+/-" + new Float(Parameter.pSliceDataRangeGtVal).toString() + " \u03c3";
            }
            this.data = new Object[][]{{"Slice Data Population", new Integer(Parameter.pSliceDataPopVal)}, {"Data Keep Range >", gtStr}, {"Data Keep Range <", ltStr}};
            WholeNumberField slicePopField = new WholeNumberField(0, 5);
            NumberCellEditor ed0 = new NumberCellEditor(slicePopField);
            JComboBox<String> cb14 = new JComboBox<String>(this.SA_SD_VALUES);
            cb14.setBackground(Color.white);
            cb14.setFont(this.theFont);
            DefaultCellEditor ed16 = new DefaultCellEditor(cb14);
            JComboBox<String> cb2 = new JComboBox<String>(this.SA_SD_VALUES);
            cb2.setBackground(Color.white);
            cb2.setFont(this.theFont);
            DefaultCellEditor ed2 = new DefaultCellEditor(cb2);
            this.rm.addEditorForRow(0, ed0);
            this.rm.addEditorForRow(1, ed16);
            this.rm.addEditorForRow(2, ed2);
        } else if (source == 30) {
            String s = null;
            s = Parameter.pIdentifierCol instanceof String ? "MEV column name: '" + Parameter.pIdentifierCol + "'" : "TAV column number: " + Parameter.pIdentifierCol;
            this.data = new Object[][]{{"Identifier Column", new String(s)}};
            cb13 = new JComboBox<String>(this.IDENTIFIER_COL_VALUES);
            cb13.setBackground(Color.white);
            cb13.setFont(this.theFont);
            ed12 = new DefaultCellEditor(cb13);
            this.rm.addEditorForRow(0, ed12);
        } else if (source == 32) {
            s1 = null;
            s2 = null;
            s1 = Parameter.pTtestPValBase == -323 ? "T-Distribution" : (Parameter.pTtestPValBase == 320 ? "All possible permutations" : new Integer(Parameter.pTtestPValBase).toString() + " random permutations");
            if (Parameter.pTtestSigMethod == 324) {
                s2 = "Just Alpha";
            } else if (Parameter.pTtestSigMethod == 325) {
                s2 = "Standard Bonferroni";
            } else if (Parameter.pTtestSigMethod == 326) {
                s2 = "Adjusted Bonferroni";
            }
            this.data = new Object[][]{{"Hypothetical Non-significant Log Ratio", new Float(Parameter.pTtestHypoMean)}, {"Compute p-values Based On", new String(s1)}, {"\u03b1 (critical p-value)", new Float(Parameter.pTtestAlpha)}, {"Significant Method", new String(s2)}};
            JButton b2 = new JButton(Parameter.pGroupFilesVec.toString());
            b2.setFont(this.getFont());
            DecimalNumberField field = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed2 = new NumberCellEditor(field);
            JComboBox<String> cb3 = new JComboBox<String>(this.TTEST_P_BASE_VALUES);
            cb3.setBackground(Color.white);
            cb3.setFont(this.theFont);
            DefaultCellEditor ed3 = new DefaultCellEditor(cb3);
            JComboBox<String> cb5 = new JComboBox<String>(this.TTEST_SIG_METHODS_VALUES);
            cb5.setBackground(Color.white);
            cb5.setFont(this.theFont);
            DefaultCellEditor ed5 = new DefaultCellEditor(cb5);
            this.rm.addEditorForRow(0, ed2);
            this.rm.addEditorForRow(1, ed3);
            this.rm.addEditorForRow(2, ed2);
            this.rm.addEditorForRow(3, ed5);
        } else if (source == 33) {
            s1 = null;
            s2 = null;
            String s3 = null;
            if (Parameter.pSAMS0Method == 3301) {
                s1 = "Tusher's methods";
            } else if (Parameter.pSAMS0Method == 3302) {
                s1 = "5th percentile";
            } else if (Parameter.pSAMS0Method == 3302) {
                s1 = "50th percentile";
            } else if (Parameter.pSAMS0Method == 3304) {
                s1 = "90th percentile";
            } else if (Parameter.pSAMS0Method == 3305) {
                s1 = "Use minimum S value";
            }
            s2 = Parameter.pSAMImputationEngine == 3306 ? Integer.toString(Parameter.pSAMNearestNeighborsNumber) + " Nearest Neighbors" : "Row Average";
            s3 = Parameter.pSAMAllUniquePerm ? " unique" : " random";
            this.data = new Object[][]{{"Hypothetical Non-significant Log Ratio", new Float(Parameter.pSAMHypoMean)}, {"Number of Permutations", new String(Integer.toString(Parameter.pSAMPermutationsNumber)) + s3}, {"S0 Calculation Method", new String(s1)}, {"Missing Data Imputation Method", new String(s2)}};
            DecimalNumberField field = new DecimalNumberField(0.0f, 5);
            NumberCellEditor ed0 = new NumberCellEditor(field);
            JButton b3 = new JButton();
            b3.setFont(this.theFont);
            SAMPermutationsNumberEditor ed17 = new SAMPermutationsNumberEditor(b3);
            JComboBox<String> cb2 = new JComboBox<String>(this.SAM_S0_METHODS_VALUES);
            cb2.setBackground(Color.white);
            cb2.setFont(this.theFont);
            DefaultCellEditor ed2 = new DefaultCellEditor(cb2);
            JButton bb = new JButton();
            bb.setFont(this.theFont);
            SAMImputationEngineEditor ed3 = new SAMImputationEngineEditor(bb);
            this.rm.addEditorForRow(0, ed0);
            this.rm.addEditorForRow(1, ed17);
            this.rm.addEditorForRow(2, ed2);
            this.rm.addEditorForRow(3, ed3);
        } else if (source == 40) {
            if (Parameter.pFlipdyeCutOptionStr.equalsIgnoreCase("threshold cut")) {
                this.data = new Object[][]{{"Data Trim Option", Parameter.pFlipdyeCutOptionStr}, {"Cross Log Ratio Data Keep Range", new Float(Parameter.pFlipdyeDataKeepRangeVal).toString()}};
                cb12 = new JComboBox<String>(this.FLIPDYE_CUT_OPTION_VALUES);
                cb12.setBackground(Color.white);
                cb12.setFont(this.theFont);
                ed1 = new DefaultCellEditor(cb12);
                DecimalNumberField hardCutField = new DecimalNumberField(Parameter.pFlipdyeDataKeepRangeVal, 5);
                hardCutField.setBackground(Color.white);
                hardCutField.setFont(this.theFont);
                NumberCellEditor ed3 = new NumberCellEditor(hardCutField);
                this.rm.addEditorForRow(0, ed1);
                this.rm.addEditorForRow(1, ed3);
            } else {
                this.data = new Object[][]{{"Data Trim Option", Parameter.pFlipdyeCutOptionStr}, {"Cross Log Ratio Data Keep Range", "+/-" + Parameter.pFlipdyeDataKeepRangeVal + " \u03c3"}};
                cb12 = new JComboBox<String>(this.FLIPDYE_CUT_OPTION_VALUES);
                cb12.setBackground(Color.white);
                cb12.setFont(this.theFont);
                ed1 = new DefaultCellEditor(cb12);
                JComboBox<String> cb3 = new JComboBox<String>(this.SD_VALUES);
                cb3.setBackground(Color.white);
                cb3.setFont(this.theFont);
                DefaultCellEditor ed3 = new DefaultCellEditor(cb3);
                this.rm.addEditorForRow(0, ed1);
                this.rm.addEditorForRow(1, ed3);
            }
        } else if (this.src == 41) {
            this.data = new Object[][]{{"MAANOVA", Parameter.pMaAnovaStr}};
            b = new JButton("no selection made");
            b.setToolTipText("Launch MAANOVA dialog");
            b.setFont(this.getFont());
            ed1 = new MaanovaCellEditor(b);
            JTextField tf = new JTextField("TEST");
            tf.setEditable(false);
            tf.setBackground(Color.white);
            tf.setFont(this.theFont);
            DefaultCellEditor ed2 = new DefaultCellEditor(tf);
            this.rm.addEditorForRow(0, ed1);
        } else if (source == 100) {
            if (fpd == 2) {
                this.data = new Object[][]{{"Virtual Trim", new Boolean(Parameter.pVtrimOpt)}, {"Output Trimmed Data", new Boolean(Parameter.pOutputTrimmedDataOpt)}, {"Apply Cross File Cutoff", new Boolean(Parameter.pUseCrossFileTrimOpt)}, {"Cross File Cutoff Pct ( \u2264 1.0 )", new Float(Parameter.pCrossFilePct)}};
                cb = new JCheckBox();
                cb.setForeground(Color.white);
                cb.setBackground(Color.white);
                ((AbstractButton)cb).setHorizontalAlignment(0);
                ed = new DefaultCellEditor((JCheckBox)cb);
                DecimalNumberField crossFilePctField = new DecimalNumberField(0.0f, 5);
                NumberCellEditor ed3 = new NumberCellEditor(crossFilePctField);
                this.rm.addEditorForRow(0, ed);
                this.rm.addEditorForRow(1, ed);
                this.rm.addEditorForRow(2, ed);
                this.rm.addEditorForRow(3, ed3);
            } else {
                this.data = new Object[][]{{"Virtual Trim", new Boolean(Parameter.pVtrimOpt)}, {"Output Trimmed Data", new Boolean(Parameter.pOutputTrimmedDataOpt)}};
                cb = new JCheckBox();
                cb.setForeground(Color.white);
                cb.setBackground(Color.white);
                ((AbstractButton)cb).setHorizontalAlignment(0);
                ed = new DefaultCellEditor((JCheckBox)cb);
                this.rm.addEditorForRow(0, ed);
                this.rm.addEditorForRow(1, ed);
            }
        } else {
            this.setBackground(Color.white);
        }
        DefaultTableModel midasParamTableModel = new DefaultTableModel(this.COLUMN_NAMES, this.data.length){

            public String getColumnName(int col) {
                return ParameterPane.this.COLUMN_NAMES[col];
            }

            public Object getValueAt(int row, int col) {
                return ParameterPane.this.data[row][col];
            }

            public boolean isCellEditable(int row, int col) {
                return col >= 1;
            }

            public void setValueAt(Object value, int row, int col) {
                if (ParameterPane.this.DEBUG) {
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
                }
                String key = ParameterPane.this.data[row][col - 1].toString();
                ((ParameterPane)ParameterPane.this).data[row][col] = value;
                if (ParameterPane.this.src == 0) {
                    if (key == "Data File Name") {
                        Parameter.pSingleFileStr = value.toString();
                        Parameter.pFilePairVec = new Vector();
                        Parameter.pFolderStr = "Please specify a directory";
                        Parameter.pFolderFilesVec = new Vector();
                    } else if (key == "One Bad Channel Tolerance Policy") {
                        Parameter.pOneBadChannelPolicyStr = value.toString();
                    } else if (key == "Use ChannelA Flag") {
                        Parameter.pUseCh1FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh1FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh1FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh1FlagCol = -1;
                        }
                    } else if (key == "Use ChannelB Flag") {
                        Parameter.pUseCh2FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh2FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh2FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh2FlagCol = -1;
                        }
                    } else if (key == "ChannelA Background Checking") {
                        Parameter.pCh1BkgdOpt = (Boolean)value;
                        if (Parameter.pCh1BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh1BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "ChannelB Background Checking") {
                        Parameter.pCh2BkgdOpt = (Boolean)value;
                        if (Parameter.pCh2BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh2BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "Signal/Noise Threshold") {
                        Parameter.pBkgdSNRatioVal = ((Double)value).floatValue();
                    }
                } else if (ParameterPane.this.src == 1) {
                    if (key == "Data File Pair") {
                        Parameter.pFilePairVec = (Vector)value;
                        Parameter.pSingleFileStr = "Please specify a file";
                        Parameter.pFolderStr = "Please specify a directory";
                        Parameter.pFolderFilesVec = new Vector();
                    } else if (key == "One Bad Channel Tolerance Policy") {
                        Parameter.pOneBadChannelPolicyStr = value.toString();
                    } else if (key == "Use ChannelA Flag") {
                        Parameter.pUseCh1FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh1FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh1FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh1FlagCol = -1;
                        }
                    } else if (key == "Use ChannelB Flag") {
                        Parameter.pUseCh2FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh2FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh2FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh2FlagCol = -1;
                        }
                    } else if (key == "ChannelA Background Checking") {
                        Parameter.pCh1BkgdOpt = (Boolean)value;
                        if (Parameter.pCh1BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh1BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "ChannelB Background Checking") {
                        Parameter.pCh2BkgdOpt = (Boolean)value;
                        if (Parameter.pCh2BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh2BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "Signal/Noise Threshold") {
                        Parameter.pBkgdSNRatioVal = ((Double)value).floatValue();
                    }
                } else if (ParameterPane.this.src == 2) {
                    if (key == "Multiple Data Files Names") {
                        Parameter.pFolderStr = value.toString();
                        Parameter.pSingleFileStr = "Please specify a file";
                        Parameter.pFilePairVec = new Vector();
                    } else if (key == "One Bad Channel Tolerance Policy") {
                        Parameter.pOneBadChannelPolicyStr = value.toString();
                    } else if (key == "Use ChannelA Flag") {
                        Parameter.pUseCh1FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh1FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh1FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh1FlagCol = -1;
                        }
                    } else if (key == "Use ChannelB Flag") {
                        Parameter.pUseCh2FlagOpt = (Boolean)value;
                        if (Parameter.pUseCh2FlagOpt) {
                            ParameterPane.this.launchFlagColDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pUseCh2FlagOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pUseCh2FlagCol = -1;
                        }
                    } else if (key == "ChannelA Background Checking") {
                        Parameter.pCh1BkgdOpt = (Boolean)value;
                        if (Parameter.pCh1BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(0);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh1BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "ChannelB Background Checking") {
                        Parameter.pCh2BkgdOpt = (Boolean)value;
                        if (Parameter.pCh2BkgdOpt) {
                            ParameterPane.this.launchBkgdDialog(1);
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pCh2BkgdOpt);
                            this.fireTableCellUpdated(row, col);
                        }
                    } else if (key == "Signal/Noise Threshold") {
                        Parameter.pBkgdSNRatioVal = ((Double)value).floatValue();
                    }
                } else if (ParameterPane.this.src == 12) {
                    if (key == "Cy3 Intensity Threshold") {
                        Parameter.pCy3CutoffVal = ((Integer)value).longValue();
                    } else if (key == "Cy5 Intensity Threshold") {
                        Parameter.pCy5CutoffVal = ((Integer)value).longValue();
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 11) {
                    if (key == "Mode") {
                        Parameter.pLocfitModeStr = value.toString();
                    } else if (key == "Smoothing Parameter") {
                        Parameter.pSmoothParaVal = ((Double)value).floatValue();
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 15) {
                    if (key == "Mode") {
                        Parameter.pIterLinRegModeStr = value.toString();
                    } else if (key == "Outlier Range") {
                        Parameter.pIterLinRegSDRangeVal = Float.parseFloat(value.toString().substring(3, 7));
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 14) {
                    if (key == "Data Range For Mean Centering") {
                        Parameter.pIterLogMeanSDRangeVal = Float.parseFloat(value.toString().substring(3, 7));
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 13) {
                    if (key == "Block SD Regularization") {
                        Parameter.pBlockSDRegOpt = (Boolean)value;
                    } else if (key == "Slide SD Regularization") {
                        if ((Parameter.pFolderStr.equalsIgnoreCase("Please specify a directory") || Parameter.pFolderStr.endsWith(FileBrowser.fsep)) && Parameter.pSingleFileStr.equalsIgnoreCase("Please specify a file")) {
                            Parameter.pSlideSDRegOpt = (Boolean)value;
                        } else {
                            AlertDialogPane alertDialogPane = new AlertDialogPane(1, "Slide Standard Deviation regularization only applies on multiple data files ");
                            Parameter.pSlideSDRegOpt = false;
                        }
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 16) {
                    if (key == "Confidence Interval Checking") {
                        Parameter.pRatioStatsCIChkOpt = (Boolean)value;
                        if (Parameter.pRatioStatsCIChkOpt) {
                            ParameterPane.this.launchRatioStatsCIDialog();
                            ((ParameterPane)ParameterPane.this).data[row][col] = new Boolean(Parameter.pRatioStatsCIChkOpt);
                            this.fireTableCellUpdated(row, col);
                        } else {
                            Parameter.pRatioStatsCIVal = -1;
                        }
                    } else if (key == "Reference") {
                        Parameter.pRefStr = value.toString();
                    }
                } else if (ParameterPane.this.src == 10) {
                    if (key == "Cy3 Intensity Threshold") {
                        Parameter.pCy3CutoffVal = ((Integer)value).longValue();
                    } else if (key == "Cy5 Intensity Threshold") {
                        Parameter.pCy5CutoffVal = ((Integer)value).longValue();
                    }
                } else if (ParameterPane.this.src == 20) {
                    if (key == "Slice Data Population") {
                        Parameter.pSliceDataPopVal = (Integer)value;
                    } else if (key == "Data Keep Range <") {
                        Parameter.pSliceDataRangeLtVal = value.toString().equalsIgnoreCase("----------") ? Float.POSITIVE_INFINITY : Float.parseFloat(value.toString().substring(3, 7));
                    } else if (key == "Data Keep Range >") {
                        Parameter.pSliceDataRangeGtVal = value.toString().equalsIgnoreCase("----------") ? Float.NEGATIVE_INFINITY : Float.parseFloat(value.toString().substring(3, 7));
                    }
                } else if (ParameterPane.this.src == 30) {
                    if (key == "Identifier Column") {
                        if (value.toString().equalsIgnoreCase("MEV format, specify the identifier column name")) {
                            ParameterPane.this.launchIdColDialog("mev");
                            ((ParameterPane)ParameterPane.this).data[row][col] = new String("MEV column name: '" + Parameter.pIdentifierCol.toString() + "'");
                            this.fireTableCellUpdated(row, col);
                        } else if (value.toString().equalsIgnoreCase("TAV format, specify the identifier column number")) {
                            ParameterPane.this.launchIdColDialog("tav");
                            ((ParameterPane)ParameterPane.this).data[row][col] = new String("TAV column number: " + Parameter.pIdentifierCol.toString());
                            this.fireTableCellUpdated(row, col);
                        }
                    }
                } else if (ParameterPane.this.src == 32) {
                    if (key != "Group Assignment") {
                        if (key == "Hypothetical Non-significant Log Ratio") {
                            Parameter.pTtestHypoMean = Float.parseFloat(value.toString());
                        } else if (key == "Compute p-values Based On") {
                            if (value.toString().equalsIgnoreCase("Specify permutation number")) {
                                ParameterPane.this.launchTtestPermutNumberDialog();
                                ((ParameterPane)ParameterPane.this).data[row][col] = new String(Parameter.pTtestPValBase + " random permutations");
                                this.fireTableCellUpdated(row, col);
                            } else if (value.toString().equalsIgnoreCase("T-Distribution")) {
                                Parameter.pTtestPValBase = -323;
                            } else if (value.toString().equalsIgnoreCase("All possible permutations")) {
                                Parameter.pTtestPValBase = 320;
                            }
                        } else if (key == "\u03b1 (critical p-value)") {
                            Parameter.pTtestAlpha = Float.parseFloat(value.toString());
                        } else if (key == "Significant Method") {
                            if (value.toString().equalsIgnoreCase("Just \u03b1")) {
                                Parameter.pTtestSigMethod = 324;
                            } else if (value.toString().equalsIgnoreCase("Standard Bonferroni")) {
                                Parameter.pTtestSigMethod = 325;
                            } else if (value.toString().equalsIgnoreCase("Adjusted Bonferroni")) {
                                Parameter.pTtestSigMethod = 326;
                            }
                        }
                    }
                } else if (ParameterPane.this.src == 33) {
                    if (key == "Hypothetical Non-significant Log Ratio") {
                        Parameter.pSAMHypoMean = Float.parseFloat(value.toString());
                    } else if (key == "Number of Permutations") {
                        Parameter.pSAMPermutationsNumber = Integer.parseInt(value.toString().substring(0, value.toString().indexOf(" ")));
                    } else if (key == "S0 Calculation Method") {
                        if (value.toString().equalsIgnoreCase("Tusher's methods")) {
                            Parameter.pSAMS0Method = 3301;
                        } else if (value.toString().equalsIgnoreCase("5th percentile")) {
                            Parameter.pSAMS0Method = 3302;
                        } else if (value.toString().equalsIgnoreCase("50th percentile")) {
                            Parameter.pSAMS0Method = 3303;
                        } else if (value.toString().equalsIgnoreCase("90th percentile")) {
                            Parameter.pSAMS0Method = 3304;
                        } else if (value.toString().equalsIgnoreCase("Use minimum S value")) {
                            Parameter.pSAMS0Method = 3305;
                        }
                    } else if (key == "Missing Data Imputation Method") {
                        String sss = value.toString();
                    }
                    System.out.println(" ----> Parameter.pSAMHypoMean = " + Parameter.pSAMHypoMean);
                    System.out.println(" ----> Parameter.pSAMPermutationsNumber = " + Parameter.pSAMPermutationsNumber);
                    System.out.println(" ----> Parameter.pSAMS0Method = " + Parameter.pSAMS0Method);
                    System.out.println(" ----> Parameter.pSAMImputationEngine = " + Parameter.pSAMImputationEngine);
                    System.out.println(" ----> Parameter.pSAMNearestNeighborsNumber = " + Parameter.pSAMNearestNeighborsNumber);
                } else if (ParameterPane.this.src == 40) {
                    if (key == "Data Trim Option") {
                        Parameter.pFlipdyeCutOptionStr = value.toString();
                    } else if (key == "Cross Log Ratio Data Keep Range") {
                        Parameter.pFlipdyeDataKeepRangeVal = Parameter.pFlipdyeCutOptionStr.equalsIgnoreCase("threshold cut") ? Float.parseFloat(value.toString()) : Float.parseFloat(value.toString().substring(3, 7));
                    }
                } else if (ParameterPane.this.src == 100) {
                    if (key == "Output File Name") {
                        Parameter.pOutFileStr = value.toString();
                    } else if (key == "Virtual Trim") {
                        Parameter.pVtrimOpt = (Boolean)value;
                    } else if (key == "Re-number") {
                        Parameter.pReNumberOpt = (Boolean)value;
                    } else if (key == "Output Trimmed Data") {
                        Parameter.pOutputTrimmedDataOpt = (Boolean)value;
                    } else if (key == "Apply Cross File Cutoff") {
                        Parameter.pUseCrossFileTrimOpt = (Boolean)value;
                    } else if (key == "Cross File Cutoff Pct ( \u2264 1.0 )" && Parameter.pUseCrossFileTrimOpt) {
                        Parameter.pCrossFilePct = ((Double)value).floatValue();
                    }
                }
                if (value.toString().equalsIgnoreCase("threshold cut") && ParameterPane.this.src == 40) {
                    ParameterPane.access$102(ParameterPane.this, new Object[][]{{"Data Trim Option", "threshold cut"}, {"Cross Log Ratio Data Keep Range", "1.0"}});
                    ParameterPane.this.rm.removeEditorForRow(1);
                    DecimalNumberField hardCutField = new DecimalNumberField(1.0f, 5);
                    NumberCellEditor ed = new NumberCellEditor(hardCutField);
                    ParameterPane.this.rm.addEditorForRow(1, ed);
                } else if (value.toString().equalsIgnoreCase("SD cut") && ParameterPane.this.src == 40) {
                    ParameterPane.access$102(ParameterPane.this, new Object[][]{{"Data Trim Option", "SD cut"}, {"Cross Log Ratio Data Keep Range", "+/-1.00 \u03c3 -- 68.4%"}});
                    ParameterPane.this.rm.removeEditorForRow(1);
                    JComboBox<String> cb3 = new JComboBox<String>(ParameterPane.this.SD_VALUES);
                    cb3.setBackground(Color.white);
                    cb3.setFont(ParameterPane.this.theFont);
                    DefaultCellEditor ed = new DefaultCellEditor(cb3);
                    ParameterPane.this.rm.addEditorForRow(1, ed);
                }
                this.fireTableCellUpdated(row, col);
                if (ParameterPane.this.DEBUG) {
                    System.out.println("New value of data:");
                    this.printDebugData();
                }
            }

            private void printDebugData() {
                int numRows = this.getRowCount();
                int numCols = this.getColumnCount();
                int i = 0;
                while (i < numRows) {
                    System.out.print("    row " + i + ":");
                    int j = 0;
                    while (j < numCols) {
                        System.out.print("  " + ParameterPane.this.data[i][j]);
                        ++j;
                    }
                    System.out.println();
                    ++i;
                }
                System.out.println("--------------------------");
            }
        };
        JTableX table = new JTableX(midasParamTableModel);
        table.setPreferredScrollableViewportSize(new Dimension(180, 150));
        class MultiRenderer
        extends DefaultTableCellRenderer {
            JCheckBox checkBox;
            JComboBox comboBox;
            private final /* synthetic */ ParameterPane this$0;

            public MultiRenderer(ParameterPane this$0) {
                this.this$0 = this$0;
                this.checkBox = new JCheckBox();
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Boolean) {
                    this.checkBox.setForeground(Color.white);
                    this.checkBox.setBackground(Color.white);
                    this.checkBox.setSelected((Boolean)value);
                    this.checkBox.setHorizontalAlignment(0);
                    return this.checkBox;
                }
                if ((ParameterPane.access$300(this.this$0) == 0 || ParameterPane.access$300(this.this$0) == 1 || ParameterPane.access$300(this.this$0) == 2) && value instanceof String[]) {
                    if (row == 1) {
                        this.comboBox = new JComboBox<String>(ParameterPane.access$1200(this.this$0));
                        this.comboBox.setForeground(Color.white);
                        this.comboBox.setBackground(Color.white);
                        this.comboBox.setSelectedIndex(0);
                        return this.comboBox;
                    }
                } else {
                    if (ParameterPane.access$300(this.this$0) == 20 && value instanceof String[]) {
                        if (row == 1) {
                            this.comboBox = new JComboBox<String>(ParameterPane.access$1000(this.this$0));
                            this.comboBox.setForeground(Color.white);
                            this.comboBox.setBackground(Color.white);
                            this.comboBox.setSelectedIndex(0);
                        } else if (row == 2) {
                            this.comboBox = new JComboBox<String>(ParameterPane.access$1000(this.this$0));
                            this.comboBox.setForeground(Color.white);
                            this.comboBox.setBackground(Color.white);
                            this.comboBox.setSelectedIndex(0);
                        }
                        return this.comboBox;
                    }
                    if (ParameterPane.access$300(this.this$0) == 30 && value instanceof String[]) {
                        if (row == 0) {
                            this.comboBox = new JComboBox<String>(ParameterPane.access$1300(this.this$0));
                            this.comboBox.setForeground(Color.white);
                            this.comboBox.setBackground(Color.white);
                            this.comboBox.setSelectedIndex(0);
                        }
                    } else {
                        if (ParameterPane.access$300(this.this$0) == 40 && value instanceof String[]) {
                            if (row == 0) {
                                this.comboBox = new JComboBox<String>(ParameterPane.access$1400(this.this$0));
                                this.comboBox.setForeground(Color.white);
                                this.comboBox.setBackground(Color.white);
                                this.comboBox.setSelectedIndex(0);
                            } else if (row == 1) {
                                this.comboBox = new JComboBox<String>(ParameterPane.access$1000(this.this$0));
                                this.comboBox.setForeground(Color.white);
                                this.comboBox.setBackground(Color.white);
                                this.comboBox.setSelectedIndex(2);
                            }
                            return this.comboBox;
                        }
                        if (ParameterPane.access$300(this.this$0) == 12 && value instanceof String[] && row == 2) {
                            this.comboBox = new JComboBox<String>(ParameterPane.access$1500(this.this$0));
                            this.comboBox.setForeground(Color.white);
                            this.comboBox.setBackground(Color.white);
                            this.comboBox.setSelectedIndex(0);
                        }
                    }
                }
                String str = value == null ? "" : value.toString();
                return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
            }
        }
        table.getColumn("Value").setCellRenderer(new MultiRenderer(this));
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowEditorModel(this.rm);
        JScrollPane scrollPane = new JScrollPane(table);
        this.setForeground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "North");
    }

    private void launchFlagColDialog(int channel) {
        JOptionPane askFlagColPane = new JOptionPane();
        Object[] flag1ColValues = new Object[]{"MEV format file, use column with header of 'FlagA'", "9", "13", "16"};
        Object[] flag2ColValues = new Object[]{"MEV format file, use column with header of 'FlagB'", "10", "14", "17"};
        if (channel == 0) {
            Object retVal = JOptionPane.showInputDialog(this, "Column Number", "Channel A flag Column Number", 2, null, flag1ColValues, null);
            if (retVal == null) {
                Parameter.pUseCh1FlagCol = -1;
                Parameter.pUseCh1FlagOpt = false;
            } else if (retVal.toString().length() < 3) {
                Parameter.pUseCh1FlagCol = Integer.parseInt(retVal.toString());
            }
        } else if (channel == 1) {
            Object retVal = JOptionPane.showInputDialog(this, "Column Number", "Channel B flag Column Number", 2, null, flag2ColValues, null);
            if (retVal == null) {
                Parameter.pUseCh2FlagCol = -1;
                Parameter.pUseCh2FlagOpt = false;
            } else if (retVal.toString().length() < 3) {
                Parameter.pUseCh2FlagCol = Integer.parseInt(retVal.toString());
            }
        }
    }

    private void launchBkgdDialog(int channel) {
        JOptionPane askBkgdColPane = new JOptionPane();
        Object[] bkgd1ColValues = new Object[]{"MEV format file, use column with header of 'BkgA'", "14"};
        Object[] bkgd2ColValues = new Object[]{"MEV format file, use column with header of 'BkgB'", "15"};
        if (channel == 0) {
            Object retVal = JOptionPane.showInputDialog(this, "Column Number", "Channel A Background Column Number", 2, null, bkgd1ColValues, null);
            if (retVal == null) {
                Parameter.pCh1BkgdCol = -1;
                Parameter.pCh1BkgdOpt = false;
            } else if (retVal.toString().length() < 3) {
                Parameter.pCh1BkgdCol = Integer.parseInt(retVal.toString());
            }
        } else if (channel == 1) {
            Object retVal = JOptionPane.showInputDialog(this, "Column Number", "Channel B Background Column Number", 2, null, bkgd2ColValues, null);
            if (retVal == null) {
                Parameter.pCh2BkgdCol = -1;
                Parameter.pCh2BkgdOpt = false;
            } else if (retVal.toString().length() < 3) {
                Parameter.pCh2BkgdCol = Integer.parseInt(retVal.toString());
            }
        }
    }

    private void launchRatioStatsCIDialog() {
        JOptionPane askBkgdColPane = new JOptionPane();
        Object[] CIValues = new Object[]{"95%", "99%"};
        Object retVal = JOptionPane.showInputDialog(this, "Confidence Interval", "Ratio Statistics", 2, null, CIValues, null);
        if (retVal == null) {
            Parameter.pRatioStatsCIVal = -1;
            Parameter.pRatioStatsCIChkOpt = false;
        } else {
            Parameter.pRatioStatsCIVal = Integer.parseInt(retVal.toString().substring(0, 2));
        }
    }

    private void launchIdColDialog(String type) {
        if (type.equalsIgnoreCase("mev")) {
            final JDialog d = new JDialog(Midas.frame, "Please specify identifier column name", true);
            final JTextField field = new JTextField(10);
            JPanel p1 = new JPanel();
            JPanel p2 = new JPanel();
            JLabel label = new JLabel("Identifier column name:");
            JButton button = new JButton("Set");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Parameter.pIdentifierCol = field.getText();
                    d.dispose();
                }
            });
            p2.add(label);
            p2.add(field);
            p1.add(p2);
            p1.add(button);
            d.getContentPane().add(p1);
            d.setSize(new Dimension(280, 105));
            d.setResizable(false);
            d.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
            d.setVisible(true);
        } else if (type.equalsIgnoreCase("tav")) {
            final JDialog d = new JDialog(Midas.frame, "Please specify identifier column number", true);
            final WholeNumberField field = new WholeNumberField(9, 10);
            JPanel p1 = new JPanel();
            JPanel p2 = new JPanel();
            JLabel label = new JLabel("Identifier column number:");
            JButton button = new JButton("Set");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Parameter.pIdentifierCol = new Integer(field.getValue());
                    d.dispose();
                }
            });
            p2.add(label);
            p2.add(field);
            p1.add(p2);
            p1.add(button);
            d.getContentPane().add(p1);
            d.setSize(new Dimension(280, 105));
            d.setResizable(false);
            d.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
            d.setVisible(true);
        }
    }

    private void launchTtestPermutNumberDialog() {
        final JDialog d = new JDialog(Midas.frame, "Please specify a permutation number", true);
        final WholeNumberField field = new WholeNumberField(100, 10);
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JLabel label = new JLabel("Permutation number:");
        JButton button = new JButton("Set");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Parameter.pTtestPValBase = field.getValue();
                d.dispose();
            }
        });
        p2.add(label);
        p2.add(field);
        p1.add(p2);
        p1.add(button);
        d.getContentPane().add(p1);
        d.setSize(new Dimension(280, 105));
        d.setResizable(false);
        d.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
        d.setVisible(true);
    }

    static /* synthetic */ Object[][] access$102(ParameterPane x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1200(ParameterPane x0) {
        return x0.ONE_BAD_CHANNEL_POLICY_VALUES;
    }

    static /* synthetic */ String[] access$1300(ParameterPane x0) {
        return x0.IDENTIFIER_COL_VALUES;
    }

    static /* synthetic */ String[] access$1400(ParameterPane x0) {
        return x0.FLIPDYE_CUT_OPTION_VALUES;
    }

    static /* synthetic */ String[] access$1500(ParameterPane x0) {
        return x0.CY_REF_VALUES;
    }
}

