/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.VariReg;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.LogRatioToCy;

public class BatchVariReg
extends Module {
    private ColumnWorker[] dCW;
    private int[] slideDataNumber;

    public BatchVariReg(ColumnWorker[] folderCW, boolean doBlock, boolean doSlide, String ref) throws Exception {
        int fileCounts = folderCW.length;
        float[][] slideLogRatio = new float[fileCounts][];
        float[] slideLogRatioSD = new float[fileCounts];
        int[][] slideLogRatioRawNdx = new int[fileCounts][];
        this.dCW = new ColumnWorker[fileCounts];
        this.slideDataNumber = new int[fileCounts];
        float slideLogRatioSDProd = 1.0f;
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String sdRegFB = projFolderFB.createSubDir("sd_reg");
        int fileIndex = 0;
        while (fileIndex < fileCounts) {
            VariReg eachVariReg = new VariReg(folderCW[fileIndex], ref);
            if (doBlock) {
                this.dCW[fileIndex] = eachVariReg.getFileVariRegColumnWorker();
                slideLogRatio[fileIndex] = eachVariReg.getSortedAssembledLogRatio();
                slideLogRatioSD[fileIndex] = eachVariReg.getSlideLogRatioSD();
                slideLogRatioSDProd *= slideLogRatioSD[fileIndex];
            } else {
                this.dCW[fileIndex] = folderCW[fileIndex];
                slideLogRatio[fileIndex] = eachVariReg.getSortedAssembledRawLogRatio();
                slideLogRatioSD[fileIndex] = eachVariReg.getSlideRawLogRatioSD();
                slideLogRatioSDProd *= slideLogRatioSD[fileIndex];
            }
            this.slideDataNumber[fileIndex] = slideLogRatio[fileIndex].length;
            slideLogRatioRawNdx[fileIndex] = eachVariReg.getSortedAssembledRawNdx();
            ++fileIndex;
        }
        if (doSlide) {
            float slideLogRatioGeoMean = MathTools.nthRoot(slideLogRatioSDProd, fileCounts);
            String preBoxName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + "all_slide_pre.box";
            DataReporter dr = new DataReporter(preBoxName, slideLogRatio);
            int fileIndex2 = 0;
            while (fileIndex2 < fileCounts) {
                float slideLogRatioSDFactor = slideLogRatioSD[fileIndex2] / MathTools.nthRoot(slideLogRatioSDProd, fileCounts);
                System.out.println("    ----> File#: " + fileIndex2 + ", processed spots#: " + slideLogRatio[fileIndex2].length + ", slideLogRatioSD = " + slideLogRatioSD[fileIndex2] + ", slideLogRatioSDFactor = " + slideLogRatioSDFactor);
                int slideGeneNdx = 0;
                while (slideGeneNdx < slideLogRatio[fileIndex2].length) {
                    float[] fArray = slideLogRatio[fileIndex2];
                    int n = slideGeneNdx++;
                    fArray[n] = fArray[n] / slideLogRatioSDFactor;
                }
                ++fileIndex2;
            }
            String postBoxName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + "all_slide_post.box";
            dr = new DataReporter(postBoxName, slideLogRatio);
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put(new String("pre_slide_box_name"), preBoxName);
            hash.put(new String("post_slide_box_name"), postBoxName);
            hash.put(new String("slide_log_ratio_sd_geo_mean"), new Float(slideLogRatioGeoMean));
            Module.proj.insertReportItem("slide_sdreg", hash);
        }
        int fileIndex3 = 0;
        while (fileIndex3 < fileCounts) {
            LogRatioToCy logRatioToCy = new LogRatioToCy(this.dCW[fileIndex3].getColumnOneArray(), this.dCW[fileIndex3].getColumnTwoArray(), slideLogRatio[fileIndex3], slideLogRatioRawNdx[fileIndex3], ref);
            this.dCW[fileIndex3].setColOneArray(logRatioToCy.getCy3Column());
            this.dCW[fileIndex3].setColTwoArray(logRatioToCy.getCy5Column());
            ++fileIndex3;
        }
    }

    public final ColumnWorker[] getFolderVariRegColumnWorker() {
        return this.dCW;
    }
}

