/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.NegateFlags;

public class IterativeLogMean
extends Module {
    private ColumnWorker fCW;
    private float[] cy3Column;
    private float[] cy5Column;
    private boolean[] inputFlag;
    private float[] logRatio;
    private float slideRawLogRatioMean;
    private float slideRawLogRatioSD;
    private float logRatioMean;
    private float logRatioSD;
    private int m = 1;
    private int[] withinRangeCounts = new int[100];
    private float[] logRatioMeans = new float[100];
    private float[] logRatioSDs = new float[100];

    public IterativeLogMean(ColumnWorker fileCW, float nSD, String ref) throws Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String iterLinRegFB = projFolderFB.createSubDir("iter_log_mean_centering");
        this.fCW = fileCW;
        this.cy3Column = fileCW.getColumnOneArray();
        this.cy5Column = fileCW.getColumnTwoArray();
        int totalRowCount = this.fCW.getRowCounts();
        boolean[] tempFlag = fileCW.getRowFlagArray();
        this.inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, this.inputFlag, 0, tempFlag.length);
        boolean[] iterLogFlag = new boolean[fileCW.getRowCounts()];
        iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
        iterLogFlag = new AndFlags(iterLogFlag, this.inputFlag).getAndFlag();
        int lastQualiCount = 0;
        CyToLogProdRatio lpr = new CyToLogProdRatio(this.cy3Column, this.cy5Column, iterLogFlag);
        this.logRatio = lpr.getLogRatio();
        lastQualiCount = this.logRatio.length;
        while (true) {
            StatsTools sTools = new StatsTools();
            sTools.computeMeanSD(this.logRatio);
            this.logRatioMean = sTools.getXMean();
            this.logRatioSD = sTools.getXSD();
            System.out.println("    ------ iteration " + this.m + " ------");
            System.out.println("    Within Range Count  = " + lastQualiCount);
            System.out.println("    logRatioMean        = " + this.logRatioMean);
            System.out.println("    logRatioSD          = " + this.logRatioSD);
            this.withinRangeCounts[this.m] = lastQualiCount;
            this.logRatioMeans[this.m] = this.logRatioMean;
            this.logRatioSDs[this.m] = this.logRatioSD;
            int qualifiedCount = 0;
            int rawNdx = 0;
            while (rawNdx < totalRowCount) {
                if (this.cy3Column[rawNdx] > 1.0f && this.cy5Column[rawNdx] > 1.0f && iterLogFlag[rawNdx]) {
                    if (ref.equalsIgnoreCase("Cy3")) {
                        int n = rawNdx;
                        this.cy5Column[n] = (float)((double)this.cy5Column[n] / Math.pow(2.0, this.logRatioMean));
                    } else {
                        int n = rawNdx;
                        this.cy3Column[n] = (float)((double)this.cy3Column[n] * Math.pow(2.0, this.logRatioMean));
                    }
                    if (Math.abs(MathTools.log2(this.cy5Column[rawNdx] / this.cy3Column[rawNdx])) < this.logRatioSD * nSD) {
                        this.logRatio[qualifiedCount] = MathTools.log2(this.cy5Column[rawNdx] / this.cy3Column[rawNdx]);
                        ++qualifiedCount;
                    } else {
                        iterLogFlag[rawNdx] = false;
                    }
                }
                ++rawNdx;
            }
            if (qualifiedCount == lastQualiCount || this.m > 100) {
                System.out.println("    *********************************");
                break;
            }
            if (this.m > 100) {
                System.out.println("    Maximum iteration number 100 reached! ");
                break;
            }
            float[] t = new float[this.logRatio.length];
            System.arraycopy(this.logRatio, 0, t, 0, this.logRatio.length);
            this.logRatio = new float[qualifiedCount];
            System.arraycopy(t, 0, this.logRatio, 0, qualifiedCount);
            lastQualiCount = qualifiedCount;
            ++this.m;
        }
        this.fCW.setColOneArray(this.cy3Column);
        this.fCW.setColTwoArray(this.cy5Column);
        String ityName = Module.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_iterLogMean.ity";
        String ltyName = Module.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_iterLogMean.lty";
        String prcName = Module.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_iterLogMean.prc";
        String hisName = Module.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_iterLogMean.his";
        String boxName = Module.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_iterLogMean_block.box";
        DataPrep dataPrep = new DataPrep(fileCW);
        DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
        dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
        dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("identity", new Integer(14));
        hash.put(CodeBook.lookup(99901), ityName);
        hash.put(CodeBook.lookup(99902), ltyName);
        hash.put(CodeBook.lookup(99903), prcName);
        hash.put(CodeBook.lookup(99904), hisName);
        hash.put(CodeBook.lookup(99905), boxName);
        hash.put("experiment data file: ", fileCW.getFileNameWithExtension());
        hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
        String[] moduleNotes = new String[]{"experiment data file: ", "processed data count: "};
        hash.put("module_notes", moduleNotes);
        Module.proj.insertReportItem("iterLogMean_for_" + fileCW.getFileName(), hash);
    }

    public final ColumnWorker getIterLogMeanColumnWorker() {
        return this.fCW;
    }

    public final int getIterationCounts() {
        return this.m;
    }

    public final int[] getWithinRangeCounts() {
        return this.withinRangeCounts;
    }

    public final float[] getLogRatioMeans() {
        return this.logRatioMeans;
    }

    public final float[] getLogRatioSDs() {
        return this.logRatioSDs;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            IterativeLogMean ilm = new IterativeLogMean(fileCW, 3.0f, "Cy3");
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

