/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.tigr.midas.display.Midas;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.SAMGraph;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.mev.ExperimentUtil2;
import org.tigr.midas.mev.cluster.algorithm.AlgorithmException;
import org.tigr.midas.mev.data.FloatMatrix;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.CW2FloatMatrix;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class SAM
extends Module {
    public static final int TUSHER_METHOD = 3301;
    public static final int FIFTH_PERCENTILE = 3302;
    public static final int FIFTIETH_PERCENTILE = 3303;
    public static final int NINTIETH_PERCENTILE = 3304;
    public static final int MIN_S_VAL = 3305;
    public static final int K_NEAREST_NEIGHBOR = 3306;
    public static final int ROW_AVG_IMPUTER = 3307;
    public static final int ALL_PERMUTATIONS = 3308;
    private FloatMatrix expMatrix;
    private FloatMatrix imputedMatrix;
    private int numGenes;
    private int numExps;
    private double sNought = 0.0;
    private double s0Percentile;
    private double oneClassMean;
    private double[] dArray;
    private double[] rArray;
    private double[] sortedDArray;
    private double[] dBarValues;
    private double[] globalAllSValues;
    private double[] globalAllQValues;
    private double[] globalSortedAllSValues;
    private int validN;
    private int numNeighbors;
    private BufferedImage samImage;
    private ColumnWorker[] groupCW;
    private boolean[] sigFlag;

    public SAM(ColumnWorker[] groupCW, float hypoMean, boolean useAllPerms, int numPermutations, int s0By, int imputeEngine, int numNeighbors) throws AlgorithmException {
        int i;
        int i2;
        int j;
        int[] validArray;
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String crossSlidesamFB = projFolderFB.createSubDir("one_class_sam");
        this.groupCW = groupCW;
        this.numNeighbors = numNeighbors;
        double pi0Hat = 0.0;
        double delta = 0.0;
        double[] deltaGrid = new double[1001];
        int[] numSigGenesByDelta = new int[1];
        int[] sortedDArrayIndices = new int[1];
        double[] medNumFalselyCalledGenesByDelta = new double[1];
        double[] ninetiethPercentileFalselyCalledGenesByDelta = new double[1];
        double[] FDRmedian = new double[1];
        double[] FDR90thPercentile = new double[1];
        double[] qLowestFDR = new double[1];
        this.expMatrix = new CW2FloatMatrix().getFloatMatrix(groupCW);
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        System.out.println("    ---- numGenes = " + this.numGenes + ", numExps = " + this.numExps);
        System.out.println("    ---- hypoMean = " + hypoMean);
        System.out.println("    ---- numPermutations = " + numPermutations);
        System.out.println("    ---- s0By = " + s0By);
        System.out.println("    ---- imputeEngine = " + imputeEngine);
        System.out.println("    ---- numNeighbors = " + numNeighbors);
        this.sigFlag = new boolean[this.numGenes];
        if (imputeEngine == 3306) {
            this.imputedMatrix = this.imputeKNearestMatrix(this.expMatrix, numNeighbors);
        } else if (imputeEngine == 3307) {
            this.imputedMatrix = this.imputeRowAverageMatrix(this.expMatrix);
        }
        this.globalAllSValues = this.getAllSValues();
        QSort sortSValues = new QSort(this.globalAllSValues);
        this.globalSortedAllSValues = sortSValues.getSortedDouble();
        if (s0By == 3301) {
            this.globalAllQValues = this.getQValues();
            this.sNought = this.getSNought();
        } else {
            double userPercentile = 0.0;
            userPercentile = s0By == 3302 ? 5.0 : (s0By == 3303 ? 50.0 : (s0By == 3304 ? 90.0 : (s0By == 3305 ? 0.0 : (double)s0By / 100.0)));
            this.sNought = this.getSAlpha(userPercentile);
            this.s0Percentile = userPercentile;
        }
        this.dArray = new double[this.numGenes];
        this.rArray = new double[this.numGenes];
        int i3 = 0;
        while (i3 < this.dArray.length) {
            this.dArray[i3] = this.getD(i3, this.imputedMatrix);
            this.rArray[i3] = this.getR(i3, this.imputedMatrix);
            ++i3;
        }
        QSort sortDArray = new QSort(this.dArray);
        this.sortedDArray = sortDArray.getSortedDouble();
        sortedDArrayIndices = sortDArray.getOrigIndx();
        int numCombs = !useAllPerms ? numPermutations : (int)MathTools.pow2(this.numExps);
        double[][] permutedDValues = new double[numCombs][this.numGenes];
        Random rand = new Random();
        long[] randomSeeds = new long[numCombs];
        int i4 = 0;
        while (i4 < numCombs) {
            randomSeeds[i4] = rand.nextLong();
            ++i4;
        }
        if (!useAllPerms) {
            System.out.println("    ---- Not use all perms! numCombs = " + numCombs);
            int i5 = 0;
            while (i5 < numCombs) {
                int[] permutedExpts = new int[1];
                boolean[] changeSign = new boolean[1];
                validArray = new int[this.numExps];
                j = 0;
                while (j < this.numExps) {
                    validArray[j] = j;
                    ++j;
                }
                changeSign = this.getOneClassChangeSignArray(randomSeeds[i5], validArray);
                FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.imputedMatrix, changeSign);
                double[] permDArray = new double[permutedMatrix.getRowDimension()];
                int j2 = 0;
                while (j2 < permutedMatrix.getRowDimension()) {
                    permDArray[j2] = this.getD(j2, permutedMatrix);
                    ++j2;
                }
                QSort sortPermDArray = new QSort(permDArray);
                double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                int j3 = 0;
                while (j3 < sortedPermDArray.length) {
                    permutedDValues[i5][j3] = sortedPermDArray[j3];
                    ++j3;
                }
                ++i5;
            }
        } else {
            int[] permutedExpts = new int[this.numExps];
            int i6 = 0;
            while (i6 < this.numExps) {
                permutedExpts[i6] = i6;
                ++i6;
            }
            int i7 = 0;
            while (i7 < numCombs) {
                validArray = new int[this.numExps];
                j = 0;
                while (j < this.numExps) {
                    validArray[j] = j;
                    ++j;
                }
                boolean[] changeSign = this.getOneClassChangeSignArrayAllUniquePerms(i7, validArray);
                FloatMatrix permutedMatrix = this.getOneClassPermMatrix(this.imputedMatrix, changeSign);
                double[] permDArray = new double[permutedMatrix.getRowDimension()];
                int j4 = 0;
                while (j4 < permutedMatrix.getRowDimension()) {
                    permDArray[j4] = this.getD(j4, permutedMatrix);
                    ++j4;
                }
                QSort sortPermDArray = new QSort(permDArray);
                double[] sortedPermDArray = sortPermDArray.getSortedDouble();
                int j5 = 0;
                while (j5 < sortedPermDArray.length) {
                    permutedDValues[i7][j5] = sortedPermDArray[j5];
                    ++j5;
                }
                ++i7;
            }
        }
        this.dBarValues = new double[this.numGenes];
        int i8 = 0;
        while (i8 < this.numGenes) {
            double[] currentGene = new double[numCombs];
            int j6 = 0;
            while (j6 < numCombs) {
                currentGene[j6] = permutedDValues[j6][i8];
                ++j6;
            }
            this.dBarValues[i8] = this.getMean(currentGene);
            ++i8;
        }
        double[] oneDimPermutedDValues = new double[numCombs * this.numGenes];
        int counter1 = 0;
        int i9 = 0;
        while (i9 < numCombs) {
            j = 0;
            while (j < this.numGenes) {
                oneDimPermutedDValues[counter1] = permutedDValues[i9][j];
                ++counter1;
                ++j;
            }
            ++i9;
        }
        QSort sortAllPermutedDValues = new QSort(oneDimPermutedDValues);
        double[] sortedAllPermutedDValues = sortAllPermutedDValues.getSortedDouble();
        System.out.println("    ---- sortedAllPermutedDValues.length = " + sortedAllPermutedDValues.length);
        int[] sortedAllPermutedDValuesIndices = sortAllPermutedDValues.getOrigIndx();
        int percentile25thIndex = (int)Math.round((double)sortedAllPermutedDValues.length * 0.25 - 1.0);
        if (percentile25thIndex < 0) {
            percentile25thIndex = 0;
        } else if (percentile25thIndex >= sortedAllPermutedDValues.length) {
            percentile25thIndex = sortedAllPermutedDValues.length - 1;
        }
        int percentile75thIndex = (int)Math.round((double)sortedAllPermutedDValues.length * 0.75 - 1.0);
        if (percentile75thIndex < 0) {
            percentile75thIndex = 0;
        } else if (percentile75thIndex >= sortedAllPermutedDValues.length) {
            percentile75thIndex = sortedAllPermutedDValues.length - 1;
        }
        double q25 = sortedAllPermutedDValues[percentile25thIndex];
        double q75 = sortedAllPermutedDValues[percentile75thIndex];
        int piCounter = 0;
        int i10 = 0;
        while (i10 < this.dArray.length) {
            if (this.dArray[i10] > q25 && this.dArray[i10] < q75) {
                ++piCounter;
            }
            ++i10;
        }
        pi0Hat = (double)piCounter / (0.5 * (double)this.numGenes);
        pi0Hat = Math.min(pi0Hat, 1.0);
        double maximum = this.getMax(this.dArray);
        double minimum = this.getMin(this.dArray);
        delta = Math.abs(maximum) > Math.abs(minimum) ? (double)((float)(0.25 * Math.abs(maximum))) : (double)((float)(0.25 * Math.abs(minimum)));
        double[] diffValues = new double[this.sortedDArray.length];
        int i11 = 0;
        while (i11 < diffValues.length) {
            diffValues[i11] = Math.abs(this.sortedDArray[i11] - this.dBarValues[i11]);
            ++i11;
        }
        double maxDelta = this.getMax(diffValues);
        double minDelta = this.getMin(diffValues);
        double deltaIncrement = (maxDelta - minDelta) / 1000.0;
        double currentDelta = minDelta;
        int i12 = 0;
        while (i12 < deltaGrid.length) {
            deltaGrid[i12] = currentDelta;
            currentDelta += deltaIncrement;
            ++i12;
        }
        double[] cutUp = new double[deltaGrid.length];
        double[] cutLow = new double[deltaGrid.length];
        int i13 = 0;
        while (i13 < cutUp.length) {
            cutUp[i13] = this.getCutUp(deltaGrid[i13]);
            cutLow[i13] = this.getCutLow(deltaGrid[i13]);
            ++i13;
        }
        numSigGenesByDelta = new int[deltaGrid.length];
        int i14 = 0;
        while (i14 < deltaGrid.length) {
            numSigGenesByDelta[i14] = this.getNumSigGenesByDelta(cutUp[i14], cutLow[i14]);
            ++i14;
        }
        medNumFalselyCalledGenesByDelta = new double[deltaGrid.length];
        ninetiethPercentileFalselyCalledGenesByDelta = new double[deltaGrid.length];
        int i15 = 0;
        while (i15 < deltaGrid.length) {
            medNumFalselyCalledGenesByDelta[i15] = this.getMedNumFalselyCalledGenesByDelta(permutedDValues, cutUp[i15], cutLow[i15]);
            ninetiethPercentileFalselyCalledGenesByDelta[i15] = this.getNinetiethPercentileFalselyCalledGenesByDelta(permutedDValues, cutUp[i15], cutLow[i15]);
            ++i15;
        }
        int i16 = 0;
        while (i16 < deltaGrid.length) {
            medNumFalselyCalledGenesByDelta[i16] = pi0Hat * medNumFalselyCalledGenesByDelta[i16];
            ninetiethPercentileFalselyCalledGenesByDelta[i16] = pi0Hat * ninetiethPercentileFalselyCalledGenesByDelta[i16];
            ++i16;
        }
        FDRmedian = new double[deltaGrid.length];
        FDR90thPercentile = new double[deltaGrid.length];
        int i17 = 0;
        while (i17 < deltaGrid.length) {
            FDRmedian[i17] = medNumFalselyCalledGenesByDelta[i17] * 100.0 / (double)numSigGenesByDelta[i17];
            FDR90thPercentile[i17] = ninetiethPercentileFalselyCalledGenesByDelta[i17] * 100.0 / (double)numSigGenesByDelta[i17];
            ++i17;
        }
        boolean calculateQLowestFDR = false;
        if (calculateQLowestFDR) {
            qLowestFDR = new double[this.numGenes];
            int i18 = 0;
            while (i18 < this.numGenes) {
                int sigDeltaIndex = 0;
                boolean sigFound = false;
                int j7 = deltaGrid.length - 1;
                while (j7 >= 0) {
                    if (this.isSignificant(i18, cutUp[j7], cutLow[j7])) {
                        sigDeltaIndex = j7;
                        sigFound = true;
                        break;
                    }
                    --j7;
                }
                if (sigFound) {
                    double currDelta = deltaGrid[sigDeltaIndex];
                    qLowestFDR[i18] = this.getMedNumFalselyCalledGenesByDelta(permutedDValues, this.getCutUp(currDelta), this.getCutLow(currDelta));
                    qLowestFDR[i18] = qLowestFDR[i18] * pi0Hat * 100.0 / (double)numSigGenesByDelta[sigDeltaIndex];
                } else {
                    qLowestFDR[i18] = Double.NaN;
                }
                ++i18;
            }
        } else {
            qLowestFDR = new double[this.numGenes];
        }
        FloatMatrix qLowestFDRMatrix = new FloatMatrix(qLowestFDR.length, 1);
        int i19 = 0;
        while (i19 < qLowestFDR.length) {
            qLowestFDRMatrix.A[i19][0] = (float)qLowestFDR[i19];
            ++i19;
        }
        FloatMatrix dValuesMatrix = new FloatMatrix(this.dArray.length, 1);
        FloatMatrix rValuesMatrix = new FloatMatrix(this.rArray.length, 1);
        int i20 = 0;
        while (i20 < this.dArray.length) {
            dValuesMatrix.A[i20][0] = (float)this.dArray[i20];
            rValuesMatrix.A[i20][0] = (float)this.rArray[i20];
            ++i20;
        }
        FloatMatrix deltaGridMatrix = new FloatMatrix(deltaGrid.length, 1);
        FloatMatrix medNumFalseMatrix = new FloatMatrix(medNumFalselyCalledGenesByDelta.length, 1);
        FloatMatrix false90thMatrix = new FloatMatrix(ninetiethPercentileFalselyCalledGenesByDelta.length, 1);
        FloatMatrix numSigMatrix = new FloatMatrix(numSigGenesByDelta.length, 1);
        FloatMatrix FDRMedianMatrix = new FloatMatrix(FDRmedian.length, 1);
        FloatMatrix FDR90thMatrix = new FloatMatrix(FDR90thPercentile.length, 1);
        int i21 = 0;
        while (i21 < deltaGrid.length) {
            deltaGridMatrix.A[i21][0] = (float)deltaGrid[i21];
            medNumFalseMatrix.A[i21][0] = (float)medNumFalselyCalledGenesByDelta[i21];
            false90thMatrix.A[i21][0] = (float)ninetiethPercentileFalselyCalledGenesByDelta[i21];
            numSigMatrix.A[i21][0] = numSigGenesByDelta[i21];
            FDRMedianMatrix.A[i21][0] = (float)FDRmedian[i21];
            FDR90thMatrix.A[i21][0] = (float)FDR90thPercentile[i21];
            ++i21;
        }
        System.out.println("     Waiting for user to decide preferred delta from SAM graph ...");
        SAMGraph sg = new SAMGraph(Midas.frame, this.dBarValues, this.sortedDArray, delta, deltaGrid, numSigGenesByDelta, medNumFalselyCalledGenesByDelta, ninetiethPercentileFalselyCalledGenesByDelta, FDRmedian, FDR90thPercentile, true);
        boolean graphInteraction = true;
        if (graphInteraction) {
            sg.setVisible(true);
            delta = sg.getDelta();
        }
        System.out.println("    ---- delta = " + delta);
        delta = sg.getDelta();
        String numSig = sg.getNumSig();
        String numFalseSigMed = sg.getNumFalseSigMed();
        String numFalseSig90th = sg.getNumFalseSig90th();
        String FDRMedian = sg.getFDRMedian();
        String FDR90th = sg.getFDR90th();
        double upperCutoff = this.getCutUp(delta);
        double lowerCutoff = this.getCutLow(delta);
        FloatMatrix dBarMatrix = new FloatMatrix(this.dBarValues.length, 1);
        FloatMatrix sortedDMatrix = new FloatMatrix(this.sortedDArray.length, 1);
        int i22 = 0;
        while (i22 < this.dBarValues.length) {
            dBarMatrix.A[i22][0] = (float)this.dBarValues[i22];
            ++i22;
        }
        int i23 = 0;
        while (i23 < this.sortedDArray.length) {
            sortedDMatrix.A[i23][0] = (float)this.sortedDArray[i23];
            ++i23;
        }
        Vector<Integer> posSigGenes = new Vector<Integer>();
        Vector<Integer> negSigGenes = new Vector<Integer>();
        Vector<Integer> nonSigGenes = new Vector<Integer>();
        boolean posSigEncountered = false;
        boolean negSigEncountered = false;
        int lowestPosSigIndex = 0;
        int highestNegSigIndex = 0;
        int i24 = 0;
        while (i24 < this.dBarValues.length) {
            if (this.dBarValues[i24] > 0.0 && this.sortedDArray[i24] - this.dBarValues[i24] > delta) {
                lowestPosSigIndex = i24;
                posSigEncountered = true;
                break;
            }
            ++i24;
        }
        int i25 = 0;
        while (i25 < this.dBarValues.length) {
            if (this.dBarValues[i25] < 0.0 && this.dBarValues[i25] - this.sortedDArray[i25] > delta) {
                highestNegSigIndex = i25;
                negSigEncountered = true;
            }
            ++i25;
        }
        if (posSigEncountered && negSigEncountered) {
            i2 = 0;
            while (i2 < highestNegSigIndex + 1) {
                negSigGenes.add(new Integer(sortedDArrayIndices[i2]));
                this.sigFlag[sortedDArrayIndices[i2]] = true;
                ++i2;
            }
            i = highestNegSigIndex + 1;
            while (i < lowestPosSigIndex) {
                nonSigGenes.add(new Integer(sortedDArrayIndices[i]));
                this.sigFlag[sortedDArrayIndices[i]] = false;
                ++i;
            }
            int i26 = lowestPosSigIndex;
            while (i26 < this.dBarValues.length) {
                posSigGenes.add(new Integer(sortedDArrayIndices[i26]));
                this.sigFlag[sortedDArrayIndices[i26]] = true;
                ++i26;
            }
        } else if (posSigEncountered && !negSigEncountered) {
            i2 = 0;
            while (i2 < lowestPosSigIndex) {
                nonSigGenes.add(new Integer(sortedDArrayIndices[i2]));
                this.sigFlag[sortedDArrayIndices[i2]] = false;
                ++i2;
            }
            i = lowestPosSigIndex;
            while (i < this.dBarValues.length) {
                posSigGenes.add(new Integer(sortedDArrayIndices[i]));
                this.sigFlag[sortedDArrayIndices[i]] = true;
                ++i;
            }
        } else if (!posSigEncountered && negSigEncountered) {
            i2 = 0;
            while (i2 < highestNegSigIndex + 1) {
                negSigGenes.add(new Integer(sortedDArrayIndices[i2]));
                this.sigFlag[sortedDArrayIndices[i2]] = true;
                ++i2;
            }
            i = highestNegSigIndex + 1;
            while (i < this.dBarValues.length) {
                nonSigGenes.add(new Integer(sortedDArrayIndices[i]));
                this.sigFlag[sortedDArrayIndices[i]] = false;
                ++i;
            }
        } else if (!posSigEncountered && !negSigEncountered) {
            i2 = 0;
            while (i2 < this.dBarValues.length) {
                nonSigGenes.add(new Integer(sortedDArrayIndices[i2]));
                this.sigFlag[sortedDArrayIndices[i2]] = false;
                ++i2;
            }
        }
        Vector<Integer> allSigGenes = new Vector<Integer>();
        allSigGenes.addAll(posSigGenes);
        allSigGenes.addAll(negSigGenes);
        Vector[] clusters = new Vector[]{posSigGenes, negSigGenes, allSigGenes, nonSigGenes};
        FloatMatrix means = this.getMeans(clusters);
        FloatMatrix variances = this.getVariances(clusters, means);
        System.out.println("    ---- posSigGenes size = " + clusters[0].size());
        System.out.println("    ---- negSigGenes size = " + clusters[1].size());
        System.out.println("    ---- allSigGenes size = " + clusters[2].size());
        System.out.println("    ---- nonSigGenes size = " + clusters[3].size());
        int fileNdx = 0;
        while (fileNdx < this.numExps) {
            float[] cy3Column = groupCW[fileNdx].getColumnOneArray();
            float[] cy5Column = groupCW[fileNdx].getColumnTwoArray();
            DataPrep dataPrep = new DataPrep(groupCW[fileNdx]);
            int inCount = dataPrep.getNonZeroCount();
            int geneNdx = 0;
            while (geneNdx < this.numGenes) {
                if (!this.sigFlag[geneNdx]) {
                    cy3Column[geneNdx] = 0.0f;
                    cy5Column[geneNdx] = 0.0f;
                }
                ++geneNdx;
            }
            this.groupCW[fileNdx].setRowFlag(new AndFlags(this.sigFlag, groupCW[fileNdx].getRowFlagArray()).getAndFlag());
            this.groupCW[fileNdx].setColOneArray(cy3Column);
            this.groupCW[fileNdx].setColTwoArray(cy5Column);
            String ityName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_sam.ity";
            String ltyName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_sam.lty";
            String prcName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_sam.prc";
            String hisName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_sam.his";
            String boxName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_sam_block.box";
            String samName = Module.proj.getProjPath() + "one_class_sam" + FileBrowser.fsep + Module.proj.getProjNameWithoutExt() + ".sam";
            dataPrep = new DataPrep(groupCW[fileNdx]);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            dr = new DataReporter(samName, delta, this.dBarValues, this.sortedDArray);
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(33));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put(CodeBook.lookup(99907), samName);
            hash.put("experiment data file:      ", groupCW[fileNdx].getFileNameWithExtension());
            hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
            String[] moduleNotes = new String[]{"experiment data file:      ", "post-filtering data count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("sam_for_" + groupCW[fileNdx].getFileName(), hash);
            ++fileNdx;
        }
    }

    private FloatMatrix getMeans(Vector[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.numExps);
        int i = 0;
        while (i < clusters.length) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
            ++i;
        }
        return means;
    }

    private FloatMatrix getMean(Vector cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.numExps);
        int n = cluster.size();
        int denom = 0;
        int i = 0;
        while (i < this.numExps) {
            float currentMean = 0.0f;
            denom = 0;
            int j = 0;
            while (j < n) {
                float value = this.expMatrix.get((Integer)cluster.get(j), i);
                if (!Float.isNaN(value)) {
                    currentMean += value;
                    ++denom;
                }
                ++j;
            }
            mean.set(0, i, currentMean / (float)denom);
            ++i;
        }
        return mean;
    }

    private float getMean(float[] row) {
        float mean = 0.0f;
        int validN = 0;
        int i = 0;
        while (i < row.length) {
            if (!Float.isNaN(row[i])) {
                mean += row[i];
                ++validN;
            }
            ++i;
        }
        if (validN == 0) {
            validN = 1;
        }
        return mean /= (float)validN;
    }

    private double getMean(double[] row) {
        double mean = 0.0;
        int validN = 0;
        int i = 0;
        while (i < row.length) {
            if (!Double.isNaN(row[i])) {
                mean += row[i];
                ++validN;
            }
            ++i;
        }
        if (validN == 0) {
            validN = 1;
        }
        double finalMean = mean / (double)validN;
        return finalMean;
    }

    private FloatMatrix getVariances(Vector[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
                ++column;
            }
            ++row;
        }
        return variances;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix inputMatrix, int k) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        int i = 0;
        while (i < numRows) {
            if (this.isMissingValues(inputMatrix, i)) {
                Vector<Integer> nonMissingExpts = new Vector<Integer>();
                int j = 0;
                while (j < numCols) {
                    if (!Float.isNaN(inputMatrix.A[i][j])) {
                        nonMissingExpts.add(new Integer(j));
                    }
                    ++j;
                }
                Vector geneSubset = this.getValidGenes(i, inputMatrix, nonMissingExpts);
                Vector kNearestGenes = this.getKNearestGenes(i, k, inputMatrix, geneSubset, nonMissingExpts);
                int j2 = 0;
                while (j2 < numCols) {
                    resultMatrix.A[i][j2] = !Float.isNaN(inputMatrix.A[i][j2]) ? inputMatrix.A[i][j2] : this.getExptWeightedMean(i, j2, kNearestGenes, inputMatrix);
                    ++j2;
                }
            } else {
                int j = 0;
                while (j < numCols) {
                    resultMatrix.A[i][j] = inputMatrix.A[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return this.imputeRowAverageMatrix(resultMatrix);
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix inputMatrix) throws AlgorithmException {
        int numRows = inputMatrix.getRowDimension();
        int numCols = inputMatrix.getColumnDimension();
        FloatMatrix resultMatrix = new FloatMatrix(numRows, numCols);
        int i = 0;
        while (i < numRows) {
            float[] currentRow = new float[numCols];
            float[] currentOrigRow = new float[numCols];
            int j = 0;
            while (j < numCols) {
                currentRow[j] = inputMatrix.A[i][j];
                currentOrigRow[j] = inputMatrix.A[i][j];
                ++j;
            }
            int k = 0;
            while (k < numCols) {
                if (Float.isNaN(inputMatrix.A[i][k])) {
                    currentRow[k] = this.getMean(currentOrigRow);
                }
                ++k;
            }
            int l = 0;
            while (l < numCols) {
                resultMatrix.A[i][l] = currentRow[l];
                ++l;
            }
            ++i;
        }
        return resultMatrix;
    }

    private double[] getAllSValues() {
        double[] sValues = new double[this.numGenes];
        int i = 0;
        while (i < this.numGenes) {
            sValues[i] = this.getS(i, this.imputedMatrix);
            ++i;
        }
        return sValues;
    }

    private double getS(int gene, FloatMatrix matrix) {
        return this.sOneClass(gene, matrix);
    }

    private double[] getQValues() {
        double[] qValues = new double[101];
        qValues[0] = Double.NEGATIVE_INFINITY;
        int i = 1;
        while (i < qValues.length) {
            qValues[i] = this.getSAlpha(i);
            ++i;
        }
        return qValues;
    }

    private double getSNought() throws AlgorithmException {
        double sNot = 0.0;
        double[] qValues = this.globalAllQValues;
        double[] alphaArray = new double[101];
        double currentAlpha = 0.0;
        int i = 0;
        while (i < alphaArray.length) {
            alphaArray[i] = currentAlpha;
            if ((currentAlpha += 1.0) > 100.0) {
                currentAlpha = 100.0;
            }
            ++i;
        }
        double[] cvAlphaArray = new double[alphaArray.length];
        int i2 = 0;
        while (i2 < alphaArray.length) {
            cvAlphaArray[i2] = this.getCvAlpha(alphaArray[i2], qValues);
            ++i2;
        }
        QSort sortCvAlphaArray = new QSort(cvAlphaArray);
        double[] sortedCvAlphaArray = sortCvAlphaArray.getSortedDouble();
        int[] sortedCvAlphaArrayIndices = sortCvAlphaArray.getOrigIndx();
        int minAlphaIndex = sortedCvAlphaArrayIndices[0];
        double argminAlpha = alphaArray[minAlphaIndex];
        sNot = this.getSAlpha(argminAlpha);
        this.s0Percentile = argminAlpha;
        return sNot;
    }

    private double getSAlpha(double percentile) {
        double sAlpha = 0.0;
        double[] sortedSValues = this.globalSortedAllSValues;
        int percentileIndex = (int)Math.floor((double)sortedSValues.length * percentile / 100.0) - 1;
        if (percentileIndex < 0) {
            percentileIndex = 0;
        } else if (percentileIndex >= sortedSValues.length) {
            percentileIndex = sortedSValues.length - 1;
        }
        sAlpha = sortedSValues[percentileIndex];
        return sAlpha;
    }

    private double getD(int gene, FloatMatrix matrix) {
        return this.getR(gene, matrix) / (this.getS(gene, matrix) + this.sNought);
    }

    private double getDAlpha(int gene, double alpha) {
        return this.getR(gene, this.imputedMatrix) / (this.getS(gene, this.imputedMatrix) + this.getSAlpha(alpha));
    }

    private double getR(int gene, FloatMatrix matrix) {
        return this.rOneClass(gene, matrix);
    }

    private double rOneClass(int gene, FloatMatrix matrix) {
        int validN = 0;
        double xiBar = 0.0;
        int i = 0;
        while (i < this.numExps) {
            ++validN;
            xiBar += (double)matrix.A[gene][i] - this.oneClassMean;
            ++i;
        }
        return xiBar / (double)validN;
    }

    private boolean[] getOneClassChangeSignArray(long seed, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        int i = 0;
        while (i < changeSignArray.length) {
            changeSignArray[i] = false;
            ++i;
        }
        Random generator2 = new Random(seed);
        int i2 = 0;
        while (i2 < validExpts.length) {
            changeSignArray[validExpts[i2]] = generator2.nextBoolean();
            ++i2;
        }
        return changeSignArray;
    }

    private boolean[] getOneClassChangeSignArrayAllUniquePerms(int num, int[] validExpts) {
        boolean[] changeSignArray = new boolean[this.numExps];
        int i = 0;
        while (i < changeSignArray.length) {
            changeSignArray[i] = false;
            ++i;
        }
        int numValidExps = validExpts.length;
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        if (binArray.length < numValidExps) {
            Vector<Character> binVector = new Vector<Character>();
            int i2 = 0;
            while (i2 < numValidExps - binArray.length) {
                binVector.add(new Character('0'));
                ++i2;
            }
            int i3 = 0;
            while (i3 < binArray.length) {
                binVector.add(new Character(binArray[i3]));
                ++i3;
            }
            binArray = new char[binVector.size()];
            int i4 = 0;
            while (i4 < binArray.length) {
                binArray[i4] = ((Character)binVector.get(i4)).charValue();
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < validExpts.length) {
            changeSignArray[validExpts[i5]] = binArray[i5] == '1';
            ++i5;
        }
        return changeSignArray;
    }

    private FloatMatrix getOneClassPermMatrix(FloatMatrix inputMatrix, boolean[] changeSign) {
        FloatMatrix permutedMatrix = new FloatMatrix(inputMatrix.getRowDimension(), inputMatrix.getColumnDimension());
        int i = 0;
        while (i < inputMatrix.getRowDimension()) {
            int j = 0;
            while (j < inputMatrix.getColumnDimension()) {
                permutedMatrix.A[i][j] = changeSign[j] ? (float)((double)inputMatrix.A[i][j] - 2.0 * ((double)inputMatrix.A[i][j] - this.oneClassMean)) : inputMatrix.A[i][j];
                ++j;
            }
            ++i;
        }
        return permutedMatrix;
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (min > array[i]) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    private double getCutUp(double currentDelta) {
        boolean posSigEncountered = false;
        double cutUp = Double.POSITIVE_INFINITY;
        int lowestPosSigIndex = 0;
        boolean highestNegSigIndex = false;
        int i = 0;
        while (i < this.dBarValues.length) {
            if (this.dBarValues[i] > 0.0 && this.sortedDArray[i] - this.dBarValues[i] > currentDelta) {
                lowestPosSigIndex = i;
                posSigEncountered = true;
                break;
            }
            ++i;
        }
        cutUp = posSigEncountered ? this.sortedDArray[lowestPosSigIndex] : Double.POSITIVE_INFINITY;
        return cutUp;
    }

    private double getCutLow(double currentDelta) {
        int highestNegSigIndex = 0;
        boolean negSigEncountered = false;
        double cutLow = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.dBarValues.length) {
            if (this.dBarValues[i] < 0.0 && this.dBarValues[i] - this.sortedDArray[i] > currentDelta) {
                highestNegSigIndex = i;
                negSigEncountered = true;
            }
            ++i;
        }
        cutLow = negSigEncountered ? this.sortedDArray[highestNegSigIndex] : Double.NEGATIVE_INFINITY;
        return cutLow;
    }

    private int getNumSigGenesByDelta(double currentCutUp, double currentCutLow) {
        int numSigGenes = 0;
        int i = 0;
        while (i < this.sortedDArray.length) {
            if (this.sortedDArray[i] >= currentCutUp || this.sortedDArray[i] <= currentCutLow) {
                ++numSigGenes;
            }
            ++i;
        }
        return numSigGenes;
    }

    private double getMedNumFalselyCalledGenesByDelta(double[][] permDVals, double currentCutUp, double currentCutLow) {
        double[] falselyCalledGenes = new double[permDVals.length];
        int i = 0;
        while (i < falselyCalledGenes.length) {
            double[] currentPerm = new double[permDVals[i].length];
            int j = 0;
            while (j < currentPerm.length) {
                currentPerm[j] = permDVals[i][j];
                ++j;
            }
            int numFalse = 0;
            int j2 = 0;
            while (j2 < currentPerm.length) {
                if (currentPerm[j2] >= currentCutUp || currentPerm[j2] <= currentCutLow) {
                    ++numFalse;
                }
                ++j2;
            }
            falselyCalledGenes[i] = numFalse;
            ++i;
        }
        return this.getMedian(falselyCalledGenes);
    }

    private double getNinetiethPercentileFalselyCalledGenesByDelta(double[][] permDVals, double currentCutUp, double currentCutLow) {
        double[] falselyCalledGenes = new double[permDVals.length];
        int i = 0;
        while (i < falselyCalledGenes.length) {
            double[] currentPerm = new double[permDVals[i].length];
            int j = 0;
            while (j < currentPerm.length) {
                currentPerm[j] = permDVals[i][j];
                ++j;
            }
            int numFalse = 0;
            int j2 = 0;
            while (j2 < currentPerm.length) {
                if (currentPerm[j2] >= currentCutUp || currentPerm[j2] <= currentCutLow) {
                    ++numFalse;
                }
                ++j2;
            }
            falselyCalledGenes[i] = numFalse;
            ++i;
        }
        QSort sortFalselyCalled = new QSort(falselyCalledGenes);
        double[] sortedFalselyCalledGenes = sortFalselyCalled.getSortedDouble();
        int ninetiethPercentileIndex = (int)Math.round((double)sortedFalselyCalledGenes.length * 0.9 - 1.0);
        return sortedFalselyCalledGenes[ninetiethPercentileIndex];
    }

    private boolean isSignificant(int gene, double currentCutUp, double currentCutLow) {
        boolean isSig = false;
        if (this.dArray[gene] >= currentCutUp || this.dArray[gene] <= currentCutLow) {
            isSig = true;
        }
        return isSig;
    }

    private float getSampleVariance(Vector cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(Vector cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        int i = 0;
        while (i < size) {
            float value = this.expMatrix.get((Integer)cluster.get(i), column);
            if (!Float.isNaN(value)) {
                sum = (float)((double)sum + Math.pow(value - mean, 2.0));
                ++this.validN;
            }
            ++i;
        }
        return sum;
    }

    private boolean isMissingValues(FloatMatrix mat, int row) {
        int i = 0;
        while (i < mat.getColumnDimension()) {
            if (Float.isNaN(mat.A[row][i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector getValidGenes(int gene, FloatMatrix mat, Vector validExpts) {
        Vector<Integer> validGenes = new Vector<Integer>();
        int i = 0;
        while (i < mat.getRowDimension()) {
            if (this.hasAllExpts(i, mat, validExpts) && gene != i) {
                validGenes.add(new Integer(i));
            }
            ++i;
        }
        if (validGenes.size() < this.numNeighbors) {
            int additionalGenesNeeded = this.numNeighbors - validGenes.size();
            Vector additionalGenes = this.getAdditionalGenes(gene, additionalGenesNeeded, validGenes, mat);
            int i2 = 0;
            while (i2 < additionalGenes.size()) {
                validGenes.add((Integer)additionalGenes.get(i2));
                ++i2;
            }
        }
        return validGenes;
    }

    Vector getKNearestGenes(int gene, int k, FloatMatrix mat, Vector geneSubset, Vector nonMissingExpts) {
        Vector<Integer> allValidGenes = new Vector<Integer>();
        Vector<Integer> nearestGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        float factor = 1.0f;
        int i = 0;
        while (i < geneSubset.size()) {
            int currentGene = (Integer)geneSubset.get(i);
            if (gene != currentGene) {
                float currentDistance = ExperimentUtil2.geneEuclidianDistance(mat, null, gene, currentGene, factor);
                geneDistances.add(new Float(currentDistance));
                allValidGenes.add(new Integer(currentGene));
            }
            ++i;
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        int i2 = 0;
        while (i2 < geneDistances.size()) {
            float currentDist;
            geneDistancesArray[i2] = currentDist = ((Float)geneDistances.get(i2)).floatValue();
            ++i2;
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        int i3 = 0;
        while (i3 < k) {
            int currentGeneIndex = sortedDistanceIndices[i3];
            int currentNearestGene = (Integer)allValidGenes.get(currentGeneIndex);
            nearestGenes.add(new Integer(currentNearestGene));
            ++i3;
        }
        return nearestGenes;
    }

    private float getExptWeightedMean(int gene, int expt, Vector geneVector, FloatMatrix mat) {
        float weightedMean = 0.0f;
        int validN = 0;
        float numerator = 0.0f;
        float[] recipNeighborDistances = new float[geneVector.size()];
        float factor = 1.0f;
        int i = 0;
        while (i < recipNeighborDistances.length) {
            int currentGene = (Integer)geneVector.get(i);
            if (!Float.isNaN(mat.A[currentGene][expt])) {
                float distance = ExperimentUtil2.geneEuclidianDistance(mat, null, gene, currentGene, factor);
                if (distance == 0.0f) {
                    distance = Float.MIN_VALUE;
                }
                recipNeighborDistances[i] = 1.0f / distance;
                numerator += recipNeighborDistances[i] * mat.A[currentGene][expt];
                ++validN;
            } else {
                recipNeighborDistances[i] = 0.0f;
            }
            ++i;
        }
        float denominator = 0.0f;
        int i2 = 0;
        while (i2 < recipNeighborDistances.length) {
            denominator += recipNeighborDistances[i2];
            ++i2;
        }
        weightedMean = numerator / denominator;
        return weightedMean;
    }

    private double sOneClass(int gene, FloatMatrix matrix) {
        double xiBar = this.rOneClass(gene, matrix);
        double sValue = 0.0;
        int validN = 0;
        int i = 0;
        while (i < this.numExps) {
            ++validN;
            sValue += Math.pow((double)matrix.A[gene][i] - xiBar, 2.0);
            ++i;
        }
        return Math.sqrt(sValue / (double)(validN * (validN - 1)));
    }

    private double getCvAlpha(double alpha, double[] qValues) {
        double[] vjValuesArray = new double[100];
        int i = 0;
        while (i < vjValuesArray.length) {
            vjValuesArray[i] = this.getMAD(i + 1, alpha);
            ++i;
        }
        double var = this.getVar(vjValuesArray);
        double mean = this.getMean(vjValuesArray);
        double n = 0.0;
        int i2 = 0;
        while (i2 < vjValuesArray.length) {
            if (!Double.isNaN(vjValuesArray[i2])) {
                n += 1.0;
            }
            ++i2;
        }
        if (n == 1.0) {
            return 0.0;
        }
        if (n == 0.0) {
            return Double.NaN;
        }
        double stdDev = Math.sqrt(var / (n - 1.0));
        return stdDev / mean;
    }

    private double getMedian(double[] array) {
        QSort sortArray = new QSort(array);
        double median = 0.0;
        double[] sortedArray = sortArray.getSortedDouble();
        if (sortedArray.length % 2 == 0) {
            double mid2 = sortedArray.length / 2;
            int midIndex2 = (int)Math.round(mid2);
            int midIndex1 = midIndex2 - 1;
            median = (sortedArray[midIndex2] + sortedArray[midIndex1]) / 2.0;
        } else {
            double mid = (double)(sortedArray.length / 2) - 0.5;
            int midIndex = (int)Math.round(mid);
            median = sortedArray[midIndex];
        }
        return median;
    }

    private boolean hasAllExpts(int gene, FloatMatrix mat, Vector validExpts) {
        int i = 0;
        while (i < validExpts.size()) {
            int expIndex = (Integer)validExpts.get(i);
            if (Float.isNaN(mat.A[gene][expIndex])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Vector getAdditionalGenes(int currentGene, int numGenesNeeded, Vector alreadyPresentGenes, FloatMatrix mat) {
        Vector<Integer> additionalGenes = new Vector<Integer>();
        Vector<Integer> allGenes = new Vector<Integer>();
        Vector<Float> geneDistances = new Vector<Float>();
        float factor = 1.0f;
        int i = 0;
        while (i < mat.getRowDimension()) {
            if (i != currentGene) {
                float currentDistance = ExperimentUtil2.geneEuclidianDistance(mat, null, i, currentGene, factor);
                geneDistances.add(new Float(currentDistance));
                allGenes.add(new Integer(i));
            }
            ++i;
        }
        float[] geneDistancesArray = new float[geneDistances.size()];
        int i2 = 0;
        while (i2 < geneDistances.size()) {
            float currentDist;
            geneDistancesArray[i2] = currentDist = ((Float)geneDistances.get(i2)).floatValue();
            ++i2;
        }
        QSort sortGeneDistances = new QSort(geneDistancesArray);
        float[] sortedDistances = sortGeneDistances.getSorted();
        int[] sortedDistanceIndices = sortGeneDistances.getOrigIndx();
        int counter = 0;
        int i3 = 0;
        while (i3 < sortedDistanceIndices.length) {
            int currentIndex = sortedDistanceIndices[i3];
            int currentNearestGene = (Integer)allGenes.get(currentIndex);
            if (!this.belongsIn(alreadyPresentGenes, currentNearestGene)) {
                additionalGenes.add(new Integer(currentNearestGene));
                if (++counter >= numGenesNeeded) break;
            }
            ++i3;
        }
        return additionalGenes;
    }

    private double getMAD(int j, double alpha) {
        double[] sValues = this.globalAllSValues;
        double[] qValues = this.globalAllQValues;
        Vector validSValuesAndGenes = this.getValidSValuesAndGenes(sValues, qValues, j);
        Vector validSValues = (Vector)validSValuesAndGenes.get(0);
        Vector validGenes = (Vector)validSValuesAndGenes.get(1);
        double[] dValues = new double[validSValues.size()];
        int i = 0;
        while (i < dValues.length) {
            double currentD;
            int currentGene = (Integer)validGenes.get(i);
            dValues[i] = currentD = this.getDAlpha(currentGene, alpha);
            ++i;
        }
        double medianD = this.getMedian(dValues);
        double[] absDevValues = new double[dValues.length];
        int i2 = 0;
        while (i2 < dValues.length) {
            absDevValues[i2] = Math.abs(dValues[i2] - medianD);
            ++i2;
        }
        double medianAbsDev = this.getMedian(absDevValues) / 0.6745;
        return medianAbsDev;
    }

    private double getVar(double[] values) {
        double mean = this.getMean(values);
        double var = 0.0;
        int i = 0;
        while (i < values.length) {
            if (!Double.isNaN(values[i])) {
                double sqDev = (values[i] - mean) * (values[i] - mean);
                var += sqDev;
            }
            ++i;
        }
        return var;
    }

    private boolean belongsIn(Vector geneVector, int gene) {
        int i = 0;
        while (i < geneVector.size()) {
            int currentGene = (Integer)geneVector.get(i);
            if (gene == currentGene) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector getValidSValuesAndGenes(double[] sValues, double[] qValues, int j) {
        Vector validSValuesAndGenes = new Vector();
        Vector<Double> validSValues = new Vector<Double>();
        Vector<Integer> validGenes = new Vector<Integer>();
        if (j == 100) {
            int i = 0;
            while (i < sValues.length) {
                if (sValues[i] >= qValues[j]) {
                    validSValues.add(new Double(sValues[i]));
                    validGenes.add(new Integer(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < sValues.length) {
                if (sValues[i] >= qValues[j] && sValues[i] < qValues[j + 1]) {
                    validSValues.add(new Double(sValues[i]));
                    validGenes.add(new Integer(i));
                } else if (sValues[i] == qValues[j] && sValues[i] == qValues[j + 1]) {
                    validSValues.add(new Double(sValues[i]));
                    validGenes.add(new Integer(i));
                }
                ++i;
            }
        }
        validSValuesAndGenes.add(validSValues);
        validSValuesAndGenes.add(validGenes);
        return validSValuesAndGenes;
    }

    public ColumnWorker[] getOneClassSAMColumnWorker() {
        return this.groupCW;
    }

    public static void main(String[] args) {
        String path = "C:\\DataFiles0\\mev files\\BryanData\\";
        String[] f = new String[]{"NFE005d0001.mev", "NFE005d0002.mev", "NFE005d0003.mev", "NFE005d0004.mev", "NFE005d0005.mev", "NFE005d0006.mev", "NFE005d0007.mev", "NFE005d0008.mev"};
        ColumnWorker[] folderCW = new ColumnWorker[4];
        try {
            int fileNdx = 0;
            while (fileNdx < 4) {
                folderCW[fileNdx] = new ColumnWorker(path + f[fileNdx]);
                folderCW[fileNdx].setColumnsForUID();
                folderCW[fileNdx].setColumnsForMeta(2, 3);
                folderCW[fileNdx].setColumns(6, 7);
                System.out.println("------ > Done with reading " + path + f[fileNdx]);
                ++fileNdx;
            }
            SAM sam = new SAM(folderCW, 0.0f, false, 8, 3302, 3306, 12);
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

