/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.SliceAnalyzer;
import org.tigr.midas.exception.SAInvalidSliceWindowDataPopulation;
import org.tigr.midas.exception.SA_CantComputeSliceMeanSD;
import org.tigr.midas.exception.SliceAnalysisException;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class SliceAnalysis
extends Module {
    private ColumnWorker fCW;
    private int totalRowCount;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] sortedLogProd;

    public SliceAnalysis(ColumnWorker fileCW, int sliceDataPop, float sliceDataRangeLtVal, float sliceDataRangeGtVal) throws SliceAnalysisException, SAInvalidSliceWindowDataPopulation, SA_CantComputeSliceMeanSD {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String saFB = projFolderFB.createSubDir("slice_analysis");
        try {
            this.fCW = fileCW;
            this.totalRowCount = fileCW.getRowCounts();
            this.cy3Column = fileCW.getColumnOneArray();
            this.cy5Column = fileCW.getColumnTwoArray();
            boolean[] tempFlag = fileCW.getRowFlagArray();
            boolean[] inputFlag = new boolean[tempFlag.length];
            System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);
            boolean[] saFlag = new boolean[this.totalRowCount];
            DataPrep dataPrep = new DataPrep(fileCW);
            if (sliceDataPop > dataPrep.getLogRatio().length) {
                throw new SAInvalidSliceWindowDataPopulation();
            }
            SliceAnalyzer sliceAnalyzer = new SliceAnalyzer(dataPrep.getLogProd(), dataPrep.getLogRatio(), dataPrep.getRawNdx(), sliceDataPop);
            sliceAnalyzer.findDataPointsInStdRange(sliceDataRangeGtVal, sliceDataRangeLtVal);
            float[] prod = sliceAnalyzer.getWithinRangeLogProd();
            float[] ratio = sliceAnalyzer.getWithinRangeLogRatio();
            int[] outputNdx = sliceAnalyzer.getWithinRangeRawNdx();
            int withinRangeCount = sliceAnalyzer.getWithinRangeCount();
            int beyondRangeCount = sliceAnalyzer.getBeyondRangeCount();
            float[] rawProd = sliceAnalyzer.getWholeX();
            float[] rawRatio = sliceAnalyzer.getWholeY();
            float[] ratioMean = sliceAnalyzer.getlogRatioMean();
            float[] ratioStd = sliceAnalyzer.getlogRatioStd();
            float[] zScoreVal = sliceAnalyzer.getZscoreVal();
            float[] pVal = sliceAnalyzer.getPVal();
            float[] logPVal = sliceAnalyzer.getLogPVal();
            int[] rawFullNdx = sliceAnalyzer.getWholeZ();
            int rawRowIndex = 0;
            while (rawRowIndex < fileCW.getRowCounts()) {
                int i = 0;
                while (i < outputNdx.length) {
                    if (outputNdx[i] == rawRowIndex) {
                        saFlag[rawRowIndex] = true;
                        break;
                    }
                    saFlag[rawRowIndex] = false;
                    ++i;
                }
                ++rawRowIndex;
            }
            boolean[] outputFlag = new AndFlags(inputFlag, saFlag).getAndFlag();
            this.fCW.setColOneArray(this.cy3Column);
            this.fCW.setColTwoArray(this.cy5Column);
            this.fCW.setRowFlag(outputFlag);
            String ityName = Module.proj.getProjPath() + "slice_analysis" + FileBrowser.fsep + fileCW.getFileName() + "_slice.ity";
            String ltyName = Module.proj.getProjPath() + "slice_analysis" + FileBrowser.fsep + fileCW.getFileName() + "_slice.lty";
            String prcName = Module.proj.getProjPath() + "slice_analysis" + FileBrowser.fsep + fileCW.getFileName() + "_slice.prc";
            String hisName = Module.proj.getProjPath() + "slice_analysis" + FileBrowser.fsep + fileCW.getFileName() + "_slice.his";
            String boxName = Module.proj.getProjPath() + "slice_analysis" + FileBrowser.fsep + fileCW.getFileName() + "_slice_block.box";
            dataPrep = new DataPrep(fileCW);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(20));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put("experiment data file:      ", fileCW.getFileNameWithExtension());
            hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
            String[] moduleNotes = new String[]{"experiment data file:      ", "post-filtering data count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("slice_for_" + fileCW.getFileName(), hash);
        }
        catch (SAInvalidSliceWindowDataPopulation ex) {
            throw ex;
        }
        catch (SA_CantComputeSliceMeanSD ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SliceAnalysisException();
        }
    }

    public void preWork(boolean[] inputFlag) {
        float[] wholeLogRatio = new float[this.totalRowCount];
        float[] nonZeroLogRatio = new float[this.totalRowCount];
        float[] wholeLogProd = new float[this.totalRowCount];
        float[] nonZeroLogProd = new float[this.totalRowCount];
        int[] nonZeroRawIdx = new int[this.totalRowCount];
        int[] zeroRawIdx = new int[this.totalRowCount];
        int nonZeroCount = 0;
        int zeroCount = 0;
        int rowIndex = 0;
        while (rowIndex < this.totalRowCount) {
            if (this.cy3Column[rowIndex] <= 1.0f || this.cy5Column[rowIndex] <= 1.0f || !inputFlag[rowIndex]) {
                this.cy3Column[rowIndex] = 0.0f;
                this.cy5Column[rowIndex] = 0.0f;
                wholeLogRatio[rowIndex] = 0.0f;
                wholeLogProd[rowIndex] = 0.0f;
                zeroRawIdx[zeroCount] = rowIndex;
                ++zeroCount;
            } else {
                wholeLogRatio[rowIndex] = MathTools.log2(this.cy5Column[rowIndex] / this.cy3Column[rowIndex]);
                wholeLogProd[rowIndex] = MathTools.log10(this.cy5Column[rowIndex] * this.cy3Column[rowIndex]);
                nonZeroLogRatio[nonZeroCount] = wholeLogRatio[rowIndex];
                nonZeroLogProd[nonZeroCount] = wholeLogProd[rowIndex];
                nonZeroRawIdx[nonZeroCount] = rowIndex;
                ++nonZeroCount;
            }
            ++rowIndex;
        }
        System.out.println("    ---- totalRowCount = " + this.totalRowCount);
        System.out.println("    ---- nonZeroCount = " + nonZeroCount);
        System.out.println("    ---- zeroCount = " + zeroCount);
        float[] t = new float[nonZeroLogProd.length];
        System.arraycopy(nonZeroLogProd, 0, t, 0, nonZeroLogProd.length);
        nonZeroLogProd = new float[nonZeroCount];
        System.arraycopy(t, 0, nonZeroLogProd, 0, nonZeroCount);
        t = new float[nonZeroLogRatio.length];
        System.arraycopy(nonZeroLogRatio, 0, t, 0, nonZeroLogRatio.length);
        nonZeroLogRatio = new float[nonZeroCount];
        System.arraycopy(t, 0, nonZeroLogRatio, 0, nonZeroCount);
        int[] tt = new int[nonZeroRawIdx.length];
        System.arraycopy(nonZeroRawIdx, 0, tt, 0, nonZeroRawIdx.length);
        nonZeroRawIdx = new int[nonZeroCount];
        System.arraycopy(tt, 0, nonZeroRawIdx, 0, nonZeroCount);
        tt = new int[zeroRawIdx.length];
        System.arraycopy(zeroRawIdx, 0, tt, 0, zeroRawIdx.length);
        zeroRawIdx = new int[zeroCount];
        System.arraycopy(tt, 0, zeroRawIdx, 0, zeroCount);
    }

    public final ColumnWorker getFileSAColumnWorker() {
        return this.fCW;
    }
}

