/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.BlockFiller;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.LogRatioToCy;

public class VariReg
extends Module {
    private ColumnWorker fCW;
    private int assembledGoodCount;
    private boolean[] inputFlag;
    private float[][] blockLogProd;
    private float[][] blockLogRatio;
    private int[][] blockNdx;
    private float[][] sdRegBlockLogRatio;
    private float[] blockLogRatioMean;
    private float[] blockLogRatioSD;
    private float[] blockLogRatioFactor;
    private String[] blockSummary;
    private float[] sortedAssembledLogProd;
    private float[] sortedAssembledLogRatio;
    private float[] sortedAssembledRawLogRatio;
    private int[] sortedAssembledRawNdx;
    private float slideRawLogRatioMean;
    private float slideRawLogRatioSD;
    private float slideLogRatioMean;
    private float slideLogRatioSD;

    public VariReg(ColumnWorker fileCW, String ref) throws Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String sdRegFB = projFolderFB.createSubDir("sd_reg");
        this.fCW = fileCW;
        boolean[] tempFlag = fileCW.getRowFlagArray();
        this.inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, this.inputFlag, 0, tempFlag.length);
        int totalRowCount = this.fCW.getRowCounts();
        BlockFiller blockFiller = new BlockFiller(fileCW);
        this.blockLogProd = new float[blockFiller.getBlockNumber()][];
        this.blockLogRatio = new float[blockFiller.getBlockNumber()][];
        this.blockNdx = new int[blockFiller.getBlockNumber()][];
        this.sdRegBlockLogRatio = new float[blockFiller.getBlockNumber()][];
        this.blockLogRatioMean = new float[blockFiller.getBlockNumber()];
        this.blockLogRatioSD = new float[blockFiller.getBlockNumber()];
        this.blockLogRatioFactor = new float[blockFiller.getBlockNumber()];
        this.blockSummary = new String[blockFiller.getBlockNumber()];
        int blockCount = 0;
        while (blockCount < blockFiller.getBlockNumber()) {
            float[] cy3Column = blockFiller.getBlockCy3(blockCount);
            float[] cy5Column = blockFiller.getBlockCy5(blockCount);
            int[] rawNdx = blockFiller.getOrigIndex(blockCount);
            CyToLogProdRatio lpr = new CyToLogProdRatio(cy3Column, cy5Column, rawNdx, this.inputFlag);
            this.blockLogProd[blockCount] = lpr.getLogProd();
            this.blockLogRatio[blockCount] = lpr.getLogRatio();
            this.blockNdx[blockCount] = lpr.getNdx();
            StatsTools s = new StatsTools();
            s.computeMeanSD(this.blockLogRatio[blockCount]);
            this.blockLogRatioMean[blockCount] = s.getXMean();
            this.blockLogRatioSD[blockCount] = s.getXSD();
            System.out.println("    ----> Block " + blockCount + ", blockLogRatioMean = " + this.blockLogRatioMean[blockCount] + ", blockLogRatioSD = " + this.blockLogRatioSD[blockCount]);
            this.assembledGoodCount += this.blockLogRatio[blockCount].length;
            ++blockCount;
        }
        float blockSDProd = 1.0f;
        int blockCount2 = 0;
        while (blockCount2 < blockFiller.getBlockNumber()) {
            blockSDProd *= this.blockLogRatioSD[blockCount2];
            ++blockCount2;
        }
        System.out.println("    assembledGoodCount = " + this.assembledGoodCount);
        float[] assembledLogProd = new float[this.assembledGoodCount];
        float[] assembledLogRatio = new float[this.assembledGoodCount];
        float[] assembledRawLogRatio = new float[this.assembledGoodCount];
        int[] assembledRawNdx = new int[this.assembledGoodCount];
        int assembleNdx = 0;
        float blockSDMean = MathTools.nthRoot(blockSDProd, blockFiller.getBlockNumber());
        int blockCount3 = 0;
        while (blockCount3 < blockFiller.getBlockNumber()) {
            this.sdRegBlockLogRatio[blockCount3] = new float[this.blockLogRatio[blockCount3].length];
            this.blockLogRatioFactor[blockCount3] = this.blockLogRatioSD[blockCount3] / MathTools.nthRoot(blockSDProd, blockFiller.getBlockNumber());
            System.out.println("    ----> Block " + blockCount3 + ", processed spots#: " + this.blockLogRatio[blockCount3].length + ", blockLogRatioFactor = " + this.blockLogRatioFactor[blockCount3]);
            int blockGeneNdx = 0;
            while (blockGeneNdx < this.blockLogRatio[blockCount3].length) {
                assembledRawLogRatio[assembleNdx] = this.blockLogRatio[blockCount3][blockGeneNdx];
                assembledLogRatio[assembleNdx] = this.blockLogRatio[blockCount3][blockGeneNdx] / this.blockLogRatioFactor[blockCount3];
                this.sdRegBlockLogRatio[blockCount3][blockGeneNdx] = this.blockLogRatio[blockCount3][blockGeneNdx] / this.blockLogRatioFactor[blockCount3];
                assembledLogProd[assembleNdx] = this.blockLogProd[blockCount3][blockGeneNdx];
                assembledRawNdx[assembleNdx] = this.blockNdx[blockCount3][blockGeneNdx];
                ++assembleNdx;
                ++blockGeneNdx;
            }
            ++blockCount3;
        }
        QSort sortAssemble = new QSort(assembledLogProd);
        this.sortedAssembledLogProd = sortAssemble.getSorted();
        int[] cc = sortAssemble.getOrigIndx();
        this.sortedAssembledLogRatio = new float[this.sortedAssembledLogProd.length];
        this.sortedAssembledRawLogRatio = new float[this.sortedAssembledLogProd.length];
        this.sortedAssembledRawNdx = new int[this.sortedAssembledLogProd.length];
        int sac = 0;
        while (sac < this.sortedAssembledLogProd.length) {
            this.sortedAssembledLogRatio[sac] = assembledLogRatio[cc[sac]];
            this.sortedAssembledRawLogRatio[sac] = assembledRawLogRatio[cc[sac]];
            this.sortedAssembledRawNdx[sac] = assembledRawNdx[cc[sac]];
            ++sac;
        }
        StatsTools sTools = new StatsTools();
        sTools.computeMeanSD(this.sortedAssembledRawLogRatio);
        this.slideRawLogRatioMean = sTools.getXMean();
        this.slideRawLogRatioSD = sTools.getXSD();
        sTools = new StatsTools();
        sTools.computeMeanSD(this.sortedAssembledLogRatio);
        this.slideLogRatioMean = sTools.getXMean();
        this.slideLogRatioSD = sTools.getXSD();
        System.out.println("    slideRawLogRatioMean = " + this.slideRawLogRatioMean);
        System.out.println("    slideRawLogRatioSD = " + this.slideRawLogRatioSD);
        System.out.println("    slideLogRatioMean = " + this.slideLogRatioMean);
        System.out.println("    slideLogRatioSD = " + this.slideLogRatioSD);
        LogRatioToCy logRatioToCy = new LogRatioToCy(this.fCW.getColumnOneArray(), this.fCW.getColumnTwoArray(), this.sortedAssembledLogRatio, this.sortedAssembledRawNdx, ref);
        this.fCW.setColOneArray(logRatioToCy.getCy3Column());
        this.fCW.setColTwoArray(logRatioToCy.getCy5Column());
        String ityName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + fileCW.getFileName() + "_sdreg.ity";
        String ltyName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + fileCW.getFileName() + "_sdreg.lty";
        String prcName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + fileCW.getFileName() + "_sdreg.prc";
        String hisName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + fileCW.getFileName() + "_sdreg.his";
        String boxName = Module.proj.getProjPath() + "sd_reg" + FileBrowser.fsep + fileCW.getFileName() + "_sdreg_block.box";
        DataPrep dataPrep = new DataPrep(fileCW);
        DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
        dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
        dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("identity", new Integer(13));
        hash.put(CodeBook.lookup(99901), ityName);
        hash.put(CodeBook.lookup(99902), ltyName);
        hash.put(CodeBook.lookup(99903), prcName);
        hash.put(CodeBook.lookup(99904), hisName);
        hash.put(CodeBook.lookup(99905), boxName);
        hash.put("experiment data file: ", fileCW.getFileNameWithExtension());
        hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
        hash.put("slide log-ratio mean: ", new Float(this.slideLogRatioMean));
        hash.put("slide log-ratio SD:   ", new Float(this.slideLogRatioSD));
        String[] moduleNotes = new String[]{"experiment data file: ", "processed data count: ", "slide log-ratio mean: ", "slide log-ratio SD:   "};
        hash.put("module_notes", moduleNotes);
        Module.proj.insertReportItem("sdreg_for_" + fileCW.getFileName(), hash);
    }

    public final ColumnWorker getFileVariRegColumnWorker() {
        return this.fCW;
    }

    public final float[] getBlockLogRatioMean() {
        return this.blockLogRatioMean;
    }

    public final float[] getBlockLogRatioSD() {
        return this.blockLogRatioSD;
    }

    public final float[] getBlockLogRatioSDFactor() {
        return this.blockLogRatioFactor;
    }

    public final float[] getSortedAssembledLogRatio() {
        return this.sortedAssembledLogRatio;
    }

    public final float[] getSortedAssembledRawLogRatio() {
        return this.sortedAssembledRawLogRatio;
    }

    public final int[] getSortedAssembledRawNdx() {
        return this.sortedAssembledRawNdx;
    }

    public final float getSlideRawLogRatioMean() {
        return this.slideRawLogRatioMean;
    }

    public final float getSlideRawLogRatioSD() {
        return this.slideRawLogRatioSD;
    }

    public final float getSlideLogRatioMean() {
        return this.slideLogRatioMean;
    }

    public final float getSlideLogRatioSD() {
        return this.slideLogRatioSD;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\VariRegTest\\CAG-108_MDS.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            VariReg veriReg = new VariReg(fileCW, "Cy3");
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

