/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.math;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.tigr.midas.math.SortAlgorithm;

public class SortItem
extends Applet
implements Runnable {
    private Thread kicker;
    int[] arr;
    int h1 = -1;
    int h2 = -1;
    String algName;
    SortAlgorithm algorithm;

    void scramble() {
        int[] a = new int[this.getSize().height / 2];
        double f = (double)this.getSize().width / (double)a.length;
        int i = a.length;
        while (--i >= 0) {
            a[i] = (int)((double)i * f);
        }
        int i2 = a.length;
        while (--i2 >= 0) {
            int j = (int)((double)i2 * Math.random());
            int t = a[i2];
            a[i2] = a[j];
            a[j] = t;
        }
        this.arr = a;
    }

    void pause() {
        this.pause(-1, -1);
    }

    void pause(int H1) {
        this.pause(H1, -1);
    }

    void pause(int H1, int H2) {
        this.h1 = H1;
        this.h2 = H2;
        if (this.kicker != null) {
            this.repaint();
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void init() {
        String at = this.getParameter("alg");
        if (at == null) {
            at = "BubbleSort";
        }
        this.algName = at + "Algorithm";
        this.scramble();
        this.addMouseListener(new ClockStarter());
        this.resize(100, 100);
    }

    public void paint(Graphics g) {
        int[] a = this.arr;
        int y = this.getSize().height - 1;
        g.setColor(this.getBackground());
        int i = a.length;
        while (--i >= 0) {
            g.drawLine(this.arr[i], y, this.getSize().width, y);
            y -= 2;
        }
        g.setColor(Color.black);
        y = this.getSize().height - 1;
        int i2 = a.length;
        while (--i2 >= 0) {
            g.drawLine(0, y, this.arr[i2], y);
            y -= 2;
        }
        if (this.h1 >= 0) {
            g.setColor(Color.red);
            y = this.h1 * 2 + 1;
            g.drawLine(0, y, this.getSize().width, y);
        }
        if (this.h2 >= 0) {
            g.setColor(Color.blue);
            y = this.h2 * 2 + 1;
            g.drawLine(0, y, this.getSize().width, y);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void run() {
        try {
            if (this.algorithm == null) {
                this.algorithm = (SortAlgorithm)Class.forName(this.algName).newInstance();
                this.algorithm.setParent(this);
            }
            this.algorithm.init();
            this.algorithm.sort(this.arr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        if (this.kicker != null) {
            try {
                this.kicker.stop();
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            this.kicker = null;
        }
        if (this.algorithm != null) {
            try {
                this.algorithm.stop();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    synchronized void startSort() {
        if (this.kicker == null || !this.kicker.isAlive()) {
            this.scramble();
            this.repaint();
            this.kicker = new Thread(this);
            this.kicker.start();
        }
    }

    class ClockStarter
    extends MouseAdapter {
        ClockStarter() {
        }

        public void mouseReleased(MouseEvent e) {
            SortItem.this.startSort();
        }
    }
}

