/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.report;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.engine.Project;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.report.FreeItem;
import org.tigr.midas.report.PdfControl;
import org.tigr.midas.report.TableItem;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.FileBrowser;

public class PreparePDFReport {
    Color captionColor = new Color(3, 99, 189);
    Font font24B = FontFactory.getFont((String)"Helvetica", (float)24.0f, (int)1);
    Font font18BI = FontFactory.getFont((String)"Helvetica", (float)18.0f, (int)3, (Color)this.captionColor);
    Font font14BI = FontFactory.getFont((String)"Helvetica", (float)14.0f, (int)3, (Color)this.captionColor);
    Font font14I = FontFactory.getFont((String)"Helvetica", (float)14.0f, (int)2, (Color)this.captionColor);
    Font font12BI = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)3, (Color)this.captionColor);
    Font fontC12 = FontFactory.getFont((String)"Courier", (float)12.0f, (int)0, (Color)Color.black);
    Font font12I_black = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)2, (Color)Color.black);
    Font font12B = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1, (Color)this.captionColor);
    Font font11 = FontFactory.getFont((String)"Helvetica", (float)11.0f);
    Font font10B = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)1, (Color)this.captionColor);
    Font fontC10I_blue = FontFactory.getFont((String)"Courier", (float)10.0f, (int)2, (Color)Color.blue);
    Font font9 = FontFactory.getFont((String)"Helvetica", (float)9.0f);
    Document document;
    PdfWriter writer;
    Project proj;
    PdfControl pc;
    List flowCodeList;
    static /* synthetic */ Class class$org$tigr$midas$report$PreparePDFReport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparePDFReport(Project prj) {
        System.out.println("Preparing PDF report ...");
        this.proj = prj;
        this.pc = this.proj.getPdfControl();
        this.flowCodeList = this.proj.getFlowCodeList();
        try {
            this.document = this.docInit();
            this.docCover(this.document);
            this.docAdd(this.document, this.partI());
            this.docAdd(this.document, this.partII());
            this.docAdd(this.document, this.partIII());
            this.docAdd(this.document, this.partIV());
            Object var3_2 = null;
            this.docClose(this.document);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.docClose(this.document);
            throw throwable;
        }
    }

    private Document docInit() {
        try {
            Document doc = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
            String pdfName = this.proj.getProjFullName().substring(0, this.proj.getProjFullName().length() - 4);
            this.writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(pdfName + ".pdf"));
            doc.open();
            HeaderFooter pageN = new HeaderFooter(new Phrase("Page: "), true);
            pageN.setBorder(0);
            doc.setFooter(pageN);
            return doc;
        }
        catch (Exception de) {
            System.out.println("----> Error in docInit()\n");
            de.printStackTrace();
            return null;
        }
    }

    private void docCover(Document doc) {
        try {
            Image tm4Logo = Image.getInstance((URL)(class$org$tigr$midas$report$PreparePDFReport == null ? (class$org$tigr$midas$report$PreparePDFReport = PreparePDFReport.class$("org.tigr.midas.report.PreparePDFReport")) : class$org$tigr$midas$report$PreparePDFReport).getClassLoader().getResource("org/tigr/midas/report/tm4_logo.gif"));
            tm4Logo.scalePercent(50.0f);
            tm4Logo.setAbsolutePosition(36.0f, 758.0f);
            doc.add((Element)tm4Logo);
            String title = this.pc.get("title") != null ? "   " + this.pc.get("title").toString() : "    TIGR MIDAS Analysis Report";
            Paragraph p1 = new Paragraph("      " + title + "\n\n\n", this.font18BI);
            p1.setAlignment(1);
            doc.add((Element)p1);
            String preparedBy = "Prepared by " + this.pc.get("analyst");
            String preparedOn = DateFormat.getDateInstance(1, Locale.US).format(new Date(System.currentTimeMillis()));
            Paragraph p2 = new Paragraph(preparedBy + "\n" + preparedOn, this.font14I);
            p2.setAlignment(1);
            doc.add((Element)p2);
        }
        catch (Exception de) {
            System.out.println("----> Error in docAddTitle()\n");
            de.printStackTrace();
            doc.close();
        }
    }

    private void docAdd(Document doc, Chapter chap) {
        try {
            doc.add((Element)chap);
        }
        catch (Exception de) {
            System.out.println("----> Error in docAdd()\n");
            de.printStackTrace();
            doc.close();
        }
    }

    private void docClose(Document doc) {
        doc.close();
    }

    private Chapter partI() {
        System.out.println("    ---- Reporting general information ...");
        Chapter chapter1 = new Chapter(new Paragraph("Part I: General Information", this.font14BI), 1);
        chapter1.setNumberDepth(0);
        Paragraph projInfo = new Paragraph("Project Information", this.font12BI);
        Section project = chapter1.addSection(projInfo);
        ArrayList<String> keyList = new ArrayList<String>(5);
        Hashtable<String, Object> infoHash = new Hashtable<String, Object>(5);
        keyList.add("Analyst:");
        keyList.add("Analysis Start Time:");
        keyList.add("Analysis Stop Time:");
        keyList.add("MIDAS Version:");
        keyList.add("Project File Name:");
        infoHash.put("Analyst:", this.pc.get("analyst") != null ? this.pc.get("analyst").toString() : "analyst");
        infoHash.put("Analysis Start Time:", this.proj.getStartDate().toString());
        infoHash.put("Analysis Stop Time:", this.proj.getStopDate().toString());
        infoHash.put("MIDAS Version:", this.proj.midasVersion);
        infoHash.put("Project File Name:", this.proj.getProjFullName());
        infoHash.put("keyList", keyList);
        new FreeItem(infoHash).mountTo(project);
        Paragraph sysInfo = new Paragraph("System Information", this.font12BI);
        Section system = chapter1.addSection(sysInfo);
        keyList = new ArrayList(9);
        infoHash = new Hashtable(9);
        keyList.add("Java Runtime Environment version:");
        keyList.add("Java Runtime Environment vendor:");
        keyList.add("Java Virtual Machine name:");
        keyList.add("Java Virtual Machine version:");
        keyList.add("Java Virtual Machine vendor:");
        keyList.add("Operating System name:");
        keyList.add("Operating System version:");
        keyList.add("Operating System architecture:");
        keyList.add("System MAX Memory:");
        infoHash.put("Java Runtime Environment version:", System.getProperty("java.version"));
        infoHash.put("Java Runtime Environment vendor:", System.getProperty("java.vendor"));
        infoHash.put("Java Virtual Machine name:", System.getProperty("java.vm.name"));
        infoHash.put("Java Virtual Machine version:", System.getProperty("java.vm.version"));
        infoHash.put("Java Virtual Machine vendor:", System.getProperty("java.vm.vendor"));
        infoHash.put("Operating System name:", System.getProperty("os.name"));
        infoHash.put("Operating System version:", System.getProperty("os.version"));
        infoHash.put("Operating System architecture:", System.getProperty("os.arch"));
        infoHash.put("System MAX Memory:", Long.toString(Runtime.getRuntime().maxMemory()));
        infoHash.put("keyList", keyList);
        new FreeItem(infoHash).mountTo(system);
        return chapter1;
    }

    private Chapter partII() {
        System.out.println("    ---- Reporting analysis design and parameter settings ...");
        Chapter chapter2 = new Chapter(new Paragraph("Part II: Analysis Design and Parameter Settings", this.font14BI), 2);
        chapter2.setNumberDepth(0);
        Paragraph designInfo = new Paragraph("Analysis Design and Parameter Settings", this.font12BI);
        Anchor inputFileAnchor = new Anchor("Click to see Appendix A\n", this.fontC10I_blue);
        inputFileAnchor.setReference("#Input File List");
        Section design = chapter2.addSection(designInfo);
        int i = 0;
        while (i < this.flowCodeList.size()) {
            Hashtable<String, Object> paramHash = new Hashtable<String, Object>(10);
            switch (Integer.parseInt(this.flowCodeList.get(i).toString())) {
                case 0: {
                    ArrayList<String> keyList = new ArrayList<String>(6);
                    keyList.add("Input file name");
                    keyList.add("One Bad Channel Tolerance Policy");
                    keyList.add("Use channel A flag");
                    keyList.add("Use channel B flag");
                    keyList.add("Channel A background checking");
                    keyList.add("Channel B background checking");
                    keyList.add("Signal/Noise threshold");
                    paramHash.put("Input file name", inputFileAnchor);
                    paramHash.put("One Bad Channel Tolerance Policy", Parameter.pOneBadChannelPolicyStr);
                    paramHash.put("Use channel A flag", Parameter.pUseCh1FlagOpt ? "Yes" : "No");
                    paramHash.put("Use channel B flag", Parameter.pUseCh2FlagOpt ? "Yes" : "No");
                    paramHash.put("Channel A background checking", Parameter.pCh1BkgdOpt ? "Yes" : "No");
                    paramHash.put("Channel B background checking", Parameter.pCh2BkgdOpt ? "Yes" : "No");
                    paramHash.put("Signal/Noise threshold", new Float(Parameter.pBkgdSNRatioVal));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 1: {
                    ArrayList<String> keyList = new ArrayList(6);
                    keyList.add("Input file pair(s)");
                    keyList.add("One Bad Channel Tolerance Policy");
                    keyList.add("Use channel A flag");
                    keyList.add("Use channel B flag");
                    keyList.add("Channel A background checking");
                    keyList.add("Channel B background checking");
                    keyList.add("Signal/Noise threshold");
                    paramHash.put("Input file pair(s)", inputFileAnchor);
                    paramHash.put("One Bad Channel Tolerance Policy", Parameter.pOneBadChannelPolicyStr);
                    paramHash.put("Use channel A flag", Parameter.pUseCh1FlagOpt ? "Yes" : "No");
                    paramHash.put("Use channel B flag", Parameter.pUseCh2FlagOpt ? "Yes" : "No");
                    paramHash.put("Channel A background checking", Parameter.pCh1BkgdOpt ? "Yes" : "No");
                    paramHash.put("Channel B background checking", Parameter.pCh2BkgdOpt ? "Yes" : "No");
                    paramHash.put("Signal/Noise threshold", new Float(Parameter.pBkgdSNRatioVal));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 2: {
                    ArrayList<String> keyList = new ArrayList(6);
                    keyList.add("Input file names");
                    keyList.add("One Bad Channel Tolerance Policy");
                    keyList.add("Use channel A flag");
                    keyList.add("Use channel B flag");
                    keyList.add("Channel A background checking");
                    keyList.add("Channel B background checking");
                    keyList.add("Signal/Noise threshold");
                    paramHash.put("Input file names", inputFileAnchor);
                    paramHash.put("One Bad Channel Tolerance Policy", Parameter.pOneBadChannelPolicyStr);
                    paramHash.put("Use channel A flag", Parameter.pUseCh1FlagOpt ? "Yes" : "No");
                    paramHash.put("Use channel B flag", Parameter.pUseCh2FlagOpt ? "Yes" : "No");
                    paramHash.put("Channel A background checking", Parameter.pCh1BkgdOpt ? "Yes" : "No");
                    paramHash.put("Channel B background checking", Parameter.pCh2BkgdOpt ? "Yes" : "No");
                    paramHash.put("Signal/Noise threshold", new Float(Parameter.pBkgdSNRatioVal));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 12: {
                    ArrayList<String> keyList = new ArrayList(1);
                    keyList.add("Reference");
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 11: {
                    ArrayList<String> keyList = new ArrayList(3);
                    keyList.add("Mode");
                    keyList.add("Smooth parameter");
                    keyList.add("Reference");
                    paramHash.put("Mode", Parameter.pLocfitModeStr);
                    paramHash.put("Smooth parameter", new Float(Parameter.pSmoothParaVal));
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 15: {
                    ArrayList<String> keyList = new ArrayList(3);
                    keyList.add("Mode");
                    keyList.add("Outlier range");
                    keyList.add("Reference");
                    paramHash.put("Mode", Parameter.pIterLinRegModeStr);
                    paramHash.put("Outlier range", new Float(Parameter.pIterLinRegSDRangeVal));
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 14: {
                    ArrayList<String> keyList = new ArrayList(2);
                    keyList.add("Data range for mean centering");
                    keyList.add("Reference");
                    paramHash.put("Data range for mean centering", new Float(Parameter.pIterLogMeanSDRangeVal));
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 16: {
                    ArrayList<String> keyList = new ArrayList(2);
                    keyList.add("Confidence interval");
                    keyList.add("Reference");
                    paramHash.put("Confidence interval", Parameter.pRatioStatsCIChkOpt ? new Integer(Parameter.pRatioStatsCIVal).toString() + "%" : "N/A");
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 13: {
                    ArrayList<String> keyList = new ArrayList(3);
                    keyList.add("Block mode");
                    keyList.add("Slide mode");
                    keyList.add("Reference");
                    paramHash.put("Block mode", Parameter.pBlockSDRegOpt ? "Yes" : "No");
                    paramHash.put("Slide mode", Parameter.pSlideSDRegOpt ? "Yes" : "No");
                    paramHash.put("Reference", Parameter.pRefStr);
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 10: {
                    ArrayList<String> keyList = new ArrayList(2);
                    keyList.add("Cy3 intensity threshold");
                    keyList.add("Cy5 intensity threshold");
                    paramHash.put("Cy3 intensity threshold", new Long(Parameter.pCy3CutoffVal));
                    paramHash.put("Cy5 intensity threshold", new Long(Parameter.pCy5CutoffVal));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 20: {
                    ArrayList<String> keyList = new ArrayList(3);
                    keyList.add("Slice data population");
                    keyList.add("Data keep range lower limit");
                    keyList.add("Data keep range upper limit");
                    paramHash.put("Slice data population", new Integer(Parameter.pSliceDataPopVal));
                    paramHash.put("Data keep range lower limit", new Float(Parameter.pSliceDataRangeGtVal));
                    paramHash.put("Data keep range upper limit", new Float(Parameter.pSliceDataRangeLtVal));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 30: {
                    ArrayList<String> keyList = new ArrayList(1);
                    keyList.add("Identifier column");
                    paramHash.put("Identifier column", Parameter.pIdentifierCol.toString());
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 32: {
                    ArrayList<String> keyList = new ArrayList(4);
                    keyList.add("Hypothetical non-significant log-ratio");
                    keyList.add("Compute p-value based on");
                    keyList.add("Critical p-value (alpha)");
                    keyList.add("Significant gene selection method");
                    paramHash.put("Hypothetical non-significant log-ratio", new Float(Parameter.pTtestHypoMean));
                    paramHash.put("Compute p-value based on", Parameter.pTtestPValBase > 0 ? new Integer(Parameter.pTtestPValBase).toString() + " permutations" : CodeBook.lookup(Parameter.pTtestPValBase));
                    paramHash.put("Critical p-value (alpha)", new Float(Parameter.pTtestAlpha));
                    paramHash.put("Significant gene selection method", CodeBook.lookup(Parameter.pTtestSigMethod));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 33: {
                    ArrayList<String> keyList = new ArrayList(4);
                    keyList.add("Hypothetical non-significant log-ratio");
                    keyList.add("Number of Permutations");
                    keyList.add("S0 Calculation Method");
                    keyList.add("Missing Data Imputation Method");
                    paramHash.put("Hypothetical non-significant log-ratio", new Float(Parameter.pSAMHypoMean));
                    paramHash.put("Number of Permutations", new Integer(Parameter.pSAMPermutationsNumber).toString() + (Parameter.pSAMAllUniquePerm ? " unique" : "random"));
                    paramHash.put("S0 Calculation Method", CodeBook.lookup(Parameter.pSAMS0Method));
                    paramHash.put("Missing Data Imputation Method", (Parameter.pSAMImputationEngine == 3306 ? new Integer(Parameter.pSAMNearestNeighborsNumber).toString() : "") + CodeBook.lookup(Parameter.pSAMImputationEngine));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 40: {
                    ArrayList<String> keyList = new ArrayList(2);
                    keyList.add("Data trim option");
                    keyList.add("Cross log-ratio data keep range");
                    paramHash.put("Data trim option", Parameter.pFlipdyeCutOptionStr);
                    paramHash.put("Cross log-ratio data keep range", Parameter.pFlipdyeDataKeepRangeVal + (Parameter.pFlipdyeCutOptionStr.equalsIgnoreCase("SD cut") ? " SD" : ""));
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 41: {
                    String[][] s = new String[MaAnovaParameter.elistSize][2];
                    int ii = 0;
                    while (ii < MaAnovaParameter.elistSize) {
                        s[ii][0] = MaAnovaParameter.GetExpStringArray()[ii];
                        s[ii][1] = MaAnovaParameter.GetFile(ii);
                        ++ii;
                    }
                    ArrayList<String> keyList = new ArrayList(4);
                    keyList.add("Design");
                    keyList.add("Variety Gene Effects");
                    keyList.add("Dye Gene Effects");
                    keyList.add("Array Gene Effects");
                    paramHash.put("Design", s);
                    paramHash.put("Variety Gene Effects", MaAnovaParameter.anova_model[0] == 0 ? "No" : "Yes");
                    paramHash.put("Dye Gene Effects", MaAnovaParameter.anova_model[1] == 0 ? "No" : "Yes");
                    paramHash.put("Array Gene Effects", MaAnovaParameter.anova_model[2] == 0 ? "No" : "Yes");
                    paramHash.put("keyList", keyList);
                    break;
                }
                case 100: {
                    ArrayList<String> keyList;
                    if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 2) {
                        keyList = new ArrayList(4);
                        keyList.add("Virtual trim Option");
                        keyList.add("Output trimmed data option");
                        keyList.add("Cross file trim option");
                        keyList.add("Cross file trim percentage");
                        paramHash.put("Virtual trim Option", Parameter.pVtrimOpt ? "Yes" : "No");
                        paramHash.put("Output trimmed data option", Parameter.pOutputTrimmedDataOpt ? "Yes" : "No");
                        paramHash.put("Cross file trim option", Parameter.pUseCrossFileTrimOpt ? "Yes" : "No");
                        paramHash.put("Cross file trim percentage", Float.toString(MathTools.roundUpToPlace(new Float(Parameter.pCrossFilePct).floatValue() * 100.0f, 2)) + "%");
                        paramHash.put("keyList", keyList);
                        break;
                    }
                    keyList = new ArrayList(2);
                    keyList.add("Virtual trim Option");
                    keyList.add("Output trimmed data option");
                    paramHash.put("Virtual trim Option", Parameter.pVtrimOpt ? "Yes" : "No");
                    paramHash.put("Output trimmed data option", Parameter.pOutputTrimmedDataOpt ? "Yes" : "No");
                    paramHash.put("keyList", keyList);
                }
            }
            design.add((Object)new Phrase("\n   " + CodeBook.lookup(Integer.parseInt(this.flowCodeList.get(i).toString())), this.font12I_black));
            new FreeItem(paramHash).mountTo(design);
            ++i;
        }
        return chapter2;
    }

    private Chapter partIII() {
        try {
            Chapter chapter3 = new Chapter(new Paragraph("Part III: Analysis Results", this.font14BI), 2);
            chapter3.setNumberDepth(0);
            chapter3.setBookmarkOpen(true);
            Section resultsSec = chapter3.addSection("Results");
            boolean postPairMerge = false;
            System.out.println("    ---- Reporting process results ...");
            Hashtable resultHash = this.proj.getReportItemHash();
            int i = 0;
            while (i < this.flowCodeList.size()) {
                ArrayList graphCodeList = (ArrayList)this.pc.get(this.flowCodeList.get(i).toString());
                switch (Integer.parseInt(this.flowCodeList.get(i).toString())) {
                    case 0: {
                        System.out.println("         Reporting raw data ...");
                        Hashtable hash = (Hashtable)resultHash.get("raw_for_" + this.getFileName(Parameter.pSingleFileStr));
                        TableItem tableItem = new TableItem(this.writer, hash, graphCodeList);
                        tableItem.mountTo(resultsSec);
                        break;
                    }
                    case 1: {
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting raw data ...");
                        int pairNdx = 0;
                        while (pairNdx < Parameter.pFilePairVec.size()) {
                            Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                            String fileName1 = eachPairVec.elementAt(0).toString();
                            String fileName2 = eachPairVec.elementAt(1).toString();
                            hash = (Hashtable)resultHash.get("raw_for_" + this.getFileName(fileName1));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            hash = (Hashtable)resultHash.get("raw_for_" + this.getFileName(fileName2));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++pairNdx;
                        }
                        break;
                    }
                    case 2: {
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting raw data ...");
                        int fileNdx = 0;
                        while (fileNdx < Parameter.pFolderFilesVec.size()) {
                            String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                            hash = (Hashtable)resultHash.get("raw_for_" + this.getFileName(fileName));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++fileNdx;
                        }
                        break;
                    }
                    case 12: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting total intensity normalization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("totint_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("totint_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("totint_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("totint_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("totint_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 11: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting lowess normalization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("lowess_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("lowess_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("lowess_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("lowess_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("lowess_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 15: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting iterative linear regression normalization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("iterLinReg_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("iterLinReg_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("iterLinReg_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("iterLinReg_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("iterLinReg_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 14: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting iterative log mean centering normalization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("iterLogMean_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("iterLogMean_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("iterLogMean_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("iterLogMean_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("iterLogMean_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 13: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting standard deviation regularization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("sdreg_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("sdreg_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("sdreg_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("sdreg_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("sdreg_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 16: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting ratio statistics normalization results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("ratiostats_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("ratiostats_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("ratiostats_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("ratiostats_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("ratiostats_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 10: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting low intensity filtering results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("lowFilter_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("lowFilter_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("lowFilter_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("lowFilter_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("lowFilter_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 20: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting slice analysis results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("slice_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("slice_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("slice_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("slice_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("slice_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 30: {
                        String fileName;
                        String fileName2;
                        String fileName1;
                        Vector eachPairVec;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting in-slide replicates analysis results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("inSliceRep_for_" + this.getFileName(Parameter.pSingleFileStr));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                                fileName1 = eachPairVec.elementAt(0).toString();
                                fileName2 = eachPairVec.elementAt(1).toString();
                                if (!postPairMerge) {
                                    hash = (Hashtable)resultHash.get("inSliceRep_for_" + this.getFileName(fileName1));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                    hash = (Hashtable)resultHash.get("inSliceRep_for_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                } else {
                                    hash = (Hashtable)resultHash.get("inSliceRep_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                                    tableItem = new TableItem(this.writer, hash, graphCodeList);
                                    tableItem.mountTo(resultsSec);
                                }
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("inSliceRep_for_" + this.getFileName(fileName));
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                    case 32: {
                        String fileName;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting cross-slide replicates t-test results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                        int fileNdx = 0;
                        while (fileNdx < Parameter.pFolderFilesVec.size()) {
                            fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                            hash = (Hashtable)resultHash.get("ttest_for_" + this.getFileName(fileName));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++fileNdx;
                        }
                        break;
                    }
                    case 33: {
                        String fileName;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting cross-slide one-class SAM results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2 || Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                        int fileNdx = 0;
                        while (fileNdx < Parameter.pFolderFilesVec.size()) {
                            fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                            hash = (Hashtable)resultHash.get("sam_for_" + this.getFileName(fileName));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++fileNdx;
                        }
                        break;
                    }
                    case 40: {
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting flip-dye consistency checking results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 1) break;
                        int pairNdx = 0;
                        while (pairNdx < Parameter.pFilePairVec.size()) {
                            hash = (Hashtable)resultHash.get("flip_dye_for_pair" + pairNdx);
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++pairNdx;
                        }
                        postPairMerge = true;
                        break;
                    }
                    case 41: {
                        String fileName;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting maanova results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                        int fileNdx = 0;
                        while (fileNdx < MaAnovaParameter.elistSize) {
                            fileName = MaAnovaParameter.GetFile(fileNdx);
                            hash = (Hashtable)resultHash.get("maanova_for_" + this.getFileName(fileName));
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            ++fileNdx;
                        }
                        break;
                    }
                    case 100: {
                        String fileName;
                        TableItem tableItem;
                        Hashtable hash;
                        System.out.println("         Reporting final results ...");
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                            hash = (Hashtable)resultHash.get("write");
                            tableItem = new TableItem(this.writer, hash, graphCodeList);
                            tableItem.mountTo(resultsSec);
                            break;
                        }
                        if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                            int pairNdx = 0;
                            while (pairNdx < Parameter.pFilePairVec.size()) {
                                hash = (Hashtable)resultHash.get("write_for_pair_" + pairNdx);
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++pairNdx;
                            }
                        } else {
                            if (Integer.parseInt(this.flowCodeList.get(0).toString()) != 2) break;
                            int fileNdx = 0;
                            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                hash = (Hashtable)resultHash.get("write_for_file_" + fileNdx);
                                tableItem = new TableItem(this.writer, hash, graphCodeList);
                                tableItem.mountTo(resultsSec);
                                ++fileNdx;
                            }
                        }
                        break;
                    }
                }
                ++i;
            }
            return chapter3;
        }
        catch (Exception de) {
            de.printStackTrace();
            System.err.println(de.getMessage());
            return null;
        }
    }

    private Chapter partIV() {
        Chapter chapter4 = new Chapter(new Paragraph("Part IV: Appendix A", this.font14BI), 3);
        chapter4.setNumberDepth(0);
        try {
            if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 0) {
                Paragraph names = new Paragraph("", this.fontC12);
                Anchor appendixAnchor = new Anchor("Input file name: \r", this.fontC12);
                appendixAnchor.setName("Input File List");
                names.add((Object)appendixAnchor);
                Section inputs = chapter4.addSection(names);
                inputs.add((Object)new Paragraph(Parameter.pSingleFileStr, this.fontC12));
            } else if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 1) {
                Paragraph names = new Paragraph("", this.fontC12);
                Table table = new Table(3);
                int[] headerwidths = new int[]{12, 44, 44};
                table.setWidths(headerwidths);
                table.setWidth(92.0f);
                table.setSpacing(2.0f);
                table.setOffset(0.0f);
                Cell cell = new Cell();
                cell.setBorder(10);
                cell.add((Object)new Phrase(11.0f, new Chunk("Pair #", this.fontC12)));
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
                cell = new Cell();
                cell.setBorder(10);
                cell.add((Object)new Phrase(11.0f, new Chunk("File 1", this.fontC12)));
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
                cell = new Cell();
                cell.setBorder(2);
                cell.add((Object)new Phrase(11.0f, new Chunk("File 2", this.fontC12)));
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
                int pairIndex = 0;
                while (pairIndex < Parameter.pFilePairVec.size()) {
                    Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairIndex);
                    cell = new Cell();
                    cell.setBorder(10);
                    cell.add((Object)new Phrase(11.0f, new Chunk(Integer.toString(pairIndex + 1), this.fontC12)));
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    cell = new Cell();
                    cell.setBorder(10);
                    cell.add((Object)new Phrase(11.0f, new Chunk(eachPairVec.elementAt(0).toString(), this.fontC12)));
                    cell.setHorizontalAlignment(0);
                    table.addCell(cell);
                    cell = new Cell();
                    cell.setBorder(2);
                    cell.add((Object)new Phrase(11.0f, new Chunk(eachPairVec.elementAt(1).toString(), this.fontC12)));
                    cell.setHorizontalAlignment(0);
                    table.addCell(cell);
                    ++pairIndex;
                }
                Anchor appendixAnchor = new Anchor("Input file pair(s) table: ", this.fontC12);
                appendixAnchor.setName("Input File List");
                names.add((Object)appendixAnchor);
                Section inputs = chapter4.addSection(names);
                inputs.add((Object)table);
            } else if (Integer.parseInt(this.flowCodeList.get(0).toString()) == 2) {
                Paragraph names = new Paragraph("", this.fontC12);
                String fileList = new String();
                int i = 0;
                while (i < Parameter.pFolderFilesVec.size()) {
                    String fileName = Parameter.pFolderFilesVec.elementAt(i).toString();
                    fileList = fileList + fileName + "\r";
                    ++i;
                }
                Table table = new Table(1);
                table.setWidth(94.0f);
                table.setSpacing(2.0f);
                table.setCellpadding(2.0f);
                table.setOffset(0.0f);
                Cell cell = new Cell();
                cell.setBorder(0);
                cell.add((Object)new Phrase(11.0f, new Chunk(fileList, this.fontC12)));
                table.addCell(cell);
                Anchor appendixAnchor = new Anchor("Input file(s) table: ", this.font12BI);
                appendixAnchor.setName("Input File List");
                names.add((Object)appendixAnchor);
                Section inputs = chapter4.addSection(names);
                inputs.add((Object)table);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return chapter4;
    }

    private String getFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.lastIndexOf(46));
    }

    public static void main(String[] args) {
        PreparePDFReport p = new PreparePDFReport(new Project());
        System.out.println("Done!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

