/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.tigr.midas.exception.ReportException;

public class TxtReport {
    private PrintStream out;

    public TxtReport(String rptFileName) throws Exception {
        try {
            System.out.println("Preparing TXT report ...");
            this.out = new PrintStream(new FileOutputStream(new File(rptFileName)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ReportException("Report Error.");
        }
    }

    public final Date appendCurrentTime(String prefix) {
        Date now = new Date(System.currentTimeMillis());
        this.out.println();
        this.out.println("* " + prefix + now.toString());
        return now;
    }

    public final void appendStartTime(Date start) {
        this.out.println("* Process started at: " + start.toString());
    }

    public final void appendStopTime(Date stop) {
        this.out.println("* Process started at: " + stop.toString());
    }

    public final void appendCaption(String caption) {
        this.out.println("* " + caption);
    }

    public final void appendLine(String text) {
        this.out.println(text);
    }

    public final void appendLineIndentOne(String text) {
        this.out.println("    " + text);
    }

    public final void appendLineIndentTwo(String text) {
        this.out.println("        " + text);
    }

    public final void appendLineIndentThree(String text) {
        this.out.println("            " + text);
    }

    public final void appendLineIndentFour(String text) {
        this.out.println("               " + text);
    }

    public final void appendText(String text) {
        this.out.print(text);
    }

    public final void close() {
        this.out.close();
    }
}

