/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import org.tigr.midas.mev.data.FloatMatrix;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;

public class CW2FloatMatrix {
    public FloatMatrix getFloatMatrix(ColumnWorker[] cw) {
        float[][] r = new float[cw.length][cw[0].getRowCounts()];
        float[][] matrix = new float[cw[0].getRowCounts()][cw.length];
        int cwNdx = 0;
        while (cwNdx < cw.length) {
            r[cwNdx] = new CyToLogProdRatio(cw[cwNdx].getColumnOneArray(), cw[cwNdx].getColumnTwoArray()).getLogRatio();
            ++cwNdx;
        }
        int rowNdx = 0;
        while (rowNdx < cw[0].getRowCounts()) {
            int colNdx = 0;
            while (colNdx < cw.length) {
                matrix[rowNdx][colNdx] = r[colNdx][rowNdx];
                ++colNdx;
            }
            ++rowNdx;
        }
        return new FloatMatrix(matrix);
    }

    public static void main(String[] args) {
        String path = "C:\\DataFiles0\\mev files\\BryanData\\";
        String[] f = new String[]{"NFE005d0001.mev", "NFE005d0002.mev", "NFE005d0003.mev", "NFE005d0004.mev", "NFE005d0005.mev", "NFE005d0006.mev", "NFE005d0007.mev", "NFE005d0008.mev"};
        ColumnWorker[] folderCW = new ColumnWorker[3];
        try {
            int fileNdx = 0;
            while (fileNdx < 3) {
                folderCW[fileNdx] = new ColumnWorker(path + f[fileNdx]);
                folderCW[fileNdx].setColumnsForUID();
                folderCW[fileNdx].setColumnsForMeta(2, 3);
                folderCW[fileNdx].setColumns(6, 7);
                System.out.println("------ > Done with reading " + path + f[fileNdx]);
                ++fileNdx;
            }
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("------ > Converting to FloatMatrix ...");
        FloatMatrix A = new CW2FloatMatrix().getFloatMatrix(folderCW);
        int i = 0;
        while (i < A.m) {
            int j = 0;
            while (j < 3) {
                System.out.println(" i = " + i + ", j = " + j + ", a = " + A.get(i, j));
                ++j;
            }
            ++i;
        }
        System.out.println(" m = " + A.getRowDimension());
        System.out.println(" n = " + A.getColumnDimension());
        System.out.println("------ > Done!");
    }
}

