/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.ArrayResizer;

public class CyToLogProdRatio {
    private int goodDataNumber;
    private float[] logX;
    private float[] logY;
    private float[] logProd;
    private float[] logRatio;
    private int[] ndx;

    public CyToLogProdRatio(float[] x, float[] y, int[] z, boolean[] b) {
        this.logX = new float[x.length];
        this.logY = new float[y.length];
        this.logProd = new float[x.length];
        this.logRatio = new float[y.length];
        this.ndx = new int[z.length];
        int dataNumber = 0;
        while (dataNumber < x.length) {
            if (!Float.isInfinite(x[dataNumber]) && !Float.isInfinite(y[dataNumber]) && !Float.isNaN(x[dataNumber]) && !Float.isNaN(y[dataNumber]) && x[dataNumber] > 1.0f && y[dataNumber] > 1.0f && b[z[dataNumber]]) {
                this.logX[this.goodDataNumber] = MathTools.log10(x[dataNumber]);
                this.logY[this.goodDataNumber] = MathTools.log10(y[dataNumber]);
                this.logProd[this.goodDataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                this.logRatio[this.goodDataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
                this.ndx[this.goodDataNumber] = z[dataNumber];
                ++this.goodDataNumber;
            }
            ++dataNumber;
        }
        this.logX = new ArrayResizer(this.logX, this.goodDataNumber).getFArray();
        this.logY = new ArrayResizer(this.logY, this.goodDataNumber).getFArray();
        this.logProd = new ArrayResizer(this.logProd, this.goodDataNumber).getFArray();
        this.logRatio = new ArrayResizer(this.logRatio, this.goodDataNumber).getFArray();
        this.ndx = new ArrayResizer(this.ndx, this.goodDataNumber).getIArray();
    }

    public CyToLogProdRatio(float[] x, float[] y, boolean[] b) {
        this.logX = new float[x.length];
        this.logY = new float[y.length];
        this.logProd = new float[x.length];
        this.logRatio = new float[y.length];
        this.ndx = new int[x.length];
        int dataNumber = 0;
        while (dataNumber < x.length) {
            if (!Float.isInfinite(x[dataNumber]) && !Float.isInfinite(y[dataNumber]) && !Float.isNaN(x[dataNumber]) && !Float.isNaN(y[dataNumber]) && x[dataNumber] > 1.0f && y[dataNumber] > 1.0f && b[dataNumber]) {
                this.logX[this.goodDataNumber] = MathTools.log10(x[dataNumber]);
                this.logY[this.goodDataNumber] = MathTools.log10(y[dataNumber]);
                this.logProd[this.goodDataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                this.logRatio[this.goodDataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
                this.ndx[this.goodDataNumber] = dataNumber;
                ++this.goodDataNumber;
            }
            ++dataNumber;
        }
        this.logX = new ArrayResizer(this.logX, this.goodDataNumber).getFArray();
        this.logY = new ArrayResizer(this.logY, this.goodDataNumber).getFArray();
        this.logProd = new ArrayResizer(this.logProd, this.goodDataNumber).getFArray();
        this.logRatio = new ArrayResizer(this.logRatio, this.goodDataNumber).getFArray();
        this.ndx = new ArrayResizer(this.ndx, this.goodDataNumber).getIArray();
    }

    public CyToLogProdRatio(float[] x, float[] y) {
        this.logX = new float[x.length];
        this.logY = new float[y.length];
        this.logProd = new float[x.length];
        this.logRatio = new float[y.length];
        int dataNumber = 0;
        while (dataNumber < x.length) {
            if (Float.isInfinite(x[dataNumber]) || Float.isInfinite(y[dataNumber]) || Float.isNaN(x[dataNumber]) || Float.isNaN(y[dataNumber])) {
                this.logX[dataNumber] = Float.NaN;
                this.logY[dataNumber] = Float.NaN;
                this.logProd[dataNumber] = Float.NaN;
                this.logRatio[dataNumber] = Float.NaN;
            } else {
                this.logX[dataNumber] = MathTools.log10(x[dataNumber]);
                this.logY[dataNumber] = MathTools.log10(y[dataNumber]);
                this.logProd[dataNumber] = MathTools.log10(x[dataNumber] * y[dataNumber]);
                this.logRatio[dataNumber] = MathTools.log2(y[dataNumber] / x[dataNumber]);
            }
            ++dataNumber;
        }
    }

    public final float[] getLogX() {
        return this.logX;
    }

    public final float[] getLogY() {
        return this.logY;
    }

    public final float[] getLogProd() {
        return this.logProd;
    }

    public final float[] getLogRatio() {
        return this.logRatio;
    }

    public final int[] getNdx() {
        return this.ndx;
    }

    public final int getGoodDataNumber() {
        return this.goodDataNumber;
    }
}

