/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util.swing;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Thread thread;
    public boolean isStopped = false;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                    Object var2_1 = null;
                    SwingWorker.this.threadVar.clear();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SwingWorker.this.threadVar.clear();
                    throw throwable;
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    public SwingWorker(int p) {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                    Object var2_1 = null;
                    SwingWorker.this.threadVar.clear();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SwingWorker.this.threadVar.clear();
                    throw throwable;
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        t.setPriority(p);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
            this.isStopped = false;
        }
    }

    public void stop() {
        Thread t = this.threadVar.get();
        t = null;
        this.isStopped = true;
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

