/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ScpClient {
    private SshClient ssh;
    private File cwd;
    private boolean verbose;
    private ChannelEventListener eventListener;

    public ScpClient(SshClient sshClient, boolean bl, ChannelEventListener channelEventListener) {
        this(new File(ConfigurationLoader.checkAndGetProperty("user.dir", ".")), sshClient, bl, channelEventListener);
    }

    public ScpClient(File file, SshClient sshClient, boolean bl, ChannelEventListener channelEventListener) {
        this.ssh = sshClient;
        this.cwd = file;
        this.verbose = bl;
        this.eventListener = channelEventListener;
    }

    public void put(InputStream inputStream, long l, String string, String string2) throws IOException {
        ScpChannel scpChannel = new ScpChannel("scp -t " + (this.verbose ? "-v " : "") + string2);
        scpChannel.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scpChannel)) {
            throw new IOException("Failed to open SCP channel");
        }
        scpChannel.waitForResponse();
        scpChannel.writeStreamToRemote(inputStream, l, string);
        scpChannel.close();
    }

    public InputStream get(String string) throws IOException {
        ScpChannel scpChannel = new ScpChannel("scp -f " + (this.verbose ? "-v " : "") + string);
        scpChannel.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scpChannel)) {
            throw new IOException("Failed to open SCP Channel");
        }
        return scpChannel.readStreamFromRemote();
    }

    public void put(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (!file.exists()) {
            throw new IOException(string + " does not exist");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(string + " is not a regular file or directory");
        }
        if (file.isDirectory() && !bl) {
            throw new IOException(string + " is a directory, use recursive mode");
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        ScpChannel scpChannel = new ScpChannel("scp " + (file.isDirectory() ? "-d " : "") + "-t " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string2);
        scpChannel.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scpChannel)) {
            throw new IOException("Failed to open SCP channel");
        }
        scpChannel.waitForResponse();
        scpChannel.writeFileToRemote(file, bl);
        scpChannel.close();
    }

    public void put(String[] stringArray, String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (stringArray.length == 1) {
            this.put(stringArray[0], string, bl);
        } else {
            ScpChannel scpChannel = new ScpChannel("scp -d -t " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string);
            scpChannel.addEventListener(this.eventListener);
            if (!this.ssh.openChannel(scpChannel)) {
                throw new IOException("Failed to open SCP channel");
            }
            scpChannel.waitForResponse();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.isAbsolute()) {
                    file = new File(this.cwd, stringArray[i]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    throw new IOException(file.getName() + " is not a regular file or directory");
                }
                scpChannel.writeFileToRemote(file, bl);
            }
            scpChannel.close();
        }
    }

    public void get(String string, String[] stringArray, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\" ");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        this.get(string, string2, bl);
    }

    public void get(String string, String string2, boolean bl) throws IOException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException(string + " is not a regular file or directory");
        }
        ScpChannel scpChannel = new ScpChannel("scp -f " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string2);
        scpChannel.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scpChannel)) {
            throw new IOException("Failed to open SCP Channel");
        }
        scpChannel.readFromRemote(file);
        scpChannel.close();
    }

    class ScpInputStream
    extends InputStream {
        long length;
        InputStream in;
        long count;
        ScpChannel channel;

        ScpInputStream(long l, InputStream inputStream, ScpChannel scpChannel) {
            this.length = l;
            this.in = inputStream;
            this.channel = scpChannel;
        }

        public int read() throws IOException {
            if (this.count == this.length) {
                return -1;
            }
            if (this.count >= this.length) {
                throw new EOFException("End of file.");
            }
            int n = this.in.read();
            if (n == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.count;
            if (this.count == this.length) {
                this.channel.waitForResponse();
                this.channel.writeOk();
            }
            return n;
        }

        public void close() throws IOException {
            this.channel.close();
        }
    }

    class ScpChannel
    extends SessionChannelClient {
        byte[] buffer = new byte[16384];
        String cmd;

        ScpChannel(String string) {
            this.cmd = string;
            this.setName("scp");
        }

        protected void onChannelOpen() throws IOException {
            if (!this.executeCommand(this.cmd)) {
                throw new IOException("Failed to execute the command " + this.cmd);
            }
        }

        private boolean writeDirToRemote(File file, boolean bl) throws IOException {
            if (!bl) {
                this.writeError("File " + file.getName() + " is a directory, use recursive mode");
                return false;
            }
            String string = "D0755 0 " + file.getName() + "\n";
            this.out.write(string.getBytes());
            this.waitForResponse();
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                this.writeFileToRemote(file2, bl);
            }
            this.out.write("E\n".getBytes());
            return true;
        }

        private void writeStreamToRemote(InputStream inputStream, long l, String string) throws IOException {
            String string2 = "C0644 " + l + " " + string + "\n";
            this.out.write(string2.getBytes());
            this.waitForResponse();
            this.writeCompleteFile(inputStream, l);
            this.writeOk();
            this.waitForResponse();
        }

        private void writeFileToRemote(File file, boolean bl) throws IOException {
            if (file.isDirectory()) {
                if (!this.writeDirToRemote(file, bl)) {
                    return;
                }
            } else if (file.isFile()) {
                String string = "C0644 " + file.length() + " " + file.getName() + "\n";
                this.out.write(string.getBytes());
                this.waitForResponse();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.writeCompleteFile(fileInputStream, file.length());
                this.writeOk();
            } else {
                throw new IOException(file.getName() + " not valid for SCP");
            }
            this.waitForResponse();
        }

        private void readFromRemote(File file) throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.writeOk();
            block7: while (true) {
                try {
                    string = this.readString();
                }
                catch (EOFException eOFException) {
                    return;
                }
                char c = string.charAt(0);
                switch (c) {
                    case 'E': {
                        this.writeOk();
                        return;
                    }
                    case 'T': {
                        throw new IOException("SCP time not supported: " + string);
                    }
                    case 'C': 
                    case 'D': {
                        Object object;
                        String string2 = file.getAbsolutePath();
                        this.parseCommand(string, stringArray);
                        if (file.isDirectory()) {
                            string2 = string2 + File.separator + stringArray[2];
                        }
                        File file2 = new File(string2);
                        if (c == 'D') {
                            if (file2.exists()) {
                                if (!file2.isDirectory()) {
                                    object = "Invalid target " + file2.getName() + ", must be a directory";
                                    this.writeError((String)object);
                                    throw new IOException((String)object);
                                }
                            } else if (!file2.mkdir()) {
                                object = "Could not create directory: " + file2.getName();
                                this.writeError((String)object);
                                throw new IOException((String)object);
                            }
                            this.readFromRemote(file2);
                            continue block7;
                        }
                        object = new FileOutputStream(file2);
                        this.writeOk();
                        long l = Long.parseLong(stringArray[1]);
                        this.readCompleteFile((FileOutputStream)object, l);
                        this.waitForResponse();
                        this.writeOk();
                        continue block7;
                    }
                }
                break;
            }
            this.writeError("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private InputStream readStreamFromRemote() throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.writeOk();
            try {
                string = this.readString();
            }
            catch (EOFException eOFException) {
                return null;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'E': {
                    this.writeOk();
                    return null;
                }
                case 'T': {
                    throw new IOException("SCP time not supported: " + string);
                }
                case 'D': {
                    throw new IOException("Directories cannot be copied to a stream");
                }
                case 'C': {
                    this.parseCommand(string, stringArray);
                    this.writeOk();
                    long l = Long.parseLong(stringArray[1]);
                    return new BufferedInputStream(new ScpInputStream(l, this.in, this), 16384);
                }
            }
            this.writeError("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private void parseCommand(String string, String[] stringArray) throws IOException {
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            if (n == -1 || n2 == -1) {
                this.writeError("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n);
            stringArray[1] = string.substring(n + 1, n2);
            stringArray[2] = string.substring(n2 + 1);
        }

        private String readString() throws IOException {
            int n;
            int n2 = 0;
            while ((n = this.in.read()) != 10 && n >= 0) {
                this.buffer[n2++] = (byte)n;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            if (this.buffer[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.buffer[0] == 2 || this.buffer[0] == 1) {
                String string = new String(this.buffer, 1, n2 - 1);
                if (this.buffer[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: " + string);
            }
            return new String(this.buffer, 0, n2);
        }

        private void waitForResponse() throws IOException {
            int n = this.in.read();
            if (n == 0) {
                return;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.readString();
            if (n == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }

        private void writeOk() throws IOException {
            this.out.write(0);
        }

        private void writeError(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCompleteFile(InputStream inputStream, long l) throws IOException {
            int n = 0;
            try {
                while ((long)n < l) {
                    int n2 = inputStream.read(this.buffer, 0, (int)(l - (long)n < (long)this.buffer.length ? l - (long)n : (long)this.buffer.length));
                    if (n2 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n += n2;
                    this.out.write(this.buffer, 0, n2);
                }
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readCompleteFile(FileOutputStream fileOutputStream, long l) throws IOException {
            int n = 0;
            try {
                while ((long)n < l) {
                    int n2 = this.in.read(this.buffer, 0, (int)(l - (long)n < (long)this.buffer.length ? l - (long)n : (long)this.buffer.length));
                    if (n2 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n += n2;
                    fileOutputStream.write(this.buffer, 0, n2);
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

