/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.sp;

import drasys.or.CompareNumberReverse;
import drasys.or.InvalidPriorityException;
import drasys.or.PairI;
import drasys.or.cont.PriorityQueue;
import drasys.or.cont.PriorityQueueI;
import drasys.or.graph.EdgeI;
import drasys.or.graph.EdgeValueI;
import drasys.or.graph.ElementI;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.InvalidGraphError;
import drasys.or.graph.InvalidPropertyException;
import drasys.or.graph.PropertiesAdapter;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.sp.SingleVertexI;
import drasys.or.graph.sp.SingleVertexListenerI;
import java.util.Enumeration;
import java.util.Vector;

public class Connections
implements SingleVertexI {
    private GraphI _graph;
    private PriorityQueueI _queue;
    private SingleVertexListenerI _listener;
    private PropertiesI _properties = new PropertiesAdapter();
    private int _label;
    private int _numVert;
    private int _numEdge;
    private int _pathCnt;
    private int _graphChangeCount;
    private Edge[] _edges;
    private Edge[] _reversedEdges;
    private Vertex _candHead;
    private Vertex _candTail;
    private Vertex[] _vertices;
    private int _maxLen;
    private int _maxPaths;
    private double _maxCost;
    private double _maxTime;
    private double _maxDist;
    private boolean _reverseEdges;
    private boolean _allEdgesAreDirected;

    public Connections(GraphI graphI) {
        this._init();
        this._setGraph(graphI);
        this._queue = new PriorityQueue(new CompareNumberReverse());
    }

    public Connections(GraphI graphI, PriorityQueueI priorityQueueI) {
        this._init();
        this._setGraph(graphI);
        this._queue = priorityQueueI;
        this._queue.setCompare(new CompareNumberReverse());
    }

    private int _generatePaths(Object object) throws VertexNotFoundException, InvalidPropertyException {
        EdgeValueI edgeValueI;
        Object object2;
        Object object3;
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("Can't find the origin vertex.");
        }
        if (this._listener != null) {
            this._listener.beginPathTree(vertexI, this._reverseEdges);
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        this._label += 2;
        this._candHead = null;
        this._queue.removeAllElements();
        vertex._prevEdge = null;
        vertex.setPerm(this._label);
        if (!this._reverseEdges || !this._allEdgesAreDirected) {
            object3 = vertex._vertex.outEdges();
            while (object3.hasMoreElements()) {
                object2 = (EdgeI)object3.nextElement();
                if (this._reverseEdges && object2.isDirected()) continue;
                edgeValueI = this._edges[object2.getIndex()];
                ((Edge)edgeValueI)._len = 1;
                ((Edge)edgeValueI)._prevEdge = null;
                ((Edge)edgeValueI).setIsInQueue(this._label);
                ((Edge)edgeValueI)._cost = this._properties.getEdgeCost((EdgeI)object2, this._reverseEdges);
                ((Edge)edgeValueI)._time = this._properties.getEdgeTime((EdgeI)object2, this._reverseEdges);
                ((Edge)edgeValueI)._dist = this._properties.getEdgeDistance((EdgeI)object2, this._reverseEdges);
                ((Edge)edgeValueI)._queuePair = this._queue.insert(new Double(((Edge)edgeValueI)._cost), edgeValueI);
            }
        }
        if (this._reverseEdges || !this._allEdgesAreDirected) {
            object3 = vertex._vertex.inEdges();
            while (object3.hasMoreElements()) {
                object2 = (EdgeI)object3.nextElement();
                if (!this._reverseEdges && object2.isDirected()) continue;
                edgeValueI = this._reversedEdges[object2.getIndex()];
                ((Edge)edgeValueI)._len = 1;
                ((Edge)edgeValueI)._prevEdge = null;
                ((Edge)edgeValueI).setIsInQueue(this._label);
                ((Edge)edgeValueI)._cost = this._properties.getEdgeCost((EdgeI)object2, this._reverseEdges ^ true);
                ((Edge)edgeValueI)._time = this._properties.getEdgeTime((EdgeI)object2, this._reverseEdges ^ true);
                ((Edge)edgeValueI)._dist = this._properties.getEdgeDistance((EdgeI)object2, this._reverseEdges ^ true);
                ((Edge)edgeValueI)._queuePair = this._queue.insert(new Double(((Edge)edgeValueI)._cost), edgeValueI);
            }
        }
        this._pathCnt = 0;
        while (this._queue.size() > 0 && this._pathCnt < this._maxPaths) {
            Edge edge;
            object3 = (Edge)this._queue.popHead().getSecond();
            ((Edge)object3).setPerm(this._label);
            if (!((Edge)object3)._dest.isPerm(this._label)) {
                ((Edge)object3)._dest.setPerm(this._label);
                ((Edge)object3)._dest._prevEdge = object3;
                if (((Edge)object3)._dest._isCand && ((Edge)object3)._dest != vertex) {
                    ((Edge)object3)._dest._nextCand = null;
                    if (this._candHead == null) {
                        this._candHead = ((Edge)object3)._dest;
                        this._candTail = ((Edge)object3)._dest;
                    } else {
                        this._candTail._nextCand = ((Edge)object3)._dest;
                        this._candTail = ((Edge)object3)._dest;
                    }
                    ++this._pathCnt;
                }
            }
            if (this._properties.isVertexRestricted(((Edge)object3)._dest._vertex)) continue;
            if (!this._reverseEdges || !this._allEdgesAreDirected) {
                object2 = ((Edge)object3)._dest._vertex.outEdges();
                while (object2.hasMoreElements()) {
                    edgeValueI = (EdgeI)object2.nextElement();
                    if (this._reverseEdges && edgeValueI.isDirected() || (edge = this._edges[edgeValueI.getIndex()]).isPerm(this._label) || this._properties.isEdgeRestricted(edge._edge, this._reverseEdges) || !this._reverseEdges && this._properties.isConnectionRestricted(((Edge)object3)._edge, ((Edge)object3)._dest._vertex, (EdgeI)edgeValueI) || this._reverseEdges && this._properties.isConnectionRestricted((EdgeI)edgeValueI, ((Edge)object3)._dest._vertex, ((Edge)object3)._edge)) continue;
                    this._updateEdge((Edge)object3, edge, this._reverseEdges);
                }
            }
            if (!this._reverseEdges && this._allEdgesAreDirected) continue;
            object2 = ((Edge)object3)._dest._vertex.inEdges();
            while (object2.hasMoreElements()) {
                edgeValueI = (EdgeI)object2.nextElement();
                if (!this._reverseEdges && edgeValueI.isDirected() || (edge = this._reversedEdges[edgeValueI.getIndex()]).isPerm(this._label) || this._properties.isEdgeRestricted(edge._edge, this._reverseEdges ^ true) || !this._reverseEdges && this._properties.isConnectionRestricted(((Edge)object3)._edge, ((Edge)object3)._dest._vertex, (EdgeI)edgeValueI) || this._reverseEdges && this._properties.isConnectionRestricted((EdgeI)edgeValueI, ((Edge)object3)._dest._vertex, ((Edge)object3)._edge)) continue;
                this._updateEdge((Edge)object3, edge, this._reverseEdges ^ true);
            }
        }
        if (this._listener != null) {
            this._listener.endPathTree(this._pathCnt);
        }
        return this._pathCnt;
    }

    private void _init() {
        this._label = 2;
        this._candTail = null;
        this._candHead = null;
        this._pathCnt = 0;
        this._listener = null;
        this._properties = null;
        this._maxLen = Integer.MAX_VALUE;
        this._maxCost = Double.POSITIVE_INFINITY;
        this._maxTime = Double.POSITIVE_INFINITY;
        this._maxDist = Double.POSITIVE_INFINITY;
        this._maxPaths = Integer.MAX_VALUE;
    }

    private void _setGraph(GraphI graphI) {
        Vertex vertex;
        Object object;
        Object object2;
        Object object3;
        this._graph = graphI;
        this._graphChangeCount = graphI.getChangeCount();
        this._numVert = graphI.sizeOfVertices();
        this._vertices = new Vertex[this._numVert];
        Enumeration enumeration = graphI.vertices();
        while (enumeration.hasMoreElements()) {
            object3 = (VertexI)enumeration.nextElement();
            this._vertices[object3.getIndex()] = new Vertex((VertexI)object3);
        }
        this.setCandidate(false);
        this._numEdge = graphI.sizeOfEdges();
        this._edges = new Edge[this._numEdge];
        object3 = graphI.edges();
        while (object3.hasMoreElements()) {
            object2 = (EdgeI)object3.nextElement();
            object = this._vertices[object2.getToVertex().getIndex()];
            vertex = this._vertices[object2.getFromVertex().getIndex()];
            this._edges[object2.getIndex()] = new Edge((EdgeI)object2, vertex, (Vertex)object);
        }
        boolean bl = this._allEdgesAreDirected = graphI.sizeOfDirectedEdges() == graphI.sizeOfEdges();
        if (!this._allEdgesAreDirected) {
            this._reversedEdges = new Edge[this._numEdge];
            object2 = graphI.edges();
            while (object2.hasMoreElements()) {
                object = (EdgeI)object2.nextElement();
                vertex = this._vertices[object.getToVertex().getIndex()];
                Vertex vertex2 = this._vertices[object.getFromVertex().getIndex()];
                this._reversedEdges[object.getIndex()] = new Edge((EdgeI)object, vertex, vertex2);
            }
        }
        if (this._listener != null) {
            this._listener.initialize(graphI, this);
        }
    }

    private final void _updateEdge(Edge edge, Edge edge2, boolean bl) {
        int n = edge._len + 1;
        if (n > this._maxLen) {
            return;
        }
        double d = edge._cost;
        d += this._properties.getEdgeCost(edge2._edge, bl);
        d += this._properties.getVertexCost(edge._dest._vertex);
        d += this._properties.getConnectionCost(edge._edge, edge._dest._vertex, edge2._edge);
        double d2 = edge._time;
        d2 += this._properties.getEdgeTime(edge2._edge, bl);
        d2 += this._properties.getVertexTime(edge._dest._vertex);
        d2 += this._properties.getConnectionTime(edge._edge, edge._dest._vertex, edge2._edge);
        double d3 = edge._dist;
        d3 += this._properties.getEdgeDistance(edge2._edge, bl);
        if (d > this._maxCost || d2 > this._maxTime || d3 > this._maxDist) {
            return;
        }
        if (!edge2.isInQueue(this._label)) {
            edge2._len = n;
            edge2._cost = d;
            edge2._time = d2;
            edge2._dist = d3;
            edge2._prevEdge = edge;
            edge2.setIsInQueue(this._label);
            edge2._queuePair = this._queue.insert(new Double(d), edge2);
            if (this._listener != null) {
                this._listener.updateVertexCost(edge._dest._vertex, edge2._edge, edge2._dest._vertex, edge2);
            }
        } else if (edge2._cost > d) {
            edge2._len = n;
            edge2._cost = d;
            edge2._time = d2;
            edge2._dist = d3;
            edge2._prevEdge = edge;
            try {
                this._queue.changePriority(edge2._queuePair, new Double(d));
            }
            catch (InvalidPriorityException invalidPriorityException) {
                throw new GraphError("The priority queue does not support change priority.");
            }
            if (this._listener != null) {
                this._listener.updateVertexCost(edge._dest._vertex, edge2._edge, edge2._dest._vertex, edge2);
            }
        }
    }

    public Enumeration candidates() {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        return new CandEnumeration(this._candHead);
    }

    public int generatePathsFrom(Object object) throws VertexNotFoundException, InvalidPropertyException {
        this._reverseEdges = false;
        return this._generatePaths(object);
    }

    public int generatePathsTo(Object object) throws VertexNotFoundException, InvalidPropertyException {
        this._reverseEdges = true;
        return this._generatePaths(object);
    }

    public EdgeValueI getEdgeValue(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            return null;
        }
        return vertex._prevEdge;
    }

    public VertexI getNearestCandidate() {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        return this._candHead == null ? null : this._candHead._vertex;
    }

    public Vector getPath(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            throw new VertexNotFoundException("The vertex is not in the solution.");
        }
        Vector<ElementI> vector = new Vector<ElementI>(vertex._prevEdge._len * 2 + 1);
        vector.addElement(vertex._vertex);
        Edge edge = vertex._prevEdge;
        while (edge != null) {
            vector.addElement(edge._edge);
            vector.addElement(edge._orig._vertex);
            edge = edge._prevEdge;
        }
        if (!this._reverseEdges) {
            int n = 0;
            int n2 = vector.size() - 1;
            while (n2 > n) {
                Object e = vector.elementAt(n);
                vector.setElementAt((ElementI)vector.elementAt(n2), n);
                vector.setElementAt((ElementI)e, n2);
            }
            ++n;
            --n2;
        }
        return vector;
    }

    public Enumeration pathElements(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            throw new VertexNotFoundException("The vertex is not in the solution.");
        }
        return new PathEnumeration(vertex);
    }

    public void setCandidate(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._vertices[vertexI.getIndex()]._isCand = bl;
    }

    public void setCandidate(boolean bl) {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        int n = 0;
        while (n < this._numVert) {
            this._vertices[n]._isCand = bl;
            ++n;
        }
    }

    public void setListener(SingleVertexListenerI singleVertexListenerI) {
        this._listener = singleVertexListenerI;
        if (this._listener != null && this._graph != null) {
            this._listener.initialize(this._graph, this);
        }
    }

    public void setMaxCost(double d) {
        this._maxCost = d;
    }

    public void setMaxDistance(double d) {
        this._maxDist = d;
    }

    public void setMaxLength(int n) {
        this._maxLen = n;
    }

    public void setMaxPaths(int n) {
        this._maxPaths = n;
    }

    public void setMaxTime(double d) {
        this._maxTime = d;
    }

    public void setProperties(PropertiesI propertiesI) {
        this._properties = propertiesI;
    }

    public String toString() {
        if (this._graph == null) {
            return "Dijkstra: The graph is not set\n";
        }
        String string = "";
        string = String.valueOf(string) + "------------------------------------\n";
        string = String.valueOf(string) + "Connections: " + this._graph.sizeOfVertices() + " vertices, " + this._graph.sizeOfEdges() + " edges\n";
        string = String.valueOf(string) + "------------------------------------\n";
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + this._vertices[((VertexI)enumeration.nextElement()).getIndex()] + "\n";
        }
        string = String.valueOf(string) + "\n";
        return string;
    }

    public boolean usesConnectionProperties() {
        return true;
    }

    private static class Vertex {
        int _label = 0;
        boolean _isCand = false;
        Edge _prevEdge;
        Vertex _nextCand;
        VertexI _vertex;

        Vertex(VertexI vertexI) {
            this._vertex = vertexI;
        }

        boolean isPerm(int n) {
            return this._label == n + 1;
        }

        void setPerm(int n) {
            this._label = n + 1;
        }

        public String toString() {
            return String.valueOf(this._vertex.toString()) + (this._isCand ? ", cand" : "");
        }
    }

    private static class Edge
    implements EdgeValueI {
        int _label = 0;
        PairI _queuePair;
        double _cost;
        double _time;
        double _dist;
        int _len;
        boolean _isCand;
        Vertex _orig;
        Vertex _dest;
        Edge _prevEdge;
        EdgeI _edge;

        Edge(EdgeI edgeI, Vertex vertex, Vertex vertex2) {
            this._orig = vertex;
            this._dest = vertex2;
            this._edge = edgeI;
        }

        public double getCost(boolean bl) {
            return this._cost;
        }

        public double getDistance(boolean bl) {
            return this._dist;
        }

        public double getTime(boolean bl) {
            return this._time;
        }

        boolean isInQueue(int n) {
            return this._label == n;
        }

        boolean isPerm(int n) {
            return this._label == n + 1;
        }

        void setIsInQueue(int n) {
            this._label = n;
        }

        void setPerm(int n) {
            this._label = n + 1;
        }

        public String toString() {
            return String.valueOf(this._edge.toString()) + (this._isCand ? ", cand" : "");
        }
    }

    private static class CandEnumeration
    implements Enumeration {
        Vertex _vertex;

        CandEnumeration(Vertex vertex) {
            this._vertex = vertex;
        }

        public boolean hasMoreElements() {
            return this._vertex != null;
        }

        public Object nextElement() {
            if (this._vertex == null) {
                return null;
            }
            VertexI vertexI = this._vertex._vertex;
            this._vertex = this._vertex._nextCand;
            return vertexI;
        }
    }

    private static class PathEnumeration
    implements Enumeration {
        Vertex _vertex;
        Edge _edge;
        boolean _didEdge;

        PathEnumeration(Vertex vertex) {
            this._vertex = vertex;
            this._edge = null;
        }

        public boolean hasMoreElements() {
            return this._vertex != null || this._edge != null;
        }

        public Object nextElement() {
            if (this._vertex != null) {
                VertexI vertexI = this._vertex._vertex;
                this._edge = this._vertex._prevEdge;
                this._vertex = null;
                this._didEdge = false;
                return vertexI;
            }
            if (!this._didEdge) {
                this._didEdge = true;
                return this._edge._edge;
            }
            this._didEdge = false;
            VertexI vertexI = this._edge._orig._vertex;
            this._edge = this._edge._prevEdge;
            return vertexI;
        }
    }
}

