/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.ComplexI;
import drasys.or.linear.blas.BLAS3;
import drasys.or.linear.blas.BLAS3I;
import drasys.or.linear.blas.BlasException;
import drasys.or.util.Smp;

public class SmpBLAS3
implements BLAS3I {
    Smp _smp = new Smp(100);
    BLAS3I _blas3 = null;
    BlasException _exception = null;

    public SmpBLAS3() {
        this._blas3 = new BLAS3();
    }

    public SmpBLAS3(BLAS3I bLAS3I) {
        this._blas3 = bLAS3I;
    }

    public void cgemm(int n, int n2, int n3, ComplexI complexI, float[] fArray, int n4, int n5, int n6, float[] fArray2, int n7, int n8, int n9, ComplexI complexI2, float[] fArray3, int n10, int n11, int n12) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n12 > n11) {
            nArray = this._smp.balanceTasks(n2, n * n3);
            if (nArray.length < 2) {
                this._blas3.cgemm(n, n2, n3, complexI, fArray, n4, n5, n6, fArray2, n7, n8, n9, complexI2, fArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n13 = 0;
            int n14 = nArray[0];
            while (n13 < nArray.length) {
                n14 = nArray[n13];
                runnableArray[n13] = new CgemmJob(n, n14, n3, complexI, fArray, n4, n5, n6, fArray2, n7, n8, n9, complexI2, fArray3, n10, n11, n12);
                n7 += n14 * n9;
                n10 += n14 * n12;
                ++n13;
            }
        } else {
            nArray = this._smp.balanceTasks(n, n2 * n3);
            if (nArray.length < 2) {
                this._blas3.cgemm(n, n2, n3, complexI, fArray, n4, n5, n6, fArray2, n7, n8, n9, complexI2, fArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n15 = 0;
            int n16 = nArray[0];
            while (n15 < nArray.length) {
                n16 = nArray[n15];
                runnableArray[n15] = new CgemmJob(n16, n2, n3, complexI, fArray, n4, n5, n6, fArray2, n7, n8, n9, complexI2, fArray3, n10, n11, n12);
                n4 += n16 * n5;
                n10 += n16 * n11;
                ++n15;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void dgemm(int n, int n2, int n3, double d, double[] dArray, int n4, int n5, int n6, double[] dArray2, int n7, int n8, int n9, double d2, double[] dArray3, int n10, int n11, int n12) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n12 > n11) {
            nArray = this._smp.balanceTasks(n2, n * n3);
            if (nArray.length < 2) {
                this._blas3.dgemm(n, n2, n3, d, dArray, n4, n5, n6, dArray2, n7, n8, n9, d2, dArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n13 = 0;
            int n14 = nArray[0];
            while (n13 < nArray.length) {
                n14 = nArray[n13];
                runnableArray[n13] = new DgemmJob(n, n14, n3, d, dArray, n4, n5, n6, dArray2, n7, n8, n9, d2, dArray3, n10, n11, n12);
                n7 += n14 * n9;
                n10 += n14 * n12;
                ++n13;
            }
        } else {
            nArray = this._smp.balanceTasks(n, n2 * n3);
            if (nArray.length < 2) {
                this._blas3.dgemm(n, n2, n3, d, dArray, n4, n5, n6, dArray2, n7, n8, n9, d2, dArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n15 = 0;
            int n16 = nArray[0];
            while (n15 < nArray.length) {
                n16 = nArray[n15];
                runnableArray[n15] = new DgemmJob(n16, n2, n3, d, dArray, n4, n5, n6, dArray2, n7, n8, n9, d2, dArray3, n10, n11, n12);
                n4 += n16 * n5;
                n10 += n16 * n11;
                ++n15;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public Smp getSmp() {
        return this._smp;
    }

    public void setSmp(Smp smp) {
        this._smp = smp;
    }

    public void sgemm(int n, int n2, int n3, float f, float[] fArray, int n4, int n5, int n6, float[] fArray2, int n7, int n8, int n9, float f2, float[] fArray3, int n10, int n11, int n12) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n12 > n11) {
            nArray = this._smp.balanceTasks(n2, n * n3);
            if (nArray.length < 2) {
                this._blas3.sgemm(n, n2, n3, f, fArray, n4, n5, n6, fArray2, n7, n8, n9, f2, fArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n13 = 0;
            int n14 = nArray[0];
            while (n13 < nArray.length) {
                n14 = nArray[n13];
                runnableArray[n13] = new SgemmJob(n, n14, n3, f, fArray, n4, n5, n6, fArray2, n7, n8, n9, f2, fArray3, n10, n11, n12);
                n7 += n14 * n9;
                n10 += n14 * n12;
                ++n13;
            }
        } else {
            nArray = this._smp.balanceTasks(n, n2 * n3);
            if (nArray.length < 2) {
                this._blas3.sgemm(n, n2, n3, f, fArray, n4, n5, n6, fArray2, n7, n8, n9, f2, fArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n15 = 0;
            int n16 = nArray[0];
            while (n15 < nArray.length) {
                n16 = nArray[n15];
                runnableArray[n15] = new SgemmJob(n16, n2, n3, f, fArray, n4, n5, n6, fArray2, n7, n8, n9, f2, fArray3, n10, n11, n12);
                n4 += n16 * n5;
                n10 += n16 * n11;
                ++n15;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zgemm(int n, int n2, int n3, ComplexI complexI, double[] dArray, int n4, int n5, int n6, double[] dArray2, int n7, int n8, int n9, ComplexI complexI2, double[] dArray3, int n10, int n11, int n12) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n12 > n11) {
            nArray = this._smp.balanceTasks(n2, n * n3);
            if (nArray.length < 2) {
                this._blas3.zgemm(n, n2, n3, complexI, dArray, n4, n5, n6, dArray2, n7, n8, n9, complexI2, dArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n13 = 0;
            int n14 = nArray[0];
            while (n13 < nArray.length) {
                n14 = nArray[n13];
                runnableArray[n13] = new ZgemmJob(n, n14, n3, complexI, dArray, n4, n5, n6, dArray2, n7, n8, n9, complexI2, dArray3, n10, n11, n12);
                n7 += n14 * n9;
                n10 += n14 * n12;
                ++n13;
            }
        } else {
            nArray = this._smp.balanceTasks(n, n2 * n3);
            if (nArray.length < 2) {
                this._blas3.zgemm(n, n2, n3, complexI, dArray, n4, n5, n6, dArray2, n7, n8, n9, complexI2, dArray3, n10, n11, n12);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n15 = 0;
            int n16 = nArray[0];
            while (n15 < nArray.length) {
                n16 = nArray[n15];
                runnableArray[n15] = new ZgemmJob(n16, n2, n3, complexI, dArray, n4, n5, n6, dArray2, n7, n8, n9, complexI2, dArray3, n10, n11, n12);
                n4 += n16 * n5;
                n10 += n16 * n11;
                ++n15;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    private class DgemmJob
    implements Runnable {
        int _m;
        int _n;
        int _k;
        int _begA;
        int _incAi;
        int _incAj;
        int _begB;
        int _incBi;
        int _incBj;
        int _begC;
        int _incCi;
        int _incCj;
        double _alpha;
        double _beta;
        double[] _A;
        double[] _B;
        double[] _C;

        DgemmJob(int n, int n2, int n3, double d, double[] dArray, int n4, int n5, int n6, double[] dArray2, int n7, int n8, int n9, double d2, double[] dArray3, int n10, int n11, int n12) {
            this._m = n;
            this._n = n2;
            this._k = n3;
            this._alpha = d;
            this._beta = d2;
            this._A = dArray;
            this._begA = n4;
            this._incAi = n5;
            this._incAj = n6;
            this._B = dArray2;
            this._begB = n7;
            this._incBi = n8;
            this._incBj = n9;
            this._C = dArray3;
            this._begC = n10;
            this._incCi = n11;
            this._incCj = n12;
        }

        public void run() {
            try {
                SmpBLAS3.this._blas3.dgemm(this._m, this._n, this._k, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._B, this._begB, this._incBi, this._incBj, this._beta, this._C, this._begC, this._incCi, this._incCj);
            }
            catch (BlasException blasException) {
                SmpBLAS3.this._exception = blasException;
            }
        }
    }

    private class SgemmJob
    implements Runnable {
        int _m;
        int _n;
        int _k;
        int _begA;
        int _incAi;
        int _incAj;
        int _begB;
        int _incBi;
        int _incBj;
        int _begC;
        int _incCi;
        int _incCj;
        float _alpha;
        float _beta;
        float[] _A;
        float[] _B;
        float[] _C;

        SgemmJob(int n, int n2, int n3, float f, float[] fArray, int n4, int n5, int n6, float[] fArray2, int n7, int n8, int n9, float f2, float[] fArray3, int n10, int n11, int n12) {
            this._m = n;
            this._n = n2;
            this._k = n3;
            this._alpha = f;
            this._beta = f2;
            this._A = fArray;
            this._begA = n4;
            this._incAi = n5;
            this._incAj = n6;
            this._B = fArray2;
            this._begB = n7;
            this._incBi = n8;
            this._incBj = n9;
            this._C = fArray3;
            this._begC = n10;
            this._incCi = n11;
            this._incCj = n12;
        }

        public void run() {
            try {
                SmpBLAS3.this._blas3.sgemm(this._m, this._n, this._k, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._B, this._begB, this._incBi, this._incBj, this._beta, this._C, this._begC, this._incCi, this._incCj);
            }
            catch (BlasException blasException) {
                SmpBLAS3.this._exception = blasException;
            }
        }
    }

    private class ZgemmJob
    implements Runnable {
        int _m;
        int _n;
        int _k;
        int _begA;
        int _incAi;
        int _incAj;
        int _begB;
        int _incBi;
        int _incBj;
        int _begC;
        int _incCi;
        int _incCj;
        ComplexI _alpha;
        ComplexI _beta;
        double[] _A;
        double[] _B;
        double[] _C;

        ZgemmJob(int n, int n2, int n3, ComplexI complexI, double[] dArray, int n4, int n5, int n6, double[] dArray2, int n7, int n8, int n9, ComplexI complexI2, double[] dArray3, int n10, int n11, int n12) {
            this._m = n;
            this._n = n2;
            this._k = n3;
            this._alpha = complexI;
            this._beta = complexI2;
            this._A = dArray;
            this._begA = n4;
            this._incAi = n5;
            this._incAj = n6;
            this._B = dArray2;
            this._begB = n7;
            this._incBi = n8;
            this._incBj = n9;
            this._C = dArray3;
            this._begC = n10;
            this._incCi = n11;
            this._incCj = n12;
        }

        public void run() {
            try {
                SmpBLAS3.this._blas3.zgemm(this._m, this._n, this._k, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._B, this._begB, this._incBi, this._incBj, this._beta, this._C, this._begC, this._incCi, this._incCj);
            }
            catch (BlasException blasException) {
                SmpBLAS3.this._exception = blasException;
            }
        }
    }

    private class CgemmJob
    implements Runnable {
        int _m;
        int _n;
        int _k;
        int _begA;
        int _incAi;
        int _incAj;
        int _begB;
        int _incBi;
        int _incBj;
        int _begC;
        int _incCi;
        int _incCj;
        ComplexI _alpha;
        ComplexI _beta;
        float[] _A;
        float[] _B;
        float[] _C;

        CgemmJob(int n, int n2, int n3, ComplexI complexI, float[] fArray, int n4, int n5, int n6, float[] fArray2, int n7, int n8, int n9, ComplexI complexI2, float[] fArray3, int n10, int n11, int n12) {
            this._m = n;
            this._n = n2;
            this._k = n3;
            this._alpha = complexI;
            this._beta = complexI2;
            this._A = fArray;
            this._begA = n4;
            this._incAi = n5;
            this._incAj = n6;
            this._B = fArray2;
            this._begB = n7;
            this._incBi = n8;
            this._incBj = n9;
            this._C = fArray3;
            this._begC = n10;
            this._incCi = n11;
            this._incCj = n12;
        }

        public void run() {
            try {
                SmpBLAS3.this._blas3.cgemm(this._m, this._n, this._k, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._B, this._begB, this._incBi, this._incBj, this._beta, this._C, this._begC, this._incCi, this._incCj);
            }
            catch (BlasException blasException) {
                SmpBLAS3.this._exception = blasException;
            }
        }
    }
}

