/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.SizableVectorI;
import drasys.or.matrix.Vect;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SparseVector
extends Vect
implements SizableVectorI {
    private int _size = 0;
    private Element _tmpElement = new Element(0, 0.0);
    private Hashtable _index = null;

    public SparseVector() {
        this._index = new Hashtable();
    }

    public SparseVector(int n) {
        this._size = n;
        this._index = new Hashtable();
    }

    public SparseVector(int n, int n2) {
        this._size = n;
        this._index = new Hashtable(n2);
    }

    public SparseVector(VectorI vectorI) {
        this._size = vectorI.size();
        this._index = new Hashtable(this._size);
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            Element element = new Element(vectorElementI.getIndex(), vectorElementI.getValue());
            this._index.put(element, element);
        }
    }

    public SparseVector(VectorI vectorI, double d) {
        this._size = vectorI.size();
        this._index = new Hashtable(this._size);
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            double d2 = vectorElementI.getValue();
            if (this.equals(d2, 0.0)) continue;
            Element element = new Element(vectorElementI.getIndex(), d2);
            this._index.put(element, element);
        }
    }

    public SparseVector(double[] dArray) {
        this._size = dArray.length;
        this._index = new Hashtable(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            Element element = new Element(n, dArray[n]);
            this._index.put(element, element);
            ++n;
        }
    }

    public SparseVector(double[] dArray, double d) {
        super(d);
        this._size = dArray.length;
        this._index = new Hashtable(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            double d2 = dArray[n];
            if (!this.equals(d2, 0.0)) {
                Element element = new Element(n, d2);
                this._index.put(element, element);
            }
            ++n;
        }
    }

    public void addElement(double d) {
        this.setElementAt(this._size++, d);
    }

    public int capacity() {
        return Integer.MAX_VALUE;
    }

    public double elementAt(int n) {
        if (n < 0 || n >= this._size) {
            throw new ArrayIndexOutOfBoundsException("index = " + n + ", size = " + this._size);
        }
        this._tmpElement._index = n;
        Element element = (Element)this._index.get(this._tmpElement);
        return element == null ? 0.0 : element._value;
    }

    public Enumeration elements() {
        return this._index.elements();
    }

    public double[] getArray() {
        double[] dArray = new double[this._size];
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            dArray[vectorElementI.getIndex()] = vectorElementI.getValue();
        }
        return dArray;
    }

    public boolean isNull(int n) {
        if (n < 0 || n >= this._size) {
            throw new ArrayIndexOutOfBoundsException("index = " + n + ", size = " + this._size);
        }
        this._tmpElement._index = n;
        Element element = (Element)this._index.get(this._tmpElement);
        return element == null;
    }

    public void setCapacity(int n) {
    }

    public void setElementAt(int n, double d) {
        if (n < 0 || n >= this._size) {
            throw new ArrayIndexOutOfBoundsException("index = " + n + ", size = " + this._size);
        }
        this._tmpElement._index = n;
        Element element = (Element)this._index.get(this._tmpElement);
        if (element == null) {
            element = new Element(n, d);
            this._index.put(element, element);
        } else {
            element._value = d;
        }
    }

    public void setElements(double d) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((VectorElementI)enumeration.nextElement()).setValue(d);
        }
    }

    public void setSize(int n) {
        if (n < this._size) {
            Object object;
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this._index.elements();
            while (enumeration.hasMoreElements()) {
                object = (Element)enumeration.nextElement();
                if (((Element)object)._index < n) continue;
                vector.addElement(object);
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                this._index.remove(object.nextElement());
            }
        }
        this._size = n;
    }

    public int size() {
        return this._size;
    }

    public int sizeOfElements() {
        return this._index.size();
    }

    public double sum(int n) {
        double d = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            if (vectorElementI.getIndex() < n) continue;
            d += vectorElementI.getValue();
        }
        return d;
    }

    public double sum(int n, int n2) {
        double d = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n3 = vectorElementI.getIndex();
            if (n3 < n || n3 >= n2) continue;
            d += vectorElementI.getValue();
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, double d) {
        int n2 = 0;
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            if (vectorElementI.getIndex() < n) continue;
            double d3 = vectorElementI.getValue() - d;
            d2 += d3 * d3;
            ++n2;
        }
        return d2 + (double)(this._size - n - n2) * d * d;
    }

    public double sumOfSquaredDifferences(int n, int n2, double d) {
        int n3 = 0;
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n4 = vectorElementI.getIndex();
            if (n4 < n || n4 >= n2) continue;
            double d3 = vectorElementI.getValue() - d;
            d2 += d3 * d3;
            ++n3;
        }
        return d2 + (double)(n2 - n - n3) * d * d;
    }

    public double sumOfSquares(int n) {
        double d = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            if (vectorElementI.getIndex() < n) continue;
            double d2 = vectorElementI.getValue();
            d += d2 * d2;
        }
        return d;
    }

    public double sumOfSquares(int n, int n2) {
        double d = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n3 = vectorElementI.getIndex();
            if (n3 < n || n3 >= n2) continue;
            double d2 = vectorElementI.getValue();
            d += d2 * d2;
        }
        return d;
    }

    static class Element
    implements VectorElementI,
    Serializable {
        int _index;
        double _value;

        Element(int n, double d) {
            this._index = n;
            this._value = d;
        }

        public boolean equals(Object object) {
            return this._index == ((Element)object)._index;
        }

        public int getIndex() {
            return this._index;
        }

        public double getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._index;
        }

        public void setValue(double d) {
            this._value = d;
        }
    }
}

