/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.Bisection;
import drasys.or.nonlinear.EquationSolutionI;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.Integration;
import drasys.or.nonlinear.IntegrationI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.ContinuousDistributionI;
import drasys.or.prob.ProbError;

public class NormalDistribution
extends ContinuousDistribution
implements ContinuousDistributionI {
    Cdf _cdf;
    Pdf _pdf;
    double _std;
    double _var;
    double _var2;
    double _mean;
    double _left;
    double _extra;
    boolean _haveExtra;
    static IntegrationI _integration;
    static EquationSolutionI _solver;

    public NormalDistribution() {
        this.setParameters(0.0, 1.0);
    }

    public NormalDistribution(double d, double d2) {
        this.setParameters(d, d2);
    }

    public NormalDistribution(double d, double d2, long l) {
        super(l);
        this.setParameters(d, d2);
    }

    public NormalDistribution(double d, double d2, IntegrationI integrationI) {
        _integration = integrationI;
        this.setParameters(d, d2);
    }

    public NormalDistribution(double d, double d2, IntegrationI integrationI, EquationSolutionI equationSolutionI) {
        _solver = equationSolutionI;
        _integration = integrationI;
        this.setParameters(d, d2);
    }

    public double cdf(double d) {
        double d2;
        if (d < this._mean - 4.0 * this._std) {
            return 0.0;
        }
        if (d > this._mean + 4.0 * this._std) {
            return 1.0;
        }
        if (_integration == null) {
            _integration = new Integration();
        }
        if (this._pdf == null) {
            this._pdf = new Pdf();
        }
        try {
            d2 = _integration.integrate(this._pdf, this._mean - 4.0 * this._std, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NormalDistribution)) {
            return false;
        }
        NormalDistribution normalDistribution = (NormalDistribution)object;
        return normalDistribution._std == this._std && normalDistribution._mean == this._mean;
    }

    public double function(double d) {
        return this.pdf(d);
    }

    public double getRandomScaler() {
        double d;
        double d2;
        double d3;
        if (this._haveExtra) {
            this._haveExtra = false;
            return this._extra;
        }
        while ((d3 = (d2 = this._random.nextDouble() * 2.0 - 1.0) * d2 + (d = this._random.nextDouble() * 2.0 - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = this._std * Math.sqrt(-2.0 * Math.log(d3) / d3);
        this._extra = d * d4 + this._mean;
        this._haveExtra = true;
        return d2 * d4 + this._mean;
    }

    public double inverseCdf(double d) {
        double d2;
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        double d3 = this._mean - 4.0 * this._std;
        double d4 = this._mean + 4.0 * this._std;
        double d5 = this.cdf(d3);
        double d6 = this.cdf(d4);
        if (d <= d5) {
            return d3;
        }
        if (d >= d6) {
            return d4;
        }
        if (_solver == null) {
            _solver = new Bisection();
        }
        if (this._cdf == null) {
            this._cdf = new Cdf();
        }
        if (_integration == null) {
            _integration = new Integration();
        }
        try {
            d2 = _solver.solve(this._cdf, d3, d4, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        return d2;
    }

    public double mean() {
        return this._mean;
    }

    public double pdf(double d) {
        double d2 = d - this._mean;
        return this._left * Math.exp(d2 * d2 * this._var2);
    }

    public double probability(double d, double d2) {
        double d3;
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        if (d2 <= this._mean - 4.0 * this._std) {
            return 0.0;
        }
        if (d >= this._mean + 4.0 * this._std) {
            return 0.0;
        }
        if (_integration == null) {
            _integration = new Integration();
        }
        if (this._pdf == null) {
            this._pdf = new Pdf();
        }
        try {
            d3 = _integration.integrate(this._pdf, d, d2);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("NonLinear:" + nonlinearException.getMessage());
        }
        return d3;
    }

    public void setParameters(double d, double d2) {
        if (d2 <= 0.0) {
            throw new InvalidArgumentError("The std must be greater than zero.");
        }
        this._std = d2;
        this._var = d2 * d2;
        this._var2 = -1.0 / (this._var * 2.0);
        this._mean = d;
        this._left = 1.0 / (Math.sqrt(Math.PI * 2) * this._var);
        this._haveExtra = false;
    }

    public double std() {
        return this._std;
    }

    public String toString() {
        return "NormalDistribution(mean = " + this._mean + ", std = " + this._std + ")";
    }

    public double variance() {
        return this._var;
    }

    public class Pdf
    implements FunctionI {
        public double function(double d) {
            return NormalDistribution.this.pdf(d);
        }
    }

    public class Cdf
    implements FunctionI {
        public double function(double d) {
            return NormalDistribution.this.cdf(d);
        }
    }
}

