/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.matrix.ColumnMajorMatrix;
import drasys.or.matrix.ContiguousMatrix;
import drasys.or.matrix.ContiguousVector;
import drasys.or.matrix.MatrixI;
import drasys.or.prob.NormalDistribution;

public class LinearCorrelation {
    private int _nv;
    private int _ns;
    private MatrixI _samples;
    private double _confidence = -1.0;
    private double _zc;
    private double _lowerConfidence;
    private double _upperConfidence;
    private NormalDistribution _z = null;
    private ContiguousVector _std = null;
    private ContiguousVector _mean = null;
    private ContiguousMatrix _lower = null;
    private ContiguousMatrix _upper = null;
    private ContiguousMatrix _sumOfProducts = null;
    private ContiguousVector _sumOfSquares = null;
    private ContiguousMatrix _covariance = null;
    private ContiguousMatrix _correlation = null;

    public LinearCorrelation(MatrixI matrixI) {
        this._nv = matrixI.sizeOfColumns();
        this._ns = matrixI.sizeOfRows();
        this._samples = matrixI;
    }

    public ContiguousMatrix getCorrelation() {
        if (this._correlation != null) {
            return this._correlation;
        }
        this.getStd();
        this.getCovariance();
        this._correlation = new ColumnMajorMatrix(this._nv, this._nv);
        int n = 0;
        while (n < this._nv) {
            this._correlation.setElementAt(n, n, 1.0);
            int n2 = 0;
            while (n2 < n) {
                double d = this._covariance.elementAt(n, n2) / this._std.elementAt(n) / this._std.elementAt(n2);
                this._correlation.setElementAt(n, n2, d);
                this._correlation.setElementAt(n2, n, d);
                ++n2;
            }
            ++n;
        }
        return this._correlation;
    }

    public ContiguousMatrix getCovariance() {
        if (this._covariance != null) {
            return this._covariance;
        }
        this.getMean();
        this.getStd();
        this.getSumOfProducts();
        this._covariance = new ColumnMajorMatrix(this._nv, this._nv);
        double d = 1.0 / ((double)this._ns - 1.0);
        int n = 0;
        while (n < this._nv) {
            double d2 = this._std.elementAt(n);
            this._covariance.setElementAt(n, n, d2 * d2);
            int n2 = 0;
            while (n2 < n) {
                double d3 = d * (this._sumOfProducts.elementAt(n, n2) - (double)this._ns * this._mean.elementAt(n) * this._mean.elementAt(n2));
                this._covariance.setElementAt(n, n2, d3);
                this._covariance.setElementAt(n2, n, d3);
                ++n2;
            }
            ++n;
        }
        return this._covariance;
    }

    public ContiguousMatrix getLowerBound(double d) {
        if (this._lower != null && this._lowerConfidence == d) {
            return this._lower;
        }
        this.getCorrelation();
        this._lowerConfidence = d;
        if (this._lower == null) {
            this._lower = new ColumnMajorMatrix(this._nv, this._nv);
        }
        double d2 = this.getZ(d);
        int n = 0;
        while (n < this._nv) {
            this._lower.setElementAt(n, n, this._correlation.elementAt(n, n));
            int n2 = 0;
            while (n2 < n) {
                double d3 = this._correlation.elementAt(n, n2);
                double d4 = 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) - d2;
                double d5 = Math.exp(2.0 * d4);
                double d6 = (d5 - 1.0) / (d5 + 1.0);
                this._lower.setElementAt(n, n2, d6);
                this._lower.setElementAt(n2, n, d6);
                ++n2;
            }
            ++n;
        }
        return this._lower;
    }

    public ContiguousVector getMean() {
        if (this._mean != null) {
            return this._mean;
        }
        this._mean = new ContiguousVector(this._nv);
        int n = 0;
        while (n < this._nv) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this._ns) {
                d += this._samples.elementAt(n2, n);
                ++n2;
            }
            this._mean.setElementAt(n, d / (double)this._ns);
            ++n;
        }
        return this._mean;
    }

    public ContiguousVector getStd() {
        if (this._std != null) {
            return this._std;
        }
        this.getMean();
        this.getSumOfSquares();
        this._std = new ContiguousVector(this._nv);
        double d = 1.0 / ((double)this._ns - 1.0);
        int n = 0;
        while (n < this._nv) {
            double d2 = this._mean.elementAt(n);
            this._std.setElementAt(n, Math.sqrt(d * (this._sumOfSquares.elementAt(n) - (double)this._ns * d2 * d2)));
            ++n;
        }
        return this._std;
    }

    public ContiguousMatrix getSumOfProducts() {
        if (this._sumOfProducts != null) {
            return this._sumOfProducts;
        }
        this.getSumOfSquares();
        this._sumOfProducts = new ColumnMajorMatrix(this._nv, this._nv);
        int n = 0;
        while (n < this._nv) {
            this._sumOfProducts.setElementAt(n, n, this._sumOfSquares.elementAt(n));
            int n2 = 0;
            while (n2 < n) {
                double d = 0.0;
                int n3 = 0;
                while (n3 < this._ns) {
                    d += this._samples.elementAt(n3, n) * this._samples.elementAt(n3, n2);
                    ++n3;
                }
                this._sumOfProducts.setElementAt(n, n2, d);
                this._sumOfProducts.setElementAt(n2, n, d);
                ++n2;
            }
            ++n;
        }
        return this._sumOfProducts;
    }

    public ContiguousVector getSumOfSquares() {
        if (this._sumOfSquares != null) {
            return this._sumOfSquares;
        }
        this._sumOfSquares = new ContiguousVector(this._nv);
        int n = 0;
        while (n < this._nv) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this._ns) {
                double d2 = this._samples.elementAt(n2, n);
                d += d2 * d2;
                ++n2;
            }
            this._sumOfSquares.setElementAt(n, d);
            ++n;
        }
        return this._sumOfSquares;
    }

    public ContiguousMatrix getUpperBound(double d) {
        if (this._upper != null && this._upperConfidence == d) {
            return this._upper;
        }
        this.getCorrelation();
        this._upperConfidence = d;
        if (this._upper == null) {
            this._upper = new ColumnMajorMatrix(this._nv, this._nv);
        }
        double d2 = this.getZ(d);
        int n = 0;
        while (n < this._nv) {
            this._upper.setElementAt(n, n, this._correlation.elementAt(n, n));
            int n2 = 0;
            while (n2 < n) {
                double d3 = this._correlation.elementAt(n, n2);
                double d4 = 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) + d2;
                double d5 = Math.exp(2.0 * d4);
                double d6 = (d5 - 1.0) / (d5 + 1.0);
                this._upper.setElementAt(n, n2, d6);
                this._upper.setElementAt(n2, n, d6);
                ++n2;
            }
            ++n;
        }
        return this._upper;
    }

    private double getZ(double d) {
        if (this._ns < 4) {
            throw new Error("Can't get confidence interval for fewer than 4 samples.");
        }
        if (this._confidence == d) {
            return this._zc;
        }
        this._confidence = d;
        if (this._z == null) {
            this._z = new NormalDistribution();
        }
        this._zc = this._z.inverseCdf(1.0 - 0.5 * (1.0 - d)) / Math.sqrt(this._ns - 3);
        return this._zc;
    }
}

