/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;

public class CentroidsViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 201020001L;
    protected CentroidViewer centroidViewer;

    public CentroidsViewer(Experiment experiment, int[][] nArray) {
        this(new CentroidViewer(experiment, nArray));
    }

    public CentroidsViewer(CentroidViewer centroidViewer) {
        this.centroidViewer = centroidViewer;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.centroidViewer.setData(iFramework.getData());
        this.centroidViewer.setMode((Integer)iFramework.getUserObject());
        this.centroidViewer.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
        this.centroidViewer.onSelected(iFramework);
    }

    public void onDataChanged(IData iData) {
        this.centroidViewer.setData(iData);
    }

    public void setMeans(float[][] fArray) {
        this.centroidViewer.setMeans(fArray);
    }

    public void setVariances(float[][] fArray) {
        this.centroidViewer.setVariances(fArray);
    }

    public void setCodes(float[][] fArray) {
        this.centroidViewer.setCodes(fArray);
    }

    public Experiment getExperiment() {
        return this.centroidViewer.getExperiment();
    }

    protected IData getData() {
        return this.centroidViewer.getData();
    }

    public int[][] getClusters() {
        return this.centroidViewer.getClusters();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.centroidViewer.onMenuChanged(iDisplayMenu);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = (int)Math.ceil(Math.sqrt(this.getClusters().length));
        int n2 = (int)Math.ceil((float)this.getClusters().length / (float)n);
        float f = (float)(this.getWidth() - 10) / (float)n;
        float f2 = (float)(this.getHeight() - 10) / (float)n2;
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (int j = 0; j < n && (n3 = i * n + j) < this.getClusters().length; ++j) {
                this.centroidViewer.setClusterIndex(n3);
                rectangle.setBounds(Math.round(10.0f + (float)j * f), Math.round(10.0f + (float)i * f2), Math.round(f - 10.0f), Math.round(f2 - 10.0f));
                this.centroidViewer.paint((Graphics2D)graphics, rectangle, false);
            }
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int getViewerType() {
        return 0;
    }
}

