/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableSearchDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.QSort;

public class ExperimentClusterTableViewer
implements IViewer,
Serializable {
    public static final long serialVersionUID = 201080001L;
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String STORE_SELECTED_ROWS_CMD = "store-selected-rows-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD = "launch-new-session-with-sel-rows-cmd";
    protected static final String SEARCH_CMD = "search-cmd";
    protected static final String CLEAR_ALL_CMD = "clear-all-cmd";
    protected static final String SELECT_ALL_CMD = "select-all-cmd";
    protected static final String SORT_ORIG_ORDER_CMD = "sort-orig-order-cmd";
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    private JComponent header;
    private JPopupMenu popup;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int[][] clusters;
    private int[][] sortedClusters;
    private String[] auxTitles;
    private Object[][] auxData;
    private boolean[][] sortedAscending;
    private JTable clusterTable;
    private ExperimentClusterTableModel clusterModel;
    private ClusterTableSearchDialog searchDialog;
    static /* synthetic */ Class class$java$awt$Color;

    public ExperimentClusterTableViewer(Experiment experiment, int[][] nArray, IData iData, String[] stringArray, Object[][] objectArray) {
        int n;
        int n2;
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.data = iData;
        this.experiment = experiment;
        this.clusters = nArray;
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        this.sortedClusters = new int[nArray.length][];
        for (n2 = 0; n2 < this.sortedClusters.length; ++n2) {
            this.sortedClusters[n2] = new int[nArray[n2].length];
        }
        for (n2 = 0; n2 < this.sortedClusters.length; ++n2) {
            for (n = 0; n < this.sortedClusters[n2].length; ++n) {
                this.sortedClusters[n2][n] = nArray[n2][n];
            }
        }
        this.clusterModel = new ExperimentClusterTableModel();
        this.clusterTable = new JTable(this.clusterModel);
        this.clusterTable.setDefaultRenderer(class$java$awt$Color == null ? (class$java$awt$Color = ExperimentClusterTableViewer.class$("java.awt.Color")) : class$java$awt$Color, new ColorRenderer(true));
        TableColumn tableColumn = null;
        for (n = 0; n < this.clusterModel.getColumnCount(); ++n) {
            tableColumn = this.clusterTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(30);
        }
        this.sortedAscending = new boolean[nArray.length][this.clusterModel.getColumnCount()];
        for (n = 0; n < this.sortedAscending.length; ++n) {
            for (int i = 0; i < this.sortedAscending[n].length; ++i) {
                this.sortedAscending[n][i] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    public ExperimentClusterTableViewer(Experiment experiment, int[][] nArray, IData iData) {
        this(experiment, nArray, iData, new String[0], new Object[0][0]);
    }

    public JComponent getContentComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.gray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.clusterTable, gridBagConstraints);
        jPanel.add(this.clusterTable);
        return jPanel;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public JComponent getHeaderComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.header, gridBagConstraints);
        jPanel.add(this.header);
        return jPanel;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        Integer n = (Integer)iFramework.getUserObject();
        this.setClusterIndex(n == null ? 0 : n);
        this.clusterTable.clearSelection();
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    public int[] getSortedCluster() {
        return this.sortedClusters[this.clusterIndex];
    }

    protected int getProbe(int n) {
        return this.experiment.getGeneIndexMappedToData(n);
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    int n4 = mouseEvent.getModifiers() & 2;
                    boolean bl = n4 != 0;
                    ExperimentClusterTableViewer.this.sortByColumn(n2, !ExperimentClusterTableViewer.this.sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][n2], bl);
                    boolean bl2 = ((ExperimentClusterTableViewer)ExperimentClusterTableViewer.this).sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][n2] = !ExperimentClusterTableViewer.this.sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][n2];
                    if (bl) {
                        for (int i = 0; i < ExperimentClusterTableViewer.this.clusterModel.getColumnCount(); ++i) {
                            ((ExperimentClusterTableViewer)ExperimentClusterTableViewer.this).sortedAscending[ExperimentClusterTableViewer.this.getClusterIndex()][i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        if (bl2) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedClusters[this.clusterIndex][i] = this.getCluster()[i];
            }
            this.clusterTable.repaint();
            this.clusterTable.clearSelection();
            return;
        }
        int[] nArray = new int[this.getCluster().length];
        if (n == 0) {
            Object object;
            double[] dArray = new double[this.getCluster().length];
            for (int i = 0; i < dArray.length; ++i) {
                object = this.data.getExperimentColor(this.getCluster()[i]) == null ? Color.white : this.data.getExperimentColor(this.getCluster()[i]);
                dArray[i] = ((Color)object).getRGB();
            }
            QSort qSort = new QSort(dArray);
            object = qSort.getOrigIndx();
            for (int i = 0; i < ((int[])object).length; ++i) {
                nArray[i] = this.getCluster()[object[i]];
            }
        } else if (n == 1) {
            int n2;
            Object[] objectArray = new SortableField[this.getCluster().length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                int n3 = this.getCluster()[n2];
                String string = this.data.getFullSampleName(this.experiment.getSampleIndex(this.getCluster()[n2]));
                objectArray[n2] = new SortableField(n3, string);
            }
            Arrays.sort(objectArray);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                nArray[n2] = ((SortableField)objectArray[n2]).getIndex();
            }
        } else {
            int n4 = ExperimentClusterTableViewer.getObjectType(this.auxData[0][n - 2]);
            if (n4 == 12 || n4 == 11 || n4 == 10) {
                double[] dArray = new double[this.getCluster().length];
                for (int i = 0; i < dArray.length; ++i) {
                    if (n4 == 12) {
                        dArray[i] = (Double)this.auxData[this.getCluster()[i]][n - 2];
                        continue;
                    }
                    if (n4 == 11) {
                        dArray[i] = ((Float)this.auxData[this.getCluster()[i]][n - 2]).doubleValue();
                        continue;
                    }
                    if (n4 != 10) continue;
                    dArray[i] = ((Integer)this.auxData[this.getCluster()[i]][n - 2]).doubleValue();
                }
                QSort qSort = new QSort(dArray);
                int[] nArray2 = qSort.getOrigIndx();
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray[i] = this.getCluster()[nArray2[i]];
                }
            } else if (n4 == 14) {
                int n5;
                Object[] objectArray = new SortableField[this.getCluster().length];
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    int n6 = this.getCluster()[n5];
                    String string = ((Boolean)this.auxData[this.getCluster()[n5]][n - 2]).toString();
                    objectArray[n5] = new SortableField(n6, string);
                }
                Arrays.sort(objectArray);
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    nArray[n5] = ((SortableField)objectArray[n5]).getIndex();
                }
            } else if (n4 == 13) {
                int n7;
                Object[] objectArray = new SortableField[this.getCluster().length];
                for (n7 = 0; n7 < objectArray.length; ++n7) {
                    int n8 = this.getCluster()[n7];
                    String string = (String)this.auxData[this.getCluster()[n7]][n - 2];
                    objectArray[n7] = new SortableField(n8, string);
                }
                Arrays.sort(objectArray);
                for (n7 = 0; n7 < objectArray.length; ++n7) {
                    nArray[n7] = ((SortableField)objectArray[n7]).getIndex();
                }
            }
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedClusters[this.clusterIndex][i] = nArray[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.removeRowSelectionInterval(0, this.clusterTable.getRowCount() - 1);
    }

    private static int[] getTypes(Object[][] objectArray) {
        int[] nArray = new int[objectArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ExperimentClusterTableViewer.getObjectType(objectArray[0][i]);
        }
        return nArray;
    }

    private static int getObjectType(Object object) {
        int n = -1;
        if (object instanceof Boolean) {
            return 14;
        }
        if (object instanceof Double) {
            return 12;
        }
        if (object instanceof Float) {
            return 11;
        }
        if (object instanceof Integer) {
            return 10;
        }
        if (object instanceof String) {
            return 13;
        }
        return n;
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.clusterTable.getLocation().x + 100, this.clusterTable.getLocation().y + 100);
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public void setClusterColor(Color color) {
        boolean bl;
        if (color == null && !(bl = this.framework.removeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 1))) {
            JOptionPane.showMessageDialog(null, "Cluster not deleted! Selected rows must exactly correspond to a cluster created in the current algorithm run", "Error", 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.onDataChanged(this.data);
    }

    public void storeSelectedRowsAsCluster() {
        if (this.getArrayMappedToSelectedIndices().length == 0) {
            JOptionPane.showMessageDialog(null, "No rows selected! Cluster will not be saved", "Error", 0);
        } else {
            this.framework.storeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 1);
            this.onDataChanged(this.data);
        }
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    public void launchNewSessionWithSelectedRows() {
        this.framework.launchNewMAV(this.getArrayMappedToSelectedIndices(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    public void sortInOrigOrder() {
        int n;
        for (n = 0; n < this.getSortedCluster().length; ++n) {
            this.sortedClusters[this.clusterIndex][n] = this.getCluster()[n];
        }
        this.clusterTable.repaint();
        this.clusterTable.clearSelection();
        for (n = 0; n < this.clusterModel.getColumnCount(); ++n) {
            this.sortedAscending[this.getClusterIndex()][n] = false;
        }
    }

    private int[] getArrayMappedToSelectedIndices() {
        int[] nArray = this.clusterTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.getSortedCluster()[nArray[i]];
        }
        return nArray2;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store entire cluster", GUIFactory.getIcon((String)"new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Store selected rows as cluster", GUIFactory.getIcon((String)"new16.gif"));
        jMenuItem.setActionCommand(STORE_SELECTED_ROWS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete cluster composed of selected rows", GUIFactory.getIcon((String)"delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session with entire cluster", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch new session with selected rows", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Search...", GUIFactory.getIcon((String)"ClusterInformationResult.gif"));
        jMenuItem.setActionCommand(SEARCH_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        jMenuItem.setActionCommand(SELECT_ALL_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        jMenuItem.setActionCommand(CLEAR_ALL_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Sort table in original experiment order...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        jMenuItem.setActionCommand(SORT_ORIG_ORDER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
            } else {
                ExperimentUtil.saveAllExperimentClustersWithAux(frame, this.getExperiment(), this.getData(), this.getClusters(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
            } else {
                ExperimentUtil.saveExperimentClusterWithAux(frame, this.getExperiment(), this.getData(), this.getCluster(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.popup);
        objectOutputStream.writeInt(this.clusterIndex);
        objectOutputStream.writeObject(this.sortedClusters);
        objectOutputStream.writeObject(this.auxTitles);
        objectOutputStream.writeObject(this.auxData);
        objectOutputStream.writeObject(this.sortedAscending);
        objectOutputStream.writeObject(this.clusterTable);
        objectOutputStream.writeObject(this.clusterModel);
        objectOutputStream.writeObject(this.searchDialog);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.header = (JComponent)objectInputStream.readObject();
        this.popup = (JPopupMenu)objectInputStream.readObject();
        this.clusterIndex = objectInputStream.readInt();
        this.sortedClusters = (int[][])objectInputStream.readObject();
        this.auxTitles = (String[])objectInputStream.readObject();
        this.auxData = (Object[][])objectInputStream.readObject();
        this.sortedAscending = (boolean[][])objectInputStream.readObject();
        this.clusterTable = (JTable)objectInputStream.readObject();
        this.clusterModel = (ExperimentClusterTableModel)objectInputStream.readObject();
        this.searchDialog = (ClusterTableSearchDialog)objectInputStream.readObject();
        this.clusterTable.setDefaultRenderer(class$java$awt$Color == null ? (class$java$awt$Color = ExperimentClusterTableViewer.class$("java.awt.Color")) : class$java$awt$Color, new ColorRenderer(true));
        TableColumn tableColumn = null;
        for (n = 0; n < this.clusterModel.getColumnCount(); ++n) {
            tableColumn = this.clusterTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(30);
        }
        this.sortedAscending = new boolean[this.clusters.length][this.clusterModel.getColumnCount()];
        for (n = 0; n < this.sortedAscending.length; ++n) {
            for (int i = 0; i < this.sortedAscending[n].length; ++i) {
                this.sortedAscending[n][i] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    public int getViewerType() {
        return 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.setBackground(color);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(ExperimentClusterTableViewer.SAVE_CLUSTER_CMD)) {
                ExperimentClusterTableViewer.this.onSaveCluster();
            } else if (string.equals(ExperimentClusterTableViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ExperimentClusterTableViewer.this.onSaveClusters();
            } else if (string.equals(ExperimentClusterTableViewer.STORE_CLUSTER_CMD)) {
                ExperimentClusterTableViewer.this.storeCluster();
            } else if (string.equals(ExperimentClusterTableViewer.STORE_SELECTED_ROWS_CMD)) {
                ExperimentClusterTableViewer.this.storeSelectedRowsAsCluster();
            } else if (string.equals(ExperimentClusterTableViewer.SET_DEF_COLOR_CMD)) {
                ExperimentClusterTableViewer.this.onSetDefaultColor();
            } else if (string.equals(ExperimentClusterTableViewer.LAUNCH_NEW_SESSION_CMD)) {
                ExperimentClusterTableViewer.this.launchNewSession();
            } else if (string.equals(ExperimentClusterTableViewer.LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD)) {
                ExperimentClusterTableViewer.this.launchNewSessionWithSelectedRows();
            } else if (string.equals(ExperimentClusterTableViewer.SEARCH_CMD)) {
                ExperimentClusterTableViewer.this.searchTable();
            } else if (string.equals(ExperimentClusterTableViewer.CLEAR_ALL_CMD)) {
                ExperimentClusterTableViewer.this.clusterTable.clearSelection();
            } else if (string.equals(ExperimentClusterTableViewer.SELECT_ALL_CMD)) {
                ExperimentClusterTableViewer.this.clusterTable.selectAll();
            } else if (string.equals(ExperimentClusterTableViewer.SORT_ORIG_ORDER_CMD)) {
                ExperimentClusterTableViewer.this.sortInOrigOrder();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || ExperimentClusterTableViewer.this.getCluster() == null || ExperimentClusterTableViewer.this.getCluster().length == 0) {
                return;
            }
            ExperimentClusterTableViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, String string) {
            this.index = n;
            this.field = string;
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ExperimentClusterTableModel
    extends AbstractTableModel {
        String[] columnNames;

        public ExperimentClusterTableModel() {
            this.columnNames = new String[2 + ExperimentClusterTableViewer.this.auxTitles.length];
            this.columnNames[0] = "Stored Color";
            this.columnNames[1] = "Sample Name";
            for (int i = 2; i < this.columnNames.length; ++i) {
                this.columnNames[i] = ExperimentClusterTableViewer.this.auxTitles[i - 2];
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return ExperimentClusterTableViewer.this.getCluster().length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ExperimentClusterTableViewer.this.data.getExperimentColor(ExperimentClusterTableViewer.this.getSortedCluster()[n]) == null ? Color.white : ExperimentClusterTableViewer.this.data.getExperimentColor(ExperimentClusterTableViewer.this.getSortedCluster()[n]);
            }
            if (n2 == 1) {
                return ExperimentClusterTableViewer.this.data.getFullSampleName(ExperimentClusterTableViewer.this.experiment.getSampleIndex(ExperimentClusterTableViewer.this.getSortedCluster()[n]));
            }
            return String.valueOf(ExperimentClusterTableViewer.this.auxData[ExperimentClusterTableViewer.this.getSortedCluster()[n]][n2 - 2]);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

