/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;

public class TCBKeyFrame {
    public Point3f position;
    public Quat4f quat;
    public Point3f scale;
    public float tension;
    public float continuity;
    public float bias;
    public float knot;
    public int linear;

    TCBKeyFrame() {
        this.bias = 0.0f;
        this.continuity = 0.0f;
        this.tension = 0.0f;
    }

    public TCBKeyFrame(float f, int n, Point3f point3f, Quat4f quat4f, Point3f point3f2, float f2, float f3, float f4) {
        this.knot = f;
        this.linear = n;
        this.position = new Point3f(point3f);
        this.quat = new Quat4f(quat4f);
        this.scale = new Point3f(point3f2);
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame0"));
        }
        if (f4 < -1.0f || f4 > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame1"));
        }
        if (f3 < -1.0f || f3 > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame2"));
        }
        this.tension = f2;
        this.continuity = f3;
        this.bias = f4;
    }

    public TCBKeyFrame(TCBKeyFrame tCBKeyFrame) {
        this(tCBKeyFrame.knot, tCBKeyFrame.linear, tCBKeyFrame.position, tCBKeyFrame.quat, tCBKeyFrame.scale, tCBKeyFrame.tension, tCBKeyFrame.continuity, tCBKeyFrame.bias);
    }

    public void debugPrint(String string) {
        System.out.println("\n" + string);
        System.out.println(" knot = " + this.knot);
        System.out.println(" linear = " + this.linear);
        System.out.println(" position(x,y,z) = " + this.position.x + " " + this.position.y + " " + this.position.z);
        System.out.println(" tension = " + this.tension);
        System.out.println(" continuity = " + this.continuity);
        System.out.println(" bias = " + this.bias);
    }
}

