/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Intersect {
    private static boolean lineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray) {
        Vector3d vector3d2 = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            return false;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - Double.MIN_VALUE || d6 > d11 + Double.MIN_VALUE) {
            return false;
        }
        dArray[0] = d13;
        return true;
    }

    public static boolean pointAndLine(PickPoint pickPoint, Point3d[] point3dArray, int n) {
        if (point3dArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dArray = new double[1];
        Point3d point3d = point3dArray[n++];
        Point3d point3d2 = point3dArray[n];
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickPoint.get(point3d3);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(point3d3, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean pointAndLine(PickPoint pickPoint, Point3f[] point3fArray, int n) {
        if (point3fArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dArray = new double[1];
        Point3d point3d = new Point3d(point3fArray[n++]);
        Point3d point3d2 = new Point3d(point3fArray[n]);
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickPoint.get(point3d3);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(point3d3, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean pointAndPoint(PickPoint pickPoint, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        pickPoint.get(point3d2);
        return point3d2.x == point3d.x && point3d2.y == point3d.y && point3d2.z == point3d.z;
    }

    public static boolean pointAndPoint(PickPoint pickPoint, Point3f point3f) {
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        return (float)point3d.x == point3f.x && (float)point3d.y == point3f.y && (float)point3d.z == point3f.z;
    }

    private static boolean pointAndPoly(Point3d[] point3dArray, PickPoint pickPoint) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        vector3d4.set((Tuple3d)point3d);
        return d - vector3d3.dot(vector3d4) == 0.0;
    }

    private static boolean pointAndQuad(PickPoint pickPoint, Point3d[] point3dArray, int n) {
        if (point3dArray.length - n < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.pointAndPoly(point3dArray2, pickPoint);
    }

    private static boolean pointAndQuad(PickPoint pickPoint, Point3f[] point3fArray, int n) {
        if (point3fArray.length - n < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] point3dArray = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray[n2] = new Point3d(point3fArray[n + n2]);
            ++n2;
        }
        return Intersect.pointAndPoly(point3dArray, pickPoint);
    }

    private static boolean pointAndTriangle(PickPoint pickPoint, Point3d[] point3dArray, int n) {
        if (point3dArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect9"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.pointAndPoly(point3dArray2, pickPoint);
    }

    private static boolean pointAndTriangle(PickPoint pickPoint, Point3f[] point3fArray, int n) {
        if (point3fArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect10"));
        }
        Point3d[] point3dArray = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d(point3fArray[n + n2]);
            ++n2;
        }
        return Intersect.pointAndPoly(point3dArray, pickPoint);
    }

    public static boolean rayAndLine(PickRay pickRay, Point3d[] point3dArray, int n, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3dArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        pickRay.get(point3d, vector3d);
        Point3d point3d2 = point3dArray[n++];
        Point3d point3d3 = point3dArray[n];
        return Intersect.lineAndRay(point3d2, point3d3, point3d, vector3d, dArray);
    }

    public static boolean rayAndLine(PickRay pickRay, Point3f[] point3fArray, int n, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3fArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        pickRay.get(point3d, vector3d);
        Point3d point3d2 = new Point3d(point3fArray[n++]);
        Point3d point3d3 = new Point3d(point3fArray[n]);
        return Intersect.lineAndRay(point3d2, point3d3, point3d, vector3d, dArray);
    }

    public static boolean rayAndPoint(PickRay pickRay, Point3d point3d, double[] dArray) {
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickRay.get(point3d2, vector3d);
        return Intersect.rayAndPoint(point3d, point3d2, vector3d, dArray);
    }

    public static boolean rayAndPoint(PickRay pickRay, Point3f point3f, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickRay.get(point3d, vector3d);
        return Intersect.rayAndPoint(new Point3d(point3f), point3d, vector3d, dArray);
    }

    private static boolean rayAndPoint(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + dArray[0] * vector3d.y) - Double.MIN_VALUE || point3d.y > d + Double.MIN_VALUE)) {
            return false;
        }
        return n >= 2 || !(point3d.z < (d = point3d2.z + dArray[0] * vector3d.z) - Double.MIN_VALUE) && !(point3d.z > d + Double.MIN_VALUE);
    }

    private static boolean rayAndPoly(Point3d[] point3dArray, PickRay pickRay, double[] dArray) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        pickRay.get(point3d, vector3d5);
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        d2 = vector3d3.dot(vector3d5);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        dArray[0] = (d - vector3d3.dot(vector3d4)) / d2;
        if (dArray[0] < 0.0) {
            return false;
        }
        point3d2.x = point3d.x + vector3d5.x * dArray[0];
        point3d2.y = point3d.y + vector3d5.y * dArray[0];
        point3d2.z = point3d.z + vector3d5.z * dArray[0];
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        int n3 = d3 > d4 ? 0 : 1;
        if (n3 == 0) {
            if (d3 < d5) {
                n3 = 2;
            }
        } else if (n3 == 1 && d4 < d5) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray2[n] = point3dArray[n].y - point3d2.y;
                    dArray3[n] = point3dArray[n].z - point3d2.z;
                    break;
                }
                case 1: {
                    dArray2[n] = point3dArray[n].x - point3d2.x;
                    dArray3[n] = point3dArray[n].z - point3d2.z;
                    break;
                }
                case 2: {
                    dArray2[n] = point3dArray[n].x - point3d2.x;
                    dArray3[n] = point3dArray[n].y - point3d2.y;
                    break;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray3[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray3[n2] < 0.0 ? -1 : 1)) {
                double d6;
                if (dArray2[n] > 0.0 && dArray2[n2] > 0.0) {
                    ++n4;
                } else if ((dArray2[n] > 0.0 || dArray2[n2] > 0.0) && (d6 = dArray2[n] - dArray3[n] * (dArray2[n2] - dArray2[n]) / (dArray3[n2] - dArray3[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            dArray[0] = dArray[0] * vector3d5.length();
            return true;
        }
        return false;
    }

    public static boolean rayAndQuad(PickRay pickRay, Point3d[] point3dArray, int n, double[] dArray) {
        if (point3dArray.length - n < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect0"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.rayAndPoly(point3dArray2, pickRay, dArray);
    }

    public static boolean rayAndTriangle(PickRay pickRay, Point3d[] point3dArray, int n, double[] dArray) {
        if (point3dArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.rayAndPoly(point3dArray2, pickRay, dArray);
    }

    public static boolean rayAndTriangle(PickRay pickRay, Point3f[] point3fArray, int n, double[] dArray) {
        if (point3fArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] point3dArray = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d(point3fArray[n + n2]);
            ++n2;
        }
        return Intersect.rayAndPoly(point3dArray, pickRay, dArray);
    }

    public static boolean segmentAndLine(PickSegment pickSegment, Point3d[] point3dArray, int n, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3dArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        Point3d point3d3 = point3dArray[n++];
        Point3d point3d4 = point3dArray[n];
        return Intersect.lineAndRay(point3d3, point3d4, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean segmentAndLine(PickSegment pickSegment, Point3f[] point3fArray, int n, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3fArray.length - n < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        Point3d point3d3 = new Point3d(point3fArray[n++]);
        Point3d point3d4 = new Point3d(point3fArray[n]);
        return Intersect.lineAndRay(point3d3, point3d4, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean segmentAndPoint(PickSegment pickSegment, Point3d point3d, double[] dArray) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickSegment.get(point3d2, point3d3);
        vector3d.x = point3d3.x - point3d2.x;
        vector3d.y = point3d3.y - point3d2.y;
        vector3d.z = point3d3.z - point3d2.z;
        return Intersect.rayAndPoint(point3d, point3d2, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean segmentAndPoint(PickSegment pickSegment, Point3f point3f, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(new Point3d(point3f), point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    private static boolean segmentAndPoly(Point3d[] point3dArray, PickSegment pickSegment, double[] dArray) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        pickSegment.get(point3d, point3d2);
        vector3d5.x = point3d2.x - point3d.x;
        vector3d5.y = point3d2.y - point3d.y;
        vector3d5.z = point3d2.z - point3d.z;
        d2 = vector3d3.dot(vector3d5);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        dArray[0] = (d - vector3d3.dot(vector3d4)) / d2;
        if (dArray[0] < 0.0 || dArray[0] > 1.0) {
            return false;
        }
        point3d3.x = point3d.x + vector3d5.x * dArray[0];
        point3d3.y = point3d.y + vector3d5.y * dArray[0];
        point3d3.z = point3d.z + vector3d5.z * dArray[0];
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        int n3 = d3 > d4 ? 0 : 1;
        if (n3 == 0) {
            if (d3 < d5) {
                n3 = 2;
            }
        } else if (n3 == 1 && d4 < d5) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray2[n] = point3dArray[n].y - point3d3.y;
                    dArray3[n] = point3dArray[n].z - point3d3.z;
                    break;
                }
                case 1: {
                    dArray2[n] = point3dArray[n].x - point3d3.x;
                    dArray3[n] = point3dArray[n].z - point3d3.z;
                    break;
                }
                case 2: {
                    dArray2[n] = point3dArray[n].x - point3d3.x;
                    dArray3[n] = point3dArray[n].y - point3d3.y;
                    break;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray3[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray3[n2] < 0.0 ? -1 : 1)) {
                double d6;
                if (dArray2[n] > 0.0 && dArray2[n2] > 0.0) {
                    ++n4;
                } else if ((dArray2[n] > 0.0 || dArray2[n2] > 0.0) && (d6 = dArray2[n] - dArray3[n] * (dArray2[n2] - dArray2[n]) / (dArray3[n2] - dArray3[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            dArray[0] = dArray[0] * vector3d5.length();
            return true;
        }
        return false;
    }

    public static boolean segmentAndQuad(PickSegment pickSegment, Point3d[] point3dArray, int n, double[] dArray) {
        if (point3dArray.length - n < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.segmentAndPoly(point3dArray2, pickSegment, dArray);
    }

    public static boolean segmentAndQuad(PickSegment pickSegment, Point3f[] point3fArray, int n, double[] dArray) {
        if (point3fArray.length - n < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] point3dArray = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray[n2] = new Point3d(point3fArray[n + n2]);
            ++n2;
        }
        return Intersect.segmentAndPoly(point3dArray, pickSegment, dArray);
    }

    public static boolean segmentAndTriangle(PickSegment pickSegment, Point3d[] point3dArray, int n, double[] dArray) {
        if (point3dArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect5"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray2[n2] = point3dArray[n + n2];
            ++n2;
        }
        return Intersect.segmentAndPoly(point3dArray2, pickSegment, dArray);
    }

    public static boolean segmentAndTriangle(PickSegment pickSegment, Point3f[] point3fArray, int n, double[] dArray) {
        if (point3fArray.length - n < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect6"));
        }
        Point3d[] point3dArray = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d(point3fArray[n + n2]);
            ++n2;
        }
        return Intersect.segmentAndPoly(point3dArray, pickSegment, dArray);
    }
}

