/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;

public class Sphere
extends Primitive {
    public static final int BODY = 0;
    static final int MID_REZ_DIV = 15;
    float radius;
    int divisions;

    public Sphere() {
        this(1.0f, 1, 15);
    }

    public Sphere(float f) {
        this(f, 1, 15);
    }

    public Sphere(float f, int n, int n2) {
        this(f, n, n2, null);
    }

    public Sphere(float f, int n, int n2, Appearance appearance) {
        GeomBuffer geomBuffer;
        Shape3D shape3D;
        this.radius = f;
        this.divisions = n2;
        this.flags = n;
        double d = (this.flags & 4) != 0 ? -1.0 : 1.0;
        double d2 = Math.PI * 2 / (double)n2;
        double d3 = Math.PI / (double)n2;
        double d4 = 0.0;
        double d5 = 1.0 / (double)n2;
        double d6 = 1.0 / (double)n2;
        GeomBuffer geomBuffer2 = this.getCachedGeometry(1, f, 0.0f, 0.0f, n2, 0, n);
        if (geomBuffer2 != null) {
            shape3D = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = new GeomBuffer(n2 * (n2 + 1) * 2);
            int n3 = n2 - 1;
            while (n3 >= 0) {
                double d7 = (double)n3 * d3;
                geomBuffer.begin(1);
                double d8 = 0.0;
                int n4 = 0;
                while (n4 <= n2) {
                    double d9 = n4 == n2 ? 0.0 : (double)n4 * d2;
                    double d10 = -Math.sin(d9) * Math.sin(d7);
                    double d11 = Math.cos(d9) * Math.sin(d7);
                    double d12 = d * Math.cos(d7);
                    geomBuffer.normal3d(d10 * d, d11 * d, d12 * d);
                    geomBuffer.texCoord2d(d8, d4 + d6);
                    geomBuffer.vertex3d(d10 * (double)f, d11 * (double)f, d12 * (double)f);
                    d10 = -Math.sin(d9) * Math.sin(d7 + d3);
                    d11 = Math.cos(d9) * Math.sin(d7 + d3);
                    d12 = d * Math.cos(d7 + d3);
                    geomBuffer.normal3d(d10 * d, d11 * d, d12 * d);
                    geomBuffer.texCoord2d(d8, d4);
                    geomBuffer.vertex3d(d10 * (double)f, d11 * (double)f, d12 * (double)f);
                    d8 += d5;
                    ++n4;
                }
                geomBuffer.end();
                d4 += d6;
                --n3;
            }
            shape3D = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts = geomBuffer.getNumVerts();
            this.numTris = geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(1, f, 0.0f, 0.0f, n2, 0, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3D.setCapability(14);
            shape3D.setCapability(15);
        }
        geomBuffer = new Matrix4d();
        Matrix4d matrix4d = new Matrix4d();
        geomBuffer.setIdentity();
        matrix4d.setIdentity();
        Transform3D transform3D = new Transform3D();
        geomBuffer.rotX(-1.5707963267948966);
        matrix4d.mul(matrix4d, (Matrix4d)geomBuffer);
        transform3D.set(matrix4d);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setTransform(transform3D);
        transformGroup.addChild((Node)shape3D);
        this.addChild((Node)transformGroup);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Sphere(float f, int n, Appearance appearance) {
        this(f, n, 15, appearance);
    }

    public Sphere(float f, Appearance appearance) {
        this(f, 1, 15, appearance);
    }

    public Node cloneNode(boolean bl) {
        Sphere sphere = new Sphere(this.radius, this.flags, this.divisions, this.getAppearance());
        sphere.duplicateNode((Node)this, bl);
        return sphere;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public Shape3D getShape() {
        return (Shape3D)((Group)this.getChild(0)).getChild(0);
    }

    public Shape3D getShape(int n) {
        if (n != 0) {
            return null;
        }
        return (Shape3D)((Group)this.getChild(0)).getChild(0);
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)((Group)this.getChild(0)).getChild(0)).setAppearance(appearance);
    }
}

