/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexVector;
import JSci.maths.DoubleVector;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class IntegerVector
extends MathVector {
    protected static final int ARRAY_1D = 1;
    protected int[] vector;

    protected IntegerVector(int n, int n2) {
        super(n);
        this.storageFormat = n2;
    }

    public IntegerVector(int n) {
        this(n, 1);
        this.vector = new int[n];
    }

    public IntegerVector(int[] nArray) {
        this(nArray.length, 1);
        this.vector = nArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerVector && this.N == ((IntegerVector)object).N) {
            IntegerVector integerVector = (IntegerVector)object;
            int n = 0;
            while (n < this.N) {
                if (this.vector[n] != integerVector.getComponent(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector toDoubleVector() {
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.N) {
            dArray[n] = this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public ComplexVector toComplexVector() {
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.N) {
            dArray[n] = this.vector[n];
            ++n;
        }
        return new ComplexVector(dArray, new double[this.N]);
    }

    public int getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException("Invalid component.");
        }
        this.vector[n] = n2;
    }

    public double norm(int n) {
        double d = Math.pow(this.vector[0], n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(this.vector[n2], n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        int n = this.vector[0] * this.vector[0];
        int n2 = 1;
        while (n2 < this.N) {
            n += this.vector[n2] * this.vector[n2];
            ++n2;
        }
        return Math.sqrt(n);
    }

    public double infNorm() {
        int n = this.vector[0];
        int n2 = 1;
        while (n2 < this.N) {
            if (this.vector[n2] > n) {
                n = this.vector[n2];
            }
            ++n2;
        }
        return n;
    }

    public AbelianGroupMember negate() {
        int[] nArray = new int[this.N];
        nArray[0] = -this.vector[0];
        int n = 1;
        while (n < this.N) {
            nArray[n] = -this.vector[n];
            ++n;
        }
        return new IntegerVector(nArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof IntegerVector) {
            return this.add((IntegerVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerVector add(IntegerVector integerVector) {
        switch (integerVector.storageFormat) {
            case 1: {
                return this.rawAdd(integerVector);
            }
        }
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + integerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] + integerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private IntegerVector rawAdd(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] + integerVector.vector[n];
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof IntegerVector) {
            return this.subtract((IntegerVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerVector subtract(IntegerVector integerVector) {
        switch (integerVector.storageFormat) {
            case 1: {
                return this.rawSubtract(integerVector);
            }
        }
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - integerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] - integerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private IntegerVector rawSubtract(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] - integerVector.vector[n];
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerVector scalarMultiply(int n) {
        int[] nArray = new int[this.N];
        nArray[0] = n * this.vector[0];
        int n2 = 1;
        while (n2 < this.N) {
            nArray[n2] = n * this.vector[n2];
            ++n2;
        }
        return new IntegerVector(nArray);
    }

    public int scalarProduct(IntegerVector integerVector) {
        switch (integerVector.storageFormat) {
            case 1: {
                return this.rawScalarProduct(integerVector);
            }
        }
        if (this.N == integerVector.N) {
            int n = this.vector[0] * integerVector.getComponent(0);
            int n2 = 1;
            while (n2 < this.N) {
                n += this.vector[n2] * integerVector.getComponent(n2);
                ++n2;
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private int rawScalarProduct(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int n = this.vector[0] * integerVector.vector[0];
            int n2 = 1;
            while (n2 < this.N) {
                n += this.vector[n2] * integerVector.vector[n2];
                ++n2;
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

