/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.groups.DiscreteGroup;

public final class DihedralGroup
extends DiscreteGroup {
    private String[] elements;

    public DihedralGroup(int n) {
        super("D" + n);
        this.elements = new String[2 * n];
        this.elements[0] = "e";
        this.elements[1] = "b";
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append('c');
            this.elements[n2 + 1] = stringBuffer.toString();
            this.elements[n2 + n] = 'b' + stringBuffer.toString();
            ++n2;
        }
    }

    public String compose(String string, String string2) {
        if (this.isIdentity(string)) {
            return string2;
        }
        if (this.isIdentity(string2)) {
            return string;
        }
        if (string.equals("b")) {
            if (string2.equals("b")) {
                return this.identity();
            }
            if (string2.charAt(0) == 'b') {
                return string2.substring(1);
            }
            return string + string2;
        }
        if (string2.charAt(0) == 'b') {
            if (string.charAt(0) == 'b') {
                int n = string2.length() - string.length();
                if (n == 0) {
                    return this.identity();
                }
                if (n < 0) {
                    n += this.elements.length / 2;
                }
                return this.elements[1 + n];
            }
            int n = string2.length() - 1 - string.length();
            if (n == 0) {
                return this.elements[1];
            }
            if (n < 0) {
                n += this.elements.length / 2;
            }
            return this.elements[this.elements.length / 2 + n];
        }
        if (string.charAt(0) == 'b') {
            String string3 = string + string2;
            if (string3.length() > this.elements.length / 2) {
                return string3.substring(0, string3.length() - this.elements.length / 2);
            }
            return string3;
        }
        String string4 = string + string2;
        if (string4.length() == this.elements.length / 2) {
            return this.identity();
        }
        if (string4.length() < this.elements.length / 2) {
            return string4;
        }
        return string4.substring(0, string4.length() - this.elements.length / 2);
    }

    public String identity() {
        return this.elements[0];
    }

    public String inverse(String string) {
        if (this.isIdentity(string)) {
            return this.identity();
        }
        if (string.equals("b")) {
            return this.elements[1];
        }
        int n = 2;
        while (n < this.elements.length) {
            if (this.isInverse(string, this.elements[n])) {
                return this.elements[n];
            }
            ++n;
        }
        return null;
    }
}

