/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import java.io.IOException;
import java.io.InputStream;

public final class ChunkyByteArray
extends InputStream {
    private static final int CHUNK_SHIFT = 14;
    private static final int CHUNK_SIZE = 16384;
    private static final int CHUNK_MASK = 16383;
    private static final int INITIAL_CHUNK_COUNT = 64;
    private InputStream fInputStream = null;
    private byte[][] fData = new byte[64][];
    private int fLength = 0;
    private int fOffset = 0;

    public ChunkyByteArray(InputStream is) throws IOException {
        this.fInputStream = is;
        this.fill();
    }

    public int read() throws IOException {
        if (this.fData == null) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.read();
        }
        byte b = this.fData[0][this.fOffset];
        if (++this.fOffset == this.fLength) {
            this.fData = null;
            if (this.fLength < 16384) {
                this.fInputStream = null;
            }
        }
        return b;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesLeft = this.fLength - this.fOffset;
        if (bytesLeft == 0) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.read(buffer, offset, length);
        }
        if (length <= 0) {
            return 0;
        }
        byte[] chunk = this.fData[0];
        if (length >= bytesLeft) {
            length = bytesLeft;
            if (this.fLength < 16384) {
                this.fInputStream = null;
            }
        }
        if (buffer == null) {
            this.fOffset += length;
            return length;
        }
        int stop = offset + length;
        do {
            buffer[offset++] = chunk[this.fOffset++];
        } while (offset < stop);
        return length;
    }

    public void rewind() {
        this.fOffset = 0;
    }

    private void fill() throws IOException {
        int bufnum = this.fLength >> 14;
        byte[] data = new byte[16384];
        this.fData[bufnum] = data;
        int offset = 0;
        int capacity = 16384;
        int result = 0;
        do {
            if ((result = this.fInputStream.read(data, offset, capacity)) == -1) {
                data[offset] = -1;
                this.fInputStream.close();
                this.fInputStream = null;
                return;
            }
            if (result <= 0) continue;
            this.fLength += result;
            offset += result;
            capacity -= result;
        } while (capacity > 0);
    }

    public byte byteAt(int offset) {
        int chunk = offset >> 14;
        int index = offset & 0x3FFF;
        try {
            return this.fData[chunk][index];
        }
        catch (NullPointerException nullPointerException) {
            try {
                if (index == 0) {
                    this.fill();
                    return this.fData[chunk][index];
                }
                return 0;
            }
            catch (IOException iOException) {
                return 0;
            }
        }
    }

    public boolean atEOF(int offset) {
        return offset > this.fLength;
    }

    public void checkEOF(int offset) {
        if (offset > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

