/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.EntityDecl;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.NotationDecl;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;

public final class DefaultEntityPool
implements EntityPool {
    private static final boolean DEBUG_530 = false;
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState = null;
    private StringPool fStringPool = null;
    private int fEntityCount = 0;
    private int[][] fEntityName = new int[32][];
    private int[][] fEntityValue = new int[32][];
    private int[][] fPublicId = new int[32][];
    private int[][] fSystemId = new int[32][];
    private int[][] fNotationName = new int[32][];
    private int fNotationListHead = -1;
    private EntityDecl fInternalEntityDecl = null;

    public DefaultEntityPool(ParserState parserState, boolean createStandardEntities) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        if (createStandardEntities) {
            this.fInternalEntityDecl = new EntityDecl();
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fEntityCount = 0;
        this.fNotationListHead = -1;
        if (this.fInternalEntityDecl != null) {
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    public EntityPool resetOrCopy(ParserState parserState) {
        return new DefaultEntityPool(parserState, this.fInternalEntityDecl != null);
    }

    private void createInternalEntity(String name, String value) {
        this.fInternalEntityDecl.entityName = this.fStringPool.addSymbol(name);
        this.fInternalEntityDecl.entityValue = this.fStringPool.addString(value);
        this.fInternalEntityDecl.publicId = -1;
        this.fInternalEntityDecl.systemId = -1;
        this.fInternalEntityDecl.notationName = -1;
        this.addEntityDecl(this.fInternalEntityDecl);
    }

    private boolean ensureCapacity(int chunk) {
        try {
            return this.fEntityName[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fEntityName, 0, newIntArray, 0, chunk);
            this.fEntityName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fEntityValue, 0, newIntArray, 0, chunk);
            this.fEntityValue = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fPublicId, 0, newIntArray, 0, chunk);
            this.fPublicId = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fSystemId, 0, newIntArray, 0, chunk);
            this.fSystemId = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNotationName, 0, newIntArray, 0, chunk);
            this.fNotationName = newIntArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fEntityName[chunk] = new int[32];
        this.fEntityValue[chunk] = new int[32];
        this.fPublicId[chunk] = new int[32];
        this.fSystemId[chunk] = new int[32];
        this.fNotationName[chunk] = new int[32];
        return true;
    }

    public int addEntityDecl(EntityDecl decl) {
        int chunk = this.fEntityCount >> 5;
        int index = this.fEntityCount & 0x1F;
        this.ensureCapacity(chunk);
        this.fEntityName[chunk][index] = decl.entityName;
        this.fEntityValue[chunk][index] = decl.entityValue;
        this.fPublicId[chunk][index] = decl.publicId;
        this.fSystemId[chunk][index] = decl.systemId;
        this.fNotationName[chunk][index] = decl.notationName;
        int entityIndex = this.fEntityCount++;
        return entityIndex;
    }

    public int addNotationDecl(NotationDecl decl) {
        int index;
        int chunk;
        int nIndex = this.fNotationListHead;
        while (nIndex != -1) {
            chunk = nIndex >> 5;
            index = nIndex & 0x1F;
            if (this.fNotationName[chunk][index] == decl.notationName) {
                return -1;
            }
            nIndex = this.fEntityValue[chunk][index];
        }
        chunk = this.fEntityCount >> 5;
        index = this.fEntityCount & 0x1F;
        this.ensureCapacity(chunk);
        this.fEntityName[chunk][index] = -1;
        this.fEntityValue[chunk][index] = this.fNotationListHead;
        this.fPublicId[chunk][index] = decl.publicId;
        this.fSystemId[chunk][index] = decl.systemId;
        this.fNotationName[chunk][index] = decl.notationName;
        this.fNotationListHead = this.fEntityCount++;
        return this.fNotationListHead;
    }

    public int lookupEntity(int nameIndex) {
        int chunk = 0;
        int index = 0;
        int entityIndex = 0;
        while (entityIndex < this.fEntityCount) {
            if (this.fEntityName[chunk][index] == nameIndex) {
                return entityIndex;
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++entityIndex;
        }
        return -1;
    }

    public boolean isExternal(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fEntityValue[chunk][index] == -1;
    }

    public boolean isUnparsed(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fNotationName[chunk][index] != -1;
    }

    public int getEntityName(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fEntityName[chunk][index];
    }

    public int getEntityValue(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fEntityValue[chunk][index];
    }

    public int getPublicId(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fPublicId[chunk][index];
    }

    public int getSystemId(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fSystemId[chunk][index];
    }

    public int lookupNotation(int nameIndex) {
        int nIndex = this.fNotationListHead;
        while (nIndex != -1) {
            int chunk = nIndex >> 5;
            int index = nIndex & 0x1F;
            if (this.fNotationName[chunk][index] == nameIndex) {
                return nIndex;
            }
            nIndex = this.fEntityValue[chunk][index];
        }
        return -1;
    }

    public int getNotationName(int entityIndex) {
        int chunk = entityIndex >> 5;
        int index = entityIndex & 0x1F;
        return this.fNotationName[chunk][index];
    }

    public void checkUnparsedEntities() throws Exception {
        XMLErrorHandler handler = this.fParserState.getErrorHandler();
        int i = 0;
        while (i < this.fEntityCount) {
            int notationNameIndex;
            int chunk = i >> 5;
            int index = i & 0x1F;
            if (this.fEntityName[chunk][index] != -1 && (notationNameIndex = this.fNotationName[chunk][index]) != -1 && this.lookupNotation(notationNameIndex) == -1) {
                handler.error1(68, notationNameIndex);
            }
            ++i;
        }
    }
}

