/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import java.io.IOException;
import org.xml.sax.Locator;

public final class StringReader
extends XMLReader {
    private StringPool fStringPool = null;
    private XMLDocumentHandler fDocumentHandler = null;
    private XMLErrorHandler fErrorHandler = null;
    private String fData = null;
    private int fEndOffset;
    private boolean oweLeadingSpace = false;
    private boolean oweTrailingSpace = false;

    public StringReader(ParserState parserState, boolean addEnclosingSpaces, Locator locator, int stringIndex) {
        super(parserState, locator.getPublicId(), locator.getSystemId());
        this.fLinefeedCounter = locator.getLineNumber();
        this.fCharacterCounter = locator.getColumnNumber();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fData = this.fStringPool.toString(stringIndex);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        if (addEnclosingSpaces) {
            this.oweLeadingSpace = true;
            this.oweTrailingSpace = true;
        }
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        charArray.append(this.fData.substring(offset, offset + length));
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addString(this.fData.substring(offset, offset + length));
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this.fData.substring(offset, offset + length));
    }

    public int skipOneChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return ++this.fCurrentOffset;
    }

    public int skipAsciiChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return ++this.fCurrentOffset;
    }

    public int skipToChar(char ch) throws IOException {
        if (this.oweLeadingSpace) {
            if (ch == ' ') {
                return this.fCurrentOffset;
            }
            this.oweLeadingSpace = false;
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    if (ch == ' ') {
                        return this.fCurrentOffset;
                    }
                    this.oweTrailingSpace = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (ch == this.fData.charAt(this.fCurrentOffset)) {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public int skipPastChar(char ch) throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            if (ch == ' ') {
                return this.fCurrentOffset;
            }
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    if (ch == ' ') {
                        return this.fCurrentOffset;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (ch == this.fData.charAt(this.fCurrentOffset)) {
                return ++this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public boolean skippedValidChar() throws IOException {
        char ch;
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if ((ch = this.fData.charAt(this.fCurrentOffset++)) < ' ') {
            if (ch == '\t' || ch == '\n' || ch == '\r') {
                return true;
            }
            --this.fCurrentOffset;
            return false;
        }
        if (ch <= '\ud7ff' || ch >= '\ue000' && (ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff')) {
            return true;
        }
        --this.fCurrentOffset;
        return false;
    }

    public boolean lookingAtValidChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch < ' ') {
            return ch == '\t' || ch == '\n' || ch == '\r';
        }
        return ch <= '\ud7ff' || ch >= '\ue000' && (ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int skipInvalidChar(int errorCode) throws Exception {
        int ch;
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            ch = 32;
        } else if (this.fCurrentOffset >= this.fEndOffset) {
            if (!this.oweTrailingSpace) throw new ArrayIndexOutOfBoundsException();
            this.oweTrailingSpace = false;
            ch = 32;
        } else {
            ch = this.fData.charAt(this.fCurrentOffset++);
        }
        switch (errorCode) {
            case 63: 
            case 85: {
                String arg = Integer.toHexString(ch);
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                return this.fCurrentOffset;
            }
            case 80: 
            case 82: 
            case 110: {
                String arg = new Character((char)ch).toString();
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                return this.fCurrentOffset;
            }
            case 43: {
                String arg1 = new Character((char)ch).toString();
                String arg2 = Integer.toHexString(ch);
                this.fErrorHandler.error2(errorCode, this.fStringPool.addString(arg1), this.fStringPool.addString(arg2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char ch) throws IOException {
        if (this.oweLeadingSpace) {
            if (ch == ' ') {
                this.oweLeadingSpace = false;
                return true;
            }
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                if (ch == ' ') {
                    this.oweTrailingSpace = false;
                    return true;
                }
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ch == this.fData.charAt(this.fCurrentOffset)) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public boolean lookingAtChar(char ch) throws IOException {
        if (this.oweLeadingSpace) {
            return ch == ' ';
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return ch == ' ';
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return ch == this.fData.charAt(this.fCurrentOffset);
    }

    public boolean skippedSpace() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace() throws IOException {
        if (this.oweLeadingSpace) {
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public int skipPastSpaces() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            char ch = this.fData.charAt(this.fCurrentOffset);
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public int skipDecimalDigit() {
        if (this.oweLeadingSpace) {
            return -1;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch < '0' || ch > '9') {
            return -1;
        }
        ++this.fCurrentOffset;
        return ch - 48;
    }

    public int skipHexDigit() {
        if (this.oweLeadingSpace) {
            return -1;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch > 'f' || XMLReader.fgAsciiXDigitChar[ch] == 0) {
            return -1;
        }
        ++this.fCurrentOffset;
        return ch - (ch < 'A' ? 48 : (ch < 'a' ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() {
        if (this.oweLeadingSpace) {
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch <= 'z' && XMLReader.fgAsciiAlphaChar[ch] == 1) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    private boolean skippedCharWithFlag(byte flag) {
        if (this.oweLeadingSpace) {
            if ((XMLReader.fgCharFlags[32] & flag) != 0) {
                this.oweLeadingSpace = false;
                return true;
            }
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                if ((XMLReader.fgCharFlags[32] & flag) != 0) {
                    this.oweTrailingSpace = false;
                    return true;
                }
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch < '\u0080' && (XMLReader.fgCharFlags[ch] & flag) != 0) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public final boolean skippedVersionNum() {
        return this.skippedCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() {
        return this.skippedCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if (ch < '\u0080') {
            if ((XMLReader.fgCharFlags[ch] & 4) != 0) {
                ++this.fCurrentOffset;
                return true;
            }
            if (ch == '\n') {
                ++this.fCurrentOffset;
                ++this.fLinefeedCounter;
                return true;
            }
            if (ch == '\r') {
                ++this.fCurrentOffset;
                ++this.fCarriageReturnCounter;
                return true;
            }
        }
        return false;
    }

    public boolean skippedString(char[] s) throws IOException {
        if (this.oweLeadingSpace) {
            return false;
        }
        int offset = this.fCurrentOffset;
        int i = 0;
        while (i < s.length) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.fData.charAt(offset) != s[i]) {
                return false;
            }
            ++offset;
            ++i;
        }
        this.fCurrentOffset = offset;
        return true;
    }

    public int skipPastName(char fastcheck) throws IOException {
        if (this.oweLeadingSpace) {
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        if ((XMLReader.fgCharFlags[ch] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCurrentOffset;
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            ch = this.fData.charAt(this.fCurrentOffset);
            if (fastcheck != ch) continue;
            return this.fCurrentOffset;
        } while ((XMLReader.fgCharFlags[ch] & 0x20) != 0);
        return this.fCurrentOffset;
    }

    public int scanName(char fastcheck, int expectedName) throws IOException {
        int nameOffset = this.fCurrentOffset;
        int nameLength = this.skipPastName(fastcheck) - nameOffset;
        if (nameLength == 0) {
            return -1;
        }
        int nameIndex = this.fStringPool.addSymbol(this.fData.substring(nameOffset, nameOffset + nameLength));
        if (expectedName == -1 || expectedName == nameIndex) {
            return nameIndex;
        }
        return -1;
    }

    public int skipPastNmtoken(char fastcheck) throws IOException {
        if (this.oweLeadingSpace) {
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char ch = this.fData.charAt(this.fCurrentOffset);
        while (fastcheck != ch) {
            if ((XMLReader.fgCharFlags[ch] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            ch = this.fData.charAt(this.fCurrentOffset);
        }
        return this.fCurrentOffset;
    }

    private void callCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        int length = endOffset - offset;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int stringIndex = length == 0 ? 0 : this.fStringPool.addString(this.fData.substring(offset, offset + length));
            this.fDocumentHandler.characters(stringIndex, inCDSect);
            return;
        }
        this.fDocumentHandler.characters(this.fData.toCharArray(), offset, length, inCDSect);
    }

    private void callWSCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        int contentSpecType = this.fParserState.getScanner().getCurrentContentSpecType();
        if (contentSpecType != 4) {
            this.callCharDataHandler(offset, endOffset, inCDSect);
            return;
        }
        int length = endOffset - offset;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int stringIndex = length == 0 ? 0 : this.fStringPool.addString(this.fData.substring(offset, offset + length));
            this.fDocumentHandler.ignorableWhitespace(stringIndex, inCDSect);
            return;
        }
        this.fDocumentHandler.ignorableWhitespace(this.fData.toCharArray(), offset, length, inCDSect);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState scanState) throws Exception {
        byte prop;
        char ch;
        int offset;
        block51: {
            block56: {
                block57: {
                    block55: {
                        block53: {
                            block54: {
                                offset = this.fCurrentOffset;
                                if (this.fCurrentOffset >= this.fEndOffset) {
                                    throw new ArrayIndexOutOfBoundsException();
                                }
                                if ((ch = this.fData.charAt(this.fCurrentOffset++)) >= '\u0080') break block53;
                                prop = XMLReader.fgCharFlags[ch];
                                if ((prop & 8) != 0 || ch == '\n' || ch == '\r') break block54;
                                if (ch == '<') {
                                    if (!scanState.inCDSect) {
                                        return 1;
                                    }
                                    break block51;
                                } else if (ch == '&') {
                                    if (!scanState.inCDSect) {
                                        return 2;
                                    }
                                    break block51;
                                } else {
                                    if (ch != ']') {
                                        --this.fCurrentOffset;
                                        return 4;
                                    }
                                    if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                                        this.fCurrentOffset += 2;
                                        if (!scanState.inCDSect) {
                                            return 3;
                                        }
                                        scanState.inCDSect = false;
                                        return this.scanContent(scanState);
                                    }
                                }
                                break block51;
                            }
                            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') break block51;
                            break block55;
                        }
                        if (ch == '\ufffe' || ch == '\uffff') {
                            --this.fCurrentOffset;
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                            }
                            return 4;
                        }
                        break block51;
                    }
                    do {
                        if (this.fCurrentOffset >= this.fEndOffset) {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(offset, this.fEndOffset, scanState.inCDSect);
                            }
                            throw new ArrayIndexOutOfBoundsException();
                        }
                        if (ch == '\n') {
                            ++this.fLinefeedCounter;
                            continue;
                        }
                        if (ch != '\r') continue;
                        ++this.fCarriageReturnCounter;
                    } while ((ch = this.fData.charAt(this.fCurrentOffset++)) == ' ' || ch == '\t' || ch == '\n' || ch == '\r');
                    if (ch >= '\u0080') break block56;
                    prop = XMLReader.fgCharFlags[ch];
                    if ((prop & 8) != 0) break block51;
                    if (ch != '<') break block57;
                    if (!scanState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                        }
                        return 25;
                    }
                    break block51;
                }
                if (ch == '&') {
                    if (!scanState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                        }
                        return 26;
                    }
                    break block51;
                } else if (ch == ']') {
                    if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                        }
                        this.fCurrentOffset += 2;
                        if (!scanState.inCDSect) {
                            return 27;
                        }
                        scanState.inCDSect = false;
                        return this.scanContent(scanState);
                    }
                    break block51;
                } else {
                    --this.fCurrentOffset;
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                    }
                    return 28;
                }
            }
            if (ch == '\ufffe' || ch == '\uffff') {
                --this.fCurrentOffset;
                if (this.fDocumentHandler != null) {
                    this.callWSCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                }
                return 28;
            }
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(offset, this.fEndOffset, scanState.inCDSect);
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((ch = this.fData.charAt(this.fCurrentOffset++)) >= '\u0080') break;
            prop = XMLReader.fgCharFlags[ch];
            if ((prop & 8) != 0) continue;
            if (ch == '\n') {
                ++this.fLinefeedCounter;
                continue;
            }
            if (ch != '\r') break;
            ++this.fCarriageReturnCounter;
        }
        while (true) {
            block52: {
                block58: {
                    block61: {
                        block60: {
                            block59: {
                                if (ch >= '\u0080') break block58;
                                prop = XMLReader.fgCharFlags[ch];
                                if ((prop & 8) != 0) break block52;
                                if (ch != '<') break block59;
                                if (!scanState.inCDSect) {
                                    if (this.fDocumentHandler != null) {
                                        this.callCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                                    }
                                    return 9;
                                }
                                break block52;
                            }
                            if (ch != '&') break block60;
                            if (!scanState.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                                }
                                return 10;
                            }
                            break block52;
                        }
                        if (ch != '\n') break block61;
                        ++this.fLinefeedCounter;
                        break block52;
                    }
                    if (ch == '\r') {
                        ++this.fCarriageReturnCounter;
                        break block52;
                    } else if (ch == ']') {
                        if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(offset, this.fCurrentOffset - 1, scanState.inCDSect);
                            }
                            this.fCurrentOffset += 2;
                            if (!scanState.inCDSect) {
                                return 11;
                            }
                            scanState.inCDSect = false;
                            return this.scanContent(scanState);
                        }
                        break block52;
                    } else {
                        --this.fCurrentOffset;
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                        }
                        return 12;
                    }
                }
                if (ch == '\ufffe' || ch == '\uffff') {
                    --this.fCurrentOffset;
                    if (this.fDocumentHandler != null) {
                        this.callCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                    }
                    return 12;
                }
            }
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(offset, this.fCurrentOffset, scanState.inCDSect);
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            ch = this.fData.charAt(this.fCurrentOffset++);
        }
    }
}

