/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.VectorEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FastVector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public FastVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public FastVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public FastVector() {
        this(10);
    }

    public Vector toVector() {
        Vector<Object> jv = new Vector<Object>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            jv.addElement(this.elementData[i]);
        }
        return jv;
    }

    public FastVector(Vector jv) {
        this();
        if (jv != null) {
            for (int i = 0; i < jv.size(); ++i) {
                this.addElement(jv.elementAt(i));
            }
        }
    }

    public Object itemAt(int index) {
        return this.elementAt(index);
    }

    public void addItem(Object item) {
        this.addElement(item);
    }

    public final void copyInto(Object[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            Object[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(Object elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(Object elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(Object obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final void addElement(Object obj) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public final boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        try {
            FastVector v = (FastVector)super.clone();
            v.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    public final String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

