/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqWriter;
import iubio.readseq.FeatureItem;
import iubio.readseq.SeqFileInfo;
import java.util.Hashtable;
import java.util.Vector;

public class BioseqRecord
extends SeqFileInfo {
    SeqInfo seqinfo;
    long checksum;
    String mytitle;

    public BioseqRecord() {
    }

    public BioseqRecord(Bioseq seq, BioseqDocImpl seqdoc) {
        this.set(seq, seqdoc, null);
    }

    public BioseqRecord(Bioseq seq, BioseqDocImpl seqdoc, String seqid) {
        this.set(seq, seqdoc, seqid);
    }

    public BioseqRecord(SeqFileInfo si) {
        this.set(si.seq, si.seqdoc, si.seqid);
        this.offset = si.offset;
        this.seqlen = si.seqlen;
    }

    public void set(Object seqob, Object docob, String id) {
        String did;
        this.offset = 0;
        this.seqid = id;
        this.seqdoc = docob instanceof BioseqDocImpl ? (BioseqDocImpl)docob : null;
        if (seqob == null) {
            this.seq = null;
        } else if (seqob instanceof Bioseq) {
            this.seq = (Bioseq)seqob;
        } else if (seqob instanceof byte[]) {
            Bioseq bs = new Bioseq();
            bs.setbases((byte[])seqob);
            this.seq = bs;
        } else {
            this.seq = new Bioseq(seqob);
        }
        int n = this.seqlen = this.seq != null ? this.getseq().length() : 0;
        if (this.hasdoc() && (this.seqid == null || this.seqid.startsWith(gBlankSeqid)) && (did = this.getdoc().getID()) != null) {
            this.seqid = did;
        }
        if (this.seqid == null || this.seqid.equals(gBlankSeqid)) {
            this.seqid = BioseqRecord.getNextBlankID();
        }
    }

    public long getChecksum() {
        if (this.seqinfo == null && this.hasseq()) {
            this.seqinfo = this.getseq().getSeqStats();
            this.checksum = this.seqinfo.getChecksum();
        }
        return this.checksum;
    }

    public String getTitle() {
        if (this.mytitle == null && this.hasdoc()) {
            this.mytitle = this.getdoc().getTitle();
        }
        return this.mytitle;
    }

    public final Bioseq getseq() {
        return (Bioseq)this.seq;
    }

    public final BioseqDocImpl getdoc() {
        return (BioseqDocImpl)this.seqdoc;
    }

    public void clear() {
        if (this.seq instanceof Bioseq) {
            ((Bioseq)this.seq).clear();
        }
        if (this.seqdoc instanceof BioseqDocImpl) {
            ((BioseqDocImpl)this.seqdoc).clear();
        }
        super.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": id=");
        sb.append(this.seqid);
        sb.append(", length=");
        sb.append(this.seqlen);
        if (this.hasdoc()) {
            sb.append(", title=\"");
            sb.append(this.getdoc().getTitle());
            sb.append('\"');
            if (this.getdoc().hasDocument()) {
                sb.append(", n.docitems=");
                sb.append(this.getdoc().documents().size());
            }
            if (this.getdoc().hasFeatures()) {
                sb.append(", n.features=");
                sb.append(this.getdoc().features().size());
            }
        }
        return sb.toString();
    }

    public SeqFileInfo getSeqFileInfo() {
        SeqFileInfo sfi = new SeqFileInfo();
        this.copyTo(sfi);
        return sfi;
    }

    public void copyTo(SeqFileInfo si) {
        si.seqlen = this.seqlen;
        si.offset = this.offset;
        si.seq = this.seq;
        si.seqdoc = this.seqdoc;
        si.seqid = this.seqid;
    }

    public Object clone() {
        BioseqRecord bsr = (BioseqRecord)super.clone();
        return bsr;
    }

    public final FeatureItem[] findFeatures(String feature) {
        return this.findFeatures(new String[]{feature});
    }

    public final FeatureItem[] findFeatures(String[] features2) {
        Hashtable<String, String> feath = new Hashtable<String, String>();
        for (int i = 0; i < features2.length; ++i) {
            feath.put(features2[i], "true");
        }
        return this.findFeatures(feath, null);
    }

    public final FeatureItem[] findFeatures(Hashtable wantfeatures) {
        return this.findFeatures(wantfeatures, null);
    }

    public final FeatureItem[] findFeatures(SeqRange wantrange) {
        return this.hasdoc() ? this.getdoc().findFeatures(wantrange) : null;
    }

    public FeatureItem[] findFeatures(Hashtable wantfeatures, SeqRange wantrange) {
        if ((wantfeatures != null || wantrange != null) && this.hasdoc()) {
            if (wantfeatures == null) {
                return this.getdoc().findFeatures(wantrange);
            }
            Vector v = new Vector();
            v = this.getdoc().findFeatures(wantfeatures, wantrange, v);
            if (v.isEmpty()) {
                return null;
            }
            Object[] fs = new FeatureItem[v.size()];
            v.copyInto(fs);
            return fs;
        }
        return null;
    }

    public final Bioseq extractFeatureBases(FeatureItem feature) throws SeqRangeException {
        return this.extractBases(feature.getLocation());
    }

    public final Bioseq extractFeatureBases(Hashtable wantfeatures) throws SeqRangeException {
        return this.extractRemoveFeatureBases(true, wantfeatures, null);
    }

    public final Bioseq extractFeatureBases(Hashtable wantfeatures, SeqRange wantrange) throws SeqRangeException {
        return this.extractRemoveFeatureBases(true, wantfeatures, wantrange);
    }

    public final Bioseq removeFeatureBases(Hashtable wantfeatures) throws SeqRangeException {
        return this.extractRemoveFeatureBases(false, wantfeatures, null);
    }

    public final Bioseq removeFeatureBases(Hashtable wantfeatures, SeqRange wantrange) throws SeqRangeException {
        return this.extractRemoveFeatureBases(false, wantfeatures, wantrange);
    }

    public Bioseq extractRemoveFeatureBases(boolean extract, Hashtable wantfeatures, SeqRange wantrange) throws SeqRangeException {
        if (wantfeatures != null && this.hasdoc()) {
            this.getdoc().setWantedFeatures(extract, wantfeatures, wantrange);
            SeqRange featsr = this.getdoc().getFeatureRanges(0, this.seqlen);
            Bioseq bseq = this.extractBases(featsr);
            this.getdoc().setWantedFeatures(extract, null, null);
            return bseq;
        }
        return null;
    }

    public Bioseq extractBases(SeqRange range) throws SeqRangeException {
        return BioseqWriter.extractBioseqBases(this.getseq(), range, this.seqlen, this.seqid);
    }
}

