/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.OpenString;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.DocItem;
import iubio.readseq.OutBiobase;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.WriteseqOpts;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class BioseqWriter
implements BioseqWriterIface {
    public static boolean gJavaChecksum = true;
    public static boolean gShortChecksum = false;
    public static Checksum summer;
    public static String kNocountsymbols;
    protected Writer outs;
    protected Writer douts;
    protected String lineSeparator;
    protected int formatId;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected Bioseq bioseq;
    protected Object seqdoc;
    protected Hashtable exfeatures;
    protected SeqRange featSubrange;
    protected static final int kSpaceAll = -9;
    private static final int kMaxseqwidth = 2048;
    protected WriteseqOpts opts = new WriteseqOpts();
    protected int l1 = 0;
    protected int linesout = 0;
    protected String nocountsymbols;
    protected long checksum = 0L;
    public static long checksumTotal;
    protected int fBasePart = 0;
    protected boolean dochecksum;
    protected String checksumtype;
    protected boolean doReverse;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected OutBiobaseIntf testbase = new OutBiobase(null);
    protected int testbaseKind = 3;
    protected int err;
    public static long checksumTime;

    public boolean getChecksum() {
        return this.dochecksum;
    }

    public void setChecksum(boolean turnon) {
        this.dochecksum = turnon;
    }

    public void setChecksum(boolean turnon, String checktype) {
        this.dochecksum = turnon;
        this.checksumtype = checktype;
    }

    public boolean getReverseComplement() {
        return this.doReverse;
    }

    public void setReverseComplement(boolean turnon) {
        this.doReverse = turnon;
    }

    public BioseqWriter() {
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void setOpts(WriteseqOpts newopts) {
        if (newopts != null) {
            this.opts = newopts;
        }
    }

    public WriteseqOpts getOpts() {
        return this.opts;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int id) {
        this.formatId = id;
    }

    public Writer getOutput() {
        return this.outs;
    }

    public final void setOutput(OutputStream outs) {
        this.setOutput(new OutputStreamWriter(outs));
    }

    public void setOutput(Writer outs) {
        this.outs = outs;
        this.douts = outs;
        this.err = 0;
    }

    public void close() throws IOException {
        this.outs.close();
    }

    public void setOutputTranslation(OutBiobaseIntf tester) {
        this.testbase = tester;
        this.testbaseKind = tester == null ? 3 : 1;
    }

    public OutBiobaseIntf getOutputTranslation() {
        if (this.testbaseKind == 1) {
            return this.testbase;
        }
        return null;
    }

    protected int seqLen() {
        return this.seqlen;
    }

    protected int getNseq() {
        return this.nseq;
    }

    public void setNseq(int nsequences) {
        this.nseq = nsequences;
    }

    public void writeHeader() throws IOException {
        if (this.douts == null) {
            throw new FileNotFoundException();
        }
        checksumTotal = 0L;
        this.nseq = 0;
    }

    public void writeTrailer() {
        try {
            this.douts.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDoc() {
    }

    public void writeSeq() {
        this.writeLoop();
    }

    public void writeSeqEnd() {
    }

    public void writeRecordEnd() {
        this.writeln();
    }

    public void writeRecordStart() {
        ++this.atseq;
        ++this.nseq;
        this.linesout = 0;
        this.l1 = 0;
        this.checksum = 0L;
        this.opts.numwidth = Fmt.fmt(this.seqlen).length() + 1;
    }

    public void writeSeqRecord() throws IOException {
        if (this.testbaseKind == 1) {
            this.testbase.outSeqChar(-1);
        }
        this.writeRecordStart();
        this.writePostInit();
        this.writeDoc();
        this.writeSeq();
        this.writeRecordEnd();
    }

    public void setFeatureExtraction(Hashtable featurelist) {
        this.exfeatures = featurelist;
    }

    public void setFeatureSubrange(SeqRange extractSubrange) {
        this.featSubrange = extractSubrange;
    }

    public boolean wantsDocument() {
        if (this.exfeatures != null) {
            return true;
        }
        BioseqFormat wrformat = BioseqFormats.bioseqFormat(this.formatID());
        return wrformat.hasdoc();
    }

    public boolean setMask(SeqFileInfo si, String masktag) {
        int bpart = 0;
        if (si.ismask) {
            bpart = 0;
        } else if (si.hasmask) {
            bpart = 3;
        } else {
            return false;
        }
        masktag = si.seqid.toString() + masktag;
        return this.setSeq(si.seq, si.offset, si.seqlen, masktag, si.seqdoc, si.atseq, bpart);
    }

    public boolean setSeq(SeqFileInfo si) {
        if (si.ismask) {
            return false;
        }
        return this.setSeq(si.seq, si.offset, si.seqlen, si.seqid, si.seqdoc, si.atseq, 0);
    }

    public boolean setSeq(Object seqob, int offset, int length, String seqname, Object seqdoc, int atseq, int basepart) {
        if ((length < 1 || seqob == null) && seqdoc != null) {
            seqob = new byte[]{78};
            length = 1;
        }
        this.seqlen = length;
        if (length > 0 && seqob != null) {
            if (seqob instanceof Bioseq) {
                this.bioseq = (Bioseq)seqob;
            } else if (seqob instanceof byte[]) {
                this.bioseq = new Bioseq();
                this.bioseq.setbases((byte[])seqob);
            }
            this.atseq = atseq;
            this.offset = offset;
            this.seqdoc = seqdoc;
            this.setSeqName(seqname);
            this.setSeqPart(basepart);
            if (this.exfeatures != null && seqdoc instanceof BioseqDocImpl) {
                BioseqDocImpl bdi = (BioseqDocImpl)seqdoc;
                bdi.setWantedFeatures(this.exfeatures);
                SeqRange featsr = bdi.getFeatureRanges(offset, this.seqlen);
                if (this.featSubrange != null && !this.featSubrange.isEmpty()) {
                    featsr = featsr.subrange(this.featSubrange);
                }
                if (this.extractBases(featsr)) {
                    bdi.replaceDocItem(112, new DocItem("length", String.valueOf(this.seqlen), 112, 1));
                }
            } else if (this.doReverse) {
                this.bioseq.reverseComplement(offset, this.seqlen);
                if (seqdoc instanceof BioseqDocImpl) {
                    BioseqDocImpl bdi = (BioseqDocImpl)seqdoc;
                    bdi.addComment("NOTE:  This is reverse-complement of original sequence.");
                }
            }
        }
        return this.seqlen > 0;
    }

    public static Bioseq extractBioseqBases(Bioseq inseq, SeqRange range, int seqlen, String seqid) throws SeqRangeException {
        int seqstart;
        if (range == null) {
            throw new SeqRangeException("Null SeqRange");
        }
        int totlen = 0;
        int seqend = seqstart = range.start();
        for (SeqRange sr = range; sr != null; sr = sr.next()) {
            totlen += sr.nbases();
            int srb = sr.start();
            int sre = sr.stop();
            if (srb < seqstart) {
                seqstart = srb;
            }
            if (sre <= seqend) continue;
            seqend = sre;
        }
        int totbyterange = seqend - seqstart + 1;
        if (totlen <= 0) {
            throw new SeqRangeException("Empty SeqRange");
        }
        int blen = 0;
        byte[] ba = new byte[totlen];
        byte[] bases = null;
        if (inseq.isBytes()) {
            seqstart = 0;
            bases = inseq.toBytes();
        } else {
            bases = inseq.toBytes(seqstart, totbyterange, 0);
        }
        int seqkind = bases == null ? 0 : Bioseq.getSeqtype(bases, 0, bases.length);
        boolean isamino = seqkind == 4;
        boolean isrna = seqkind == 2;
        boolean mainrevcomp = range.isComplement();
        boolean isfirst = true;
        StringBuffer msg = new StringBuffer("extractBioseqBases - Bad range ");
        for (SeqRange sr = range; sr != null; sr = sr.next()) {
            int start = sr.start();
            int len = sr.nbases();
            boolean err = false;
            if ((start -= seqstart) < 0) {
                err = true;
                msg.append(start).append(" start<0");
                start = 0;
            } else if (start + len > seqlen) {
                err = true;
                msg.append(start + len).append(" end>").append(seqlen);
                len = Math.max(0, seqlen - start);
            } else if (blen + len > totlen) {
                err = true;
                msg.append(blen + len).append("  size>").append(totlen);
                len = Math.max(0, totlen - start);
            } else {
                err = false;
            }
            if (err) {
                msg.append(" of sr=").append(sr).append(" in r=").append(range);
                msg.append(", record=").append(seqid);
                throw new SeqRangeException(msg.toString());
            }
            int bastart = blen;
            int baend = blen + len - 1;
            boolean isreversed = false;
            int srop = sr.oper2(isfirst);
            if (srop < 5) {
                boolean bl = isreversed = srop == 1;
            }
            if (mainrevcomp) {
                isreversed = !isreversed;
                bastart = totlen - blen - len;
            }
            baend = bastart + len - 1;
            if (isreversed) {
                int i;
                if (isamino) {
                    for (i = 0; i < len; ++i) {
                        ba[baend - i] = bases[start + i];
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        ba[baend - i] = BaseKind.nucleicComplement(bases[start + i], isrna);
                    }
                }
            } else {
                System.arraycopy(bases, start, ba, bastart, len);
            }
            blen += len;
            isfirst = false;
        }
        Bioseq newseq = new Bioseq();
        newseq.setbases(ba);
        return newseq;
    }

    protected boolean extractBases(SeqRange range) {
        try {
            Bioseq outseq = BioseqWriter.extractBioseqBases(this.bioseq, range, this.seqlen, this.seqid);
            this.seqlen = outseq.length();
            this.bioseq = outseq;
            return true;
        }
        catch (SeqRangeException sre) {
            System.err.println(sre);
            return false;
        }
    }

    public void setSeqName(String name) {
        int i;
        if (name == null) {
            return;
        }
        if (name.equals(SeqFileInfo.gBlankSeqid)) {
            name = SeqFileInfo.getNextBlankID();
        }
        this.seqid = name;
        this.seqid = this.seqid.trim();
        if (this.seqid.indexOf("checksum") > 0 && (i = this.seqid.indexOf("bases")) > 0) {
            while (i > 0 && this.seqid.charAt(i) != ',') {
                --i;
            }
            if (i > 0) {
                this.seqid = this.seqid.substring(0, i);
            }
        }
        if ((i = this.seqid.indexOf(32)) <= 0) {
            this.idword = this.seqid;
        } else {
            if (i > 30) {
                i = 30;
            }
            this.idword = this.seqid.substring(0, i);
        }
    }

    public void setSeqPart(int basepart) {
        this.fBasePart = basepart;
    }

    protected void writePostInit() {
        if (this.dochecksum && this.checksum == 0L) {
            this.checksum = this.calculateChecksum();
        }
        this.nocountsymbols = kNocountsymbols;
        if (this.opts.baseonlynum) {
            if (this.nocountsymbols.indexOf(this.opts.gapchar) < 0) {
                this.nocountsymbols = this.nocountsymbols + String.valueOf(this.opts.gapchar);
            }
            if (this.opts.domatch && this.nocountsymbols.indexOf(this.opts.matchchar) > 0) {
                this.nocountsymbols = this.nocountsymbols.replace(this.opts.matchchar, ' ');
            }
        }
    }

    protected void writeLoop() {
        int spacen = this.opts.spacer;
        if (spacen > 0) {
            ++spacen;
        }
        int bioseqlen = this.offset + this.seqlen;
        if (this.bioseq != null) {
            bioseqlen = Math.min(bioseqlen, this.bioseq.length());
        }
        int wseqlen = this.seqlen;
        if (this.opts.numline > 0 && wseqlen == 0) {
            wseqlen = this.opts.seqwidth;
        }
        this.opts.seqwidth = Math.min(this.opts.seqwidth, 2048);
        char[] bs = new char[2048];
        if (this.testbaseKind == 1) {
            this.testbase.outSeqChar(-1);
        }
        int i = 0;
        int bufl = 0;
        int ibase = 0;
        while (i < wseqlen) {
            int ib;
            if (this.l1 < 0) {
                this.l1 = 0;
            } else if (this.l1 == 0) {
                if (this.opts.nameleft) {
                    if (this.opts.numline > 0) {
                        this.writeString(Fmt.fmt("", this.opts.namewidth, 0));
                    } else {
                        this.writeString(Fmt.fmt(this.idword, this.opts.namewidth, this.opts.nameflags));
                    }
                }
                if (this.opts.numleft) {
                    if (this.opts.nameleft) {
                        this.writeByte(32);
                    }
                    if (this.opts.numline > 0) {
                        this.writeString(Fmt.fmt("", this.opts.numwidth, 0));
                    } else {
                        ib = this.opts.reversed ? this.opts.origin - ibase : ibase + this.opts.origin;
                        this.writeString(Fmt.fmt(ib, this.opts.numwidth, this.opts.numflags));
                    }
                }
                for (int j = 0; j < this.opts.tab; ++j) {
                    this.writeByte(32);
                }
            }
            ++this.l1;
            if (this.opts.numline > 0) {
                if (spacen == -9 || spacen != 0 && (bufl + 1) % spacen == 1) {
                    if (this.opts.numline == 1) {
                        this.writeByte(32);
                    }
                    bs[bufl++] = 32;
                }
                if (this.l1 % 10 == 1 || this.l1 == this.opts.seqwidth) {
                    if (this.opts.numline == 1) {
                        this.writeString(Fmt.fmt(this.offset + i + 1, 10, 2));
                    }
                    bs[bufl++] = 124;
                } else {
                    bs[bufl++] = 32;
                }
                ++i;
            } else {
                if (spacen == -9 || spacen != 0 && (bufl + 1) % spacen == 1) {
                    bs[bufl++] = 32;
                }
                char bc = this.offset + i >= bioseqlen ? BaseKind.indelEdge : this.bioseq.base(this.offset + i, this.fBasePart);
                ++i;
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc > '\u0000') {
                    bs[bufl++] = bc;
                    if (!this.opts.baseonlynum) {
                        ++ibase;
                    } else if (this.nocountsymbols.indexOf(bc) < 0) {
                        ++ibase;
                    }
                }
            }
            if (this.l1 != this.opts.seqwidth && i != wseqlen) continue;
            if (this.opts.blankpad) {
                while (this.l1 < this.opts.seqwidth) {
                    if (spacen == -9 || spacen != 0 && (bufl + 1) % spacen == 1) {
                        bs[bufl++] = 32;
                    }
                    bs[bufl++] = 32;
                    ++this.l1;
                }
            }
            int buflen = bufl;
            bufl = 0;
            this.l1 = 0;
            if (this.opts.numline > 0) {
                if (this.opts.numline == 2) {
                    this.writeByteArray(bs, 0, buflen);
                }
            } else {
                this.writeByteArray(bs, 0, buflen);
                if (this.opts.numright || this.opts.nameright) {
                    this.writeByte(32);
                }
                if (this.opts.numright) {
                    ib = this.opts.reversed ? this.opts.origin - ibase + 1 : ibase + this.opts.origin - 1;
                    this.writeString(Fmt.fmt(ib, this.opts.numwidth, 0));
                    if (this.opts.nameright) {
                        this.writeByte(32);
                    }
                }
                if (this.opts.nameright) {
                    this.writeString(Fmt.fmt(this.idword, this.opts.namewidth, 2));
                }
                if (i == wseqlen) {
                    this.writeSeqEnd();
                }
            }
            this.writeln();
        }
    }

    public int getError() {
        return this.err;
    }

    protected void writeString(String s) {
        try {
            this.douts.write(s);
        }
        catch (IOException ex) {
            ++this.err;
        }
    }

    protected void writeString(OpenString s) {
        try {
            this.douts.write(s.toString());
        }
        catch (IOException ex) {
            ++this.err;
        }
    }

    protected void writeByteArray(char[] ba, int offset, int len) {
        try {
            this.douts.write(ba, offset, len);
        }
        catch (IOException ex) {
            ++this.err;
        }
    }

    protected void writeByte(int c) {
        try {
            this.douts.write(c);
        }
        catch (IOException ex) {
            ++this.err;
        }
    }

    protected void writeln() {
        this.writeString(this.lineSeparator);
        ++this.linesout;
    }

    protected final void writeln(String s) {
        this.writeString(s);
        this.writeln();
    }

    protected final void writeln(OpenString s) {
        this.writeString(s);
        this.writeln();
    }

    protected long calculateChecksum() {
        if (this.checksumtype != null) {
            if (this.checksumtype.equalsIgnoreCase("CRC32")) {
                gJavaChecksum = true;
                summer = new CRC32();
            } else if (this.checksumtype.equalsIgnoreCase("Adler32")) {
                gJavaChecksum = true;
                summer = new Adler32();
            } else if (this.checksumtype.equalsIgnoreCase("GCG")) {
                gShortChecksum = true;
                gJavaChecksum = false;
            } else if (this.checksumtype.equalsIgnoreCase("CRC")) {
                gShortChecksum = false;
                gJavaChecksum = false;
            }
        }
        if (gJavaChecksum && summer == null) {
            summer = new Adler32();
        }
        return BioseqWriter.calculateChecksum(this.bioseq, this.offset, this.seqlen, summer);
    }

    protected String checksumString() {
        if (this.checksum == 0L) {
            return "";
        }
        return new String(Fmt.fmt(this.checksum, 0, 4).toUpperCase() + " checksum");
    }

    public static long calculateChecksum(Bioseq seq, int offset, int seqlen, Checksum summer) {
        long tstart = System.currentTimeMillis();
        long ckv = gJavaChecksum ? BioseqWriter.ZipChecksum(seq, offset, seqlen, summer) : (gShortChecksum ? BioseqWriter.GCGchecksum(seq, offset, seqlen) : BioseqWriter.CRC32checksum(seq, offset, seqlen));
        checksumTime += System.currentTimeMillis() - tstart;
        return ckv;
    }

    public static long ZipChecksum(Bioseq seq, int offset, int seqlen, Checksum summer) {
        byte[] ba = seq.toBytes(offset, seqlen, 0);
        if (summer == null) {
            summer = new Adler32();
        }
        summer.reset();
        for (int i = 0; i < ba.length; ++i) {
            byte b = ba[i];
            if (b >= 97 && b <= 122) {
                b = (byte)(b - 32);
            }
            summer.update(b);
        }
        long c = summer.getValue();
        checksumTotal += c;
        return c;
    }

    public static long CRC32checksum(Bioseq seq, int offset, int seqlen) {
        long c = 0xFFFFFFFFL;
        if (seq.isBytes()) {
            byte[] ba = seq.toBytes();
            for (int i = 0; i < seqlen; ++i) {
                byte b = ba[i + offset];
                if (b >= 97 && b <= 122) {
                    b = (byte)(b - 32);
                }
                c = BaseKind.crctab[((int)c ^ b) & 0xFF] ^ c >> 8;
            }
        } else {
            for (int i = 0; i < seqlen; ++i) {
                byte b = seq.basebyte(offset + i);
                if (b >= 97 && b <= 122) {
                    b = (byte)(b - 32);
                }
                c = BaseKind.crctab[((int)c ^ b) & 0xFF] ^ c >> 8;
            }
        }
        checksumTotal += (c ^= 0xFFFFFFFFL);
        return c;
    }

    public static long GCGchecksum(Bioseq seq, int offset, int seqlen) {
        int check = 0;
        int count = 0;
        if (seq.isBytes()) {
            byte[] ba = seq.toBytes();
            for (int i = 0; i < seqlen; ++i) {
                byte b = ba[i + offset];
                if (b >= 97 && b <= 122) {
                    b = (byte)(b - 32);
                }
                check += ++count * b;
                if (count != 57) continue;
                count = 0;
            }
        } else {
            for (int i = 0; i < seqlen; ++i) {
                byte b = seq.basebyte(offset + i);
                if (b >= 97 && b <= 122) {
                    b = (byte)(b - 32);
                }
                check += ++count * b;
                if (count != 57) continue;
                count = 0;
            }
        }
        checksumTotal += (long)(check %= 10000);
        checksumTotal %= 10000L;
        return check;
    }

    static {
        kNocountsymbols = "_.-?";
    }
}

