/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.GcgOutBase;
import java.text.SimpleDateFormat;
import java.util.Date;

class GcgSeqWriter
extends BioseqWriter {
    protected String datestr;

    GcgSeqWriter() {
    }

    protected long calculateChecksum() {
        return GcgSeqWriter.GCGchecksum(this.bioseq, this.offset, this.seqlen);
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.setChecksum(true);
        this.setOutputTranslation(new GcgOutBase(this.getOutputTranslation()));
        this.opts.spacer = 10;
        this.opts.numleft = true;
    }

    public void writeDoc() {
        String title;
        this.writeln(this.seqid);
        if (this.seqdoc instanceof BioseqDoc && (title = ((BioseqDoc)this.seqdoc).getTitle()) != null) {
            this.writeln(title);
        }
        if (this.datestr == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy  HH:mm");
            this.datestr = sdf.format(new Date());
        }
        this.writeString("    " + this.idword + "  Length: " + this.seqlen);
        this.writeln("  " + this.datestr + "  Check: " + this.checksum + "  ..");
    }
}

