/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

public class SeqFileInfo
implements Cloneable {
    public static String gBlankSeqid = "nameless";
    public static String gMaskName = "#Mask";
    public static boolean gWriteMask = true;
    public static int gBlanknum = 0;
    public int format;
    public int skiplines;
    public int err;
    public int atseq;
    public int nseq;
    public long modtime;
    public int seqlen;
    public int offset;
    public boolean ismask = false;
    public boolean hasmask = false;
    public Object seq;
    public Object seqdoc;
    public String seqid = gBlankSeqid;
    public Object extradata;

    public SeqFileInfo() {
    }

    public SeqFileInfo(Object seq, int offset, int seqlen) {
        this.seq = seq;
        this.offset = offset;
        this.seqlen = seqlen;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": id=");
        sb.append(this.seqid);
        sb.append(", length=");
        sb.append(this.seqlen);
        sb.append(", hasdoc=");
        sb.append(this.hasdoc());
        return sb.toString();
    }

    public final int length() {
        return this.seqlen;
    }

    public void setlength(int len) {
        this.seqlen = len;
    }

    public final int offset() {
        return this.offset;
    }

    public void setoffset(int off) {
        this.offset = off;
    }

    public final Object getseqObject() {
        return this.seq;
    }

    public void setseq(Object seq) {
        this.seq = seq;
    }

    public final Object getdocObject() {
        return this.seqdoc;
    }

    public void setdoc(Object doc) {
        this.seqdoc = doc;
    }

    public final Object getextraObject() {
        return this.extradata;
    }

    public void setextra(Object doc) {
        this.extradata = doc;
    }

    public final boolean hasseq() {
        return this.seq != null && this.seqlen > 0;
    }

    public final boolean hasdoc() {
        return this.seqdoc != null;
    }

    public final boolean hasid() {
        return this.seqid != null && this.seqid.length() > 0 && !this.seqid.startsWith(gBlankSeqid);
    }

    public final boolean hasmask() {
        return this.ismask || this.hasmask;
    }

    public final String getID() {
        return this.seqid;
    }

    public final void setSeqID(String seqid) {
        this.seqid = seqid;
        this.checkSeqID();
    }

    public void clear() {
        this.seq = null;
        this.seqdoc = null;
        this.extradata = null;
    }

    public void checkSeqID() {
        this.ismask = false;
        String sid = this.seqid;
        if (sid != null && sid.length() > 0) {
            int at = sid.indexOf(gMaskName);
            if (at > 0) {
                this.ismask = true;
                sid = sid.substring(0, at);
            }
            this.seqid = SeqFileInfo.cleanSeqID(sid);
        }
    }

    public static String getNextBlankID() {
        return gBlankSeqid + "_" + String.valueOf(++gBlanknum);
    }

    public static String getNextBlankID(String id) {
        return id + "_" + String.valueOf(++gBlanknum);
    }

    public static String cleanSeqID(String s) {
        int i = (s = s.trim()).indexOf(32);
        if (i > 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf(44)) > 0) {
            s = s.substring(0, i);
        }
        s = s.replace('\n', '_').replace('\r', '_').replace(' ', '_').replace('.', '_');
        return s;
    }

    public void copyto(SeqFileInfo si) {
        si.format = this.format;
        si.skiplines = this.skiplines;
        si.err = this.err;
        si.atseq = this.atseq;
        si.nseq = this.nseq;
        si.modtime = this.modtime;
        si.seqlen = this.seqlen;
        si.offset = this.offset;
        si.ismask = this.ismask;
        si.hasmask = this.hasmask;
        si.seq = this.seq;
        si.seqdoc = this.seqdoc;
        si.seqid = this.seqid;
    }

    public Object clone() {
        try {
            SeqFileInfo si = (SeqFileInfo)super.clone();
            si.seqid = gBlankSeqid;
            si.hasmask = false;
            si.ismask = false;
            si.seqlen = 0;
            si.offset = 0;
            si.seq = null;
            si.seqdoc = null;
            si.modtime = 0L;
            return si;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
    }
}

