/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.ReadseqException;
import iubio.readseq.SeqFileInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class Writeseq
implements Enumeration {
    protected Vector seqfilevec = new Vector();
    protected int fAt;
    protected int format;
    protected int minbases;
    protected boolean sizesDiffer = false;
    protected boolean fWriteMask = SeqFileInfo.gWriteMask;
    protected BioseqWriterIface writer;
    protected BioseqFormat former;

    public Writeseq() {
        this(BioseqFormats.kNoformat);
    }

    public Writeseq(int format) {
        this.setFormat(format);
    }

    public final int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
        this.former = BioseqFormats.bioseqFormat(format);
        if (this.writer != null && this.writer.formatID() != format) {
            this.writer = null;
        }
    }

    public BioseqWriterIface getWriter() {
        return this.writer;
    }

    public BioseqFormat getBioseqFormat() {
        return this.former;
    }

    public boolean canwrite() {
        if (this.writer != null) {
            return true;
        }
        if (this.former != null) {
            return this.former.canwrite();
        }
        return false;
    }

    public SeqFileInfo nextSeq() {
        if (this.moreresults()) {
            return (SeqFileInfo)this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public Object result() {
        if (this.moreresults()) {
            return this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public boolean moreresults() {
        return this.fAt < this.seqfilevec.size();
    }

    public int atresult() {
        return this.fAt;
    }

    public int nresults() {
        return this.seqfilevec.size();
    }

    public Vector allresults() {
        return this.seqfilevec;
    }

    public void restartresults() {
        this.fAt = 0;
    }

    public void removeresults() {
        this.fAt = 0;
        this.seqfilevec.removeAllElements();
    }

    public boolean hasMoreElements() {
        return this.moreresults();
    }

    public Object nextElement() {
        if (this.moreresults()) {
            return this.result();
        }
        return null;
    }

    public void addSeq(SeqFileInfo si) {
        if (this.minbases <= 0) {
            this.minbases = si.seqlen;
        } else {
            if (si.seqlen != this.minbases) {
                this.sizesDiffer = true;
            }
            this.minbases = Math.min(si.seqlen, this.minbases);
        }
        this.seqfilevec.addElement(si);
    }

    public void addSeq(Object aSeq, String id, int start, int nbases, Object seqdoc, boolean hasmask) {
        SeqFileInfo sa = new SeqFileInfo();
        sa.seq = aSeq;
        sa.seqdoc = seqdoc;
        sa.offset = start;
        sa.seqlen = nbases;
        sa.seqid = id;
        sa.hasmask = hasmask;
        this.addSeq(sa);
    }

    public void setWriteMask(boolean turnon) {
        this.fWriteMask = turnon;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public final void open(File f, int outFormat, int nSeqs) throws IOException {
        this.open(new FileWriter(f), outFormat, nSeqs);
    }

    public void open(Writer outs, int outFormat, int nSeqs) throws IOException {
        if (outFormat <= BioseqFormats.kUnknown) {
            throw new ReadseqException("Unknown BioseqWriter format: " + outFormat);
        }
        this.setFormat(outFormat);
        if (this.writer == null) {
            this.writer = BioseqFormats.newWriter(outFormat, nSeqs);
        }
        if (this.writer == null) {
            throw new ReadseqException("Null BioseqWriter");
        }
        this.writer.setOutput(outs);
        this.minbases = 0;
        this.sizesDiffer = false;
        this.removeresults();
    }

    public boolean write() throws IOException {
        this.restartresults();
        if (this.moreresults()) {
            if (this.writer == null) {
                throw new ReadseqException("Null BioseqWriter");
            }
            this.writer.setNseq(this.nresults());
            if (this.sizesDiffer && this.former.needsamelength()) {
                this.setSameSize();
            }
            this.writer.writeHeader();
            while (this.moreresults()) {
                SeqFileInfo si = this.nextSeq();
                if (this.writer.setSeq(si)) {
                    this.writer.writeSeqRecord();
                }
                if (!this.fWriteMask) continue;
                if (!this.writer.setMask(si, SeqFileInfo.gMaskName)) continue;
                this.writer.writeSeqRecord();
            }
            this.writer.writeTrailer();
            return true;
        }
        return false;
    }

    protected void setSameSize() {
        this.restartresults();
        while (this.moreresults()) {
            SeqFileInfo si = this.nextSeq();
            si.seqlen = this.minbases;
        }
        this.restartresults();
    }
}

