/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class XmlPrintWriter
extends PrintWriter {
    public int kLinewidth = 80;
    public static boolean compatableXmlChars = false;
    protected int atline;
    protected int atcol;
    protected boolean doTrimValue = true;
    protected boolean newline = true;
    protected boolean needindent = true;
    protected boolean headerdone;
    protected boolean noendeol;
    private char lastc;

    public XmlPrintWriter(Writer out) {
        super(out);
    }

    public XmlPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public XmlPrintWriter(OutputStream out) {
        super(out);
    }

    public XmlPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public boolean atNewline() {
        return this.newline;
    }

    public int linesWritten() {
        return this.atline;
    }

    public int atColumn() {
        return this.atcol;
    }

    public void setTrimValue(boolean turnon) {
        this.doTrimValue = turnon;
    }

    public void tab(int val) {
        this.atcol += val;
        while (val > 0) {
            super.write(32);
            --val;
        }
    }

    protected void endline() {
        ++this.atline;
        this.atcol = 0;
        this.newline = true;
        this.needindent = true;
    }

    public void println() {
        super.println();
        this.endline();
    }

    public void println(boolean x) {
        super.println(x);
        this.endline();
    }

    public void println(char x) {
        super.println(x);
        this.endline();
    }

    public void println(int x) {
        super.println(x);
        this.endline();
    }

    public void println(long x) {
        super.println(x);
        this.endline();
    }

    public void println(float x) {
        super.println(x);
        this.endline();
    }

    public void println(double x) {
        super.println(x);
        this.endline();
    }

    public void println(char[] x) {
        super.println(x);
        this.endline();
    }

    public void println(String x) {
        super.println(x);
        this.endline();
    }

    public void println(Object x) {
        super.println(x);
        this.endline();
    }

    public void header() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.headerdone = true;
    }

    public final void writeTag(String tag, String value, int level) {
        this.writeTagStart(tag, value, level);
        this.writeEndElement(tag, this.needindent, level);
    }

    public void writeTagStart(String tag, String value, int level) {
        if (value == null || value.length() + this.atcol + tag.length() + 2 < this.kLinewidth) {
            this.writeStartElement(tag, false, level);
            this.writeValue(value);
        } else {
            this.writeStartElement(tag, false, level);
            int indent = 2 * level + tag.length() + 2;
            while (value != null) {
                value = this.writeWrapText(value, indent, this.kLinewidth);
                indent = 0;
            }
        }
    }

    public String trimValue(String val) {
        char e;
        char c;
        int len;
        if (this.doTrimValue && (len = (val = val.trim()).length()) > 1 && (c = val.charAt(0)) == (e = val.charAt(len - 1)) && (c == '\"' || c == '\'')) {
            val = val.substring(1, len - 1);
            len -= 2;
        }
        return val;
    }

    public void writeValue(String val) {
        if (val == null) {
            return;
        }
        val = this.trimValue(val);
        this.writeCharacters(val, 0, val.length());
    }

    public String writeWrapText(String val, int indent, int width) {
        if (val == null) {
            return null;
        }
        val = this.trimValue(val);
        String rval = null;
        int vlen = val.length();
        int maxw = width - indent;
        int max2 = maxw + 2;
        int at = val.indexOf(10);
        if (at < 0) {
            at = val.indexOf(13);
        }
        if (at >= 0 && at <= max2) {
            if (at < vlen) {
                rval = val.substring(at + 1).trim();
            }
            val = val.substring(0, at);
        } else if (vlen > maxw) {
            at = val.lastIndexOf(32, max2);
            if (at < 0 && (at = val.lastIndexOf(44, max2)) > 0) {
                ++at;
            }
            if (at < 0 && (at = val.lastIndexOf(59, max2)) > 0) {
                ++at;
            }
            if (at < 0 && (at = val.lastIndexOf(46, max2)) > 0) {
                ++at;
            }
            if (at < 0) {
                at = maxw;
            }
            if (at > 10) {
                rval = val.substring(at).trim();
                val = val.substring(0, at);
            }
        }
        this.writeCharacters(val, 0, val.length());
        if (rval != null) {
            this.println();
        }
        return rval;
    }

    public void writeEmptyElement(String name, int level) {
        this.tab(2 * level);
        super.write(60);
        super.write(name);
        super.write("/>");
        this.atcol += 3 + name.length();
        this.println();
    }

    public final void writeStartElement(String name, int level) {
        this.writeStartElement(name, true, level);
    }

    public void writeStartElement(String name, boolean eol, int level) {
        this.tab(2 * level);
        super.write(60);
        super.write(name);
        super.write(62);
        this.atcol += 2 + name.length();
        if (eol) {
            this.println();
        }
    }

    public void printAttributes(Object attributes) {
    }

    public final void writeEndElement(String name, int level) {
        this.writeEndElement(name, this.needindent, level);
    }

    public void skipNextEndElementNewline() {
        this.noendeol = true;
    }

    public void writeEndElement(String name, boolean doindent, int level) {
        if (doindent) {
            this.tab(2 * level);
        }
        super.write(60);
        super.write(47);
        super.write(name);
        super.write(62);
        if (!this.noendeol) {
            this.println();
        }
        this.noendeol = false;
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println(" -->");
    }

    public void writeCharacters(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.printEncoded(ch[i]);
        }
    }

    public void writeCharacters(byte[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.printEncoded((char)ch[i]);
        }
    }

    public void writeCharacters(String s, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.printEncoded(s.charAt(i));
        }
    }

    public void printEncoded(char ch) {
        this.newline = false;
        this.needindent = false;
        ++this.atcol;
        switch (ch) {
            case '&': {
                super.write("&amp;");
                break;
            }
            case '<': {
                super.write("&lt;");
                break;
            }
            case '>': {
                super.write("&gt;");
                break;
            }
            case '\"': {
                super.write("&quot;");
                break;
            }
            case '\t': {
                if (compatableXmlChars) {
                    super.write("&#9;");
                    break;
                }
                super.write(ch);
                break;
            }
            case '\n': {
                if (compatableXmlChars) {
                    super.write("&#10;");
                    break;
                }
                if (this.lastc == '\r') break;
                this.println();
                break;
            }
            case '\r': {
                if (compatableXmlChars) {
                    super.write("&#12;");
                    break;
                }
                if (this.lastc == '\n') break;
                this.println();
                break;
            }
            default: {
                super.write(ch);
            }
        }
        this.lastc = ch;
    }
}

