/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Debug;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.DocItem;
import iubio.readseq.OutBiobase;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.XmlDoc;
import iubio.readseq.XmlPrintWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class XmlSeqWriter
implements BioseqWriterIface {
    public boolean showErrors;
    public static boolean includeDTD = true;
    public static String dtdUrl;
    static final int kSeqwidth = 78;
    protected XmlPrintWriter xpr;
    protected int formatId;
    protected int err;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected long checksum = 0L;
    protected int fBasePart = 0;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected Bioseq bioseq;
    protected Object seqdoc;
    protected Hashtable exfeatures;
    protected int level = 0;
    protected String dtdfile;
    protected String tagBioseqSet;
    protected String tagBioseq;
    protected String tagSeqdata;
    protected String tagName;
    protected String tagDescription;
    protected String tagChecksum;
    protected String tagSeqlen;
    protected String tagSeqkind;
    protected boolean dochecksum = true;
    protected boolean doReverse;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected OutBiobaseIntf testbase = new OutBiobase(null);
    protected int testbaseKind = 3;
    protected Checksum summer;

    public XmlSeqWriter() {
        this.showErrors = Debug.isOn;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int id) {
        this.formatId = id;
    }

    public boolean getChecksum() {
        return this.dochecksum;
    }

    public void setChecksum(boolean turnon) {
        this.dochecksum = turnon;
    }

    public boolean getReverseComplement() {
        return this.doReverse;
    }

    public void setReverseComplement(boolean turnon) {
        this.doReverse = turnon;
    }

    public final void setOutput(OutputStream outs) {
        this.setOutput(new OutputStreamWriter(outs));
    }

    public void setOutput(Writer outs) {
        this.xpr = outs instanceof XmlPrintWriter ? (XmlPrintWriter)outs : new XmlPrintWriter(outs);
    }

    public void close() throws IOException {
        this.xpr.close();
        if (this.xpr.checkError()) {
            throw new IOException("close error");
        }
    }

    public int getError() {
        if (this.xpr != null && this.xpr.checkError()) {
            ++this.err;
        }
        return this.err;
    }

    public void setOutputTranslation(OutBiobaseIntf tester) {
        this.testbase = tester;
        this.testbaseKind = tester == null ? 3 : 1;
    }

    public OutBiobaseIntf getOutputTranslation() {
        if (this.testbaseKind == 1) {
            return this.testbase;
        }
        return null;
    }

    public void setFeatureExtraction(Hashtable featurelist) {
        this.exfeatures = featurelist;
    }

    public boolean wantsDocument() {
        if (this.exfeatures != null) {
            return true;
        }
        BioseqFormat wrformat = BioseqFormats.bioseqFormat(this.formatID());
        return wrformat.hasdoc();
    }

    public int seqLen() {
        return this.seqlen;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void setNseq(int nsequences) {
        this.nseq = nsequences;
    }

    public String getDTD(String rezname) {
        if ((rezname = AppResources.global.findPath(rezname)) == null) {
            return null;
        }
        return AppResources.global.getData(rezname);
    }

    public void writeHeader() throws IOException {
        if (this.xpr == null) {
            throw new FileNotFoundException();
        }
        this.nseq = 0;
        this.level = 0;
        this.tagBioseqSet = XmlDoc.getXMLFieldName(1);
        this.tagBioseq = XmlDoc.getXMLFieldName(2);
        this.tagSeqdata = XmlDoc.getXMLFieldName(111);
        this.tagName = XmlDoc.getXMLFieldName(10);
        this.tagDescription = XmlDoc.getXMLFieldName(20);
        this.tagChecksum = XmlDoc.getXMLFieldName(114);
        this.tagSeqlen = XmlDoc.getXMLFieldName(112);
        this.tagSeqkind = XmlDoc.getXMLFieldName(113);
        this.xpr.header();
        if (includeDTD) {
            this.xpr.print("<!DOCTYPE ");
            this.xpr.print(this.tagBioseqSet);
            String sdtd = this.getDTD(this.tagBioseq + ".dtd");
            if (sdtd != null) {
                this.xpr.println(" [");
                this.xpr.print(sdtd);
                this.xpr.print("]");
            } else if (dtdUrl != null) {
                this.xpr.print(" PUBLIC \"");
                this.xpr.print(dtdUrl);
                this.xpr.print(this.tagBioseq);
                this.xpr.print(".dtd");
                this.xpr.print("\"");
            }
            this.xpr.println(">");
        }
        this.xpr.println();
        if (this.exfeatures != null) {
            this.xpr.commentStart();
            this.xpr.print("Sequence ");
            this.xpr.println(" extracted for these features:");
            Enumeration en = this.exfeatures.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = (String)this.exfeatures.get(key);
                this.xpr.println(key + "=" + val);
            }
            this.xpr.commentEnd();
        }
        this.xpr.writeStartElement(this.tagBioseqSet, this.level);
        ++this.level;
    }

    public void writeTrailer() {
        --this.level;
        this.xpr.writeEndElement(this.tagBioseqSet, this.level);
        this.xpr.flush();
    }

    public boolean setSeq(SeqFileInfo si) {
        if (si.ismask) {
            return false;
        }
        return this.setSeq(si.seq, si.offset, si.seqlen, si.seqid, si.seqdoc, si.atseq, 0);
    }

    public boolean setMask(SeqFileInfo si, String masktag) {
        int bpart = 0;
        if (si.ismask) {
            bpart = 0;
        } else if (si.hasmask) {
            bpart = 3;
        } else {
            return false;
        }
        masktag = si.seqid.toString() + masktag;
        return this.setSeq(si.seq, si.offset, si.seqlen, masktag, si.seqdoc, si.atseq, bpart);
    }

    public boolean setSeq(Object seqob, int offset, int length, String seqname, Object seqdoc, int atseq, int basepart) {
        if ((length < 1 || seqob == null) && seqdoc != null) {
            seqob = new byte[]{78};
            length = 1;
        }
        this.seqlen = length;
        this.checksum = 0L;
        if (length > 0 && seqob != null) {
            if (seqob instanceof Bioseq) {
                this.bioseq = (Bioseq)seqob;
            } else if (seqob instanceof byte[]) {
                this.bioseq = new Bioseq();
                this.bioseq.setbases((byte[])seqob);
            }
            this.atseq = atseq;
            this.offset = offset;
            this.seqdoc = seqdoc;
            this.setSeqName(seqname);
            this.setSeqPart(basepart);
            if (this.exfeatures != null && seqdoc instanceof BioseqDocImpl) {
                BioseqDocImpl bdi = (BioseqDocImpl)seqdoc;
                bdi.setWantedFeatures(this.exfeatures);
                SeqRange featsr = bdi.getFeatureRanges(offset, this.seqlen);
                if (this.extractBases(featsr)) {
                    bdi.replaceDocItem(112, new DocItem("length", String.valueOf(this.seqlen), 112, 1));
                }
            } else if (this.doReverse) {
                this.bioseq.reverseComplement(offset, this.seqlen);
                if (seqdoc instanceof BioseqDocImpl) {
                    BioseqDocImpl bdi = (BioseqDocImpl)seqdoc;
                    bdi.addComment("NOTE:  This is reverse-complement of original sequence.");
                }
            }
        }
        return this.seqlen > 0;
    }

    protected boolean extractBases(SeqRange range) {
        try {
            Bioseq outseq = BioseqWriter.extractBioseqBases(this.bioseq, range, this.seqlen, this.seqid);
            this.seqlen = outseq.length();
            this.bioseq = outseq;
            return true;
        }
        catch (SeqRangeException sre) {
            System.err.println(sre);
            return false;
        }
    }

    public void setSeqName(String name) {
        int i;
        if (name == null) {
            return;
        }
        if (name.equals(SeqFileInfo.gBlankSeqid)) {
            name = SeqFileInfo.getNextBlankID();
        }
        this.seqid = name;
        this.seqid = this.seqid.trim();
        if (this.seqid.indexOf("checksum") > 0 && (i = this.seqid.indexOf("bases")) > 0) {
            while (i > 0 && this.seqid.charAt(i) != ',') {
                --i;
            }
            if (i > 0) {
                this.seqid = this.seqid.substring(0, i);
            }
        }
        if ((i = this.seqid.indexOf(32)) <= 0) {
            this.idword = this.seqid;
        } else {
            if (i > 30) {
                i = 30;
            }
            this.idword = this.seqid.substring(0, i);
        }
    }

    public void setSeqPart(int basepart) {
        this.fBasePart = basepart;
    }

    public void writeSeqRecord() throws IOException {
        if (this.testbaseKind == 1) {
            this.testbase.outSeqChar(-1);
        }
        this.writeRecordStart();
        this.writeDoc();
        this.writeSeq();
        this.writeRecordEnd();
    }

    public void writeSeq() {
        this.xpr.writeStartElement(this.tagSeqdata, false, this.level);
        int indent = 2 * this.level + this.tagSeqdata.length() + 2;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] ba = this.bioseq.toBytes();
            int len = 78 - indent;
            for (int i = 0; i < this.seqlen; i += len) {
                if (len + i > this.seqlen) {
                    len = this.seqlen - i;
                }
                this.xpr.writeCharacters(ba, this.offset + i, len);
                if (this.seqlen >= 78) {
                    this.xpr.println();
                }
                len = 78;
            }
        } else {
            int iwid = 0;
            int len = 78 - indent;
            for (int i = 0; i < this.seqlen; ++i) {
                char bc = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc <= '\u0000') continue;
                this.xpr.printEncoded(bc);
                if (++iwid < len) continue;
                this.xpr.println();
                iwid = 0;
                len = 78;
            }
        }
        this.xpr.writeEndElement(this.tagSeqdata, false, this.level);
    }

    public void writeSeqEnd() {
    }

    public void writeRecordStart() {
        ++this.nseq;
        this.checksum = 0L;
        this.xpr.writeStartElement(this.tagBioseq, this.level);
        ++this.level;
        if (this.dochecksum && this.checksum == 0L) {
            this.checksum = this.calculateChecksum();
        }
    }

    public void writeRecordEnd() {
        --this.level;
        this.xpr.writeEndElement(this.tagBioseq, this.level);
        this.xpr.println();
    }

    protected void writeID() {
        this.xpr.writeTag(this.tagName, this.idword, this.level);
    }

    protected void writeStats() {
        this.xpr.writeTag(this.tagSeqlen, String.valueOf(this.seqlen), this.level);
        int sqtype = this.bioseq.getSeqtype();
        String skind = SeqInfo.getKindLabel(sqtype);
        this.xpr.writeTag(this.tagSeqkind, skind, this.level);
        String cks = this.checksumString();
        if (cks.length() > 0) {
            this.xpr.writeTag(this.tagChecksum, cks, this.level);
        }
    }

    public void writeDoc() {
        if (this.seqdoc instanceof BioseqDoc) {
            XmlDoc xdoc = new XmlDoc((BioseqDoc)this.seqdoc);
            xdoc.setIndent(this.level);
            if (xdoc.getID() == null) {
                this.writeID();
                this.writeStats();
            }
            xdoc.writeTo(this.xpr, true);
        } else {
            this.writeID();
            this.xpr.writeTag(this.tagDescription, this.seqid, this.level);
            this.writeStats();
        }
    }

    protected long calculateChecksum() {
        if (BioseqWriter.gJavaChecksum && this.summer == null) {
            this.summer = new Adler32();
        }
        return BioseqWriter.calculateChecksum(this.bioseq, this.offset, this.seqlen, this.summer);
    }

    protected String checksumString() {
        if (this.checksum == 0L) {
            return "";
        }
        return Long.toHexString(this.checksum).toUpperCase();
    }
}

