/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.lsf;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.lsf.LSFBatchException;
import uk.ac.sanger.jcon.lsf.LSFBjobsExec;
import uk.ac.sanger.jcon.lsf.LSFJobInfo;

public final class LSFJobUpdater {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$lsf$LSFJobUpdater == null ? (class$uk$ac$sanger$jcon$lsf$LSFJobUpdater = LSFJobUpdater.class$("uk.ac.sanger.jcon.lsf.LSFJobUpdater")) : class$uk$ac$sanger$jcon$lsf$LSFJobUpdater).getName());
    static final int runMask = -66433;
    static final int postMask = -66176;
    private StatusDAO statusDAO;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$lsf$LSFJobUpdater;

    public LSFJobUpdater(StatusDAO statusDAO) {
        this.statusDAO = statusDAO;
    }

    public void updateJobs(String queue, Map jobs) throws Exception {
        if (jobs.isEmpty()) {
            return;
        }
        LSFBjobsExec lsfBatchInfo = LSFBjobsExec.getInstance();
        List jobInfo = lsfBatchInfo.getJobInfo(jobs.keySet());
        Iterator ii = jobInfo.iterator();
        block10: while (ii.hasNext()) {
            LSFJobInfo info = (LSFJobInfo)ii.next();
            Integer lsfJobId = new Integer(info.getJobId());
            BatchJob job = (BatchJob)jobs.get(lsfJobId);
            int lsfStatus = info.getStatus();
            int runStatus = lsfStatus & 0xFFFEFC7F;
            int postStatus = lsfStatus & 0xFFFEFD80;
            int statusId = job.getStatus().getId();
            switch (postStatus) {
                case 0: 
                case 128: {
                    break;
                }
                case 256: {
                    job.setHosts(info.getExHosts());
                    job.setExitValue(info.getExitValue());
                    job.setStatus(this.statusDAO.readStatusById(5));
                    jobs.remove(lsfJobId);
                    cat.warn((Object)("Post processing failed for Job [" + job.getId() + "]"));
                    return;
                }
                default: {
                    throw new LSFBatchException("Unknown job post process status '" + lsfStatus + "' received for Job [" + job.getId() + "] from LSF Batch system");
                }
            }
            switch (runStatus) {
                case 0: 
                case 1: 
                case 2: 
                case 8: 
                case 16: 
                case 65536: {
                    continue block10;
                }
                case 4: {
                    if (statusId != 2) continue block10;
                    job.setStatus(this.statusDAO.readStatusById(3));
                    continue block10;
                }
                case 32: {
                    job.setHosts(info.getExHosts());
                    job.setExitValue(info.getExitValue());
                    job.setStatus(this.statusDAO.readStatusById(5));
                    jobs.remove(lsfJobId);
                    continue block10;
                }
                case 64: {
                    job.setHosts(info.getExHosts());
                    job.setExitValue(info.getExitValue());
                    job.setStatus(this.statusDAO.readStatusById(4));
                    jobs.remove(lsfJobId);
                    continue block10;
                }
            }
            throw new LSFBatchException("Unknown job run status '" + lsfStatus + "' received for Job [" + job.getId() + "] from LSF Batch system");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

