/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parsers;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.EntityImpl;
import com.ibm.xml.dom.NodeImpl;
import com.ibm.xml.dom.TextImpl;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.parsers.XMLDOMParser;
import java.util.Stack;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;

public class NonValidatingDOMParser
extends XMLDOMParser {
    public static final int FULL = 0;
    public static final int DEFERRED = 1;
    public static final String DEFERRED_DOCUMENT_CLASS = (class$com$ibm$xml$dom$DocumentImpl != null ? class$com$ibm$xml$dom$DocumentImpl : (class$com$ibm$xml$dom$DocumentImpl = NonValidatingDOMParser.class$("com.ibm.xml.dom.DocumentImpl"))).getName();
    private static final boolean DEBUG_ATTLIST_DECL = false;
    protected int fDocumentIndex = -1;
    protected int fDocumentTypeIndex = -1;
    protected int fCurrentNodeIndex = -1;
    protected DocumentType fDocumentType = null;
    protected Node fCurrentNode = null;
    protected Stack fNodeStack = new Stack();
    protected Document fDocument;
    protected DocumentImpl fDocumentImpl;
    protected boolean fExpandEntityReferences = false;
    protected int fNodeExpansion = 1;
    protected boolean fWithinElement = false;
    int fAmpIndex = -1;
    int fLtIndex = -1;
    int fGtIndex = -1;
    int fAposIndex = -1;
    int fQuotIndex = -1;
    protected AttrPool fAttrPool;
    protected ElementDeclPool fElementDeclPool;
    protected EntityPool fEntityPool;
    protected StringPool fStringPool;
    protected String fDocumentClass = DEFERRED_DOCUMENT_CLASS;
    private int[] nodestack = new int[16];
    private int stacktop = 0;
    static /* synthetic */ Class class$com$ibm$xml$dom$DocumentImpl;

    public NonValidatingDOMParser() {
        this.setDocumentHandler(this);
        this.setDocumentTypeHandler(this);
        this.fExpandEntityReferences = false;
        this.fNodeExpansion = 1;
        ParserState state = this.getParserState();
        state.useDefaultStringPool();
        state.useDefaultAttrPool();
        state.useDefaultEntityPool();
        state.useDefaultElementDeclPool();
        this.init(state);
    }

    public void reset() {
        super.reset();
        this.init(this.getParserState());
    }

    protected void resetOrCopy() {
        super.resetOrCopy();
        this.init(this.getParserState());
    }

    protected void init(ParserState state) {
        this.fDocumentType = null;
        this.fCurrentNode = null;
        this.fNodeStack.removeAllElements();
        this.fDocumentIndex = -1;
        this.fDocumentTypeIndex = -1;
        this.fCurrentNodeIndex = -1;
        this.fDocumentImpl = null;
        this.fDocument = null;
        this.fWithinElement = false;
        this.fAttrPool = state.getAttrPool();
        this.fElementDeclPool = state.getElementDeclPool();
        this.fEntityPool = state.getEntityPool();
        this.fStringPool = state.getStringPool();
        this.fAmpIndex = this.fStringPool.addSymbol("amp");
        this.fLtIndex = this.fStringPool.addSymbol("lt");
        this.fGtIndex = this.fStringPool.addSymbol("gt");
        this.fAposIndex = this.fStringPool.addSymbol("apos");
        this.fQuotIndex = this.fStringPool.addSymbol("quot");
    }

    protected void checkHandlers() throws Exception {
        super.checkHandlers();
    }

    public void setExpandEntityReferences(boolean expand) {
        this.fExpandEntityReferences = expand;
    }

    public boolean getExpandEntityReferences() {
        return this.fExpandEntityReferences;
    }

    public void setNodeExpansion(int nodeExpansion) {
        if (nodeExpansion != 0 && nodeExpansion != 1) {
            this.fNodeExpansion = 1;
            return;
        }
        this.fNodeExpansion = nodeExpansion;
    }

    public int getNodeExpansion() {
        return this.fNodeExpansion;
    }

    public Node getCurrentNode() {
        return this.fCurrentNode;
    }

    public void doctypeDecl(int rootElementNameIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                String rootElementName = this.fStringPool.toString(rootElementNameIndex);
                this.fDocumentType = this.fDocumentImpl.createDocumentType(rootElementName);
                this.fDocumentImpl.appendChild(this.fDocumentType);
                this.fCurrentNode = this.fDocumentType;
                return;
            }
        } else if (this.fNodeExpansion == 1) {
            this.fDocumentTypeIndex = this.fDocumentImpl.createDocumentType(rootElementNameIndex);
            this.fDocumentImpl.appendChild(this.fDocumentIndex, this.fDocumentTypeIndex);
            this.fCurrentNodeIndex = this.fDocumentTypeIndex;
        }
    }

    public void startInternalSubset() throws Exception {
    }

    public void endInternalSubset() throws Exception {
        if (this.fNodeExpansion == 0) {
            this.fCurrentNode = this.fDocument;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.fCurrentNodeIndex = this.fDocumentIndex;
        }
    }

    public void startExternalSubset(int publicIdStringIndex, int systemIdStringIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            this.fCurrentNode = this.fDocumentType;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.fCurrentNodeIndex = this.fDocumentTypeIndex;
        }
    }

    public void endExternalSubset() throws Exception {
        if (this.fNodeExpansion == 0) {
            this.fCurrentNode = this.fDocument;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.fCurrentNodeIndex = this.fDocumentIndex;
        }
    }

    public void elementDecl(int elementIndex) throws Exception {
    }

    public void attlistDecl(int elementIndex, int attDefIndex) throws Exception {
        int attrValueIndex;
        if (this.fNodeExpansion == 0) {
            int attrValueIndex2;
            if (this.fDocumentImpl != null && (attrValueIndex2 = this.fElementDeclPool.getAttValue(attDefIndex)) != -1) {
                int elementNameIndex = this.fElementDeclPool.getElementName(elementIndex);
                String elementName = this.fStringPool.toString(elementNameIndex);
                NamedNodeMap elements = ((DocumentTypeImpl)this.fDocumentType).getElements();
                ElementDefinitionImpl elementDef = (ElementDefinitionImpl)elements.getNamedItem(elementName);
                if (elementDef == null) {
                    elementDef = this.fDocumentImpl.createElementDefinition(elementName);
                    ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem(elementDef);
                }
                int attrNameIndex = this.fElementDeclPool.getAttName(attDefIndex);
                String attrName = this.fStringPool.toString(attrNameIndex);
                String attrValue = this.fStringPool.toString(attrValueIndex2);
                AttrImpl attr = (AttrImpl)this.fDocumentImpl.createAttribute(attrName);
                attr.setValue(attrValue);
                attr.setSpecified(false);
                elementDef.getAttributes().setNamedItem(attr);
                return;
            }
        } else if (this.fNodeExpansion == 1 && (attrValueIndex = this.fElementDeclPool.getAttValue(attDefIndex)) != -1) {
            int elementNameIndex = this.fElementDeclPool.getElementName(elementIndex);
            int elementDefIndex = this.fDocumentImpl.lookupElementDefinition(elementNameIndex);
            if (elementDefIndex == -1) {
                elementDefIndex = this.fDocumentImpl.createElementDefinition(elementNameIndex);
                this.fDocumentImpl.appendChild(this.fDocumentTypeIndex, elementDefIndex);
            }
            int attrNameIndex = this.fElementDeclPool.getAttName(attDefIndex);
            int attrIndex = this.fDocumentImpl.createAttribute(attrNameIndex, attrValueIndex, false);
            this.fDocumentImpl.appendChild(elementDefIndex, attrIndex);
        }
    }

    public void internalEntityDecl(int entityIndex) throws Exception {
        int entityNameIndex = this.fEntityPool.getEntityName(entityIndex);
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                if (this.fDocumentType == null) {
                    return;
                }
                Entity entity = this.fDocumentImpl.createEntity(this.fStringPool.toString(entityNameIndex));
                this.fDocumentType.getEntities().setNamedItem(entity);
                return;
            }
        } else if (this.fNodeExpansion == 1) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int newEntityIndex = this.fDocumentImpl.createEntity(entityIndex);
            this.fDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
        }
    }

    public void externalEntityDecl(int entityIndex) throws Exception {
        int entityNameIndex = this.fEntityPool.getEntityName(entityIndex);
        int publicIdIndex = this.fEntityPool.getPublicId(entityIndex);
        int systemIdIndex = this.fEntityPool.getSystemId(entityIndex);
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                if (this.fDocumentType == null) {
                    return;
                }
                EntityImpl entity = (EntityImpl)this.fDocumentImpl.createEntity(this.fStringPool.toString(entityNameIndex));
                entity.setPublicId(this.fStringPool.toString(publicIdIndex));
                entity.setSystemId(this.fStringPool.toString(systemIdIndex));
                this.fDocumentType.getEntities().setNamedItem(entity);
                return;
            }
        } else if (this.fNodeExpansion == 1) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int newEntityIndex = this.fDocumentImpl.createEntity(entityIndex);
            this.fDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
        }
    }

    public void unparsedEntityDecl(int entityIndex) throws Exception {
        int entityNameIndex = this.fEntityPool.getEntityName(entityIndex);
        int publicIdIndex = this.fEntityPool.getPublicId(entityIndex);
        int systemIdIndex = this.fEntityPool.getSystemId(entityIndex);
        int notationNameIndex = this.fEntityPool.getNotationName(entityIndex);
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                if (this.fDocumentType == null) {
                    return;
                }
                EntityImpl entity = (EntityImpl)this.fDocumentImpl.createEntity(this.fStringPool.toString(entityNameIndex));
                entity.setPublicId(this.fStringPool.toString(publicIdIndex));
                entity.setSystemId(this.fStringPool.toString(systemIdIndex));
                entity.setNotationName(this.fStringPool.toString(notationNameIndex));
                this.fDocumentType.getEntities().setNamedItem(entity);
                return;
            }
        } else if (this.fNodeExpansion == 1) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int newEntityIndex = this.fDocumentImpl.createEntity(entityIndex);
            this.fDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
        }
    }

    public void notationDecl(int notationIndex) throws Exception {
        int notationNameIndex = this.fEntityPool.getEntityName(notationIndex);
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                if (this.fDocumentType == null) {
                    return;
                }
                Notation notation = this.fDocumentImpl.createNotation(this.fStringPool.toString(notationNameIndex));
                this.fDocumentType.getNotations().setNamedItem(notation);
                return;
            }
        } else if (this.fNodeExpansion == 1) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int newNotationIndex = this.fDocumentImpl.createNotation(notationIndex);
            this.fDocumentImpl.appendChild(this.fDocumentTypeIndex, newNotationIndex);
        }
    }

    public void setDocumentClass(String documentClass) {
        if (documentClass == null) {
            documentClass = DEFERRED_DOCUMENT_CLASS;
        }
        this.fDocumentClass = documentClass;
        if (!documentClass.equals(DEFERRED_DOCUMENT_CLASS)) {
            this.setNodeExpansion(0);
        }
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public void startDocument(int versionIndex, int encodingIndex, int standAloneIndex) {
        if (versionIndex != -1) {
            this.fStringPool.orphanString(versionIndex);
        }
        if (encodingIndex != -1) {
            this.fStringPool.orphanString(encodingIndex);
        }
        if (standAloneIndex != -1) {
            this.fStringPool.orphanString(standAloneIndex);
        }
        if (this.fNodeExpansion == 0) {
            try {
                this.fDocument = (Document)Class.forName(this.fDocumentClass).newInstance();
                if (this.fDocument instanceof DocumentImpl) {
                    this.fDocumentImpl = (DocumentImpl)this.fDocument;
                }
            }
            catch (Exception exception) {}
            this.fCurrentNode = this.fDocument;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.fDocumentImpl = new DocumentImpl(this.getParserState());
            this.fDocument = this.fDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDocumentImpl.createDocument();
        }
    }

    public void endDocument() throws Exception {
    }

    public void startElement(int elementNameIndex, int attrListIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            this.fNodeStack.push(this.fCurrentNode);
            String elementName = this.fStringPool.toString(elementNameIndex);
            AttributeList attrList = this.fAttrPool.getAttributeList(attrListIndex);
            Element e = this.fDocument.createElement(elementName);
            int attrListLength = attrList.getLength();
            int i = 0;
            while (i < attrListLength) {
                e.setAttribute(attrList.getName(i), attrList.getValue(i));
                ++i;
            }
            this.fAttrPool.releaseAttrList(attrListIndex);
            this.fCurrentNode.appendChild(e);
            this.fCurrentNode = e;
            this.fWithinElement = true;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.push(this.fCurrentNodeIndex);
            int element = this.fDocumentImpl.createElement(elementNameIndex, attrListIndex);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, element);
            this.fCurrentNodeIndex = element;
            this.fWithinElement = true;
        }
    }

    public void endElement(int elementNameIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            this.fCurrentNode = (Node)this.fNodeStack.pop();
            this.fWithinElement = false;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.fCurrentNodeIndex = this.pop();
            this.fWithinElement = false;
        }
    }

    public void startEntityReference(int entityIndex) throws Exception {
        if (this.fExpandEntityReferences) {
            return;
        }
        int entityNameIndex = this.fEntityPool.getEntityName(entityIndex);
        if (entityNameIndex == this.fAmpIndex || entityNameIndex == this.fGtIndex || entityNameIndex == this.fLtIndex || entityNameIndex == this.fAposIndex || entityNameIndex == this.fQuotIndex) {
            return;
        }
        if (this.fNodeExpansion == 0) {
            this.fNodeStack.push(this.fCurrentNode);
            EntityReference er = this.fDocument.createEntityReference(this.fStringPool.toString(entityNameIndex));
            if (er == null) {
                return;
            }
            this.fNodeStack.push(er);
            this.fCurrentNode.appendChild(er);
            this.fCurrentNode = er;
            return;
        }
        if (this.fNodeExpansion == 1) {
            this.push(this.fCurrentNodeIndex);
            int entityRefIndex = this.fDocumentImpl.createEntityReference(entityIndex);
            this.push(entityRefIndex);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, entityRefIndex);
            this.fCurrentNodeIndex = entityRefIndex;
        }
    }

    public void endEntityReference(int entityIndex) throws Exception {
        if (this.fExpandEntityReferences) {
            return;
        }
        int entityNameIndex = this.fEntityPool.getEntityName(entityIndex);
        if (entityNameIndex == this.fAmpIndex || entityNameIndex == this.fGtIndex || entityNameIndex == this.fLtIndex || entityNameIndex == this.fAposIndex || entityNameIndex == this.fQuotIndex) {
            return;
        }
        if (this.fNodeExpansion == 0) {
            if (this.fDocumentImpl != null) {
                String name;
                NodeImpl erNode = (NodeImpl)this.fNodeStack.pop();
                this.fCurrentNode = (NodeImpl)this.fNodeStack.pop();
                if (erNode.getNodeType() != 5) {
                    return;
                }
                NamedNodeMap entities = this.fDocumentType.getEntities();
                Node entityNode = entities.getNamedItem(name = this.fStringPool.toString(entityNameIndex));
                if (entityNode == null || entityNode.hasChildNodes()) {
                    return;
                }
                Entity entity = (Entity)entityNode;
                if (erNode.hasChildNodes()) {
                    NodeList list = erNode.getChildNodes();
                    int len = list.getLength();
                    int i = 0;
                    while (i < len) {
                        Node childClone = list.item(i).cloneNode(true);
                        entity.appendChild(childClone);
                        ++i;
                    }
                    return;
                }
            }
        } else if (this.fNodeExpansion == 1) {
            String name = this.fStringPool.toString(entityNameIndex);
            int erChild = this.pop();
            this.fCurrentNodeIndex = this.pop();
            if (this.fDocumentImpl.getNodeType(erChild) != 5) {
                return;
            }
            erChild = this.fDocumentImpl.getFirstChild(erChild);
            if (this.fDocumentTypeIndex != -1) {
                int entityDecl = this.fDocumentImpl.getFirstChild(this.fDocumentTypeIndex);
                while (entityDecl != -1) {
                    if (this.fDocumentImpl.getNodeType(entityDecl) == 6 && this.fDocumentImpl.getNodeName(entityDecl).equals(name)) break;
                    entityDecl = this.fDocumentImpl.getNextSibling(entityDecl);
                }
                if (entityDecl != -1 && this.fDocumentImpl.getFirstChild(entityDecl) == -1) {
                    this.fDocumentImpl.setAsFirstChild(entityDecl, erChild);
                }
            }
        }
    }

    public void characters(int dataIndex, boolean cdataSection) throws Exception {
        if (this.fNodeExpansion == 0) {
            Text t = null;
            if (cdataSection) {
                t = this.fDocument.createCDATASection(this.fStringPool.orphanString(dataIndex));
            } else {
                Node lastChild = null;
                if (this.fWithinElement && this.fCurrentNode.getNodeType() == 1 && (lastChild = this.fCurrentNode.getLastChild()) != null && lastChild.getNodeType() == 3) {
                    ((Text)lastChild).appendData(this.fStringPool.orphanString(dataIndex));
                    return;
                }
                t = this.fDocument.createTextNode(this.fStringPool.orphanString(dataIndex));
            }
            if (t == null) {
                return;
            }
            this.fCurrentNode.appendChild(t);
            return;
        }
        if (this.fNodeExpansion == 1) {
            int text = cdataSection ? this.fDocumentImpl.createCDATASection(dataIndex) : this.fDocumentImpl.createTextNode(dataIndex, false);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, text);
        }
    }

    public void ignorableWhitespace(int dataIndex, boolean cdataSection) throws Exception {
        if (this.fNodeExpansion == 0) {
            Text t = null;
            t = cdataSection ? this.fDocument.createCDATASection(this.fStringPool.orphanString(dataIndex)) : this.fDocument.createTextNode(this.fStringPool.orphanString(dataIndex));
            if (t == null) {
                return;
            }
            if (this.fDocumentImpl != null) {
                ((TextImpl)t).setIgnorableWhitespace(true);
            }
            this.fCurrentNode.appendChild(t);
            return;
        }
        if (this.fNodeExpansion == 1) {
            int text = cdataSection ? this.fDocumentImpl.createCDATASection(dataIndex) : this.fDocumentImpl.createTextNode(dataIndex, true);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, text);
        }
    }

    public void processingInstruction(int targetIndex, int dataIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            String target = this.fStringPool.orphanString(targetIndex);
            String data = this.fStringPool.orphanString(dataIndex);
            ProcessingInstruction pi = this.fDocument.createProcessingInstruction(target, data);
            this.fCurrentNode.appendChild(pi);
            return;
        }
        if (this.fNodeExpansion == 1) {
            int pi = this.fDocumentImpl.createProcessingInstruction(targetIndex, dataIndex);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, pi);
        }
    }

    public void comment(int dataIndex) throws Exception {
        if (this.fNodeExpansion == 0) {
            Comment c = this.fDocument.createComment(this.fStringPool.orphanString(dataIndex));
            this.fCurrentNode.appendChild(c);
            return;
        }
        if (this.fNodeExpansion == 1) {
            int comment = this.fDocumentImpl.createComment(dataIndex);
            this.fDocumentImpl.appendChild(this.fCurrentNodeIndex, comment);
        }
    }

    public void characters(char[] ch, int start, int length, boolean cdataSection) throws Exception {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, boolean cdataSection) throws Exception {
    }

    private void push(int index) {
        if (this.stacktop == this.nodestack.length) {
            int[] newstack = new int[this.stacktop * 2];
            System.arraycopy(this.nodestack, 0, newstack, 0, this.stacktop);
            this.nodestack = newstack;
        }
        this.nodestack[this.stacktop++] = index;
    }

    private int pop() {
        return this.nodestack[--this.stacktop];
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

