/*
 * Decompiled with CFR 0.152.
 */
import flybase.Utils;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqRecord;
import iubio.readseq.FeatureItem;
import iubio.readseq.Readseq;
import iubio.readseq.SeqFileInfo;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class features {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: jre -cp .:readseq.jar features find=exon,CDS,... inputfile(s)");
        } else {
            try {
                Hashtable<String, String> feathash = new Hashtable<String, String>();
                Vector<String> names = new Vector<String>();
                PrintStream out = System.out;
                int iarg = 0;
                while (iarg < args.length) {
                    if (args[iarg].startsWith("find=")) {
                        String[] ss = Utils.splitString(args[iarg].substring(5), " ,;:");
                        out.println("Find features:");
                        int k = 0;
                        while (k < ss.length) {
                            feathash.put(ss[k], ss[k]);
                            out.println(ss[k]);
                            ++k;
                        }
                    } else {
                        names.addElement(args[iarg]);
                    }
                    ++iarg;
                }
                Readseq rd = new Readseq();
                Enumeration en = names.elements();
                while (en.hasMoreElements()) {
                    String name = rd.setInputObject(en.nextElement());
                    out.println("Reading from " + name);
                    if (!rd.isKnownFormat() || !rd.readInit()) continue;
                    while (rd.readNext()) {
                        SeqFileInfo sfi = rd.nextSeq();
                        BioseqRecord bsrec = new BioseqRecord(sfi);
                        out.println(bsrec);
                        FeatureItem[] fits = bsrec.findFeatures(feathash);
                        if (fits == null) {
                            out.println("  No such features found.");
                            continue;
                        }
                        out.println("  Extracted features");
                        int k = 0;
                        while (k < fits.length) {
                            out.println(fits[k]);
                            ++k;
                        }
                        out.println("  Extracted sequence");
                        try {
                            Bioseq bseq = bsrec.extractFeatureBases(feathash);
                            out.println(bseq);
                            out.println();
                        }
                        catch (SeqRangeException sre) {
                            out.println(sre.getMessage());
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

