/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import flybase.Debug;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import java.io.File;
import java.io.RandomAccessFile;

public class BioseqFiled
extends Bioseq {
    static final int kMaxbuf = 20480;
    protected RandomAccessFile raf;
    protected File file;
    protected boolean istempfile;
    protected boolean readwrite;
    protected boolean needsFiling;
    protected long bufoffset;
    protected long bufend;
    protected long foffset;
    protected long flength;
    protected boolean endFile;
    SeqInfo mySk = null;

    public BioseqFiled() {
        this(0);
    }

    public BioseqFiled(int maxlen) {
        super(maxlen);
    }

    public BioseqFiled(byte[] b) {
        this(b, 0, b.length);
    }

    public BioseqFiled(byte[] b, int offs, int len) {
        super(b, offs, len);
    }

    public BioseqFiled(char[] c) {
        this(c, 0, c.length);
    }

    public BioseqFiled(char[] c, int offs, int len) {
        super(c, offs, len);
    }

    public BioseqFiled(String s) {
        super(s);
    }

    public BioseqFiled(File f, boolean readwrite) {
        super(0);
        this.readwrite = readwrite;
        this.copyFrom(f);
    }

    public void copyFrom(Object ob) {
        Debug.println(this.getClass().getName() + ".copyFrom(ob)");
        if (ob instanceof File) {
            this.copyFrom((File)ob);
        } else {
            super.copyFrom(ob);
        }
    }

    public void copyFrom(File f) {
        this.finibf();
        this.file = f;
        this.istempfile = false;
        this.initbf();
    }

    protected void finibf() {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.istempfile && this.file != null) {
                this.file.delete();
                this.file = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void initbf() {
        Debug.println(this.getClass().getName() + ".initbf  " + this.file);
        this.bufoffset = 0L;
        this.bufend = 0L;
        if (this.bSeq == null) {
            this.bSeq = new byte[0];
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.readwrite ? "rw" : "r");
            this.setFileOffset(0L, this.raf.length());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.finibf();
        this.bufoffset = 0L;
        this.bufend = 0L;
        super.clear();
    }

    public void finalize() throws Throwable {
        this.finibf();
        super.finalize();
    }

    public void setFileOffset(long offset, long length) {
        if (offset != this.foffset || length != this.flength) {
            this.bufoffset = 0L;
            this.bufend = 0L;
            this.foffset = offset;
            this.flength = length;
        }
    }

    public boolean endOfFile() {
        return this.endFile;
    }

    public long fileLength() {
        if (this.raf == null) {
            return 0L;
        }
        try {
            return this.raf.length();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public int scanForEnd(int seqnum, Object lastBioseqFiled) {
        if (this.raf == null) {
            this.endFile = true;
            return -1;
        }
        int nfound = 0;
        long startoff = 0L;
        BioseqFiled lastf = null;
        if (lastBioseqFiled instanceof BioseqFiled) {
            lastf = (BioseqFiled)lastBioseqFiled;
            startoff = lastf.foffset + lastf.flength;
            nfound = seqnum - 1;
        }
        if (startoff >= this.fileLength()) {
            this.setFileOffset(startoff, 0L);
            this.endFile = true;
            return nfound;
        }
        long foff = startoff;
        long fend = startoff;
        long laststart = startoff;
        int nred = 1;
        byte[] buf = new byte[20480];
        while (nfound < seqnum && nred > 0) {
            nred = this.readBytes(foff, buf, 0, 20480);
            int k = 0;
            boolean more = true;
            while (k < nred && more) {
                if (buf[k] == 10 || buf[k] == 13) {
                    if (k > 1 || foff != startoff || k == 1 && buf[0] >= 32) {
                        if (++nfound < seqnum) {
                            laststart = (long)(1 + k) + foff;
                            break;
                        }
                        more = false;
                        break;
                    }
                    if (foff == startoff && (k == 0 || k == 1 && buf[0] < 32)) {
                        ++laststart;
                    }
                }
                ++k;
            }
            foff += (long)k;
        }
        if (nred <= 0) {
            this.endFile = true;
        }
        this.setFileOffset(laststart, foff - laststart);
        Debug.println("BioseqFiled.scanForEnd, seqnum=" + nfound + ", offset=" + this.foffset + ", len=" + this.flength);
        return nfound;
    }

    public int length() {
        return this.flength > 0L ? (int)this.flength : this.bSeq.length;
    }

    public void setbases(byte[] theBases) {
        this.bSeq = theBases;
    }

    public void setbase(int i, byte b) {
        if (this.bSeq.length > i) {
            this.bSeq[i] = b;
        }
    }

    public byte basebyte(int i) {
        if (this.raf != null) {
            if ((long)i >= this.bufoffset && (long)i < this.bufend) {
                return this.bSeq[i - (int)this.bufoffset];
            }
            int nred = this.readBases(i, 20480);
            if ((long)i >= this.bufoffset && (long)i < this.bufend) {
                return this.bSeq[i - (int)this.bufoffset];
            }
            return 0;
        }
        if (i < this.bSeq.length) {
            return this.bSeq[i];
        }
        return 0;
    }

    public boolean isBytes() {
        if (this.raf != null) {
            return false;
        }
        return this.bSeq != null && this.bSeq.length > 0;
    }

    public byte[] toBytes(int basepart) {
        if (this.isBytes()) {
            return this.bSeq;
        }
        return this.toBytes(0, -1, basepart);
    }

    protected int readBytes(long foffset, byte[] buf, int bufoffset, int length) {
        try {
            this.raf.seek(foffset);
            return this.raf.read(buf, bufoffset, length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    protected int readBases(int baseoffset, int length) {
        try {
            if (this.bSeq.length < length) {
                this.bSeq = new byte[length];
            }
            Debug.print(this.getClass().getName() + ".readBases at=" + this.foffset + baseoffset + ", want=" + length);
            this.bufend = this.bufoffset = (long)baseoffset;
            this.raf.seek((long)baseoffset + this.foffset);
            int nred = this.raf.read(this.bSeq, 0, length);
            this.bufend = this.bufoffset + (long)nred;
            Debug.println(" nread=" + nred);
            SeqInfo sk = SeqInfo.getSeqInfo(length, true, false);
            sk.add(this.bSeq, 0, length);
            this.mySk = sk;
            return nred;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public byte[] toBytes(int offset, int count, int basepart) {
        if (offset < 0) {
            offset = 0;
        }
        if (this.bSeq != null) {
            int len;
            if (offset == 0 && count == this.bSeq.length) {
                return this.bSeq;
            }
            if (this.raf != null) {
                int nred;
                len = (int)this.flength;
                if (count > 0 && count < len) {
                    len = count;
                }
                if ((nred = this.readBases(offset, len)) < 0) {
                    return null;
                }
                if (nred == len) {
                    return this.bSeq;
                }
            }
            len = this.bSeq.length - offset;
            if (count > 0 && count < len) {
                len = count;
            }
            byte[] b = new byte[len];
            System.arraycopy(this.bSeq, offset, b, 0, len);
            return b;
        }
        return null;
    }

    public char[] toChars(int offset, int count, int basepart) {
        byte[] buf = this.isBytes() ? this.bSeq : this.toBytes(offset, count, basepart);
        if (offset < 0) {
            offset = 0;
        }
        if (buf != null) {
            int len = buf.length - offset;
            if (count > 0 && count < len) {
                len = count;
            }
            char[] c = new char[len];
            int i = 0;
            while (i < len) {
                c[i] = (char)buf[i + offset];
                ++i;
            }
            return c;
        }
        return null;
    }

    public Object clone() {
        BioseqFiled bs = (BioseqFiled)super.clone();
        return bs;
    }

    public int getSeqtype() {
        if (this.mySk == null) {
            byte[] buf;
            int len = this.length();
            if (this.isBytes()) {
                buf = this.bSeq;
            } else {
                len = Math.min(len, 8192);
                buf = this.toBytes(0, len, 0);
            }
            SeqInfo sk = SeqInfo.getSeqInfo(len, true, false);
            sk.add(buf, 0, len);
            this.mySk = sk;
        }
        return this.mySk.getKind();
    }

    public SeqInfo getSeqStats(int offset, int seqlen) {
        if (this.mySk == null) {
            byte[] buf;
            if (this.isBytes()) {
                buf = this.bSeq;
            } else {
                buf = this.toBytes(offset, seqlen, 0);
                offset = 0;
            }
            SeqInfo sk = SeqInfo.getSeqInfo(seqlen, false, true);
            sk.add(buf, offset, seqlen);
            this.mySk = sk;
        }
        return this.mySk;
    }
}

